/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.cm.device.video.vivotek.mpeg;

import de.seetec.v5.re.cm.device.shared.net.rtsp.RTSPStreamSettings;
import de.seetec.v5.re.cm.device.shared.videosource.StreamingHelper;
import de.seetec.v5.re.cm.device.shared.videosource.StreamingHelperH264;
import de.seetec.v5.re.cm.device.shared.videosource.StreamingHelperMpeg4;
import de.seetec.v5.re.cm.device.shared.videosource.StreamingVideoSourceClientRTSP;
import de.seetec.v5.re.cm.device.video.vivotek.VivotekCameraSrv;
import de.seetec.v5.re.cm.device.video.vivotek.VivotekDevice;
import de.seetec.v5.re.cm.device.video.vivotek.VivotekHardwareMotionDetection;
import de.seetec.v5.re.cm.device.video.vivotek.VivotekIOHandler;
import de.seetec.v5.re.cm.device.video.vivotek.VivotekMotionDetectionHandler;
import de.seetec.v5.re.cm.shared.Tools;
import de.seetec.v5.re.shared.Codec;
import de.seetec.v5.re.shared.MediaFrame;
import de.seetec.v5.shared.Basic;
import de.seetec.v5.shared.net.NetworkHelper;
import de.seetec.v5.shared.net.NetworkParameter;
import de.seetec.v5.shared.util.ConfigurationException;
import de.seetec.v5.shared.util.SeeTecException;
import java.io.IOException;

public class VivotekMPEGVideoSourceClient
extends StreamingVideoSourceClientRTSP {
    private static final String CLASS_NAME = "de.seetec.v5.re.cm.vivotek.mpeg.VivotekMPEGVideoSourceClient";
    private static final String SET_PARAM = "/cgi-bin/admin/setparam.cgi?";
    private String passphrase = null;
    private String rtspUrl = null;
    private String streamId = null;
    private String livePostfix = "";
    private boolean is7000Series = true;
    private boolean rtpExtensionProfileCheckPassed = true;
    private int mediaType = Integer.MIN_VALUE;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void processData(byte[] data) {
        byte[] completeFrameAsByteArray = null;
        int lengthOfHeader = 0;
        boolean isFrameCompleted = false;
        if (this.isShutdown()) {
            return;
        }
        if (data == null) {
            this.logger.error("Incoming data is null for " + this.getVideoSrv());
            return;
        }
        try {
            block43: {
                if (data.length >= 2 && data[0] == -128 && data[1] == -56) {
                    System.arraycopy(data, 4, this.receiverReport, 8, 4);
                    System.arraycopy(data, 10, this.receiverReport, 24, 4);
                    this.rtspHandler.sendReceiverReportVideo(this.receiverReport);
                    return;
                }
                System.arraycopy(data, 2, this.receiverReport, 18, 2);
                this.rtspHandler.storeReceiverReportVideo(this.receiverReport);
                this.checkForPacketLoss(data);
                if ((data[0] >> 4 & 1) == 1) {
                    this.rtpExtensionProfileCheckPassed = this.is7000Series ? data[12] == 82 && data[13] == -126 : true;
                    if (this.rtpExtensionProfileCheckPassed) {
                        lengthOfHeader = Basic.byteArrayToInt4((byte[])new byte[]{data[14], data[15]});
                        if ((lengthOfHeader *= 4) > 0) {
                            for (int i = 16; i < lengthOfHeader + 16; ++i) {
                                byte lengthOfContent;
                                if (data[i] == 0) continue;
                                if (data[i] == 1) {
                                    if ((data[i + 1] & 0x80) == -128) continue;
                                    lengthOfContent = (byte)(data[i + 1] & 0x7F);
                                    i += 10;
                                    if (this.getVideoSrv().getDevice().getIOHandler() != null) {
                                        boolean additionalDIsActive;
                                        byte statusAllInputs = (byte)(data[i] & 0xF);
                                        boolean bl = additionalDIsActive = (byte)(data[i + 2] & 2) == 2;
                                        if (additionalDIsActive) {
                                            byte statusDI7 = (byte)(data[i + 2] << 3 & 8);
                                            byte statusDI4To6 = (byte)(data[i + 3] >> 5 & 7);
                                            statusAllInputs = (byte)(statusAllInputs | statusDI7 << 4 | statusDI4To6 << 4);
                                        }
                                        ((VivotekIOHandler)this.getVideoSrv().getDevice().getIOHandler()).processContent(statusAllInputs);
                                    }
                                    int userDataLength = data[i += 11] * 4;
                                    byte[] bytesToCheck = new byte[userDataLength];
                                    System.arraycopy(data, i + 1, bytesToCheck, 0, userDataLength);
                                    if (this.listener.hasHardwareMotionDetection() && this.getVideoSrv().getHardwareMotionDetection() != null) {
                                        ((VivotekMotionDetectionHandler)((Object)((VivotekHardwareMotionDetection)this.getVideoSrv().getHardwareMotionDetection()).getMotionDetectionHandler())).processMotionDetection(bytesToCheck);
                                    }
                                    i += lengthOfContent + 1 - 21;
                                    continue;
                                }
                                if ((data[i + 1] & 0x80) == -128) continue;
                                lengthOfContent = (byte)(data[i + 1] & 0x7F);
                                i += lengthOfContent + 1;
                            }
                        }
                        lengthOfHeader += 4;
                    }
                }
                int OFFSET = 12 + lengthOfHeader;
                try {
                    if (this.videoCodec == Codec.H264) {
                        if ((data[OFFSET] & 0x1C) == 28) {
                            if ((data[OFFSET + 1] & 0x80) == 128) {
                                byte newNalUnitOctet = (byte)(data[OFFSET + 1] & 0x1F);
                                byte fandNri = (byte)(data[OFFSET] & 0xE0);
                                newNalUnitOctet = (byte)(newNalUnitOctet | fandNri);
                                try {
                                    this.completeFrame.write(StreamingHelper.START_SEQUENCE);
                                    this.completeFrame.write(newNalUnitOctet);
                                    this.completeFrame.flush();
                                }
                                catch (IOException e) {
                                    this.logger.error("Error writing startSequence/NAL header for a frame.", (Throwable)e);
                                    return;
                                }
                            }
                            try {
                                this.completeFrame.write(data, OFFSET + 2, data.length - (OFFSET + 2));
                                this.completeFrame.flush();
                            }
                            catch (IOException e) {
                                this.logger.error("Error cummulating data for a frame.", (Throwable)e);
                                return;
                            }
                            if ((data[OFFSET + 1] & 0x40) == 64) {
                                completeFrameAsByteArray = this.completeFrame.toByteArray();
                                this.completeFrame.reset();
                                isFrameCompleted = true;
                            }
                            break block43;
                        }
                        if ((data[OFFSET] & 1) == 1) {
                            completeFrameAsByteArray = new byte[data.length - OFFSET + 3];
                            System.arraycopy(StreamingHelper.START_SEQUENCE, 0, completeFrameAsByteArray, 0, StreamingHelper.START_SEQUENCE.length);
                            System.arraycopy(data, OFFSET, completeFrameAsByteArray, 3, data.length - OFFSET);
                            isFrameCompleted = true;
                        } else if ((data[OFFSET] & 8) == 8) {
                            completeFrameAsByteArray = new byte[data.length - OFFSET + 3];
                            System.arraycopy(StreamingHelper.START_SEQUENCE, 0, completeFrameAsByteArray, 0, StreamingHelper.START_SEQUENCE.length);
                            System.arraycopy(data, OFFSET, completeFrameAsByteArray, 3, data.length - OFFSET);
                            isFrameCompleted = true;
                        } else {
                            if ((data[OFFSET] & 0x18) != 24) return;
                            completeFrameAsByteArray = new byte[data.length - OFFSET + 3];
                            System.arraycopy(StreamingHelper.START_SEQUENCE, 0, completeFrameAsByteArray, 0, StreamingHelper.START_SEQUENCE.length);
                            System.arraycopy(data, OFFSET, completeFrameAsByteArray, 3, data.length - OFFSET);
                            isFrameCompleted = true;
                        }
                        break block43;
                    }
                    this.completeFrame.write(data, OFFSET, data.length - OFFSET);
                    this.completeFrame.flush();
                    if (!StreamingHelper.isFollowUp(data)) {
                        completeFrameAsByteArray = this.completeFrame.toByteArray();
                        this.completeFrame.reset();
                        isFrameCompleted = true;
                    }
                }
                catch (IOException e) {
                    this.logger.error("Error cummulating data for a frame.", (Throwable)e);
                }
            }
            if (!isFrameCompleted) return;
            if (this.videoCodec == Codec.H264) {
                this.mediaType = StreamingHelperH264.checkForH264MediaType(this.getVideoSrv().getDevice(), completeFrameAsByteArray);
                if (this.mediaType < 0) {
                    this.logger.warn("Unknown Mediatype. Discarding frame for " + this.getVideoSrv());
                    return;
                } else {
                    if (this.mediaType == 7) {
                        this.parameterSetPart = new byte[completeFrameAsByteArray.length];
                        System.arraycopy(completeFrameAsByteArray, 0, this.parameterSetPart, 0, completeFrameAsByteArray.length);
                        return;
                    }
                    if (this.mediaType == 8) {
                        this.pictureSet = new byte[completeFrameAsByteArray.length];
                        System.arraycopy(completeFrameAsByteArray, 0, this.pictureSet, 0, completeFrameAsByteArray.length);
                        return;
                    }
                    if (this.mediaType == 33) {
                        if (this.parameterSetPart != null && this.pictureSet != null) {
                            this.parameterSet = new byte[this.parameterSetPart.length + this.pictureSet.length];
                            System.arraycopy(this.parameterSetPart, 0, this.parameterSet, 0, this.parameterSetPart.length);
                            System.arraycopy(this.pictureSet, 0, this.parameterSet, this.parameterSetPart.length, this.pictureSet.length);
                            int[] resolutionFromStream = StreamingHelperH264.extractH264Resolution(this.parameterSet);
                            if (resolutionFromStream != null) {
                                this.width = resolutionFromStream[0];
                                this.height = resolutionFromStream[1];
                            }
                        }
                        if (this.parameterSet == null) {
                            this.logger.fatal("Config frame not arrived as first frame. Abort!");
                            this.shutdown();
                        }
                    } else if (this.mediaType != 35) {
                        return;
                    }
                    MediaFrame mediaFrame = StreamingHelper.createSeeTecVideoFrameHeader(Codec.H264, this.width, this.height, completeFrameAsByteArray, this.parameterSet);
                    this.deliverFrameCreateServerTimestamp(this.mediaType, mediaFrame);
                }
                return;
            } else {
                this.mediaType = StreamingHelperMpeg4.checkForMPEG4Part2MediaType(completeFrameAsByteArray);
                if (this.mediaType < 0) {
                    this.logger.warn("Unknown Mediatype. Discarding frame for " + this.getVideoSrv());
                    return;
                } else {
                    int[] currentResolution;
                    if (this.mediaType == 33 && (currentResolution = StreamingHelperMpeg4.extractMPEG4Part2Resolution(completeFrameAsByteArray)) != null) {
                        this.width = currentResolution[0];
                        this.height = currentResolution[1];
                    }
                    MediaFrame mediaFrame = StreamingHelper.createSeeTecVideoFrameHeader(Codec.MPEG4, this.width, this.height, completeFrameAsByteArray);
                    this.deliverFrameCreateServerTimestamp(this.mediaType, mediaFrame);
                }
            }
            return;
        }
        catch (Throwable t) {
            this.logger.error("Ignoring packet due to unexpected error: " + t.getMessage(), t);
        }
    }

    @Override
    public void sendStatusService(int errorCode) {
        this.listener.sendStatusService(errorCode);
    }

    @Override
    public int init() {
        String prefix;
        long[] allowedValues;
        long[] allowedValues2;
        int error = 0;
        error = super.init();
        if (error != 0) {
            this.logger.error("Error while initializing. Code: " + this.errorCode + " for " + this);
            return error;
        }
        int legacyTimeout = ((VivotekDevice)this.videoSrv.getDevice()).legacyTimeout;
        this.networkParameter.checkAndSetTimeout(legacyTimeout);
        this.streamId = "_s" + this.listener.getDynamicVideoProfileID();
        if (this.getListener().getLiveCameraSrv().getDevice().getNumberOfVideoSources() > 1) {
            this.livePostfix = this.videoSourceNr - 1 == 0 ? "" : "" + this.videoSourceNr;
            this.livePostfix = this.listener.getDynamicVideoProfileID() == 0 ? this.livePostfix : this.livePostfix + "s" + (this.listener.getDynamicVideoProfileID() + 1);
        } else {
            this.livePostfix = this.listener.getDynamicVideoProfileID() == 0 ? "" : "" + (this.listener.getDynamicVideoProfileID() + 1);
        }
        try {
            this.passphrase = NetworkHelper.createBasicAuthorization((NetworkParameter)this.networkParameter);
        }
        catch (Exception ex) {
            this.logger.error("Exception while creating Basic Authorization for " + this + ": " + ex.getMessage());
        }
        if (this.getVideoSrv().getEntityType() == 212434L) {
            this.streamId = "" + ((VivotekCameraSrv)this.getVideoSrv()).getStreamNumber(this.listener.getDynamicVideoProfileID());
            this.livePostfix = this.streamId.equals("0") ? "" : "2";
            this.streamId = "_s" + this.streamId;
        }
        if (this.getVideoSrv().getEntityType() == 212431L) {
            this.streamId = "" + ((VivotekCameraSrv)this.getVideoSrv()).getStreamNumber(this.listener.getDynamicVideoProfileID());
            this.streamId = "_s" + this.streamId;
            allowedValues2 = new long[]{1L, 2L, 3L, 5L, 8L, 10L, 15L, 20L, 25L, 30L, 35L, 40L, 45L, 50L, 55L, 60L};
            this.fps = Tools.convertToCameraValues(allowedValues2, this.fps / 1000L);
        } else {
            allowedValues2 = new long[]{1L, 2L, 3L, 5L, 10L, 15L, 20L, 25L, 30L, 60L};
            this.fps = Tools.convertToCameraValues(allowedValues2, this.fps / 1000L);
        }
        this.passphrase = this.passphrase == null ? "User-Agent: RTPExPlayer\r\n" : this.passphrase + "User-Agent: RTPExPlayer\r\n";
        StringBuilder sb = new StringBuilder(256);
        StringBuilder sbAudio = new StringBuilder(256);
        if (this.getVideoSrv().getEntityType() == 212400L || this.getVideoSrv().getEntityType() == 212408L || this.getVideoSrv().getEntityType() == 212409L) {
            allowedValues = new long[]{1L, 3L, 5L, 10L, 30L, 60L, 90L, 120L};
            this.iFrameDist = Tools.convertToCameraValues(allowedValues, (long)(this.iFrameDistMS / 1000) * this.fps);
        } else {
            allowedValues = new long[]{250L, 500L, 1000L, 2000L, 3000L, 4000L};
            this.iFrameDist = Tools.convertToCameraValues(allowedValues, (long)this.iFrameDistMS);
        }
        int[] allowedIntValues = new int[]{20000, 40000, 50000, 64000, 128000, 256000, 512000, 768000, 1000000, 1500000, 2000000, 3000000, 4000000, 6000000, 8000000, 10000000, 12000000, 14000000, 16000000};
        this.bandwidth = Tools.convertToCameraValues(allowedIntValues, (int)((double)this.bandwidth / 1.024));
        this.quality /= 20000;
        this.quality = this.quality < 1 ? 1 : this.quality;
        String codecString = this.videoCodec == Codec.H264 ? "h264" : "mpeg4";
        try {
            byte[] result = NetworkHelper.readGetRequest((NetworkParameter)this.networkParameter, (String)"/cgi-bin/admin/getparam.cgi?system_info_modelname", (int)Integer.MAX_VALUE);
            String[] parts = new String(result).split("system_info_modelname='");
            if (parts.length >= 2) {
                String modelName = parts[1].substring(2);
                this.is7000Series = modelName.startsWith("7");
                this.logger.info("7000 series: '" + this.is7000Series + "' for " + this);
            }
        }
        catch (SeeTecException see) {
            this.logger.error((Object)see, (Throwable)see);
            error = see.getErrorCode();
            return error;
        }
        catch (Exception e) {
            this.logger.error((Object)e, (Throwable)e);
            return -21601;
        }
        sb.append(SET_PARAM);
        if (this.getVideoSrv().getEntityType() == 212400L || this.getVideoSrv().getEntityType() == 212408L || this.getVideoSrv().getEntityType() == 212409L) {
            this.rtspUrl = "/live" + this.livePostfix + ".sdp";
            if (this.isAudioEnabled) {
                sbAudio.append(SET_PARAM);
                sbAudio.append("audio_type=aac");
                sbAudio.append("&audio_aacbitrate=");
                sbAudio.append(this.audioBitrate);
            }
            prefix = "video_";
            sb.append(prefix);
            sb.append("codectype=0");
            sb.append("&");
            sb.append(prefix);
            sb.append("maxframe=");
            sb.append(this.fps);
            sb.append("&");
            sb.append(prefix);
            sb.append("keyinterval=");
            sb.append(this.iFrameDist);
            if (this.isConstantBitrateUsed) {
                sb.append("&");
                sb.append(prefix);
                sb.append("quality=0");
                sb.append("&");
                sb.append(prefix);
                sb.append("bitrate=");
                sb.append(this.bandwidth);
            } else {
                sb.append("&");
                sb.append(prefix);
                sb.append("quality=1");
                sb.append("&");
                sb.append(prefix);
                sb.append("quant=");
                sb.append(this.quality);
            }
            sb.append("&");
            sb.append(prefix);
            sb.append("resolution=");
            sb.append(this.width);
            sb.append("x");
            sb.append(this.height);
            sb.append("&");
            sb.append(prefix);
            sb.append("imprinttimestamp=");
            if (this.useDateTime) {
                sb.append("1");
            } else {
                sb.append("0");
            }
            sb.append("&");
            sb.append(prefix);
            sb.append("text=");
            if (this.useTitle) {
                sb.append(this.title);
            }
            sb.append("&");
            sb.append(prefix);
            sb.append("flip=");
            if (this.rotationAngle == 180) {
                sb.append("1");
                sb.append("&");
                sb.append(prefix);
                sb.append("mirror=1");
            } else {
                sb.append("0");
                sb.append("&");
                sb.append(prefix);
                sb.append("mirror=0");
            }
        } else {
            this.rtspUrl = "/live" + this.livePostfix + ".sdp";
            if (this.isAudioEnabled) {
                sbAudio.append(SET_PARAM);
                sbAudio.append("audioin_c");
                sbAudio.append(this.videoSourceNr - 1);
                sbAudio.append(this.streamId);
                sbAudio.append("_codectype=aac4&audioin_c");
                sbAudio.append(this.videoSourceNr - 1);
                sbAudio.append(this.streamId);
                sbAudio.append("_aac4_bitrate=");
                sbAudio.append(this.audioBitrate);
            }
            prefix = "videoin_c" + (this.videoSourceNr - 1) + this.streamId + "_";
            sb.append(prefix);
            sb.append("codectype=");
            sb.append(codecString);
            sb.append("&");
            sb.append(prefix);
            sb.append(codecString);
            sb.append("_maxframe=");
            sb.append(this.fps);
            sb.append("&");
            sb.append(prefix);
            sb.append(codecString);
            sb.append("_intraperiod=");
            sb.append(this.iFrameDist);
            if (this.isConstantBitrateUsed) {
                sb.append("&");
                sb.append(prefix);
                sb.append(codecString);
                sb.append("_ratecontrolmode=cbr");
                sb.append("&");
                sb.append(prefix);
                sb.append(codecString);
                sb.append("_bitrate=");
                sb.append(this.bandwidth);
            } else {
                sb.append("&");
                sb.append(prefix);
                sb.append(codecString);
                sb.append("_ratecontrolmode=vbr");
                sb.append("&");
                sb.append(prefix);
                sb.append(codecString);
                sb.append("_quant=");
                sb.append(this.quality);
            }
            sb.append("&");
            sb.append(prefix);
            sb.append("resolution=");
            if (this.getVideoSrv().getEntityType() == 212407L || this.getVideoSrv().getEntityType() == 212425L || this.getVideoSrv().getEntityType() == 212429L || this.getVideoSrv().getEntityType() == 212437L) {
                sb.append(((VivotekCameraSrv)this.getVideoSrv()).getResolutionName(this.width));
            } else if (this.resolutionTag != null && !this.resolutionTag.isEmpty()) {
                sb.append(this.resolutionTag);
            } else {
                sb.append(this.width);
                sb.append("x");
                sb.append(this.height);
            }
            sb.append("&videoin_c");
            sb.append(this.videoSourceNr - 1);
            sb.append("_");
            sb.append("imprinttimestamp=");
            sb.append(this.useDateTime ? "1" : "0");
            sb.append("&videoin_c");
            sb.append(this.videoSourceNr - 1);
            sb.append("_");
            sb.append("text=");
            if (this.useTitle) {
                sb.append(this.title);
            }
            sb.append("&videoin_c");
            sb.append(this.videoSourceNr - 1);
            sb.append("_");
            sb.append("flip=");
            if (this.rotationAngle == 180) {
                sb.append("1");
                sb.append("&videoin_c");
                sb.append(this.videoSourceNr - 1);
                sb.append("_");
                sb.append("mirror=1");
            } else {
                sb.append("0");
                sb.append("&videoin_c");
                sb.append(this.videoSourceNr - 1);
                sb.append("_");
                sb.append("mirror=0");
            }
        }
        try {
            NetworkHelper.readGetRequest((NetworkParameter)this.networkParameter, (String)sb.toString(), (int)Integer.MAX_VALUE);
        }
        catch (SeeTecException see) {
            this.logger.error((Object)see, (Throwable)see);
            error = see.getErrorCode();
            return error;
        }
        catch (Exception e) {
            this.logger.error((Object)e, (Throwable)e);
            return -21601;
        }
        if (this.isAudioEnabled) {
            try {
                NetworkHelper.readGetRequest((NetworkParameter)this.networkParameter, (String)sbAudio.toString(), (int)Integer.MAX_VALUE);
            }
            catch (SeeTecException see) {
                this.logger.error((Object)see, (Throwable)see);
                error = see.getErrorCode();
                return error;
            }
            catch (Exception e) {
                this.logger.error("Reading/Setting audio configuration from " + this.getVideoSrv().getDevice() + " failed :-(", (Throwable)e);
                return -21601;
            }
        }
        this.rtspSettings = new RTSPStreamSettings();
        try {
            error = this.rtspSettings.init(this, this.audioSourceClient, this.networkParameter, this.listener.getVideoSourceParameter().getRtspPort(), "rtsp://" + this.getHost() + this.rtspUrl, this.printDebug, this.transmissionID, this.networkParameter.getSoTimeout(), this.isAudioEnabled, 4, this.rtspUrl);
            if (error != 0) {
                this.logger.error("Initialization of RTSPSettings failed with errorCode: " + error + " for " + this.getVideoSrv());
                return error;
            }
        }
        catch (ConfigurationException ex) {
            this.logger.warn("Could not initialize rtspSettings for " + this);
            this.logger.warn((Object)ex, (Throwable)ex);
        }
        this.rtspSettings.setUserAgent("RTPExPlayer");
        this.rtspSettings.setCheckResolution(true, new int[]{this.width, this.height}, 20, 5000L);
        this.rtspSettings.setCheckResolution(true, new int[]{this.width, this.height});
        try {
            this.rtspHandler = this.rtspSettings.getRTSPHandler();
        }
        catch (SeeTecException ex) {
            this.logger.error("Exception while starting RTSP Handling for " + this.getVideoSrv() + " : " + ex.getMessage());
            return ex.getErrorCode();
        }
        error = this.rtspHandler.start();
        if (error != 0) {
            this.logger.error("Start of RTSPHandler failed with errorCode: " + error + " for " + this.getVideoSrv());
            return error;
        }
        this.logger.info("init done for" + this.getVideoSrv());
        return 0;
    }

    @Override
    public void onNetworkError(int error) {
        if (this.isShutdown()) {
            return;
        }
        this.logger.warn("Shutting down : " + error);
        this.listener.sendStatusService(error);
        this.shutdown();
    }

    @Override
    public final boolean isShutdown() {
        return this.isShutdown(CLASS_NAME);
    }

    @Override
    public int shutdown() {
        if (this.startShutdown(CLASS_NAME)) {
            return 0;
        }
        return super.shutdown();
    }
}

