/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.cm.device.video.vivotek;

import de.seetec.v5.re.cm.device.shared.io.DigitalInputSrv;
import de.seetec.v5.re.cm.device.shared.io.IOHandler;
import de.seetec.v5.shared.net.NetworkHelper;
import de.seetec.v5.shared.net.NetworkParameter;
import de.seetec.v5.shared.util.SeeTecException;

public class VivotekIOHandler
extends IOHandler {
    private static final String CLASS_NAME = "de.seetec.v5.re.cm.vivotek.VivotekIOHandler";

    @Override
    public final void run() {
        super.setRunFinished(CLASS_NAME, false);
    }

    public void processContent(byte status) {
        DigitalInputSrv[] iServices;
        int[] nInputValues = new int[super.getHighestInputNumber()];
        for (int i = 0; i < nInputValues.length; ++i) {
            int mask = (int)Math.pow(2.0, i);
            nInputValues[i] = status & mask;
        }
        for (DigitalInputSrv iService : iServices = super.getDigitalInputSrv()) {
            iService.checkInput(nInputValues);
        }
    }

    @Override
    public int writeDigitalOutput(int nNumber, int value, long holdTime) {
        StringBuilder url = new StringBuilder();
        try {
            IOHandler.HoldTimer holdTimer;
            int errorCode;
            url.append("/cgi-bin");
            if (this.device.getDeviceType() == 202400L) {
                url.append("/setdo.cgi?do=");
                url.append(value == 0 ? "L" : "H");
            } else {
                url.append("/dido/setdo.cgi?do");
                url.append(nNumber - 1);
                url.append("=");
                url.append(value);
            }
            NetworkHelper.readGetRequest((NetworkParameter)this.networkParameter, (String)url.toString());
            if (holdTime > 0L && (errorCode = (holdTimer = new IOHandler.HoldTimer()).init(nNumber, value > 0 ? 0 : 1, holdTime)) != 0) {
                holdTimer.shutdown();
                this.logger.warn("Creating " + holdTimer + " failed with error [" + errorCode + "] :-(");
            }
            return 0;
        }
        catch (SeeTecException sex) {
            this.logger.error((Object)sex, (Throwable)sex);
            return sex.getErrorCode();
        }
        catch (Throwable ex) {
            this.logger.error((Object)ex, ex);
            return -21600;
        }
    }
}

