/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.cm.device.video.vivotek;

import de.seetec.v5.re.cm.device.shared.VideoSrv;
import de.seetec.v5.re.cm.device.shared.cameracontrol.CameraControl;
import de.seetec.v5.re.cm.device.shared.cameracontrol.PresetCnf;
import de.seetec.v5.re.cm.shared.communication.VideoServiceClientRequestHandler;
import de.seetec.v5.shared.net.NetworkHelper;
import de.seetec.v5.shared.net.NetworkParameter;
import de.seetec.v5.shared.util.SeeTecException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Vector;

public class VivotekCameraControl
extends CameraControl {
    private int divider = 20000;
    private int limit = 5;
    private int oldPanSpeed = 0;
    private int oldTiltSpeed = 0;

    @Override
    public int init(VideoSrv videoSrv, String api, String host, int port, String usr, String pwd, Vector<PresetCnf> presetList) {
        int errorCode = super.init(videoSrv, api, host, port, usr, pwd, presetList);
        try {
            byte[] result = NetworkHelper.readGetRequest((NetworkParameter)this.networkParameter, (String)"/cgi-bin/viewer/getparam.cgi?capability_ptz_panspeedlv", (int)Integer.MAX_VALUE);
            if (result != null && result.length > 0) {
                String[] parts = new String(result).split("capability_ptz_panspeedlv='");
                if (parts.length > 1) {
                    this.limit = Integer.parseInt(parts[1].substring(0, parts[1].indexOf("'")));
                    this.logger.info("Camera gave us information that max pan speed is: " + this.limit);
                } else {
                    result = NetworkHelper.readGetRequest((NetworkParameter)this.networkParameter, (String)"/cgi-bin/viewer/getparam.cgi?system_info_modelname", (int)Integer.MAX_VALUE);
                    if (result != null) {
                        parts = new String(result).split("system_info_modelname='");
                        if (parts.length > 1) {
                            String modelName;
                            switch (modelName = parts[1].substring(0, parts[1].indexOf("'"))) {
                                case "SD81X1": {
                                    this.limit = 15;
                                    break;
                                }
                                case "SD83X1": 
                                case "SD83X2": 
                                case "SD83X3": {
                                    this.limit = 45;
                                    break;
                                }
                                default: {
                                    this.limit = 7;
                                }
                            }
                            this.logger.info("Model: " + modelName + " uses limit: " + this.limit);
                        }
                    } else {
                        this.logger.error("Error while requesting model name. Stay with defaults.");
                    }
                }
                if (this.videoSrv.getDevice().getDeviceEntity().getEntityType() == 202440L) {
                    this.limit = 100;
                }
                this.divider = 100000 / this.limit;
            }
        }
        catch (Throwable ex) {
            this.logger.error("Error while requesting ptz capabilities. Stay with defaults.");
        }
        return errorCode;
    }

    private byte[] sendCameraCommand(String sURL) {
        return this.sendCameraCommand(sURL, "camctrl");
    }

    private byte[] sendPresetCommand(String sURL, String command) {
        return this.sendCameraCommand(sURL, command);
    }

    private byte[] sendCameraCommand(String sURL, String command) {
        try {
            int videoSourceNr = this.videoSrv.getVideoSourceCnf().getServerEntryNo() - 1;
            int camID = this.videoSrv.getVideoSourceCnf().getPtzAddress();
            sURL = command.equals("camctrl") ? "/cgi-bin/camctrl/camctrl.cgi?channel=" + videoSourceNr + "&camid=" + camID + "&" + sURL : (command.equals("preset") ? "/cgi-bin/operator/" + command + ".cgi?channel=" + videoSourceNr + "&" + sURL : (command.equals("setparam") ? "/cgi-bin/admin/" + command + ".cgi?videoin_c" + videoSourceNr + "_" + sURL : "/cgi-bin/viewer/" + command + ".cgi?channel=" + videoSourceNr + "&" + sURL));
            byte[] result = null;
            this.videoSrv.notifyForCameraControl();
            this.logger.info("Writing URL: " + sURL + " for " + this.videoSrv);
            result = NetworkHelper.readGetRequest((NetworkParameter)this.networkParameter, (String)sURL, (int)Integer.MIN_VALUE);
            return result;
        }
        catch (Throwable ex) {
            this.logger.error((Object)ex, ex);
            return null;
        }
    }

    @Override
    public int setAbsolutePTZ(VideoServiceClientRequestHandler sender, Integer pan, Integer tilt, Integer zoom) {
        throw new RuntimeException("NOT YET IMPLEMENTED :-(");
    }

    @Override
    public int setContinuousPTZ(Integer nPanSpeed, Integer nTiltSpeed, Integer nZoomSpeed) {
        StringBuilder sb;
        int tiltSpeed;
        int panSpeed;
        if (nPanSpeed != null) {
            this.oldPanSpeed = panSpeed = nPanSpeed / this.divider;
        } else {
            panSpeed = this.oldPanSpeed;
        }
        if (nTiltSpeed != null) {
            this.oldTiltSpeed = tiltSpeed = nTiltSpeed / this.divider;
        } else {
            tiltSpeed = this.oldTiltSpeed;
        }
        if (this.videoSrv.getDevice().getDeviceEntity().getEntityType() == 202432L) {
            sb = new StringBuilder(256);
            if (tiltSpeed > 0) {
                sb.append("&move=up");
            } else if (tiltSpeed < 0) {
                sb.append("&move=down");
            }
            if (panSpeed > 0) {
                sb.append("&move=right");
            } else if (panSpeed < 0) {
                sb.append("&move=left");
            }
            String url = sb.toString();
            if (url.length() > 0) {
                url = url.substring(1);
                this.sendCameraCommand(url);
            }
        } else {
            sb = new StringBuilder(256);
            sb.append("vx=");
            sb.append(panSpeed);
            sb.append("&vy=");
            sb.append(tiltSpeed);
            sb.append("&speedpan=");
            sb.append(panSpeed);
            sb.append("&speedtilt=");
            sb.append(tiltSpeed);
            sb.append("&vs=");
            int speed = Math.max(Math.abs(panSpeed), Math.abs(tiltSpeed));
            sb.append(speed);
            this.sendCameraCommand(sb.toString());
        }
        if (nZoomSpeed != null) {
            nZoomSpeed = nZoomSpeed >= 0 ? nZoomSpeed + (this.divider - 1) : nZoomSpeed - (this.divider - 1);
            int zoomSpeed = nZoomSpeed / this.divider;
            sb = new StringBuilder(256);
            if (this.videoSrv.getDevice().getDeviceEntity().getEntityType() == 202432L) {
                if (zoomSpeed < 0) {
                    sb.append("zoom=wide");
                } else if (zoomSpeed > 0) {
                    sb.append("zoom=tele");
                }
                if (zoomSpeed != 0) {
                    this.sendCameraCommand(sb.toString());
                }
            } else {
                if (zoomSpeed != 0) {
                    if (zoomSpeed < 0) {
                        sb.append("zooming=wide&zs=");
                    } else {
                        sb.append("zooming=tele&zs=");
                    }
                    sb.append(Math.abs(zoomSpeed));
                } else {
                    sb.append("zoom=stop");
                }
                this.sendCameraCommand(sb.toString());
            }
        }
        return 0;
    }

    @Override
    public int setCenterPT(Integer xPosition, Integer yPosition, int[] resolution) {
        try {
            int[] pos = this.calcCenterPT(xPosition, yPosition, resolution[0], resolution[1]);
            this.sendCameraCommand("x=" + pos[0] + "&y=" + pos[1] + "&resolution=" + resolution[0] + "x" + resolution[1] + "&videosize=" + resolution[0] + "x" + resolution[1] + "&stretch=0", "camctrl");
            return 0;
        }
        catch (Exception ex) {
            this.logger.error("Exception while reading PTZ configuration for: " + this, (Throwable)ex);
            return 0;
        }
    }

    protected final int[] calcCenterPT(Integer x, Integer y, int w, int h) throws SeeTecException {
        if (x == null || x < 0 || x > 100 || y == null || y < 0 || y > 100 || w <= 0 || h <= 0) {
            throw new SeeTecException(-21653, "Invalid CenterPT parameters for " + this.videoSrv + ": x=" + x + ",y=" + y + ",w=" + w + ",h=" + h);
        }
        return new int[]{w * x / 100, h * y / 100};
    }

    @Override
    public int setZoomArea(Integer xPosition, Integer yPosition, Integer width, Integer height, int[] resolution) {
        throw new RuntimeException("NOT YET IMPLEMENTED :-(");
    }

    @Override
    public int setAbsoluteIris(Integer value) {
        throw new RuntimeException("NOT YET IMPLEMENTED :-(");
    }

    @Override
    public int setContinuousIris(Integer value) {
        if (value != null && value != 0) {
            if (value > 0) {
                this.sendCameraCommand("iris=open");
            } else {
                this.sendCameraCommand("iris=close");
            }
        }
        return 0;
    }

    @Override
    public int setAutoIris(Boolean active) {
        if (active.booleanValue()) {
            this.sendCameraCommand("iris=auto");
        }
        return 0;
    }

    @Override
    public int setAbsoluteFocus(Integer value) {
        throw new RuntimeException("NOT YET IMPLEMENTED :-(");
    }

    @Override
    public int setContinuousFocus(Integer value) {
        if (value != null && value != 0) {
            if (value > 0) {
                this.sendCameraCommand("focus=far");
            } else {
                this.sendCameraCommand("focus=near");
            }
        }
        return 0;
    }

    @Override
    public int setAutoFocus(Boolean active) {
        if (active.booleanValue()) {
            this.sendCameraCommand("focus=auto");
        }
        return 0;
    }

    @Override
    public int setZeroLux(Boolean active) {
        if (active.booleanValue()) {
            this.sendCameraCommand("daynight=night", "setparam");
        } else {
            this.sendCameraCommand("daynight=day", "setparam");
        }
        return 0;
    }

    @Override
    public int setAutoZeroLux(Boolean active) {
        return 0;
    }

    @Override
    public int setHomePosition() {
        this.sendCameraCommand("move=home");
        return 0;
    }

    @Override
    public int addPresetPosition(Vector<byte[]> vResult, Long presetID, String presetName) {
        String sEncodedPresetName = null;
        try {
            sEncodedPresetName = URLEncoder.encode(presetName.trim(), "UTF-8");
            PresetCnf presetCnf = PresetCnf.createPresetCnf((long)presetID, sEncodedPresetName);
            this.presetList.addElement(presetCnf);
            vResult.addElement(presetCnf.getPresetCnf());
            this.logger.info("Adding preset: " + new String(presetCnf.getPresetCnf()));
            this.sendPresetCommand("addpos=" + sEncodedPresetName, "preset");
            return 0;
        }
        catch (UnsupportedEncodingException ex) {
            throw new RuntimeException(ex.getMessage());
        }
    }

    @Override
    public int setPresetPosition(String presetName) {
        try {
            String sEncodedPresetName = URLEncoder.encode(presetName.trim(), "UTF-8");
            this.sendCameraCommand("recall=" + sEncodedPresetName, "recall");
        }
        catch (UnsupportedEncodingException ex) {
            throw new RuntimeException(ex.getMessage());
        }
        return 0;
    }

    @Override
    public int removePresetPosition(String presetName) {
        try {
            String sEncodedPresetName = URLEncoder.encode(presetName.trim(), "UTF-8");
            for (int i = 0; i < this.presetList.size(); ++i) {
                PresetCnf presetCnf = (PresetCnf)this.presetList.elementAt(i);
                if (!sEncodedPresetName.equals(presetCnf.getPresetName())) continue;
                this.logger.info("Removing preset: " + new String(presetCnf.getPresetCnf()));
                this.presetList.removeElementAt(i);
                this.sendPresetCommand("delpos=" + sEncodedPresetName, "preset");
                return 0;
            }
        }
        catch (Exception ex) {
            this.logger.error((Object)ex, (Throwable)ex);
            this.logger.error("Removing preset [" + presetName + "] failed :-(");
            return -21600;
        }
        this.logger.error("Preset [" + presetName + "] not available :-(");
        this.logger.error("PresetList=" + this.presetList);
        return -21683;
    }
}

