/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.cm.device.video.videofile.watcher;

import de.seetec.v5.re.cm.device.video.videofile.VideoFileConstants;
import de.seetec.v5.re.cm.device.video.videofile.watcher.FileListener;
import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public class FileWatcher
implements Runnable {
    private static final long INTERNAL_DEADTIME_WATCHING_ERROR = TimeUnit.MINUTES.toMillis(10L);
    private final Path rootFolder;
    private final ScheduledThreadPoolExecutor executor = (ScheduledThreadPoolExecutor)Executors.newScheduledThreadPool(1);
    private final List<FileListener> listeners = new ArrayList<FileListener>();
    private boolean isScanInProgress = false;
    private long lastWatchingError = Long.MIN_VALUE;

    public FileWatcher(Path rootFolder) {
        this.rootFolder = rootFolder;
    }

    public int startWatch() {
        if (Files.exists(this.rootFolder, new LinkOption[0])) {
            this.executor.scheduleWithFixedDelay(this, 0L, 500L, VideoFileConstants.CYCLIC_SCAN_TIME_UNIT);
            return 0;
        }
        if (this.listeners != null) {
            this.listeners.forEach(l -> l.onError(null, -21713, "Folder '" + this.rootFolder + "' not existing", "Folder '" + this.rootFolder + "' not existing"));
        }
        return -21713;
    }

    public void shutdown() {
        this.executor.shutdown();
    }

    @Override
    public void run() {
        try {
            if (!this.isScanInProgress) {
                this.isScanInProgress = true;
                this.recursiveScan(this.rootFolder);
            }
        }
        catch (IOException exception) {
            if (System.currentTimeMillis() > this.lastWatchingError + INTERNAL_DEADTIME_WATCHING_ERROR) {
                this.lastWatchingError = System.currentTimeMillis();
                if (this.listeners != null) {
                    this.listeners.forEach(l -> l.onError(null, -21713, "Error watching filesystem.", "Exception occured while watching filesystem: " + exception.getMessage()));
                }
            }
        }
        finally {
            this.isScanInProgress = false;
        }
    }

    private void recursiveScan(Path folder) throws IOException {
        DirectoryStream.Filter<Path> filter = entry -> Files.isDirectory(entry, new LinkOption[0]) || entry.toFile().getName().equalsIgnoreCase("complete");
        try (DirectoryStream<Path> directoryStream = Files.newDirectoryStream(folder, filter);){
            for (Path entry2 : directoryStream) {
                if (Files.isDirectory(entry2, new LinkOption[0])) {
                    this.recursiveScan(entry2);
                    continue;
                }
                this.listeners.forEach(l -> l.onCompleted(entry2.toFile()));
            }
        }
    }

    public void addListener(FileListener listener) {
        this.listeners.add(listener);
    }

    public boolean removeListener(FileListener listener) {
        return this.listeners.remove(listener);
    }
}

