/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.cm.device.video.videofile.metadata;

import de.seetec.v5.re.cm.device.video.videofile.metadata.GpsLocation;
import de.seetec.v5.re.cm.device.video.videofile.metadata.MetadataException;
import de.seetec.v5.re.cm.device.video.videofile.metadata.MetadataObject;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.time.Instant;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.FilenameUtils;
import org.jose4j.json.JsonUtil;

public class MetadataParser {
    public MetadataObject parse(Path folder) throws IOException, MetadataException {
        if (folder == null || !Files.exists(folder, new LinkOption[0])) {
            throw new IOException("Argument folder is null or does not exist: " + (folder == null ? "null" : folder));
        }
        Path metadataFile = folder.resolve("Metadata.json");
        if (!Files.exists(metadataFile, new LinkOption[0])) {
            throw new IOException("Metadata file '" + metadataFile + "' does not exist.");
        }
        try {
            String jsonString = new String(Files.readAllBytes(metadataFile));
            Map metadataJson = JsonUtil.parseJson((String)jsonString);
            String videoFile = (String)metadataJson.get("VideoFile");
            String startTimeAsString = (String)metadataJson.get("StartTime");
            String uniqueThirdPartyId = (String)metadataJson.get("UniqueThirdPartyId");
            String displayName = (String)metadataJson.get("DisplayName");
            long startTimeAsLong = Instant.parse(startTimeAsString).toEpochMilli();
            String triggerType = (String)metadataJson.get("TriggerType");
            String userName = (String)metadataJson.get("UserName");
            String triggerTimeAsString = (String)metadataJson.get("TriggerTime");
            Long triggerTime = triggerTimeAsString != null ? Long.valueOf(Instant.parse(triggerTimeAsString).toEpochMilli()) : null;
            MetadataObject metadataObject = new MetadataObject(folder.resolve(FilenameUtils.getName((String)videoFile)), startTimeAsLong, uniqueThirdPartyId, displayName, userName, triggerTime, triggerType);
            List gpsLocations = (List)metadataJson.get("GpsLocations");
            if (gpsLocations != null) {
                gpsLocations.forEach(entry -> {
                    String locationTimeAsString = (String)entry.get("Time");
                    Long locationTime = locationTimeAsString != null ? Long.valueOf(Instant.parse(locationTimeAsString).toEpochMilli()) : null;
                    metadataObject.addGpsLocation(new GpsLocation((String)entry.get("Location"), locationTime));
                });
            }
            return metadataObject;
        }
        catch (Exception exception) {
            throw new MetadataException(-20000, "Error while parsing metadata '" + metadataFile + "': " + exception.getMessage());
        }
    }
}

