/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.cm.device.video.videofile.metadata;

import de.seetec.v5.re.cm.device.video.videofile.metadata.GpsLocation;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;

public class MetadataObject {
    private final long startTime;
    private final String uniqueThirdPartyId;
    private final String displayName;
    private final String user;
    private final Long triggerTime;
    private final String triggerType;
    private final List<GpsLocation> gpsLocations;
    private final Path originalBaseDirectory;
    private Path videoFile;
    private Path baseDirectory;

    public MetadataObject(Path videoFile, long startTime, String uniqueThirdPartyId, String displayName, String user, Long triggerTime, String triggerType) {
        this.videoFile = videoFile;
        this.baseDirectory = videoFile.getParent();
        this.originalBaseDirectory = videoFile.getParent();
        this.startTime = startTime;
        this.uniqueThirdPartyId = uniqueThirdPartyId;
        this.displayName = displayName;
        this.user = user;
        this.triggerTime = triggerTime;
        this.triggerType = triggerType;
        this.gpsLocations = new ArrayList<GpsLocation>();
    }

    public Path getVideoFile() {
        return this.videoFile;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public String getUniqueThirdPartyId() {
        return this.uniqueThirdPartyId;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getUser() {
        return this.user;
    }

    public Long getTriggerTime() {
        return this.triggerTime;
    }

    public String getTriggerType() {
        return this.triggerType;
    }

    public List<GpsLocation> getGpsLocations() {
        return this.gpsLocations;
    }

    public void addGpsLocation(GpsLocation gpsLocation) {
        this.gpsLocations.add(gpsLocation);
    }

    public Optional<GpsLocation> getFirstLocation() {
        return this.gpsLocations.stream().sorted(Comparator.comparing(GpsLocation::getTime)).findFirst();
    }

    public Optional<GpsLocation> getLastLocation() {
        return this.gpsLocations.stream().sorted(Comparator.comparing(GpsLocation::getTime).reversed()).findFirst();
    }

    public Path getOriginalBaseDirectory() {
        return this.originalBaseDirectory;
    }

    public Path getBaseDirectory() {
        return this.baseDirectory;
    }

    public void setBaseDirectory(Path baseDirectory) {
        this.baseDirectory = baseDirectory;
        this.videoFile = baseDirectory.resolve(this.videoFile.getFileName());
    }
}

