/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.cm.device.video.videofile;

import de.seetec.v5.re.cm.device.video.videofile.VideoFileReaderFileOperations;
import de.seetec.v5.shared.util.SeeTecException;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;

public class VideoFileReaderFileOperationsImpl
implements VideoFileReaderFileOperations {
    private static final String TEMP_PREFIX = "VideoFileReader";

    @Override
    public Path createTempDirectory() throws IOException {
        return Files.createTempDirectory(TEMP_PREFIX, new FileAttribute[0]);
    }

    @Override
    public void copyDirectory(Path source, Path destination) throws IOException {
        FileUtils.copyDirectory((File)source.toFile(), (File)destination.toFile());
    }

    @Override
    public boolean isSameFile(Path path1, Path path2) throws IOException {
        return Files.isSameFile(path1, path2);
    }

    @Override
    public boolean isEmptyDirectory(Path directory) throws IOException {
        return FileUtils.isEmptyDirectory((File)directory.toFile());
    }

    @Override
    public void delete(Path file) throws IOException {
        Files.delete(file);
    }

    @Override
    public void deleteDirectory(Path file) throws IOException {
        FileUtils.deleteDirectory((File)file.toFile());
    }

    @Override
    public String getName(String name) {
        return FilenameUtils.getName((String)name);
    }

    @Override
    public boolean deleteIfExists(Path path) throws IOException {
        return Files.deleteIfExists(path);
    }

    @Override
    public boolean isEnoughSpace(Path sourceFolder, Path destFolder) throws SeeTecException {
        double factor;
        if (sourceFolder == null || destFolder == null) {
            throw new SeeTecException(-20002, "Invalid parameter specified");
        }
        long neededSize = FileUtils.sizeOfDirectory((File)sourceFolder.toFile());
        long freeSpace = destFolder.toFile().getFreeSpace();
        return (double)freeSpace > (double)neededSize * (factor = 1.5);
    }
}

