/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.cm.device.video.videofile;

import de.seetec.v5.re.cm.device.shared.VideoSrv;
import de.seetec.v5.re.cm.device.video.videofile.DescriptionBuilder;
import de.seetec.v5.re.cm.device.video.videofile.LocalDirectoryProvider;
import de.seetec.v5.re.cm.device.video.videofile.VideoFileFrameProcessor;
import de.seetec.v5.re.cm.device.video.videofile.VideoFileListener;
import de.seetec.v5.re.cm.device.video.videofile.VideoFileParser;
import de.seetec.v5.re.cm.device.video.videofile.VideoFileReaderException;
import de.seetec.v5.re.cm.device.video.videofile.VideoFileReaderFileOperations;
import de.seetec.v5.re.cm.device.video.videofile.VideoFileReaderFileOperationsImpl;
import de.seetec.v5.re.cm.device.video.videofile.metadata.MetadataObject;
import de.seetec.v5.re.shared.ContentFrame;
import de.seetec.v5.shared.Basic;
import de.seetec.v5.shared.EventType;
import de.seetec.v5.shared.configuration.events.bookmark.ActionType;
import de.seetec.v5.shared.configuration.events.bookmark.BookmarkEvent;
import de.seetec.v5.shared.proxy.ent.Entity;
import de.seetec.v5.shared.util.SeeTecException;
import java.io.IOException;
import java.nio.file.Path;
import java.util.concurrent.Semaphore;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class VideoFileReader
implements VideoFileListener {
    private static final Logger LOGGER = LogManager.getLogger(VideoFileReader.class);
    private final Path rootFolder;
    private final VideoSrv videoSrv;
    private final VideoFileFrameProcessor frameProcessor;
    private final Semaphore semaphore = new Semaphore(1);
    private final VideoFileReaderFileOperations videoFileReaderFileOperations;
    private final LocalDirectoryProvider localDirectoryProvider;

    public VideoFileReader(Path rootFolder, VideoSrv videoSrv, VideoFileFrameProcessor frameProcessor) {
        this(rootFolder, videoSrv, frameProcessor, new VideoFileReaderFileOperationsImpl(), new LocalDirectoryProvider());
    }

    VideoFileReader(Path rootFolder, VideoSrv videoSrv, VideoFileFrameProcessor frameProcessor, VideoFileReaderFileOperations localDirectoryFileOperations, LocalDirectoryProvider localDirectoryProvider) {
        this.rootFolder = rootFolder;
        this.videoSrv = videoSrv;
        this.frameProcessor = frameProcessor;
        this.videoFileReaderFileOperations = localDirectoryFileOperations;
        this.localDirectoryProvider = localDirectoryProvider;
    }

    @Override
    public Entity getEntity() {
        return this.videoSrv.getEntity();
    }

    @Override
    public void onNewVideoFile(MetadataObject metadata) throws VideoFileReaderException {
        if (this.semaphore.tryAcquire()) {
            VideoFileReaderException videoFileReaderException = null;
            try {
                Path parent = this.localDirectoryProvider.getDirectory(metadata.getBaseDirectory());
                if (parent.compareTo(metadata.getBaseDirectory()) != 0) {
                    metadata.setBaseDirectory(parent);
                }
                Path inputFile = metadata.getVideoFile();
                LOGGER.info("Start import video file " + inputFile + " for: " + this.videoSrv.toString());
                Path completedFile = metadata.getOriginalBaseDirectory().resolve(this.videoFileReaderFileOperations.getName("complete")).normalize();
                this.videoFileReaderFileOperations.deleteIfExists(completedFile);
                Path tmpFile = parent.resolve(this.videoFileReaderFileOperations.getName("video.ts")).normalize();
                this.importFrames(inputFile, tmpFile, metadata);
                this.cleanUpFolder(metadata.getOriginalBaseDirectory(), inputFile);
                if (metadata.getTriggerTime() != null) {
                    BookmarkEvent bookmarkEvent = new BookmarkEvent(null, metadata.getTriggerType(), new DescriptionBuilder().build(metadata), ActionType.FILEREADERTRIGGERTIME, true);
                    this.videoSrv.getCore().sendEvent(EventType.CLIENT_EVENTTYPE_COMMENT, this.videoSrv.getEntityID(), -1L, metadata.getTriggerTime(), Basic.cutOffRoot((String)Basic.marshalUTF8XML((Object)bookmarkEvent)).getBytes("UTF-8"));
                }
                LOGGER.info("Finished import video file for: " + this.videoSrv.toString());
                this.semaphore.release();
                if (metadata.getBaseDirectory().compareTo(metadata.getOriginalBaseDirectory()) != 0) {
                    this.cleanUpTemporaryFolder(metadata.getBaseDirectory(), videoFileReaderException);
                }
            }
            catch (Exception exception) {
                try {
                    videoFileReaderException = new VideoFileReaderException(-21713, "Cannot process videofile " + metadata.getVideoFile() + " for " + this.videoSrv.toString() + ": " + exception.getMessage(), exception);
                    throw videoFileReaderException;
                }
                catch (Throwable throwable) {
                    this.semaphore.release();
                    if (metadata.getBaseDirectory().compareTo(metadata.getOriginalBaseDirectory()) != 0) {
                        this.cleanUpTemporaryFolder(metadata.getBaseDirectory(), videoFileReaderException);
                    }
                    throw throwable;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void importFrames(Path inputFile, Path tmpFile, MetadataObject metadata) throws IOException, SeeTecException, InterruptedException {
        this.frameProcessor.importStarted();
        this.frameProcessor.convertFile(inputFile, tmpFile);
        VideoFileParser parser = null;
        try {
            ContentFrame frame;
            parser = this.frameProcessor.getParser(tmpFile);
            while ((frame = parser.readNextFrame(metadata.getStartTime())) != null) {
                this.frameProcessor.deliverFrame(frame);
            }
        }
        finally {
            this.frameProcessor.importFinished();
            if (parser != null) {
                parser.shutdown();
            }
        }
    }

    private void cleanUpFolder(Path folder, Path videoFile) throws VideoFileReaderException {
        try {
            this.videoFileReaderFileOperations.deleteIfExists(folder.resolve(this.videoFileReaderFileOperations.getName("video.ts")));
            this.videoFileReaderFileOperations.deleteIfExists(folder.resolve(this.videoFileReaderFileOperations.getName("Metadata.json")));
            this.videoFileReaderFileOperations.deleteIfExists(folder.resolve(videoFile.getFileName()));
            if (!this.videoFileReaderFileOperations.isSameFile(folder, this.rootFolder) && this.videoFileReaderFileOperations.isEmptyDirectory(folder)) {
                this.videoFileReaderFileOperations.delete(folder);
            }
        }
        catch (IOException exception) {
            throw new VideoFileReaderException(-20000, "Cannot cleanup folder: " + exception.getMessage());
        }
    }

    private void cleanUpTemporaryFolder(Path temporaryTransportStreamFileFolder, VideoFileReaderException alreadyHappenedException) throws VideoFileReaderException {
        if (temporaryTransportStreamFileFolder != null) {
            try {
                this.videoFileReaderFileOperations.deleteDirectory(temporaryTransportStreamFileFolder);
            }
            catch (IOException ioException) {
                String message = "Cannot delete temporary TS folder " + temporaryTransportStreamFileFolder + " for " + this.videoSrv.toString() + ": " + ioException.getMessage();
                if (alreadyHappenedException == null) {
                    throw new VideoFileReaderException(-21713, message);
                }
                throw new VideoFileReaderException(-21713, message, (Throwable)((Object)alreadyHappenedException));
            }
        }
    }

    @Override
    public boolean isCurrentlyRunning() {
        return this.semaphore.availablePermits() == 0;
    }
}

