/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.cm.device.video.videofile;

import de.seetec.v5.re.cm.Core;
import de.seetec.v5.re.cm.device.shared.VideoSrv;
import de.seetec.v5.re.cm.device.video.videofile.InputStreamLogger;
import de.seetec.v5.re.cm.device.video.videofile.TransportStreamParserImpl;
import de.seetec.v5.re.cm.device.video.videofile.VideoFileFrameProcessor;
import de.seetec.v5.re.cm.device.video.videofile.VideoFileParser;
import de.seetec.v5.re.cm.shared.communication.DatabaseWriter;
import de.seetec.v5.re.cm.shared.communication.DatabaseWriterRepository;
import de.seetec.v5.re.cm.shared.communication.DatabaseWriterType;
import de.seetec.v5.re.cm.shared.communication.MDBWriterFactoryImpl;
import de.seetec.v5.re.shared.ContentFrame;
import de.seetec.v5.shared.util.ConfigurationException;
import de.seetec.v5.shared.util.SeeTecException;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class VideoFileFrameProcessorImpl
implements VideoFileFrameProcessor {
    private static final Logger LOGGER = LogManager.getLogger(VideoFileFrameProcessorImpl.class);
    private static final int RECORDING_MODE = 1;
    private final List<ContentFrame> bufferedFrames = new ArrayList<ContentFrame>();
    private final Semaphore localStorageWriterSemaphore = new Semaphore(1);
    private final Core core;
    private final VideoSrv videoSrv;
    private DatabaseWriter localStorageWriter;
    private boolean wroteFirstFrame = false;

    public VideoFileFrameProcessorImpl(Core core, VideoSrv videoSrv) {
        this.core = core;
        this.videoSrv = videoSrv;
    }

    protected DatabaseWriter getLocalStorageWriter() {
        block10: {
            if (this.localStorageWriterSemaphore.tryAcquire()) {
                try {
                    if (this.localStorageWriter != null && !this.localStorageWriter.isShutdown()) {
                        DatabaseWriter databaseWriter = this.localStorageWriter;
                        return databaseWriter;
                    }
                    if (this.core == null || this.core.isShutdown()) {
                        LOGGER.warn((Object)((Object)this.core) + " is already shutting down!");
                        break block10;
                    }
                    DatabaseWriter databaseWriter = null;
                    try {
                        MDBWriterFactoryImpl mdbWriterFactory = new MDBWriterFactoryImpl(false, this.core, this.videoSrv, DatabaseWriterType.LOCAL_STORAGE);
                        databaseWriter = new DatabaseWriterRepository(this.core.getConfigurationProvider(), mdbWriterFactory);
                        databaseWriter.init();
                        this.localStorageWriter = databaseWriter;
                        LOGGER.info("... " + this.localStorageWriter + " for " + this + " created ");
                    }
                    catch (ConfigurationException | SeeTecException exception) {
                        if (databaseWriter != null) {
                            databaseWriter.shutdown();
                        }
                        throw new RuntimeException("Connecting MultimediaDatabase failed with error: " + exception.getMessage());
                    }
                }
                finally {
                    this.localStorageWriterSemaphore.release();
                }
            }
        }
        return this.localStorageWriter;
    }

    @Override
    public VideoFileParser getParser(Path inputFile) {
        return new TransportStreamParserImpl(this.videoSrv, inputFile.toFile());
    }

    @Override
    public void convertFile(Path inputFile, Path outputFile) throws IOException, InterruptedException {
        if (!Files.exists(inputFile, new LinkOption[0])) {
            throw new IllegalArgumentException("File doesn't exsist: " + inputFile.toString());
        }
        Files.deleteIfExists(outputFile);
        Process process = new ProcessBuilder("ffmpeg.exe", "-i", inputFile.toString(), "-muxdelay", "0", "-codec:v", "copy", "-codec:a", "copy", "-bsf:v", "h264_mp4toannexb", "-y", outputFile.toString()).start();
        InputStreamLogger errorStreamLogger = new InputStreamLogger(process.getErrorStream());
        errorStreamLogger.start();
        process.getInputStream().close();
        if (!process.waitFor(120L, TimeUnit.SECONDS)) {
            process.destroyForcibly();
            throw new RuntimeException("Convert failed and process terminated after 120 seconds.");
        }
        if (process.exitValue() != 0) {
            this.logProcessStream(process.getErrorStream());
            LOGGER.error("Convert exited with exiceCode=" + process.exitValue());
            throw new RuntimeException("Convert video files failed: " + inputFile.toString());
        }
    }

    private void logProcessStream(InputStream stream) throws IOException {
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(stream));){
            String line;
            while ((line = reader.readLine()) != null) {
                LOGGER.error(line);
            }
        }
    }

    @Override
    public void importStarted() {
        this.getLocalStorageWriter().setupLocalStorage(1);
        this.wroteFirstFrame = false;
    }

    @Override
    public void importFinished() {
        if (this.getLocalStorageWriter() != null) {
            this.deliverFrame((ContentFrame f) -> true);
            this.getLocalStorageWriter().finalizeCurrentSequence();
            this.getLocalStorageWriter().shutdown();
            this.localStorageWriter = null;
        }
    }

    @Override
    public void deliverFrame(ContentFrame frame) {
        if (this.wroteFirstFrame && frame.getMediatype() == 33) {
            Predicate<ContentFrame> filter = f -> f.getStartTimestamp() < frame.getStartTimestamp();
            this.deliverFrame(filter);
        }
        this.bufferedFrames.add(frame);
        this.wroteFirstFrame = true;
    }

    private void deliverFrame(Predicate<ContentFrame> filter) {
        Comparator<ContentFrame> comparator = Comparator.comparing(ContentFrame::getStartTimestamp).thenComparing(f -> !f.isVideoFrame());
        List<ContentFrame> sortedList = this.bufferedFrames.stream().filter(filter).sorted(Comparator.nullsLast(comparator)).collect(Collectors.toList());
        this.ensureIncreasingTimestamps(sortedList);
        this.deliverFrames(sortedList);
        this.bufferedFrames.removeIf(filter);
    }

    private void ensureIncreasingTimestamps(List<ContentFrame> contentFrames) {
        long lastTimestamp = 0L;
        for (ContentFrame frame : contentFrames) {
            if (frame.getStartTimestamp() == lastTimestamp) {
                long calibratedTimestamp = lastTimestamp + 1L;
                frame.setStartTimestamp(calibratedTimestamp);
                frame.setEndTimestamp(calibratedTimestamp);
            }
            lastTimestamp = frame.getStartTimestamp();
        }
    }

    private void deliverFrames(List<ContentFrame> sortedFrames) {
        sortedFrames.forEach(frame -> this.getLocalStorageWriter().deliverFrameToArchive((ContentFrame)frame, false));
        this.getLocalStorageWriter().flushRecordingQueue();
    }
}

