/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.cm.device.video.videofile;

import de.seetec.v5.re.cm.Core;
import de.seetec.v5.re.cm.configuration.definition.camera.VideoCameraDefinition;
import de.seetec.v5.re.cm.configuration.definition.device.DeviceDefinition;
import de.seetec.v5.re.cm.configuration.device.videosource.VideoSourceArchive;
import de.seetec.v5.re.cm.configuration.device.videosource.VideoSourceEntity;
import de.seetec.v5.re.cm.configuration.device.videosource.VsAlarmRecording;
import de.seetec.v5.re.cm.configuration.device.videosource.VsStandardRecording;
import de.seetec.v5.re.cm.device.shared.Service;
import de.seetec.v5.re.cm.device.shared.VideoServer;
import de.seetec.v5.re.cm.device.shared.io.IOHandler;
import de.seetec.v5.re.cm.device.video.videofile.DirectoryParser;
import de.seetec.v5.re.cm.device.video.videofile.VideoFileCameraSrv;
import de.seetec.v5.re.cm.device.video.videofile.VideoSourceCreator;
import de.seetec.v5.shared.Basic;
import de.seetec.v5.shared.proxy.ent.Entity;
import de.seetec.v5.shared.util.ConfigurationException;
import de.seetec.v5.shared.util.SeeTecException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.UnknownHostException;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchService;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.concurrent.TimeUnit;
import javax.xml.bind.JAXBException;
import org.apache.commons.io.FileUtils;
import org.apache.logging.log4j.LogManager;
import org.xml.sax.SAXException;

public class VideoFileDevice
extends VideoServer
implements VideoSourceCreator {
    private DirectoryParser directoryParser;

    @Override
    public int init(Core core, long entityID) {
        int errorCode = super.init(core, entityID);
        if (errorCode != 0) {
            this.logger.error("Initializing " + this + " failed with error [" + errorCode + "]");
            return errorCode;
        }
        try {
            File folder = FileUtils.getFile((String[])new String[]{this.getDeviceCnf().getHardwareHost()});
            this.directoryParser = new DirectoryParser(folder, this);
            errorCode = this.directoryParser.init();
            if (errorCode != 0) {
                this.logger.error("Initializing directory parser for " + this + " failed with error [" + errorCode + "]");
            }
        }
        catch (ConfigurationException excception) {
            this.logger.error("Cannot read configuration for folder: " + excception.getMessage());
            errorCode = -20036;
        }
        return errorCode;
    }

    @Override
    public int shutdown() {
        if (this.startShutdown(VideoFileDevice.class.getName())) {
            return 0;
        }
        if (this.directoryParser != null) {
            this.directoryParser.shutdown();
        }
        return super.shutdown();
    }

    public static int checkDeviceInfos(long type, String host, int port, boolean useAuthorization, String user, String pass, int timeout) {
        int errorCode = 0;
        if (host == null) {
            return -20002;
        }
        Path pathToCheck = FileSystems.getDefault().getPath(host, new String[0]);
        try {
            WatchService watcher = FileSystems.getDefault().newWatchService();
            pathToCheck.register(watcher, StandardWatchEventKinds.ENTRY_CREATE);
        }
        catch (IOException exception) {
            LogManager.getLogger(VideoFileDevice.class).info(String.format("Can't watch directory '%s', reason: '%s'.", pathToCheck, exception.getMessage()));
            errorCode = -20022;
        }
        return errorCode;
    }

    private VideoFileCameraSrv activateVideoSource(Entity videoSourceEntity) throws ConfigurationException, UnknownHostException {
        this.logger.info("Service [" + videoSourceEntity + "] will be initialized ...");
        VideoFileCameraSrv cameraSrv = new VideoFileCameraSrv();
        cameraSrv.init(this.core, this, videoSourceEntity);
        cameraSrv.initLive();
        return cameraSrv;
    }

    @Override
    public boolean existsVideoSource(String uniqueId) {
        return Arrays.stream(this.services).anyMatch(service -> {
            Entity entity = service.getEntity();
            try {
                VideoSourceEntity videoSource = (VideoSourceEntity)Basic.unmarshalXML(VideoSourceEntity.class, (Object)entity.getConfiguration());
                String id = videoSource.getUniqueThirdPartyId();
                return id != null && id.equalsIgnoreCase(uniqueId);
            }
            catch (JAXBException | SAXException exception) {
                this.logger.error("Can't deserialize configuration for Videosource " + entity.toString() + ": " + exception.getMessage());
                return false;
            }
        });
    }

    @Override
    public void createVideoSource(String videoSourceName, String uniqueId) {
        VideoSourceEntity videoSource = new VideoSourceEntity();
        try {
            videoSource.setVersion("7.4.1_11");
            videoSource.setUniqueThirdPartyId(uniqueId);
            videoSource.setArchive(new VideoSourceArchive());
            videoSource.setAlarmRecording(new VsAlarmRecording());
            videoSource.setStandardRecording(new VsStandardRecording());
            videoSource.setMultiMediaDBID(Long.parseLong(this.getDeviceCnf().getREID()));
            videoSource.getStandardRecording().setRecordingEnabled(true);
            videoSource.getStandardRecording().setTimeBasedRecording(true);
            videoSource.getStandardRecording().setTimeRangeID(-1111L);
            videoSource.getStandardRecording().setMaxRecordingTime(Duration.ofDays(120L).toMillis());
            videoSource.getAlarmRecording().setRecordingEnabled(false);
            videoSource.getAlarmRecording().setTimeBasedRecording(true);
            videoSource.getAlarmRecording().setMaxRecordingTime(Duration.ofDays(120L).toMillis());
            videoSource.setAudioEnabled(true);
            Entity branch = this.core.getBranch(this.core.getEntityByID(this.getDeviceID()));
            Entity videoSourceEntity = new Entity(Long.valueOf(this.core.getTicket()), videoSourceName, Long.valueOf(216802L), Long.valueOf(54L), Boolean.TRUE, Integer.valueOf(0), Basic.marshalUTF8XML((Object)videoSource).getBytes(), "", this.getDeviceID(), Long.valueOf(-1L), branch.getEntityID(), Long.valueOf(-1L));
            int errorCode = this.core.getEntMgrProxy().setEntity(videoSourceEntity, this.core.getCayugaToken(), TimeUnit.SECONDS.toMillis(30L));
            if (errorCode != 0) {
                this.logger.error("Adding new VideoSources [" + videoSourceEntity.getEntityID() + "/" + videoSourceEntity.getEntityName() + "] as new entity failed with error [" + errorCode + "]");
            }
            if ((errorCode = this.core.getEntMgrProxy().setEntity(this.getDeviceEntity(), this.core.getCayugaToken(), TimeUnit.SECONDS.toMillis(30L))) != 0) {
                this.logger.error("Updating VideoServer [" + this.getDeviceEntity().getEntityID() + "/" + this.getDeviceEntity().getEntityName() + "] as new entity failed with error [" + errorCode + "]");
            }
            VideoFileCameraSrv cameraSrv = this.activateVideoSource(videoSourceEntity);
            this.services = Arrays.copyOf(this.services, this.services.length + 1);
            this.services[this.services.length - 1] = cameraSrv;
            this.reloadEntityTree(this.getDeviceID());
        }
        catch (ConfigurationException | SeeTecException | FileNotFoundException | UnknownHostException | JAXBException | SAXException exception) {
            this.logger.error("Cannot create new VideoSource for " + this);
        }
    }

    @Override
    public boolean delete(long entityID) {
        ArrayList<Service> servicesToKeep = new ArrayList<Service>();
        if (this.getDeviceID() == entityID) {
            return true;
        }
        for (Service service : this.services) {
            if (service.getServiceID() == entityID) continue;
            servicesToKeep.add(service);
        }
        this.services = servicesToKeep.toArray(new Service[servicesToKeep.size()]);
        this.directoryParser.removeListener(new Entity(Long.valueOf(entityID), Integer.valueOf(0)));
        return false;
    }

    @Override
    protected IOHandler createIOHandler() {
        throw new RuntimeException("No i/o supported for " + this);
    }

    @Override
    protected boolean isSupportingIO() {
        return false;
    }

    @Override
    protected DeviceDefinition getDeviceDefinitionFromDevice(String signature, String manufacturer, String name, String comments) throws SeeTecException {
        return null;
    }

    @Override
    protected VideoCameraDefinition getVideoCameraDefinitionFromDevice() throws SeeTecException {
        return null;
    }

    public DirectoryParser getDirectoryParser() {
        return this.directoryParser;
    }
}

