/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.cm.device.video.videofile;

import de.seetec.v5.re.cm.Core;
import de.seetec.v5.re.cm.configuration.device.shared.ArrayOfCameraPreset.ArrayOfCameraPreset;
import de.seetec.v5.re.cm.configuration.device.videosource.VideoSourceEntity;
import de.seetec.v5.re.cm.device.shared.Device;
import de.seetec.v5.re.cm.device.shared.VideoSrv;
import de.seetec.v5.re.cm.device.shared.cameracontrol.PresetCnf;
import de.seetec.v5.re.cm.device.shared.videoprofile.VideoProfileHandler;
import de.seetec.v5.re.cm.device.video.videofile.DirectoryParser;
import de.seetec.v5.re.cm.device.video.videofile.VideoFileDevice;
import de.seetec.v5.re.cm.device.video.videofile.VideoFileFrameProcessor;
import de.seetec.v5.re.cm.device.video.videofile.VideoFileFrameProcessorImpl;
import de.seetec.v5.re.cm.device.video.videofile.VideoFileReader;
import de.seetec.v5.re.cm.shared.ContentStreamIntf;
import de.seetec.v5.re.cm.shared.communication.ContentStream;
import de.seetec.v5.re.cm.shared.communication.VideoServiceClientRequestHandler;
import de.seetec.v5.shared.Basic;
import de.seetec.v5.shared.proxy.ent.Entity;
import de.seetec.v5.shared.util.ConfigurationException;
import java.io.File;
import java.util.Vector;
import javax.xml.bind.JAXBException;
import org.apache.commons.io.FileUtils;
import org.xml.sax.SAXException;

public class VideoFileCameraSrv
extends VideoSrv {
    private VideoFileReader videoFileReader;
    private VideoFileFrameProcessor videoFileFrameProcessor;

    @Override
    public int init(Vector<PresetCnf> presetList) throws ConfigurationException {
        if (this.device instanceof VideoFileDevice) {
            this.videoFileFrameProcessor = new VideoFileFrameProcessorImpl(this.getCore(), this);
            try {
                VideoSourceEntity entity = (VideoSourceEntity)Basic.unmarshalXML(VideoSourceEntity.class, (Object)this.getEntity().getConfiguration());
                String uniqueThirdPartyId = entity.getUniqueThirdPartyId();
                File rootFolder = FileUtils.getFile((String[])new String[]{this.device.getDeviceCnf().getHardwareHost()});
                DirectoryParser directoryParser = ((VideoFileDevice)this.device).getDirectoryParser();
                this.videoFileReader = new VideoFileReader(rootFolder.toPath(), this, this.videoFileFrameProcessor);
                directoryParser.addListener(uniqueThirdPartyId, this.videoFileReader);
            }
            catch (JAXBException | SAXException exception) {
                this.logger.error("Cannot deserialize VideoSourceEntity for " + this + ": " + exception.getMessage());
            }
        }
        return 0;
    }

    @Override
    public int init(Core core, Device device, Entity entity) {
        int errorCode = super.init(core, device, entity);
        this.sendStatusService(errorCode);
        if (errorCode != 0) {
            this.logger.error("Creating " + this + " failed with error [" + errorCode + "]");
        }
        return errorCode;
    }

    @Override
    public boolean isMPEG() {
        return false;
    }

    @Override
    public ContentStreamIntf createContentStream(int openingMode) {
        if (this.isShutdown()) {
            throw new RuntimeException(this + " is already shutting down");
        }
        if (openingMode == 0) {
            return new ContentStream();
        }
        throw new RuntimeException("Opening mode [" + openingMode + " for " + this + " not supported for " + this);
    }

    @Override
    public int checkVideoProfileHandler() {
        return 0;
    }

    @Override
    public void changeVideoMode() {
    }

    @Override
    public int removePresetPosition(String presetName) {
        return 0;
    }

    @Override
    public int setPresetPosition(String preset) {
        return 0;
    }

    @Override
    public int setHomePosition() {
        return 0;
    }

    @Override
    public int setAutoZeroLux(Boolean active) {
        return 0;
    }

    @Override
    public int setZeroLux(Boolean active) {
        return 0;
    }

    @Override
    public int setAutoFocus(Boolean active) {
        return 0;
    }

    @Override
    public int setContinuousFocus(Integer value) {
        return 0;
    }

    @Override
    public int setAbsoluteFocus(Integer value) {
        return 0;
    }

    @Override
    public int setAutoIris(Boolean active) {
        return 0;
    }

    @Override
    public int setContinuousIris(Integer value) {
        return 0;
    }

    @Override
    public int setAbsoluteIris(Integer value) {
        return 0;
    }

    @Override
    public int setContinuousPTZ(Integer panSpeed, Integer tiltSpeed, Integer zoomSpeed) {
        return 0;
    }

    @Override
    public int setAbsolutePTZ(VideoServiceClientRequestHandler sender, Integer pan, Integer tilt, Integer zoom) {
        return 0;
    }

    @Override
    public int setAbsolutePt(VideoServiceClientRequestHandler sender, Integer pan, Integer tilt) {
        return 0;
    }

    @Override
    public int setAbsoluteZ(VideoServiceClientRequestHandler sender, Integer zoom) {
        return 0;
    }

    @Override
    public int setCenterPT(Integer xPosition, Integer yPosition, int[] resolution) {
        return 0;
    }

    @Override
    public int setZoomArea(Integer xPosition, Integer yPosition, Integer width, Integer height, int[] resolution) {
        return 0;
    }

    @Override
    public int addPresetPosition(Vector<byte[]> vResult, Long presetID, String presetName) {
        return 0;
    }

    @Override
    public void checkFramerate() {
    }

    @Override
    public final VideoProfileHandler getVideoProfileHandler(Integer classification) {
        return null;
    }

    @Override
    public String getPresetName(long presetID) throws ConfigurationException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public ArrayOfCameraPreset getCameraPresetsList() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public int addCameraPresets(ArrayOfCameraPreset presets) {
        throw new UnsupportedOperationException("Not supported yet.");
    }
}

