/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.cm.device.video.videofile;

import de.seetec.v5.re.cm.device.shared.VideoSrv;
import de.seetec.v5.re.cm.device.shared.videosource.MediaFrameBuilder;
import de.seetec.v5.re.cm.device.shared.videosource.MediaFrameWrapper;
import de.seetec.v5.re.cm.device.video.videofile.VideoFileParser;
import de.seetec.v5.re.shared.ContentFrame;
import de.seetec.v5.shared.util.SeeTecException;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.bytedeco.ffmpeg.avcodec.AVCodec;
import org.bytedeco.ffmpeg.avcodec.AVCodecContext;
import org.bytedeco.ffmpeg.avcodec.AVCodecParameters;
import org.bytedeco.ffmpeg.avcodec.AVPacket;
import org.bytedeco.ffmpeg.avformat.AVFormatContext;
import org.bytedeco.ffmpeg.avformat.AVStream;
import org.bytedeco.ffmpeg.avutil.AVFrame;
import org.bytedeco.ffmpeg.avutil.AVRational;
import org.bytedeco.ffmpeg.global.avcodec;
import org.bytedeco.ffmpeg.global.avformat;
import org.bytedeco.ffmpeg.global.avutil;
import org.bytedeco.ffmpeg.global.swresample;
import org.bytedeco.ffmpeg.swresample.SwrContext;
import org.bytedeco.javacpp.Pointer;
import org.bytedeco.javacpp.PointerPointer;

public class TransportStreamParserImpl
implements VideoFileParser {
    private static final Logger LOGGER = LogManager.getLogger(TransportStreamParserImpl.class);
    private final AVFormatContext formatContext;
    private final MediaFrameBuilder mediaFrameBuilder;
    private AVStream videoStream = null;
    private AVStream audioStream = null;
    private AVCodecParameters audioCodecParameters = (AVCodecParameters)new AVCodecParameters().retainReference();
    private AVCodecContext codecContext = null;
    private AVFrame decoderFrame = null;
    private SwrContext swr = null;

    public TransportStreamParserImpl(VideoSrv videoSrv, File filnename) {
        this.formatContext = avformat.avformat_alloc_context();
        avformat.avformat_open_input((AVFormatContext)this.formatContext, (String)filnename.getAbsolutePath(), null, null);
        avformat.avformat_find_stream_info((AVFormatContext)this.formatContext, (PointerPointer)null);
        int numberOfStreams = this.formatContext.nb_streams();
        for (int i = 0; i < numberOfStreams; ++i) {
            AVStream stream = this.formatContext.streams(i);
            AVCodecParameters parameters = stream.codecpar();
            if (this.videoStream == null && parameters.codec_type() == 0) {
                this.videoStream = stream;
                LOGGER.info("Video Parameters for: " + videoSrv.getEntityName() + " CodecType:" + parameters.codec_type() + " CodecId: " + parameters.codec_id() + " Height: " + parameters.height() + " Width: " + parameters.width());
                continue;
            }
            if (this.audioStream != null || parameters.codec_type() != 1) continue;
            this.audioStream = stream;
            this.audioCodecParameters = stream.codecpar();
            LOGGER.info("Audio Parameters for: " + videoSrv.getEntityName() + " CodecType:" + parameters.codec_type() + " CodecId: " + parameters.codec_id() + " Format: " + parameters.format() + " FrameSize: " + parameters.frame_size() + " Layout: " + parameters.channel_layout() + " Channels: " + parameters.channels() + " SampleRate: " + parameters.sample_rate());
        }
        this.mediaFrameBuilder = new MediaFrameBuilder(videoSrv.getDevice(), videoSrv);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ContentFrame readNextFrame(Long timeOffsetMillis) throws IOException, SeeTecException {
        ContentFrame contentFrame = null;
        AVPacket avPacket = new AVPacket();
        try {
            avformat.av_read_frame((AVFormatContext)this.formatContext, (AVPacket)avPacket);
            if (avPacket.buf() == null) {
                ContentFrame contentFrame2 = null;
                return contentFrame2;
            }
            int streamIndex = avPacket.stream_index();
            if (streamIndex == this.videoStream.index()) {
                long timestamp = this.calculateTimestamp(timeOffsetMillis, this.videoStream.time_base(), avPacket);
                MediaFrameWrapper mediaFrame = this.getMediaFrameFromAvPacket(avPacket);
                if (mediaFrame != null) {
                    ContentFrame contentFrame3 = new ContentFrame(mediaFrame.getMediaType(), 0, timestamp, timestamp, mediaFrame.getMediaFrame().getData());
                    return contentFrame3;
                }
            } else if (streamIndex == this.audioStream.index()) {
                if (this.codecContext == null) {
                    this.initializeDecoder();
                    this.setupSwrContext();
                }
                byte[] outbytes = this.convertToPcm(avPacket);
                int bitrate = 16 * this.audioCodecParameters.sample_rate() / 8000;
                MediaFrameWrapper mediaFrame = this.mediaFrameBuilder.buildPcmMediaFrame(outbytes, bitrate, this.audioCodecParameters.sample_rate());
                long timestamp = this.calculateTimestamp(timeOffsetMillis, this.audioStream.time_base(), avPacket);
                ContentFrame contentFrame4 = new ContentFrame(mediaFrame.getMediaType(), 0, timestamp, timestamp, mediaFrame.getMediaFrame().getData());
                return contentFrame4;
            }
        }
        finally {
            avcodec.av_packet_unref((AVPacket)avPacket);
        }
        return contentFrame;
    }

    private byte[] convertToPcm(AVPacket avPacket) {
        avcodec.avcodec_send_packet((AVCodecContext)this.codecContext, (AVPacket)avPacket);
        avcodec.avcodec_receive_frame((AVCodecContext)this.codecContext, (AVFrame)this.decoderFrame);
        int samples = this.decoderFrame.nb_samples();
        byte[] outbytes = new byte[samples * 2];
        byte[] inputdata = new byte[samples * 8];
        this.decoderFrame.buf(0).data().get(inputdata);
        swresample.swr_convert((SwrContext)this.swr, (byte[])outbytes, (int)this.decoderFrame.nb_samples(), (byte[])Arrays.copyOf(inputdata, inputdata.length), (int)this.decoderFrame.nb_samples());
        return outbytes;
    }

    private void initializeDecoder() {
        AVCodec pCodec = avcodec.avcodec_find_decoder((int)this.audioCodecParameters.codec_id());
        this.codecContext = avcodec.avcodec_alloc_context3((AVCodec)pCodec);
        this.codecContext.codec_type(1);
        avcodec.avcodec_parameters_to_context((AVCodecContext)this.codecContext, (AVCodecParameters)this.audioCodecParameters);
        avcodec.avcodec_open2((AVCodecContext)this.codecContext, (AVCodec)pCodec, (PointerPointer)null);
        this.decoderFrame = avutil.av_frame_alloc();
    }

    private void setupSwrContext() {
        this.swr = swresample.swr_alloc();
        avutil.av_opt_set_int((Pointer)this.swr, (String)"in_channel_layout", (long)this.audioCodecParameters.channels(), (int)0);
        avutil.av_opt_set_int((Pointer)this.swr, (String)"out_channel_layout", (long)1L, (int)0);
        avutil.av_opt_set_int((Pointer)this.swr, (String)"in_sample_rate", (long)this.audioCodecParameters.sample_rate(), (int)0);
        avutil.av_opt_set_int((Pointer)this.swr, (String)"out_sample_rate", (long)this.audioCodecParameters.sample_rate(), (int)0);
        avutil.av_opt_set_sample_fmt((Pointer)this.swr, (String)"in_sample_fmt", (int)this.audioCodecParameters.format(), (int)0);
        avutil.av_opt_set_sample_fmt((Pointer)this.swr, (String)"out_sample_fmt", (int)1, (int)0);
        swresample.swr_init((SwrContext)this.swr);
    }

    private long calculateTimestamp(Long timeOffsetMilliseconds, AVRational timeBase, AVPacket avPacket) {
        long presentationTimestamp = avPacket.pts();
        return timeOffsetMilliseconds + 1000L * presentationTimestamp * (long)timeBase.num() / (long)timeBase.den();
    }

    private MediaFrameWrapper getMediaFrameFromAvPacket(AVPacket avPacket) throws SeeTecException, IOException {
        byte[] data = new byte[(int)avPacket.buf().size()];
        avPacket.buf().data().get(data);
        return this.mediaFrameBuilder.buildH264MediaFrameWithSpsAndPps(Arrays.copyOf(data, data.length));
    }

    @Override
    public void shutdown() {
        if (this.decoderFrame != null) {
            avutil.av_frame_free((AVFrame)this.decoderFrame);
            this.decoderFrame = null;
        }
        if (this.codecContext != null) {
            avcodec.avcodec_free_context((AVCodecContext)this.codecContext);
            this.codecContext = null;
        }
        avformat.avformat_close_input((AVFormatContext)this.formatContext);
        avformat.avformat_free_context((AVFormatContext)this.formatContext);
        if (this.swr != null) {
            swresample.swr_free((SwrContext)this.swr);
            this.swr = null;
        }
    }
}

