/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.cm.device.video.videofile;

import de.seetec.v5.re.cm.device.video.videofile.NetworkFolderDetector;
import de.seetec.v5.shared.util.SeeTecException;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.TimeUnit;

public class NetworkFolderDetectorImpl
implements NetworkFolderDetector {
    @Override
    @SuppressFBWarnings(value={"COMMAND_INJECTION"}, justification="No unfiltered input will be processed.")
    public boolean isNetworkShare(Path pathToCheck) throws SeeTecException {
        try {
            if (pathToCheck.toString().startsWith("\\\\")) {
                return true;
            }
            if (pathToCheck.toString().toLowerCase().startsWith("c:")) {
                return false;
            }
            String driveLetter = pathToCheck.toString().substring(0, 2).toLowerCase();
            List<String> cmd = Arrays.asList("cmd", "/c", "net", "use", driveLetter);
            Process process = new ProcessBuilder(cmd).start();
            if (process.waitFor(120L, TimeUnit.SECONDS)) {
                return process.exitValue() == 0;
            }
            process.destroyForcibly();
            throw new SeeTecException(-20000, "Checking if '" + driveLetter + "' is network letter is not coming back");
        }
        catch (SeeTecException | IOException | InterruptedException | NullPointerException | StringIndexOutOfBoundsException exception) {
            throw new SeeTecException(-20000, "Unable to check if '" + pathToCheck + "' is a network drive: " + exception.getMessage(), exception);
        }
    }
}

