/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.cm.device.video.videofile;

import de.seetec.v5.re.cm.device.video.videofile.NetworkFolderDetector;
import de.seetec.v5.re.cm.device.video.videofile.NetworkFolderDetectorImpl;
import de.seetec.v5.re.cm.device.video.videofile.VideoFileReaderFileOperations;
import de.seetec.v5.re.cm.device.video.videofile.VideoFileReaderFileOperationsImpl;
import de.seetec.v5.shared.util.AccumulatingLogger;
import de.seetec.v5.shared.util.SeeTecException;
import java.io.IOException;
import java.nio.file.Path;
import java.util.concurrent.TimeUnit;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class LocalDirectoryProvider {
    private static final String ACCUMULATING_LOGGER_SPECIFIER_ERROR_COPY_STEP = "Error while local copy step of";
    private final Logger logger = LogManager.getLogger((String)this.getClass().getName());
    private final NetworkFolderDetector networkFolderDetector;
    private final VideoFileReaderFileOperations videoFileReaderFileOperations;
    private final AccumulatingLogger accumulatingLogger;

    public LocalDirectoryProvider() {
        this(new NetworkFolderDetectorImpl(), new VideoFileReaderFileOperationsImpl());
    }

    LocalDirectoryProvider(NetworkFolderDetector networkFolderDetector, VideoFileReaderFileOperations localDirectoryFileOperations) {
        this.networkFolderDetector = networkFolderDetector;
        this.videoFileReaderFileOperations = localDirectoryFileOperations;
        this.accumulatingLogger = new AccumulatingLogger(this.logger);
        this.accumulatingLogger.startSession(Level.ERROR, TimeUnit.SECONDS.toMillis(10L), ACCUMULATING_LOGGER_SPECIFIER_ERROR_COPY_STEP);
    }

    public Path getDirectory(Path directory) throws SeeTecException {
        Path tempFolder = null;
        try {
            if (this.networkFolderDetector.isNetworkShare(directory)) {
                tempFolder = this.videoFileReaderFileOperations.createTempDirectory();
                if (!this.videoFileReaderFileOperations.isEnoughSpace(directory, tempFolder)) {
                    throw new SeeTecException(-20000, "No enougth space on temp folder: " + tempFolder);
                }
                this.logger.info("Copying data from network share " + directory + " to local folder: " + tempFolder);
                this.videoFileReaderFileOperations.copyDirectory(directory, tempFolder);
                return tempFolder;
            }
            return directory;
        }
        catch (SeeTecException | IOException exception) {
            this.accumulatingLogger.log(ACCUMULATING_LOGGER_SPECIFIER_ERROR_COPY_STEP, "Error while local copy step of '" + directory + "'. Message: " + exception.getMessage(), (Exception)exception);
            if (tempFolder != null) {
                try {
                    this.videoFileReaderFileOperations.deleteDirectory(tempFolder);
                }
                catch (IOException deleteDirectoryException) {
                    this.logger.error("Error while cleaning temporary folder '" + tempFolder + "'. Message: " + deleteDirectoryException.getMessage(), (Throwable)deleteDirectoryException);
                }
            }
            throw new SeeTecException(-20000, "Error while local copy step.");
        }
    }
}

