/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.cm.device.video.videofile;

import de.seetec.v5.re.cm.device.video.videofile.VideoFileListener;
import de.seetec.v5.re.cm.device.video.videofile.VideoFileReaderException;
import de.seetec.v5.re.cm.device.video.videofile.VideoSourceCreator;
import de.seetec.v5.re.cm.device.video.videofile.metadata.MetadataException;
import de.seetec.v5.re.cm.device.video.videofile.metadata.MetadataObject;
import de.seetec.v5.re.cm.device.video.videofile.metadata.MetadataParser;
import de.seetec.v5.re.cm.device.video.videofile.watcher.FileListener;
import de.seetec.v5.re.cm.device.video.videofile.watcher.FileWatcher;
import de.seetec.v5.shared.Basic;
import de.seetec.v5.shared.EventType;
import de.seetec.v5.shared.proxy.ent.Entity;
import de.seetec.v5.shared.util.ConfigurationException;
import de.seetec.v5.shared.util.NamedThreadFactory;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.ehcache.impl.internal.concurrent.ConcurrentHashMap;

public class DirectoryParser
implements FileListener {
    private static final Logger LOGGER = LogManager.getLogger(DirectoryParser.class);
    private static final long INTERNAL_DEADTIME_READ_METADATA = TimeUnit.MINUTES.toMillis(10L);
    private static final long INTERNAL_DEADTIME_READ_VIDEODATA = TimeUnit.MINUTES.toMillis(10L);
    private final FileWatcher watcher;
    private final VideoSourceCreator videoSourceCreator;
    private final Map<String, VideoFileListener> listeners = new ConcurrentHashMap();
    private final Map<Path, Long> lastReadMetadataError = new ConcurrentHashMap();
    private final Map<Path, Long> lastReadVideoDataError = new ConcurrentHashMap();
    private final ExecutorService executorService;

    public DirectoryParser(File rootFolder, VideoSourceCreator videoSourceCreator) {
        this.videoSourceCreator = videoSourceCreator;
        this.watcher = new FileWatcher(rootFolder.toPath());
        this.executorService = Executors.newFixedThreadPool(10, (ThreadFactory)new NamedThreadFactory("VideoFile import"));
    }

    public int init() {
        this.watcher.addListener(this);
        return this.watcher.startWatch();
    }

    public void shutdown() {
        this.watcher.removeListener(this);
        this.watcher.shutdown();
        this.executorService.shutdownNow();
    }

    public void addListener(String uniqueId, VideoFileListener listener) {
        this.listeners.putIfAbsent(uniqueId, listener);
    }

    public void removeListener(String uniqueId) {
        this.listeners.remove(uniqueId);
    }

    public void removeListener(Entity entity) {
        if (entity == null) {
            return;
        }
        Iterator<Map.Entry<String, VideoFileListener>> iterator = this.listeners.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, VideoFileListener> listener = iterator.next();
            if (!listener.getValue().getEntity().getEntityID().equals(entity.getEntityID())) continue;
            iterator.remove();
        }
    }

    protected Map<String, VideoFileListener> getListeners() {
        return this.listeners;
    }

    @Override
    public void onCompleted(File file) {
        MetadataObject metadata;
        Path baseDirectory = file.toPath().getParent();
        try {
            metadata = new MetadataParser().parse(baseDirectory);
        }
        catch (MetadataException | IOException exception) {
            Long lastError = this.lastReadMetadataError.get(baseDirectory);
            if (lastError == null || System.currentTimeMillis() > lastError + INTERNAL_DEADTIME_READ_METADATA) {
                this.lastReadMetadataError.put(baseDirectory, System.currentTimeMillis());
                this.onError(null, -21713, "Can't read metadata in folder '" + baseDirectory + "'", "Can't read metadata in folder '" + baseDirectory + "'. Message: " + ((Throwable)exception).getMessage());
            }
            return;
        }
        this.lastReadMetadataError.remove(baseDirectory);
        VideoFileListener listener = this.listeners.get(metadata.getUniqueThirdPartyId());
        if (listener == null) {
            if (!this.videoSourceCreator.existsVideoSource(metadata.getUniqueThirdPartyId())) {
                LOGGER.info("New VideoSource detected: " + metadata.getUniqueThirdPartyId());
                this.videoSourceCreator.createVideoSource(metadata.getDisplayName(), metadata.getUniqueThirdPartyId());
            }
        } else if (!listener.isCurrentlyRunning()) {
            this.executorService.execute(() -> {
                block2: {
                    try {
                        listener.onNewVideoFile(metadata);
                        this.lastReadVideoDataError.remove(baseDirectory);
                    }
                    catch (VideoFileReaderException exception) {
                        LOGGER.error("Cannot import video file " + metadata.getVideoFile() + ": ", (Throwable)((Object)exception));
                        Long lastError = this.lastReadVideoDataError.get(baseDirectory);
                        if (lastError != null && System.currentTimeMillis() <= lastError + INTERNAL_DEADTIME_READ_VIDEODATA) break block2;
                        this.lastReadVideoDataError.put(baseDirectory, System.currentTimeMillis());
                        this.onError(listener.getEntity(), exception.getErrorCode(), "Can't read video file in folder '" + baseDirectory + "'", "Can't read video file in folder '" + baseDirectory + "'. Message: " + exception.getMessage());
                    }
                }
            });
        }
    }

    @Override
    public void onError(Entity serviceEntity, int errorCode, String message, String details) {
        Entity entity = serviceEntity == null ? this.videoSourceCreator.getDeviceEntity() : serviceEntity;
        try {
            String body = "Video File Reader failed for [" + entity.getEntityID() + "]/[" + entity.getEntityName() + "] at [" + Basic.getLocalHostName() + "/" + this.videoSourceCreator.getCore().getDmCnfMgr().getServerAddress() + "]: " + details;
            this.videoSourceCreator.getCore().sendErrorEvent(EventType.CM_EVENTTYPE_VIDEO_FILE_READER_IMPORT_UNSUCCESSFUL, entity.getEntityID());
            this.videoSourceCreator.getCore().sendLoggingEvent(EventType.CM_EVENTTYPE_VIDEO_FILE_READER_IMPORT_UNSUCCESSFUL, entity.getEntityID(), errorCode, "Video File Reader failed for [" + entity.getEntityID() + "]/[" + entity.getEntityName() + "]: " + message, body);
        }
        catch (ConfigurationException configurationException) {
            LOGGER.error("Exception while sending event: " + configurationException.getMessage());
        }
    }
}

