/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.cm.device.video.sony.mpeg;

import de.seetec.v5.re.cm.device.shared.net.httpserverpush.HttpServerPushContent;
import de.seetec.v5.re.cm.device.shared.net.httpserverpush.HttpServerPushHandler;
import de.seetec.v5.re.cm.device.shared.net.httpserverpush.HttpServerPushListenerIntf;
import de.seetec.v5.re.cm.device.shared.videosource.StreamingHelper;
import de.seetec.v5.re.cm.device.shared.videosource.StreamingHelperMpeg4;
import de.seetec.v5.re.cm.device.shared.videosource.StreamingVideoSourceClient;
import de.seetec.v5.re.cm.shared.Tools;
import de.seetec.v5.re.shared.Codec;
import de.seetec.v5.re.shared.MediaFrame;
import de.seetec.v5.shared.net.NetworkHelper;
import de.seetec.v5.shared.net.NetworkParameter;
import de.seetec.v5.shared.util.SeeTecException;

public class SonyMPEGVideoSourceClient_Vx
extends StreamingVideoSourceClient
implements HttpServerPushListenerIntf {
    private static final String CLASS_NAME = "de.seetec.v5.re.cm.device.video.sony.mpeg.SonyMPEGVideoSourceClient_Vx";
    final int[] MPEG_BITRATES = new int[]{64, 128, 256, 384, 512, 768, 1024, 1536, 2048};
    private HttpServerPushHandler httpServerPushHandler = null;
    private AudioHandler audioHandler = null;

    @Override
    public int init() {
        StringBuffer url = new StringBuffer();
        this.errorCode = super.init();
        if (this.errorCode != 0) {
            this.logger.error("Error while initializing. Code: " + this.errorCode + " for " + this);
            return this.errorCode;
        }
        this.fps /= 1000L;
        this.bandwidth /= 1024;
        this.iFrameDist /= 1000L;
        long[] allowedValues = new long[]{1L, 2L, 3L, 4L, 5L, 6L, 8L, 12L, 25L};
        this.fps = Tools.convertToCameraValues(allowedValues, this.fps);
        this.fps = this.fps == 25L ? 0L : this.fps;
        this.bandwidth = Tools.convertToCameraValues(this.MPEG_BITRATES, this.bandwidth);
        this.iFrameDist = this.iFrameDist <= 0L ? 1L : this.iFrameDist;
        this.iFrameDist = this.iFrameDist > 5L ? 5L : this.iFrameDist;
        this.logger.info("fps:" + this.fps + ",iFrameDist:" + this.iFrameDist);
        this.logger.info("Requested resolution: " + this.width + "x" + this.height + " (Bandwidth: " + this.bandwidth + ") for " + this.getVideoSrv());
        if (this.isAudioEnabled) {
            this.audioBitrate /= 1000;
        }
        if (super.getVideoSrv().getEntityType() == 219900L) {
            url.append("/command/system.cgi?");
            url.append("Cam").append(this.videoSourceNr).append("Protocol=99");
        } else {
            url.append("/command/system.cgi?");
            url.append("Cam").append(this.videoSourceNr).append("ID=");
            url.append(this.camID - 1);
        }
        try {
            if (NetworkHelper.readGetRequest((NetworkParameter)this.networkParameter, (String)url.toString(), (int)Integer.MIN_VALUE) == null) {
                this.logger.error("Error while setting protocol mode for " + this.getVideoSrv());
                return -20100;
            }
        }
        catch (SeeTecException e) {
            this.logger.error("Exception while setting udp mode for " + this.getVideoSrv());
            return e.getErrorCode();
        }
        url = new StringBuffer(256);
        if (this.useDateTime) {
            url.append("/command/osd.cgi?ChannelNo=");
            url.append(this.videoSourceNr);
            url.append("&partno=1&available=1&TextMode=1");
        } else if (this.useTitle) {
            url.append("/command/osd.cgi?ChannelNo=");
            url.append(this.videoSourceNr);
            url.append("&partno=1&available=1&TextMode=0&text=");
            url.append(this.title);
        } else {
            url.append("/command/osd.cgi?ChannelNo=");
            url.append(this.videoSourceNr);
            url.append("&partno=1&available=0");
        }
        try {
            if (NetworkHelper.readGetRequest((NetworkParameter)this.networkParameter, (String)url.toString(), (int)Integer.MIN_VALUE) == null) {
                this.logger.error("Error while setting date/title for " + this.getVideoSrv());
                return -20100;
            }
        }
        catch (SeeTecException e) {
            this.logger.error("Exception while setting date/title for " + this.getVideoSrv());
            return e.getErrorCode();
        }
        url = new StringBuffer();
        url.append("/command/videoset.cgi?ChannelNO=");
        url.append(this.videoSourceNr);
        if (this.width == 720) {
            url.append("&ImageSize=0");
        } else if (this.width == 640) {
            url.append("&ImageSize=1");
        } else {
            url.append("&ImageSize=2");
        }
        try {
            if (NetworkHelper.readGetRequest((NetworkParameter)this.networkParameter, (String)url.toString(), (int)Integer.MIN_VALUE) == null) {
                this.logger.error("Error while setting resolution for " + this.getVideoSrv());
                return -20100;
            }
        }
        catch (SeeTecException e) {
            this.logger.error("Exception while setting resolution for " + this.getVideoSrv());
            return e.getErrorCode();
        }
        url = new StringBuffer();
        url.append("/command/videoselect.cgi?ChannelNO=");
        url.append(this.videoSourceNr);
        url.append("&ImageCodec=1&M4FrameRate=");
        url.append(this.fps);
        url.append("&M4BitRate=").append(this.bandwidth);
        url.append("&M4IFrameInterval=").append(this.iFrameDist);
        try {
            if (NetworkHelper.readGetRequest((NetworkParameter)this.networkParameter, (String)url.toString(), (int)Integer.MIN_VALUE) == null) {
                this.logger.error("Error while setting fps for " + this.getVideoSrv());
                return -20100;
            }
            if (NetworkHelper.readGetRequest((NetworkParameter)this.networkParameter, (String)url.toString(), (int)Integer.MIN_VALUE) == null) {
                this.logger.error("Error while setting fps for " + this.getVideoSrv());
                return -20100;
            }
        }
        catch (SeeTecException e) {
            this.logger.error("Exception while setting fps for " + this.getVideoSrv());
            return e.getErrorCode();
        }
        if (this.isAudioEnabled) {
            try {
                if (NetworkHelper.readGetRequest((NetworkParameter)this.networkParameter, (String)"/command/sound.cgi&AudioIn=1", (int)Integer.MIN_VALUE) == null) {
                    this.logger.error("Error while setting audio for " + this.getVideoSrv());
                    return -20100;
                }
            }
            catch (SeeTecException e) {
                this.logger.error("Exception while setting audio for " + this.getVideoSrv());
                return e.getErrorCode();
            }
            this.logger.info("Audio enabled for " + this.getVideoSrv());
            this.audioHandler = new AudioHandler(this);
            this.errorCode = this.audioHandler.init();
            if (this.errorCode != 0) {
                this.logger.error("Exception while setting audio for " + this.getVideoSrv());
                return this.errorCode;
            }
        }
        try {
            boolean asynchronous = true;
            this.httpServerPushHandler = new HttpServerPushHandler();
            this.networkParameter.setSoTimeout(5000);
            this.errorCode = this.httpServerPushHandler.init(this, this.networkParameter, "/command/image.cgi?ChannelNO=" + this.videoSourceNr);
            if (this.errorCode != 0) {
                this.logger.error("Error [" + this.errorCode + "] with " + this.httpServerPushHandler);
            } else {
                this.errorCode = this.httpServerPushHandler.startServerPush(asynchronous);
            }
        }
        catch (Exception e) {
            this.logger.error("Reading configuration from " + this.getVideoSrv().getDevice() + " failed :-(", (Throwable)e);
            this.errorCode = -21601;
            return this.errorCode;
        }
        this.logger.info("Init done for " + this.getVideoSrv());
        return 0;
    }

    @Override
    public synchronized int shutdown() {
        if (this.startShutdown(CLASS_NAME)) {
            return 0;
        }
        if (this.httpServerPushHandler != null) {
            this.httpServerPushHandler.shutdown();
        }
        if (this.audioHandler != null) {
            this.audioHandler.shutdown();
            this.audioHandler = null;
        }
        this.audioCodec = null;
        return 0;
    }

    public void onNetworkError(int error) {
        if (this.isShutdown()) {
            return;
        }
        this.logger.warn("Shutting down : " + error + " for " + this.getVideoSrv());
        this.listener.sendStatusService(error);
        this.shutdown();
        if (this.getVideoSrv() != null && this.getVideoSrv().getHardwareMotionDetection() != null) {
            this.getVideoSrv().getHardwareMotionDetection().notifyForNetworkProblems();
        }
    }

    @Override
    public final boolean isShutdown() {
        return this.isShutdown(CLASS_NAME);
    }

    @Override
    public void sendStatusService(int nStatusCode) {
        this.listener.sendStatusService(nStatusCode);
    }

    @Override
    public void notifyForNetworkProblems() {
        if (this.isShutdown()) {
            return;
        }
        this.sendStatusService(-21603);
        this.listener.notifyForNetworkProblems();
        this.shutdown();
    }

    @Override
    public void deliverContent(HttpServerPushContent httpServerPushContent) {
        int mediaType;
        byte[] contentData = httpServerPushContent.getContentBody();
        if (contentData != null && (mediaType = StreamingHelperMpeg4.checkForMPEG4Part2MediaType(contentData)) >= 0) {
            int[] resolutionFromStream;
            if (mediaType == 33 && (resolutionFromStream = StreamingHelperMpeg4.extractMPEG4Part2Resolution(contentData)) != null && resolutionFromStream[0] > 0 && resolutionFromStream[1] > 0) {
                this.width = resolutionFromStream[0];
                this.height = resolutionFromStream[1];
            }
            try {
                MediaFrame mediaFrame = StreamingHelper.createSeeTecVideoFrameHeader(Codec.MPEG4, this.width, this.height, contentData);
                this.deliverFrameCreateServerTimestamp(mediaType, mediaFrame);
            }
            catch (SeeTecException ex) {
                this.logger.error("Exception while creating and sending media frame for " + this + " : " + ex.getMessage() + " , this.errorCode: " + ex.getErrorCode());
            }
        }
    }

    private class AudioHandler
    implements HttpServerPushListenerIntf {
        SonyMPEGVideoSourceClient_Vx daddy = null;
        HttpServerPushHandler httpServerPushHandler = null;

        public AudioHandler(SonyMPEGVideoSourceClient_Vx daddy) {
            this.daddy = daddy;
        }

        public int init() {
            int errorCode;
            try {
                boolean asynchronous = true;
                this.httpServerPushHandler = new HttpServerPushHandler();
                SonyMPEGVideoSourceClient_Vx.this.networkParameter.setSoTimeout(5000);
                errorCode = this.httpServerPushHandler.init(this, SonyMPEGVideoSourceClient_Vx.this.networkParameter, "/command/soundreceive.cgi");
                if (errorCode != 0) {
                    SonyMPEGVideoSourceClient_Vx.this.logger.error("Error [" + errorCode + "] with " + this.httpServerPushHandler);
                } else {
                    errorCode = this.httpServerPushHandler.startServerPush(asynchronous);
                    if (errorCode != 0) {
                        SonyMPEGVideoSourceClient_Vx.this.logger.error("Error [" + errorCode + "] with " + this.httpServerPushHandler);
                    }
                }
            }
            catch (Exception e) {
                SonyMPEGVideoSourceClient_Vx.this.logger.error("Reading configuration from " + SonyMPEGVideoSourceClient_Vx.this.getVideoSrv().getDevice() + " failed :-(", (Throwable)e);
                errorCode = -21601;
            }
            return errorCode;
        }

        @Override
        public final boolean isShutdown() {
            return this.daddy.isShutdown(SonyMPEGVideoSourceClient_Vx.CLASS_NAME);
        }

        @Override
        public void sendStatusService(int nStatusCode) {
            this.daddy.sendStatusService(nStatusCode);
        }

        @Override
        public void notifyForNetworkProblems() {
            this.sendStatusService(-21650);
            this.shutdown();
            this.daddy.notifyForNetworkProblems();
        }

        @Override
        public void deliverContent(HttpServerPushContent httpServerPushContent) {
            byte[] contentData = httpServerPushContent.getContentBody();
            if (contentData != null) {
                try {
                    MediaFrame mediaFrame = StreamingHelper.createSeeTecAudioFrameHeader(SonyMPEGVideoSourceClient_Vx.this.audioCodec, SonyMPEGVideoSourceClient_Vx.this.audioBitrate % 8000 == 0 ? (int)(SonyMPEGVideoSourceClient_Vx.this.audioBitrate / 8000) : 0, contentData);
                    SonyMPEGVideoSourceClient_Vx.this.deliverFrameCreateServerTimestamp(16, mediaFrame);
                }
                catch (SeeTecException ex) {
                    SonyMPEGVideoSourceClient_Vx.this.logger.error("Exception while creating and delivering audio frame for " + this + " : " + ex.getMessage() + " , error code: " + ex.getErrorCode());
                }
            }
        }

        public void shutdown() {
            this.daddy = null;
            if (this.httpServerPushHandler != null) {
                this.httpServerPushHandler.shutdown();
            }
        }
    }
}

