/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.cm.device.video.sony;

import de.seetec.v5.re.shared.Codec;

public class StreamConfiguration
implements Comparable<StreamConfiguration> {
    int dynamicVideoProfileID;
    int codec;
    int width;
    int height;
    int streamNumberOnCamera;

    public StreamConfiguration(int dynamicVideoProfileID, int codec, int width, int height, int streamNumberOnCamera) {
        this.dynamicVideoProfileID = dynamicVideoProfileID;
        this.codec = codec;
        this.width = width;
        this.height = height;
        this.streamNumberOnCamera = streamNumberOnCamera;
    }

    public int getCodec() {
        return this.codec;
    }

    public void setCodec(int codec) {
        this.codec = codec;
    }

    public int getDynamicVideoProfileID() {
        return this.dynamicVideoProfileID;
    }

    public void setDynamicVideoProfileID(int dynamicVideoProfileID) {
        this.dynamicVideoProfileID = dynamicVideoProfileID;
    }

    public int getHeight() {
        return this.height;
    }

    public void setHeight(int height) {
        this.height = height;
    }

    public int getStreamNumberOnCamera() {
        return this.streamNumberOnCamera;
    }

    public void setStreamNumberOnCamera(int streamNumberOnCamera) {
        this.streamNumberOnCamera = streamNumberOnCamera;
    }

    public int getWidth() {
        return this.width;
    }

    public void setWidth(int width) {
        this.width = width;
    }

    public int hashCode() {
        int hash = 5;
        hash = 29 * hash + this.dynamicVideoProfileID;
        hash = 29 * hash + this.codec;
        hash = 29 * hash + this.width;
        hash = 29 * hash + this.height;
        hash = 29 * hash + this.streamNumberOnCamera;
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        StreamConfiguration other = (StreamConfiguration)obj;
        if (this.dynamicVideoProfileID != other.dynamicVideoProfileID) {
            return false;
        }
        if (this.codec != other.codec) {
            return false;
        }
        if (this.width != other.width) {
            return false;
        }
        if (this.height != other.height) {
            return false;
        }
        return this.streamNumberOnCamera == other.streamNumberOnCamera;
    }

    @Override
    public int compareTo(StreamConfiguration sc) {
        if (this.width < sc.width) {
            return -1;
        }
        if (this.width == sc.width) {
            if (this.height < sc.height) {
                return -1;
            }
            if (this.height == sc.height) {
                return 0;
            }
            return 1;
        }
        return 1;
    }

    String getUrlPart() {
        return "&ImageCodec" + this.streamNumberOnCamera + (this.codec == Codec.MJPEG.getType() ? "=jpeg" : "=h264") + "&ImageSize" + this.streamNumberOnCamera + "=" + this.width + "%2C" + this.height;
    }
}

