/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.cm.device.video.sony;

import de.seetec.v5.re.cm.device.shared.net.httpserverpush.HttpServerPushContent;
import de.seetec.v5.re.cm.device.shared.net.httpserverpush.HttpServerPushHandler;
import de.seetec.v5.re.cm.device.shared.net.httpserverpush.HttpServerPushListenerIntf;
import de.seetec.v5.re.cm.device.shared.net.rtsp.RTSPStreamSettings;
import de.seetec.v5.re.cm.device.shared.videosource.StreamingHelper;
import de.seetec.v5.re.cm.device.shared.videosource.StreamingVideoSourceClientRTSP;
import de.seetec.v5.re.cm.device.video.sony.SonyCameraSrv;
import de.seetec.v5.re.cm.shared.Tools;
import de.seetec.v5.re.shared.Codec;
import de.seetec.v5.re.shared.MediaFrame;
import de.seetec.v5.shared.net.HTTPResponse;
import de.seetec.v5.shared.net.NetworkHelper;
import de.seetec.v5.shared.net.NetworkParameter;
import de.seetec.v5.shared.util.ConfigurationException;
import de.seetec.v5.shared.util.SeeTecException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class SonyVideoSourceClient_Fisheye
extends StreamingVideoSourceClientRTSP
implements HttpServerPushListenerIntf {
    private static final String CLASS_NAME = "de.seetec.v5.re.cm.device.video.sony.SonyVideoSourceClient_Fisheye";
    private int streamNumber = 1;
    private SonyCameraSrv sonyCameraSrv;
    private boolean fisheyeMode = false;

    /*
     * WARNING - void declaration
     */
    @Override
    protected int init() {
        CharSequence url;
        this.errorCode = super.init();
        if (this.errorCode != 0) {
            this.logger.error("Error while initializing. Code: " + this.errorCode + " for " + this);
            return this.errorCode;
        }
        this.networkParameter.setSoTimeout(5000);
        this.sonyCameraSrv = (SonyCameraSrv)this.getVideoSrv();
        try {
            String captureMode = this.getVideoSrv().getDevice().getDeviceCnf().getCaptureMode().getDisplayResolution();
            if (captureMode.toLowerCase().equals("fisheye mode")) {
                this.fisheyeMode = true;
            }
            this.setFisheyeMode(this.fisheyeMode);
        }
        catch (ConfigurationException ex) {
            this.logger.error((Object)ex, (Throwable)ex);
        }
        catch (SeeTecException ex) {
            this.logger.error("Exception while reading/setting capture mode for " + this + " : " + ex.getMessage());
            return ex.getErrorCode();
        }
        catch (InterruptedException ex) {
            // empty catch block
        }
        this.streamNumber = 1;
        this.logger.info("init started for" + this.getVideoSrv());
        this.iFrameDist = this.iFrameDistMS / 1000;
        int[] iFrameLimits = new int[]{1, 2, 3, 4, 5};
        this.iFrameDist = Tools.convertToCameraValues(iFrameLimits, (int)this.iFrameDist);
        this.fps /= 1000L;
        int maximalFramerate = 13;
        if (this.videoCodec == Codec.H264) {
            maximalFramerate = 10;
        }
        this.logger.info("Maximal framerate is: " + maximalFramerate);
        this.fps = this.fps > (long)maximalFramerate ? (long)maximalFramerate : this.fps;
        String codec = "h264";
        if (this.videoCodec == Codec.MJPEG) {
            codec = "jpeg";
        }
        if (this.videoCodec == Codec.MJPEG || !this.isConstantBitrateUsed) {
            int qualityLowerLimit = 1;
            int qualityUpperLimit = 10;
            this.quality = this.quality / 10000 + 1;
            this.quality = this.quality > qualityUpperLimit ? qualityUpperLimit : this.quality;
            this.quality = this.quality < qualityLowerLimit ? qualityLowerLimit : this.quality;
        } else if (this.isConstantBitrateUsed) {
            int[] allowedValues = new int[]{64, 128, 256, 384, 512, 768, 1000, 1500, 2000, 3000, 4000, 6000, 8000, 10000, 12000, 14000, 16000};
            this.bandwidth = Tools.convertToCameraValues(allowedValues, this.bandwidth / 1024);
        }
        HashMap<String, String> parameters = new HashMap<String, String>();
        if (this.isAudioEnabled) {
            parameters.put("AudioIn", "on");
        } else {
            parameters.put("AudioIn", "off");
        }
        if (this.fisheyeMode) {
            parameters.put("ImageSize" + this.streamNumber, this.width + "," + this.height);
        }
        parameters.put("ImageCodec" + this.streamNumber, codec);
        try {
            parameters.put("RTSPPort", this.listener.getVideoSourceParameter().getRtspPort() + "");
        }
        catch (ConfigurationException exception) {
            this.logger.warn("RTSP port could not be read", (Throwable)exception);
        }
        parameters.put("FrameRate" + this.streamNumber, String.valueOf(this.fps));
        if (this.videoCodec == Codec.MJPEG) {
            parameters.put("JpegQuality" + this.streamNumber, "" + this.quality);
        } else {
            parameters.put("IFrameInterval" + this.streamNumber, "" + this.iFrameDist);
            if (this.isConstantBitrateUsed) {
                parameters.put("CBR" + this.streamNumber, "on");
                parameters.put("BitRate" + this.streamNumber, "" + this.bandwidth);
            } else {
                parameters.put("CBR" + this.streamNumber, "off");
                parameters.put("H264Quality" + this.streamNumber, "" + this.quality);
            }
        }
        ArrayList<String> parametersToRemove = new ArrayList<String>();
        boolean readConfig = true;
        for (Map.Entry entry : parameters.entrySet()) {
            String string = (String)entry.getKey();
            String config = this.sonyCameraSrv.readConfiguration(string, readConfig);
            if (config != null && config.equals(entry.getValue())) {
                parametersToRemove.add(string);
            }
            readConfig = false;
        }
        for (String string : parametersToRemove) {
            parameters.remove(string);
        }
        if (!parameters.isEmpty()) {
            url = new StringBuilder("/command/camera.cgi?");
            for (Map.Entry entry : parameters.entrySet()) {
                ((StringBuilder)url).append("&").append((String)entry.getKey()).append("=").append((String)entry.getValue());
            }
            try {
                void var8_23;
                String string = ((StringBuilder)url).toString().replace("?&", "?");
                if (!string.contains("FrameRate")) {
                    String string2 = string + "&FrameRate" + this.streamNumber + "=" + this.fps;
                }
                NetworkHelper.readGetRequest((NetworkParameter)this.networkParameter, (String)var8_23, (int)Integer.MAX_VALUE, (boolean)false, null, (boolean)true);
                Thread.sleep(5000L);
            }
            catch (SeeTecException seeTecException) {
                this.logger.error("Exception while setting image parameters for " + this + ": " + seeTecException.getMessage());
                return seeTecException.getErrorCode();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        if (this.videoCodec == Codec.MJPEG) {
            url = "/image" + this.streamNumber;
            HttpServerPushHandler httpServerPushHandler = new HttpServerPushHandler();
            httpServerPushHandler.init(this, this.networkParameter, (String)url, 1024);
            httpServerPushHandler.startServerPush(true);
        } else {
            this.rtspUrl = "rtsp://" + this.getHost() + "/video" + this.streamNumber;
            this.rtspSettings = new RTSPStreamSettings();
            try {
                if (this.rtspSettings.init(this, this.audioSourceClient, this.networkParameter, this.listener.getVideoSourceParameter().getRtspPort(), this.rtspUrl, this.printDebug, this.transmissionID, 15000, this.isAudioEnabled, 4, this.rtspUrl) != 0) {
                    this.logger.error("Error while initializing Settings for RTSP streaming for " + this);
                    return -20001;
                }
            }
            catch (ConfigurationException ex) {
                this.logger.warn("Could not initialize rtspSettings for " + this);
                this.logger.warn((Object)ex, (Throwable)ex);
            }
            this.rtspSettings.setRange("npt=now-");
            this.rtspSettings.setTcpChannel(0);
            if (this.fisheyeMode) {
                this.rtspSettings.setCheckResolution(true, new int[]{this.width, this.height});
            }
            try {
                this.rtspHandler = this.rtspSettings.getRTSPHandler();
            }
            catch (SeeTecException ex) {
                this.logger.error("Exception while retrieving RTSP Handler for " + this + ": " + ex.getMessage());
                return ex.getErrorCode();
            }
            if (this.rtspHandler.start() != 0) {
                this.logger.error("Error while startint RTSP Handler for " + this);
                return -20001;
            }
            this.publishRTSPUrl(this.rtspUrl);
        }
        this.logger.info("init done for" + this.getVideoSrv());
        return 0;
    }

    @Override
    public synchronized int shutdown() {
        if (this.startShutdown(CLASS_NAME)) {
            return 0;
        }
        if (this.rtspHandler != null) {
            this.rtspHandler.shutdown();
            this.rtspHandler = null;
        }
        super.shutdown();
        this.logger.info("shutdown done for " + this.getVideoSrv());
        return 0;
    }

    @Override
    public boolean isShutdown() {
        return this.isShutdown(CLASS_NAME);
    }

    @Override
    public void onNetworkError(int error) {
        if (this.isShutdown()) {
            return;
        }
        this.listener.sendStatusService(error);
        this.shutdown();
    }

    @Override
    public void sendStatusService(int statusCode) {
        if (this.listener != null) {
            this.listener.sendStatusService(statusCode);
        } else {
            this.logger.error("Listener null for " + this);
        }
    }

    @Override
    public void processData(byte[] data) {
        this.processRtpData(data);
    }

    @Override
    public void notifyForNetworkProblems() {
        this.sendStatusService(-21656);
        this.shutdown();
    }

    @Override
    public void deliverContent(HttpServerPushContent httpServerPushContent) {
        try {
            MediaFrame mediaFrame = StreamingHelper.createSeeTecVideoFrameHeader(Codec.MJPEG, httpServerPushContent.getContentBody(), false);
            super.deliverFrameCreateServerTimestamp(0, mediaFrame);
        }
        catch (SeeTecException ex) {
            this.logger.error("Exception while creating video frame for " + this + " : " + ex.getMessage());
        }
    }

    private void setFisheyeMode(boolean fisheyeMode) throws SeeTecException, InterruptedException {
        byte[] result = NetworkHelper.readGetRequest((NetworkParameter)this.networkParameter, (String)"/cgi-bin/admin/getparam.cgi?videoin_c0_crop_size", (int)Integer.MAX_VALUE);
        String resultString = new HTTPResponse(result).getHttpBody().getData();
        boolean fisheyeOnCameraSet = resultString.contains("2560x1920");
        if (fisheyeMode) {
            if (!fisheyeOnCameraSet) {
                String url = "/cgi-bin/admin/setparam.cgi?videoin_c0_crop_size=2560x1920";
                NetworkHelper.readGetRequest((NetworkParameter)this.networkParameter, (String)url, (int)Integer.MAX_VALUE);
                Thread.sleep(15000L);
            }
        } else if (fisheyeOnCameraSet) {
            String url = "/cgi-bin/admin/setparam.cgi?videoin_c0_crop_size=1920x1080";
            NetworkHelper.readGetRequest((NetworkParameter)this.networkParameter, (String)url, (int)Integer.MAX_VALUE);
            Thread.sleep(5000L);
        }
    }
}

