/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.cm.device.video.sony;

import de.seetec.v5.re.cm.device.shared.MotionRecording;
import de.seetec.v5.re.cm.device.shared.genericevent.GenericEventTriggerCnf;
import de.seetec.v5.re.cm.device.shared.genericevent.GenericEventTriggerHandler;
import de.seetec.v5.re.cm.device.shared.net.httpserverpush.HttpServerPushContent;
import de.seetec.v5.re.cm.device.shared.net.httpserverpush.HttpServerPushHandler;
import de.seetec.v5.re.cm.device.shared.net.httpserverpush.HttpServerPushListenerIntf;
import de.seetec.v5.re.cm.shared.Tools;
import de.seetec.v5.shared.net.NetworkHelper;
import de.seetec.v5.shared.net.NetworkParameter;
import de.seetec.v5.shared.util.ConfigurationException;
import de.seetec.v5.shared.util.SeeTecException;
import java.util.HashMap;

public final class SonyTriggerHandler
extends GenericEventTriggerHandler
implements HttpServerPushListenerIntf {
    private static final String CLASS_NAME = "de.seetec.v5.re.cm.device.video.sony.SonyTriggerHandler";
    private static final String EVENTNAME_TAMPERING = "Tampering";
    private static final String URL_TAMPERING_ENABLE = "/command/tamper.cgi?TamperingFunc=on";
    private static final String URL_TAMPERING_CLEAR = "/command/tamper.cgi?TamperingStatusClear=on";
    private static final String URL_ALARMDATA = "/command/alarmdata.cgi?interval=1";
    private NetworkParameter networkParameter;
    private HttpServerPushHandler httpServerPushHandlerTrigger;

    public SonyTriggerHandler(MotionRecording motionRecording) {
        super(motionRecording);
    }

    @Override
    public void run() {
        try {
            this.networkParameter = this.device.getDeviceCnf().getNetworkParameter();
            this.networkParameter.setSoTimeout(8000);
            this.networkParameter.setIgnoreSoTimeout(false);
        }
        catch (ConfigurationException configurationException) {
            this.logger.error("Starting ServerPushHandler for Events failed. Device=" + this.device, (Throwable)configurationException);
            return;
        }
        try {
            if (this.isTamperingActivated()) {
                NetworkHelper.readGetRequest((NetworkParameter)this.networkParameter, (String)URL_TAMPERING_ENABLE, (int)Integer.MAX_VALUE, (boolean)false, null, (boolean)true);
                NetworkHelper.readGetRequest((NetworkParameter)this.networkParameter, (String)URL_TAMPERING_CLEAR, (int)Integer.MAX_VALUE, (boolean)false, null, (boolean)true);
            }
        }
        catch (SeeTecException ex) {
            this.logger.warn("Couldn't configure tampering on camera, tampering might not work: " + ex.getMessage() + ", Device=" + this.device);
        }
        catch (ConfigurationException ex) {
            this.logger.warn("Couldn't configure tampering on camera, tampering might not work: " + ex.getMessage() + ", Device=" + this.device);
        }
        while (!this.isShutdown()) {
            if (this.httpServerPushHandlerTrigger == null) {
                this.httpServerPushHandlerTrigger = new HttpServerPushHandler();
                int errorCode = this.httpServerPushHandlerTrigger.init(this, this.networkParameter, URL_ALARMDATA);
                if (errorCode == 0) {
                    this.httpServerPushHandlerTrigger.startServerPush(true);
                } else {
                    this.httpServerPushHandlerTrigger = null;
                    this.logger.error("Error [" + errorCode + "] with " + this.httpServerPushHandlerTrigger);
                }
            }
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    @Override
    public void deliverContent(HttpServerPushContent httpServerPushContent) {
        try {
            HashMap<String, String> content = new HashMap<String, String>();
            Tools.parseParameters(content, new String(httpServerPushContent.getContentBody()));
            for (GenericEventTriggerCnf event : this.genericEventTriggerCnfs) {
                String eventType;
                if (event == null || !event.isEnabled() || !content.containsKey(eventType = event.getGenericEventTriggerType()) || !((String)content.get(eventType)).equals("1")) continue;
                this.forwardTrigger(event);
                if (!eventType.equals(EVENTNAME_TAMPERING)) continue;
                try {
                    NetworkHelper.readGetRequest((NetworkParameter)this.networkParameter, (String)URL_TAMPERING_CLEAR, (int)Integer.MAX_VALUE, (boolean)false, null, (boolean)true);
                }
                catch (SeeTecException seetecException) {
                    this.logger.warn("Couldn't clear tampering status of camera, tampering might be triggered again. Device=" + this.device);
                }
            }
        }
        catch (ConfigurationException configurationException) {
            this.logger.error("Reading configuration from " + this.device + " failed", (Throwable)configurationException);
        }
    }

    @Override
    public int shutdown() {
        if (this.isShutdown()) {
            return 0;
        }
        if (this.httpServerPushHandlerTrigger != null) {
            this.httpServerPushHandlerTrigger.shutdown();
            this.httpServerPushHandlerTrigger = null;
        }
        super.shutdown();
        return 0;
    }

    @Override
    public void sendStatusService(int statusCode) {
        if (this.isShutdown()) {
            return;
        }
        if (statusCode != 0 && this.httpServerPushHandlerTrigger != null) {
            this.httpServerPushHandlerTrigger.shutdown();
            this.httpServerPushHandlerTrigger = null;
        }
    }

    @Override
    public void notifyForNetworkProblems() {
        this.sendStatusService(-21650);
    }

    private boolean isTamperingActivated() throws ConfigurationException {
        for (GenericEventTriggerCnf event : this.genericEventTriggerCnfs) {
            String eventType;
            if (event == null || !event.isEnabled() || !(eventType = event.getGenericEventTriggerType()).equals(EVENTNAME_TAMPERING)) continue;
            return true;
        }
        return false;
    }
}

