/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.cm.device.video.sony;

import de.seetec.v5.re.cm.device.video.axis.utils.Query;
import de.seetec.v5.re.cm.device.video.sony.SonyQuery;
import java.util.Locale;

public class SonyPtzCommandQuery
extends SonyQuery {
    protected static final String URL = "/command/ptzf.cgi";
    protected static final String MOVE_COMMAND = "Move";
    protected static final String ZOOM_COMMAND = "AbsoluteZoom";
    protected static final String ABSOLUTE_PTZF_COMMAND = "AbsolutePTZF";

    SonyPtzCommandQuery() {
        super(URL);
    }

    public SonyPtzCommandQuery sid() {
        String seeTecID = Long.toHexString(System.currentTimeMillis() & 0xFFFFFFFFL);
        return this.sid(seeTecID);
    }

    public SonyPtzCommandQuery sid(String sid) {
        return this.newParam("sid", sid);
    }

    public SonyPtzCommandQuery absolutePtzf(Integer pan, Integer tilt, Integer zoom, Integer ... focus) {
        if (focus != null && focus.length > 0) {
            return this.newParam(ABSOLUTE_PTZF_COMMAND, this.intTo16bitHex(pan), this.intTo16bitHex(tilt), this.intTo16bitHex(zoom), this.intTo16bitHex(focus[0]));
        }
        return this.newParam(ABSOLUTE_PTZF_COMMAND, this.intTo16bitHex(pan), this.intTo16bitHex(tilt), this.intTo16bitHex(zoom));
    }

    public SonyPtzCommandQuery move(MOVE type, MOVE_SPEED moveSpeed, Integer targetVideoCodec) {
        return this.newParam(MOVE_COMMAND, new Object[]{type, moveSpeed, "Image" + targetVideoCodec});
    }

    public SonyPtzCommandQuery move(MOVE type, Integer moveSpeed, Integer targetVideoCodec) {
        return this.newParam(MOVE_COMMAND, new Object[]{type, moveSpeed, "Image" + targetVideoCodec});
    }

    public SonyPtzCommandQuery zoom(Integer zoom) {
        return this.newParam(ZOOM_COMMAND, this.intTo16bitHex(zoom));
    }

    private SonyPtzCommandQuery newParam(String name, Object ... values) {
        String value = values[0].toString();
        StringBuilder builder = new StringBuilder(value);
        for (int i = 1; i < values.length; ++i) {
            builder.append(",");
            builder.append(values[i].toString());
        }
        this.addParam(new Query.Parameter(name, builder.toString()));
        return this;
    }

    private String intTo16bitHex(Integer num) {
        return Integer.toHexString(num & 0xFFFF);
    }

    public static enum MOVE_SPEED {
        PANTILT,
        MOTOR,
        ZOOM,
        FOCUS;


        public String toString() {
            return this.name().toLowerCase(Locale.GERMANY);
        }
    }

    public static enum MOVE {
        LEFT("left"),
        RIGHT("right"),
        UP("up"),
        DOWN("down"),
        UP_LEFT("up-left"),
        UP_RIGHT("up-right"),
        DOWN_LEFT("down-left"),
        DOWN_RIGHT("down-right"),
        TELE("tele"),
        WIDE("wide"),
        NEAR("near"),
        FAR("far"),
        STOP("stop"),
        ONEPUSHAF("onepushaf");

        private String val;

        private MOVE(String val) {
            this.val = val;
        }

        public String toString() {
            return this.val;
        }
    }
}

