/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.cm.device.video.sony;

import de.seetec.v5.re.cm.device.shared.LiveCameraSrv;
import de.seetec.v5.re.cm.device.shared.motiondetection.HardwareMotionDetection;
import de.seetec.v5.re.cm.device.shared.motiondetection.MotionDetectionHandler;
import de.seetec.v5.re.cm.device.shared.net.httpserverpush.HttpServerPushContent;
import de.seetec.v5.re.cm.device.shared.net.httpserverpush.HttpServerPushHandler;
import de.seetec.v5.re.cm.device.shared.net.httpserverpush.HttpServerPushListenerIntf;
import de.seetec.v5.re.cm.device.video.sony.SonyDevice;
import de.seetec.v5.shared.net.NetworkHelper;
import de.seetec.v5.shared.net.NetworkParameter;
import de.seetec.v5.shared.util.ConfigurationException;
import de.seetec.v5.shared.util.SeeTecException;
import java.util.concurrent.TimeUnit;
import org.apache.logging.log4j.LogManager;

public class SonyMotionDetectionHandler
extends MotionDetectionHandler
implements HttpServerPushListenerIntf {
    private static final String CLASS_NAME = "de.seetec.v5.re.cm.device.video.sony.SonyMotionDetectionHandler";
    private static final int INTERVAL_IN_SECONDS = 1;
    private long lastTamperingEventSent = Long.MIN_VALUE;
    private NetworkParameter networkParameter = null;
    private HttpServerPushHandler httpServerPushHandler = null;
    private String enableString = null;
    private int errorCode = 0;
    private static final int VMF_WINDOW_NUMBER = 5;
    private static final int AUDIO_WINDOW_NUMBER = 6;
    private byte[] result;
    private SonyDevice sonyDevice;
    private String tamperingClearUrl;
    private boolean tamperingStatus = false;

    public SonyMotionDetectionHandler() {
        this.logger = LogManager.getLogger((String)CLASS_NAME);
    }

    @Override
    public int init(HardwareMotionDetection<? extends MotionDetectionHandler> sonyHardwareMotionDetection) {
        this.listener = sonyHardwareMotionDetection;
        if (this.listener == null) {
            return -20003;
        }
        this.sonyDevice = (SonyDevice)this.listener.getVideoSrv().getDevice();
        long entityType = this.listener.getVideoSrv().getEntityType();
        if (entityType == 210518L || entityType == 210519L || entityType == 210506L || entityType == 210507L || entityType == 210509L || entityType == 210510L || entityType == 210505L) {
            this.enableString = "/command/motiondetection.cgi?MdAlarmData=on";
        } else if (entityType == 210520L || entityType == 210515L || entityType == 210516L || entityType == 210517L || entityType == 210521L || entityType == 210522L || entityType == 210513L || entityType == 210523L || entityType == 210524L || entityType == 210525L || entityType == 210514L || entityType == 210531L || entityType == 210526L || entityType == 210532L || entityType == 210527L || entityType == 210533L || entityType == 210528L || entityType == 210529L || entityType == 210534L || entityType == 210530L || entityType == 210531L || entityType == 210535L || entityType == 210536L || entityType == 210537L || entityType == 210538L || entityType == 210539L || entityType == 210540L || entityType == 210541L || entityType == 210542L || entityType == 210548L || this.listener.getVideoSrv().getDevice().getDeviceType() == 200633L || this.listener.getVideoSrv().getDevice().getDeviceType() == 200630L || this.listener.getVideoSrv().getDevice().getDeviceType() == 200631L || this.listener.getVideoSrv().getDevice().getDeviceType() == 200632L || this.sonyDevice.getSonyGeneration() > 5) {
            try {
                this.networkParameter = this.listener.getVideoSrv().getDevice().getDeviceCnf().getNetworkParameter();
                this.networkParameter.setSoTimeout(3000);
                this.networkParameter.setIgnoreSoTimeout(true);
            }
            catch (Exception e) {
                this.logger.error("Error while reading network parameter for " + this.listener.getVideoSrv(), (Throwable)e);
                return -20036;
            }
            this.enableString = "/command/system.cgi?AlarmData=on";
            String enableAudio = "/command/audiodetection.cgi?ADFunc=on";
            try {
                boolean isEnableTampering = false;
                try {
                    isEnableTampering = this.listener.getVideoSrv().getVideoSourceCnf().isEnableTampering();
                }
                catch (ConfigurationException ex) {
                    this.logger.error("Error evaluating tampering flag for " + this);
                }
                String enableTampering = "/command/system.cgi?TamperingFunc=" + (isEnableTampering ? "on" : "off");
                this.tamperingClearUrl = "/command/system.cgi?TamperingStatusClear=on";
                if (this.sonyDevice.getSonyGeneration() > 5) {
                    enableTampering = "/command/tamper.cgi?TamperingFunc=" + (isEnableTampering ? "on" : "off");
                    this.tamperingClearUrl = "/command/tamper.cgi?TamperingStatusClear=on";
                }
                NetworkHelper.readGetRequest((NetworkParameter)this.networkParameter, (String)enableTampering, (int)Integer.MAX_VALUE, (boolean)false, null, (boolean)true);
                this.result = NetworkHelper.readGetRequest((NetworkParameter)this.networkParameter, (String)"/command/inquiry.cgi?inqjs=system", (int)Integer.MAX_VALUE, (boolean)true);
                if (this.sonyDevice.getSonyGeneration() < 6) {
                    NetworkHelper.readGetRequest((NetworkParameter)this.networkParameter, (String)enableAudio, (int)Integer.MAX_VALUE, (boolean)false, null, (boolean)true);
                    this.result = NetworkHelper.readGetRequest((NetworkParameter)this.networkParameter, (String)"/command/inquiry.cgi?inqjs=audiodetection", (int)Integer.MAX_VALUE, (boolean)true);
                }
                Thread.sleep(3000L);
                NetworkHelper.readGetRequest((NetworkParameter)this.networkParameter, (String)this.tamperingClearUrl, (int)Integer.MAX_VALUE, (boolean)false, null, (boolean)true);
                this.result = NetworkHelper.readGetRequest((NetworkParameter)this.networkParameter, (String)"/command/inquiry.cgi?inqjs=system", (int)Integer.MAX_VALUE, (boolean)true);
            }
            catch (InterruptedException isEnableTampering) {
            }
            catch (SeeTecException isEnableTampering) {}
        } else if (this.listener.getVideoSrv().getDevice().getDeviceType() == 200623L) {
            this.enableString = "/command/system.cgi?AdAlarmData1=on&AdAlarmData2=on&AdAlarmData3=on&AdAlarmData4=on";
        } else {
            this.logger.warn("MOTION DETECTION NOT SUPPORTED for this type.");
            this.logger.warn("Given Type is: " + entityType);
            return -20009;
        }
        try {
            if (this.listener == null) {
                return -20036;
            }
            this.networkParameter = this.listener.getVideoSrv().getDevice().getDeviceCnf().getNetworkParameter();
            this.networkParameter.setSoTimeout(3000);
            this.networkParameter.setIgnoreSoTimeout(true);
        }
        catch (Exception e) {
            this.logger.error("Error while reading network parameter for " + this.listener.getVideoSrv(), (Throwable)e);
            return -20036;
        }
        try {
            this.result = NetworkHelper.readGetRequest((NetworkParameter)this.networkParameter, (String)this.enableString, (int)Integer.MIN_VALUE, (boolean)false, null, (boolean)true);
        }
        catch (Exception ex) {
            this.logger.error(ex.getMessage() + " for " + this.listener.getVideoSrv(), (Throwable)ex);
            return -20000;
        }
        if (this.result == null) {
            return -20003;
        }
        String url = "/command/alarmdata.cgi?interval=1";
        if (this.listener.getVideoSrv().getDevice().getDeviceType() == 200623L) {
            try {
                url = url + "&ChannelNo=" + this.listener.getVideoSrv().getVideoSourceCnf().getServerEntryNo();
            }
            catch (Exception e) {
                this.logger.error("Error while reading channel no for " + this.listener.getVideoSrv(), (Throwable)e);
                return -20036;
            }
        }
        try {
            this.networkParameter.setSoTimeout((int)(TimeUnit.SECONDS.toMillis(1L) + TimeUnit.SECONDS.toMillis(5L)));
            this.networkParameter.setIgnoreSoTimeout(false);
            this.httpServerPushHandler = new HttpServerPushHandler();
            this.errorCode = this.httpServerPushHandler.init(this, this.networkParameter, url);
            if (this.errorCode != 0) {
                this.logger.error("Error [" + this.errorCode + "] with " + this.httpServerPushHandler);
                return this.errorCode;
            }
            this.errorCode = this.httpServerPushHandler.startServerPush(true);
            if (this.errorCode != 0) {
                this.logger.error("Error [" + this.errorCode + "] while starting serverpush for " + this);
                return this.errorCode;
            }
        }
        catch (Throwable ex) {
            this.logger.error("Requesting serverpush from " + this.listener.getVideoSrv().getDevice() + " failed", ex);
            this.errorCode = -21601;
        }
        return this.errorCode;
    }

    @Override
    public int shutdown() {
        if (this.startShutdown(CLASS_NAME)) {
            return 0;
        }
        if (this.httpServerPushHandler != null) {
            this.httpServerPushHandler.shutdown();
            this.httpServerPushHandler = null;
        }
        super.shutdown();
        return 0;
    }

    @Override
    public final boolean isShutdown() {
        return this.isShutdown(CLASS_NAME);
    }

    @Override
    public void sendStatusService(int statusCode) {
        if (this.isShutdown(CLASS_NAME)) {
            return;
        }
        if (statusCode != 0) {
            this.listener.notifyForNetworkProblems();
        }
    }

    @Override
    public void notifyForNetworkProblems() {
        this.sendStatusService(-21650);
    }

    @Override
    public void deliverContent(HttpServerPushContent httpServerPushContent) {
        int SPECIFIER_LENGTH = 5;
        byte[] contentData = httpServerPushContent.getContentBody();
        if (contentData != null) {
            String[] windows = new String(contentData).split("\r\n");
            if (windows.length < 1) {
                this.logger.error("Wrong content format. Discarding for " + this.listener.getVideoSrv());
            } else {
                for (String window : windows) {
                    int value;
                    if (window.contains("OdWin") || window.contains("MdWin") || window.contains("AdWin")) {
                        try {
                            int windowNumber = Integer.parseInt(window.substring(5, window.indexOf(61)));
                            value = Integer.parseInt(window.substring(window.indexOf(61) + 1));
                            if (value != 0 && this.listener != null) {
                                this.listener.evaluateWindow(windowNumber - 1);
                            }
                        }
                        catch (NumberFormatException nfe) {
                            this.logger.error("Error while converting number for " + this.listener.getVideoSrv());
                            return;
                        }
                    }
                    if (this.sonyDevice.getSonyGeneration() > 5) {
                        block32: {
                            if (window.toLowerCase().contains("tampering")) {
                                try {
                                    if (!this.listener.getVideoSrv().getVideoSourceCnf().isEnableTampering()) break block32;
                                    value = Integer.parseInt(window.substring(window.indexOf(61) + 1));
                                    if (value != 0 && System.currentTimeMillis() > this.lastTamperingEventSent + 10000L) {
                                        this.lastTamperingEventSent = System.currentTimeMillis();
                                        try {
                                            this.result = NetworkHelper.readGetRequest((NetworkParameter)this.networkParameter, (String)this.tamperingClearUrl, (int)Integer.MAX_VALUE, (boolean)false, null, (boolean)true);
                                        }
                                        catch (SeeTecException ex) {
                                            this.logger.error("Exception occured while resetting tampering flag for " + this + ": " + ex.getMessage());
                                        }
                                        ((LiveCameraSrv)this.listener.getVideoSrv()).evaluateTampering();
                                        this.listener.getVideoSrv().getCore().sendTamperingEvent(this.listener.getVideoSrv());
                                        this.tamperingStatus = true;
                                        break block32;
                                    }
                                    if (value == 0 && this.tamperingStatus) {
                                        this.tamperingStatus = false;
                                    }
                                }
                                catch (ConfigurationException ce) {
                                    this.logger.error("Error evaluating tampering flag for " + this);
                                }
                            }
                        }
                        if (window.toLowerCase().contains("vmf")) {
                            String[] parts = window.toLowerCase().split("=");
                            if (parts.length == 2) {
                                int index = parts[0].indexOf(95);
                                String svmfNumber = index >= 0 ? parts[0].substring(3, index) : parts[0].substring(3);
                                try {
                                    int vmfNumber = Integer.parseInt(svmfNumber);
                                    value = Integer.parseInt(parts[1]);
                                    if (value != 0 && this.listener != null) {
                                        this.listener.evaluateWindow(3 + vmfNumber);
                                    }
                                }
                                catch (NumberFormatException ex) {
                                    this.logger.error("Can't parse MD: No valid content found (" + window + ") for " + this);
                                }
                            } else {
                                this.logger.error("Can't parse MD: No valid content found (" + window + ") for " + this);
                            }
                        }
                    }
                    if (this.listener.getVideoSrv().getDevice().getDeviceType() != 200624L && this.listener.getVideoSrv().getDevice().getDeviceType() != 200634L && this.listener.getVideoSrv().getDevice().getDeviceType() != 200625L && this.listener.getVideoSrv().getDevice().getDeviceType() != 200635L && this.listener.getVideoSrv().getDevice().getDeviceType() != 200626L && this.listener.getVideoSrv().getDevice().getDeviceType() != 200627L && this.listener.getVideoSrv().getDevice().getDeviceType() != 200636L && this.listener.getVideoSrv().getDevice().getDeviceType() != 200628L && this.listener.getVideoSrv().getDevice().getDeviceType() != 200629L && this.listener.getVideoSrv().getDevice().getDeviceType() != 200630L && this.listener.getVideoSrv().getDevice().getDeviceType() != 200631L && this.listener.getVideoSrv().getDevice().getDeviceType() != 200632L && this.listener.getVideoSrv().getDevice().getDeviceType() != 200637L && this.listener.getVideoSrv().getDevice().getDeviceType() != 200638L && this.listener.getVideoSrv().getDevice().getDeviceType() != 200639L && this.listener.getVideoSrv().getDevice().getDeviceType() != 200640L && this.listener.getVideoSrv().getDevice().getDeviceType() != 200641L && this.listener.getVideoSrv().getDevice().getDeviceType() != 200642L && this.listener.getVideoSrv().getDevice().getDeviceType() != 200643L && this.listener.getVideoSrv().getDevice().getDeviceType() != 200644L) continue;
                    try {
                        block34: {
                            if (window.toLowerCase().contains("vmf") && (value = Integer.parseInt(window.substring(window.indexOf(61) + 1))) != 0) {
                                this.listener.evaluateWindow(4);
                            }
                            if (window.toLowerCase().contains("tampering")) {
                                try {
                                    if (!this.listener.getVideoSrv().getVideoSourceCnf().isEnableTampering()) break block34;
                                    value = Integer.parseInt(window.substring(window.indexOf(61) + 1));
                                    if (value != 0 && System.currentTimeMillis() > this.lastTamperingEventSent + 10000L) {
                                        this.lastTamperingEventSent = System.currentTimeMillis();
                                        try {
                                            this.result = NetworkHelper.readGetRequest((NetworkParameter)this.networkParameter, (String)"/command/system.cgi?TamperingStatusClear=on", (int)Integer.MAX_VALUE, (boolean)false, null, (boolean)true);
                                        }
                                        catch (SeeTecException ex) {
                                            this.logger.error("Exception occured while resetting tampering flag for " + this + ": " + ex.getMessage());
                                        }
                                        ((LiveCameraSrv)this.listener.getVideoSrv()).evaluateTampering();
                                        this.listener.getVideoSrv().getCore().sendTamperingEvent(this.listener.getVideoSrv());
                                        this.tamperingStatus = true;
                                        break block34;
                                    }
                                    if (value == 0 && this.tamperingStatus) {
                                        this.tamperingStatus = false;
                                    }
                                }
                                catch (ConfigurationException ce) {
                                    this.logger.error("Error evaluating tampering flag for " + this);
                                }
                            }
                        }
                        if (!window.toLowerCase().contains("audio") || (value = Integer.parseInt(window.substring(window.indexOf(61) + 1))) == 0 || this.listener == null) continue;
                        this.listener.evaluateWindow(5);
                    }
                    catch (NumberFormatException nfe) {
                        this.logger.error("Error while converting number for " + this.listener.getVideoSrv());
                        return;
                    }
                }
            }
        }
    }
}

