/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.cm.device.video.sony;

import de.seetec.v5.re.cm.device.shared.io.DigitalInputSrv;
import de.seetec.v5.re.cm.device.shared.io.IOHandler;
import de.seetec.v5.re.cm.device.video.sony.SonyIOHandler;
import de.seetec.v5.shared.net.NetworkHelper;
import de.seetec.v5.shared.net.NetworkParameter;
import de.seetec.v5.shared.util.SeeTecException;

public class SonyIOHandler_CSx
extends SonyIOHandler {
    private static final String CLASS_NAME = "de.seetec.v5.re.cm.device.video.sony.SonyIOHandler_CSx";

    @Override
    public void run() {
        super.setRunFinished(CLASS_NAME, false);
        try {
            while (!(this.isShutdown(CLASS_NAME) || super.isShutdown() || this.device.isShutdown())) {
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                this.checkDigitalInputs();
            }
        }
        catch (Throwable ex) {
            this.logger.error((Object)ex, ex);
        }
        this.logger.info("Thread of this " + this + " finished :-)");
        super.setRunFinished(CLASS_NAME, true);
        this.shutdown();
    }

    private void checkDigitalInputs() {
        int[] inputValues = new int[super.getHighestInputNumber()];
        int errorCode = this.readDigitalInputs(inputValues);
        if (errorCode != 0) {
            this.logger.warn("Reading inputs failed with error [" + errorCode + "]");
            return;
        }
        DigitalInputSrv[] iServices = super.getDigitalInputSrv();
        for (int i = 0; i < iServices.length; ++i) {
            iServices[i].checkInput(inputValues);
        }
    }

    private int readDigitalInputs(int[] inputs) {
        try {
            String url = "/command/inquiry.cgi?inq=sensor";
            String result = new String(NetworkHelper.readGetRequest((NetworkParameter)this.networkParameter, (String)url, (int)Integer.MAX_VALUE, (boolean)false, (String)"Sensor"));
            for (int i = 0; i < inputs.length; ++i) {
                inputs[i] = result.toLowerCase().contains("sensor" + (i + 1) + "=1") || result.toLowerCase().contains("sensor=1") ? 1 : 0;
            }
            return 0;
        }
        catch (Exception ex) {
            this.logger.error((Object)ex);
            throw new RuntimeException("Cannot read inputs from [" + this.host + ":" + this.port + "]");
        }
    }

    @Override
    public int writeDigitalOutput(int number, int value, long holdTime) {
        try {
            IOHandler.HoldTimer holdTimer;
            int errorCode;
            String url = this.device.getDeviceType() == 200623L ? "/command/trigger.cgi?alarmout" + number : (this.device.getDeviceType() == 200615L || this.device.getDeviceType() == 200616L ? "/command/main.cgi?Trigger=alarmout" + (value == 0 ? "off" : "on") : "/command/main.cgi?Trigger=alarmout" + number + (value == 0 ? "off" : "on"));
            int wantedLength = 32;
            NetworkHelper.readGetRequest((NetworkParameter)this.networkParameter, (String)url, (int)wantedLength);
            if (holdTime > 0L && (errorCode = (holdTimer = new IOHandler.HoldTimer()).init(number, value > 0 ? 0 : 1, holdTime)) != 0) {
                holdTimer.shutdown();
                this.logger.warn("Creating " + holdTimer + " failed with error [" + errorCode + "] :-(");
            }
            return 0;
        }
        catch (SeeTecException sex) {
            this.logger.error((Object)sex, (Throwable)sex);
            return sex.getErrorCode();
        }
        catch (Throwable ex) {
            this.logger.error((Object)ex, ex);
            return -21600;
        }
    }
}

