/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.cm.device.video.sony;

import de.seetec.v5.re.cm.configuration.definition.camera.FeaturesType;
import de.seetec.v5.re.cm.configuration.definition.camera.VideoCameraDefinition;
import de.seetec.v5.re.cm.configuration.definition.device.AudioCapabilitiesType;
import de.seetec.v5.re.cm.configuration.definition.device.AudioCodecDefinitionType;
import de.seetec.v5.re.cm.configuration.definition.device.AudioCodecsType;
import de.seetec.v5.re.cm.configuration.definition.device.AvailableIOsType;
import de.seetec.v5.re.cm.configuration.definition.device.BitrateSettingsType;
import de.seetec.v5.re.cm.configuration.definition.device.CameraResolutionType;
import de.seetec.v5.re.cm.configuration.definition.device.CaptureModeDefinitionType;
import de.seetec.v5.re.cm.configuration.definition.device.CodecType;
import de.seetec.v5.re.cm.configuration.definition.device.CommentsType;
import de.seetec.v5.re.cm.configuration.definition.device.DeviceDefinition;
import de.seetec.v5.re.cm.configuration.definition.device.DeviceGroupMembershipsType;
import de.seetec.v5.re.cm.configuration.definition.device.DeviceNetworkDefinitionType;
import de.seetec.v5.re.cm.configuration.definition.device.GenericEventDefinitionType;
import de.seetec.v5.re.cm.configuration.definition.device.ImageRotationCapabilitiesType;
import de.seetec.v5.re.cm.configuration.definition.device.MiscVideoServerCapabilitiesType;
import de.seetec.v5.re.cm.configuration.definition.device.MultiStreamingDefinitionsType;
import de.seetec.v5.re.cm.configuration.definition.device.RtspSettingsType;
import de.seetec.v5.re.cm.configuration.definition.device.StreamDefinitionType;
import de.seetec.v5.re.cm.configuration.definition.device.SupportedApiVersionsType;
import de.seetec.v5.re.cm.configuration.definition.device.SupportedCameraResolutionsType;
import de.seetec.v5.re.cm.configuration.definition.device.SupportedCaptureModesType;
import de.seetec.v5.re.cm.configuration.definition.device.SupportedGenericEventsType;
import de.seetec.v5.re.cm.configuration.definition.device.SupportedMPEGProfileIDs;
import de.seetec.v5.re.cm.configuration.definition.device.SupportedRotationAnglesType;
import de.seetec.v5.re.cm.configuration.definition.device.SupportedTransmissionTypeIDsType;
import de.seetec.v5.re.cm.configuration.definition.device.SupportedVideoSourceEntityTypesType;
import de.seetec.v5.re.cm.configuration.definition.device.VirtualCameraDefinitionType;
import de.seetec.v5.re.cm.device.shared.ImageRotation;
import de.seetec.v5.re.cm.device.shared.Service;
import de.seetec.v5.re.cm.device.shared.VideoServer;
import de.seetec.v5.re.cm.device.shared.io.IOHandler;
import de.seetec.v5.re.cm.device.shared.motiondetection.HardwareMotionDetection;
import de.seetec.v5.re.cm.device.shared.motiondetection.HardwareMotionDetectionCnf;
import de.seetec.v5.re.cm.device.video.sony.SonyCamResponseHelper;
import de.seetec.v5.re.cm.device.video.sony.SonyCameraSrv;
import de.seetec.v5.re.cm.device.video.sony.SonyHardwareMotionDetection;
import de.seetec.v5.re.cm.device.video.sony.SonyHardwareMotionDetectionCnf;
import de.seetec.v5.re.cm.device.video.sony.SonyIOHandler_5thGen;
import de.seetec.v5.re.cm.device.video.sony.SonyIOHandler_CSx;
import de.seetec.v5.re.cm.device.video.sony.SonyIOHandler_Dxx;
import de.seetec.v5.re.cm.device.video.sony.SonyIOHandler_RZxxP;
import de.seetec.v5.re.cm.device.video.sony.SonyQuery;
import de.seetec.v5.re.cm.shared.AbsolutePTZCapabilities;
import de.seetec.v5.re.cm.shared.Tools;
import de.seetec.v5.re.shared.CnfDeviceCaptureMode;
import de.seetec.v5.re.shared.Codec;
import de.seetec.v5.re.shared.MediaID;
import de.seetec.v5.re.shared.MpegProfile;
import de.seetec.v5.re.shared.TransmissionType;
import de.seetec.v5.shared.net.HTTPResponse;
import de.seetec.v5.shared.net.NetworkHelper;
import de.seetec.v5.shared.net.NetworkParameter;
import de.seetec.v5.shared.net.NetworkParameterFactory;
import de.seetec.v5.shared.proxy.ent.Entity;
import de.seetec.v5.shared.util.ConfigurationException;
import de.seetec.v5.shared.util.SeeTecException;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.logging.log4j.Logger;

public class SonyDevice
extends VideoServer {
    private static final String CLASS_NAME = "de.seetec.v5.re.cm.device.video.sony.SonyDevice";
    private boolean isRTSPPortSet = false;
    private String currentName;
    private NetworkParameter networkParameter;
    private int sonyGeneration = 0;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public int initializeDevice(long srvType) {
        block26: {
            block28: {
                block27: {
                    super.initializeDevice(srvType);
                    if (srvType < 210500L) return 0;
                    if (srvType > 210599L) {
                        return 0;
                    }
                    if (srvType == 210500L || srvType == 210508L || srvType == 210501L || srvType == 210502L || srvType == 210503L || srvType == 210504L || srvType == 210505L || srvType == 210506L || srvType == 210507L || srvType == 210516L || srvType == 210517L || srvType == 210509L || srvType == 210510L || srvType == 210513L || srvType == 210514L || srvType == 210515L || srvType == 210518L || srvType == 210519L || srvType == 210520L || srvType == 210521L || srvType == 210522L || srvType == 210523L || srvType == 210524L || srvType == 210525L || srvType == 210531L || srvType == 210526L || srvType == 210532L || srvType == 210527L || srvType == 210533L || srvType == 210528L || srvType == 210529L || srvType == 210534L || srvType == 210530L || srvType == 210535L || srvType == 210536L || srvType == 210537L || srvType == 210538L || srvType == 210539L || srvType == 210540L || srvType == 210541L || srvType == 210542L) break block27;
                    if (this.getSonyGeneration() <= 5) break block26;
                    break block28;
                }
                try {
                    String[] parts;
                    String CAPTURE_MODE_STRING = "VidCapSize=";
                    String captureMode = null;
                    CnfDeviceCaptureMode cnfDeviceCaptureMode = this.getDeviceCnf().getCaptureMode();
                    if (cnfDeviceCaptureMode == null || !cnfDeviceCaptureMode.isEnabled()) break block26;
                    byte[] result = NetworkHelper.readGetRequest((NetworkParameter)this.getDeviceCnf().getNetworkParameter(), (String)"/command/inquiry.cgi?inq=camera", (int)Integer.MAX_VALUE, (boolean)true);
                    String reply = new String(result);
                    if (!reply.contains("VidCapSize=")) {
                        this.getLogger().error("Capture modes not supported but client likes to set for " + this);
                        return -20000;
                    }
                    for (String part : parts = reply.split("&")) {
                        int index = part.indexOf("VidCapSize=");
                        if (index == -1) continue;
                        captureMode = part.substring(index + "VidCapSize=".length());
                        this.getLogger().info("Current capture mode is '" + captureMode + "' for " + this);
                    }
                    if (captureMode == null) {
                        this.getLogger().error("Error while extracting capture mode from reply for " + this);
                        return -20000;
                    }
                    if (!captureMode.equalsIgnoreCase(cnfDeviceCaptureMode.getWidth() + "," + cnfDeviceCaptureMode.getHeight())) {
                        this.getLogger().info("-----------------------------------------------");
                        this.getLogger().info("New capture mode is: " + cnfDeviceCaptureMode.getWidth() + "," + cnfDeviceCaptureMode.getHeight());
                        this.getLogger().info("Capture mode has to be set. Reboot is required for " + this);
                        this.getLogger().info("-----------------------------------------------");
                        String newValue = "VidCapSize=" + cnfDeviceCaptureMode.getWidth() + "%2C" + cnfDeviceCaptureMode.getHeight();
                        if (NetworkHelper.readPostRequest((NetworkParameter)this.getDeviceCnf().getNetworkParameter(), (String)"/command/camera.cgi", (String)newValue, (int)Integer.MAX_VALUE, (boolean)false) == null) {
                            this.getLogger().error("Error while setting capture mode " + this);
                            return -20001;
                        }
                    }
                    break block26;
                }
                catch (SeeTecException e) {
                    this.getLogger().error("Error while evaluating/setting capture mode settings for " + this, (Throwable)e);
                    if (e.getErrorCode() != -20001) return e.getErrorCode();
                    return -21656;
                }
                catch (Exception e) {
                    this.getLogger().error("Error while evaluating/setting capture mode settings for " + this, (Throwable)e);
                    return -20000;
                }
            }
            try {
                CnfDeviceCaptureMode cnfDeviceCaptureMode = null;
                if (this.getSonyGeneration() > 6 && (cnfDeviceCaptureMode = this.getDeviceCnf().getCaptureMode()) != null && cnfDeviceCaptureMode.isEnabled()) {
                    boolean changeCaptureMode = true;
                    String changeModeURL = "/command/camera.cgi?";
                    Map<String, String> cameraInfo2 = this.getCameraResponse("/command/inquiry.cgi?inqjs=camera");
                    String cameraAspect = this.getCameraResponse(cameraInfo2, "var CameraAspect");
                    String operationMode = this.getCameraResponse(cameraInfo2, "var OperationMode");
                    String current = "CameraAspect=" + cameraAspect + "&OperationMode=" + operationMode;
                    if (cnfDeviceCaptureMode.getResolution().equals(current)) {
                        changeCaptureMode = false;
                    }
                    changeModeURL = changeModeURL + cnfDeviceCaptureMode.getResolution();
                    if (changeCaptureMode) {
                        NetworkHelper.readGetRequest((NetworkParameter)this.getNetworkParameter(), (String)changeModeURL, (int)Integer.MAX_VALUE, (boolean)true, null, (boolean)true);
                        this.getLogger().info("-----------------------------------------------");
                        this.getLogger().info("New capture mode is: " + cnfDeviceCaptureMode.getDisplayResolution());
                        this.getLogger().info("Capture mode has to be set. Camera will reboot for " + this);
                        this.getLogger().info("-----------------------------------------------");
                    }
                }
                Map<String, String> cameraInfo = this.getCameraResponse("/command/inquiry.cgi?inqjs=camera");
                int codecNr = 1;
                try {
                    codecNr = Integer.parseInt((String)cameraInfo.get("var ImageCodecMaxNum"));
                }
                catch (NumberFormatException cameraInfo2) {
                    // empty catch block
                }
                StringBuilder url = new StringBuilder("/command/camera.cgi?");
                for (int codecIdx = 2; codecIdx <= codecNr; ++codecIdx) {
                    url.append("&ImageCodec").append(codecIdx).append("=off");
                }
                if (url.length() > 0) {
                    NetworkHelper.readGetRequest((NetworkParameter)this.getNetworkParameter(), (String)url.toString().replace("?&", "?"), (int)Integer.MAX_VALUE, (boolean)false, null, (boolean)true);
                }
            }
            catch (ConfigurationException ex) {
                this.getLogger().error("Capture mode configuration could not be read" + ex.getMessage(), (Throwable)ex);
                return -20037;
            }
            catch (SeeTecException ex) {
                this.getLogger().error("Capture mode could not be read or written to camera for " + ex.getMessage(), (Throwable)ex);
                return ex.getErrorCode();
            }
        }
        if (this.getSonyGeneration() < 5) return 0;
        boolean tamperingActivated = false;
        try {
            for (Service service : this.services) {
                if (!(service instanceof SonyCameraSrv)) continue;
                SonyCameraSrv cameraSrv = (SonyCameraSrv)service;
                if (cameraSrv.getGenericEventHandler() != null) {
                    if (cameraSrv.getGenericEventHandler().isTriggerEnabled("Tampering")) continue;
                    tamperingActivated = true;
                    break;
                }
                if (!cameraSrv.getVideoSourceCnf().isEnableTampering()) continue;
                long[] typeList = new long[]{9808L};
                Entity[] entities = this.getEnabledEntities(new long[]{cameraSrv.getEntityID()}, typeList);
                if (tamperingActivated || entities.length != 0) continue;
                this.getLogger().info("No hardware motion detection entities enabled. Start tampering for " + this);
                SonyHardwareMotionDetectionCnf sonyHardwareMotionDetectionCnf = new SonyHardwareMotionDetectionCnf();
                HardwareMotionDetectionCnf[] hardwareMotionDetectionCnf = new HardwareMotionDetectionCnf[]{sonyHardwareMotionDetectionCnf};
                SonyHardwareMotionDetection hardwareMotionDetection = new SonyHardwareMotionDetection();
                cameraSrv.setHardwareMotionDetection(hardwareMotionDetection);
                ((HardwareMotionDetection)hardwareMotionDetection).init(cameraSrv, hardwareMotionDetectionCnf);
                tamperingActivated = true;
            }
            String disableTampering = "/command/system.cgi?TamperingFunc=off";
            String tamperingClearUrl = "/command/system.cgi?TamperingStatusClear=on";
            if (this.getSonyGeneration() > 5) {
                disableTampering = "/command/tamper.cgi?TamperingFunc=off";
                tamperingClearUrl = "/command/tamper.cgi?TamperingStatusClear=on";
            }
            NetworkHelper.readGetRequest((NetworkParameter)this.getNetworkParameter(), (String)disableTampering, (int)Integer.MAX_VALUE, (boolean)false, null, (boolean)true);
            NetworkHelper.readGetRequest((NetworkParameter)this.getNetworkParameter(), (String)tamperingClearUrl, (int)Integer.MAX_VALUE, (boolean)false, null, (boolean)true);
            return 0;
        }
        catch (ConfigurationException ex) {
            this.getLogger().error("Exception while reading configuration for " + this + " : " + ex.getMessage());
            return 0;
        }
        catch (SeeTecException ex) {
            this.getLogger().error("Exception while setting tampering for " + this + " : " + ex.getMessage());
            if (ex.getErrorCode() == -21657) {
                return -21657;
            }
            int n = ex.getErrorCode();
            return n;
        }
    }

    @Override
    protected IOHandler createIOHandler() {
        if (this.isShutdown(CLASS_NAME)) {
            this.getLogger().error(this + " is already shutting down :-( ");
            return null;
        }
        long deviceType = this.getDeviceType();
        if (deviceType == 200604L || deviceType == 200605L || deviceType == 200613L || deviceType == 200614L || deviceType == 200617L || deviceType == 200618L || deviceType == 200619L || deviceType == 200620L || deviceType == 200621L || deviceType == 200622L) {
            return new SonyIOHandler_Dxx();
        }
        if (deviceType == 200603L || deviceType == 200601L || deviceType == 200606L || deviceType == 200607L || deviceType == 200602L || deviceType == 200611L || deviceType == 200610L) {
            return new SonyIOHandler_RZxxP();
        }
        if (deviceType == 200600L || deviceType == 200612L || deviceType == 200615L || deviceType == 200616L || deviceType == 200623L) {
            return new SonyIOHandler_CSx();
        }
        if (deviceType == 200624L || deviceType == 200634L || deviceType == 200625L || deviceType == 200635L || deviceType == 200626L || deviceType == 200627L || deviceType == 200636L || deviceType == 200628L || deviceType == 200629L || deviceType == 200630L || deviceType == 200631L || deviceType == 200632L || deviceType == 200633L || deviceType == 200637L || deviceType == 200638L || deviceType == 200639L || deviceType == 200640L || deviceType == 200641L || deviceType == 200642L || deviceType == 200643L || deviceType == 200644L || this.getSonyGeneration() > 5 || deviceType == 200650L) {
            return new SonyIOHandler_5thGen();
        }
        this.getLogger().info(this + " does not support IO for device type [ " + deviceType + " ] :-( ");
        return null;
    }

    @Override
    protected boolean isSupportingIO() {
        return true;
    }

    public int setRTSPPort(NetworkParameter networkParameter, int rtsp) {
        if (!this.isRTSPPortSet) {
            this.isRTSPPortSet = true;
            if (networkParameter != null && rtsp > 0) {
                if (rtsp != 554 && rtsp < 1024) {
                    this.getLogger().error("Invalid customized RTSP port: " + rtsp + ". Valid values 554,1024..65535");
                    return -21601;
                }
                int rtspPort = rtsp;
                this.getLogger().info("Using RTSP port: " + rtspPort);
                try {
                    byte[] result = NetworkHelper.readGetRequest((NetworkParameter)networkParameter, (String)"/command/inquiry.cgi?inqjs=camera", (int)Integer.MAX_VALUE, (boolean)true);
                    int rtspPortOnCamera = Integer.parseInt(new String(result).substring(new String(result).indexOf("RTSPPort")).split("\"")[1]);
                    if (rtspPortOnCamera != rtsp) {
                        StringBuffer url = new StringBuffer("/command/camera.cgi?RTSPPort=");
                        url.append(rtspPort);
                        if (NetworkHelper.readGetRequest((NetworkParameter)networkParameter, (String)url.toString(), (int)Integer.MAX_VALUE, (boolean)false, null, (boolean)true) == null) {
                            this.getLogger().error("Error while setting initial parameters for " + this);
                            return -20000;
                        }
                        NetworkHelper.readGetRequest((NetworkParameter)networkParameter, (String)"/command/inquiry.cgi?inqjs=camera", (int)Integer.MAX_VALUE, (boolean)true);
                    }
                }
                catch (SeeTecException ex) {
                    this.getLogger().error("Exception ocurred while setting RTSP port on " + this + ": " + ex.getMessage());
                }
            } else {
                this.getLogger().error("Invalid RTSP port: " + rtsp + ". Null or below zero.");
                return -21601;
            }
        }
        return 0;
    }

    public int getSonyGeneration() {
        if (this.sonyGeneration > 0) {
            return this.sonyGeneration;
        }
        long deviceType = this.getDeviceType();
        this.sonyGeneration = deviceType == 200600L || deviceType == 200601L || deviceType == 200602L || deviceType == 200603L || deviceType == 200604L || deviceType == 200605L || deviceType == 200606L || deviceType == 200607L || deviceType == 200610L || deviceType == 200611L || deviceType == 200612L || deviceType == 200613L || deviceType == 200614L || deviceType == 200615L || deviceType == 200616L || deviceType == 200617L || deviceType == 200618L || deviceType == 200619L || deviceType == 200620L || deviceType == 200621L || deviceType == 200622L || deviceType == 200623L || deviceType == 200650L ? 4 : (deviceType == 200624L || deviceType == 200634L || deviceType == 200625L || deviceType == 200635L || deviceType == 200626L || deviceType == 200627L || deviceType == 200639L || deviceType == 200636L || deviceType == 200628L || deviceType == 200629L || deviceType == 200633L || deviceType == 200630L || deviceType == 200631L || deviceType == 200632L || deviceType == 200637L || deviceType == 200638L || deviceType == 200640L || deviceType == 200641L || deviceType == 200642L || deviceType == 200643L || deviceType == 200644L ? 5 : this.getCGIVersion(null));
        return this.sonyGeneration;
    }

    @Override
    protected DeviceDefinition getDeviceDefinitionFromDevice(String signature, String manufacturer, String name, String comments) throws SeeTecException {
        try {
            boolean hasCaptureModeChanged;
            Map<String, String> parameters = this.getCameraResponse("/command/inquiry.cgi?inqjs=system&inqjs=network&inqjs=camera");
            String currentSignature = parameters.get("var SoftVersion");
            String currentManufacturer = "Sony Smart Driver (Generation 6/7)";
            this.currentName = parameters.get("var ModelName");
            String currentComments = "RE_APP_VERSION::7.4.1_11";
            String currentlySetCaptureMode = this.getCurrentlySetCaptureMode();
            String foundDisplayResolutionInDefinition = this.getCurrentCaptureModeFromDefinition();
            boolean bl = hasCaptureModeChanged = !currentlySetCaptureMode.equals(foundDisplayResolutionInDefinition);
            if (!(signature != null && signature.equals(currentSignature) && manufacturer != null && manufacturer.equals(currentManufacturer) && name != null && name.equals(this.currentName) && comments != null && comments.equals(currentComments) && !hasCaptureModeChanged)) {
                SupportedCaptureModesType supportedCaptureModesType;
                DeviceDefinition deviceDefinition = new DeviceDefinition();
                deviceDefinition.setCountFirstChannelOnly(true);
                deviceDefinition.setSignature(currentSignature);
                deviceDefinition.setManufacturer(currentManufacturer);
                CommentsType commentsType = new CommentsType();
                commentsType.getString().add(currentComments);
                deviceDefinition.setComments(commentsType);
                deviceDefinition.setDefaultMediaID(MediaID.VIDEO_SERVER_DIGITAL.getType());
                String apiVersion = this.getSonyGeneration() == 6 ? "G6 1.0.0" : "G7 1.0.0";
                SupportedApiVersionsType supportedApiVersionsType = new SupportedApiVersionsType();
                supportedApiVersionsType.getString().add(apiVersion);
                deviceDefinition.setSupportedApiVersions(supportedApiVersionsType);
                deviceDefinition.setDefaultApiVersion(apiVersion);
                deviceDefinition.setNoOfCams(1);
                VirtualCameraDefinitionType virtualCameraDefinitionType = this.getVirtualCameraDefinitionType();
                deviceDefinition.setVirtualCameraDefinition(virtualCameraDefinitionType);
                DeviceNetworkDefinitionType deviceNetworkDefinitionType = this.getDeviceNetworkDefinitionType(parameters);
                deviceDefinition.setDeviceNetworkDefinition(deviceNetworkDefinitionType);
                if (this.getSonyGeneration() == 6) {
                    supportedCaptureModesType = this.getSupportedCaptureModesType(parameters);
                    deviceDefinition.setSupportedCaptureModes(supportedCaptureModesType);
                } else {
                    supportedCaptureModesType = this.getSupportedCaptureModesType7();
                    deviceDefinition.setSupportedCaptureModes(supportedCaptureModesType);
                }
                deviceDefinition.setDefaultCaptureModeIndex(0);
                ImageRotationCapabilitiesType imageRotationCapabilitiesType = this.getImageRotationCapabilitiesType(parameters);
                deviceDefinition.setImageRotationCapabilities(imageRotationCapabilitiesType);
                AudioCapabilitiesType audioCapabilitiesType = new AudioCapabilitiesType();
                boolean audioValue = this.getAudioAvailability(parameters);
                audioCapabilitiesType.setCanAudio(audioValue);
                audioCapabilitiesType.setNumberOfPossibleAudioStreams(audioValue ? 1 : 0);
                audioCapabilitiesType.setDefaultAudioCodecIndex(0);
                if (audioCapabilitiesType.isCanAudio()) {
                    AudioCodecsType audioCodecsType = new AudioCodecsType();
                    String[] audioCodecs = this.getAudioCodecs(parameters);
                    HashSet<String> audioCodecsList = new HashSet<String>();
                    for (String audioCodec : audioCodecs) {
                        AudioCodecDefinitionType audioCodecDefinitionType = new AudioCodecDefinitionType();
                        CodecType codecType = new CodecType();
                        if ((audioCodec.contains("g711") || audioCodec.equals("")) && !audioCodecsList.contains("g711")) {
                            audioCodecsList.add("g711");
                            codecType.setValue(Codec.G711U.getType());
                        } else if (audioCodec.contains("g726") && !audioCodecsList.contains("g726")) {
                            audioCodecsList.add("g726");
                            codecType.setValue(Codec.G726.getType());
                        } else if (audioCodec.contains("aac") && !audioCodecsList.contains("aac")) {
                            this.getLogger().warn("Audio codec AAC not yet implementet for " + this);
                        }
                        if (codecType.getValue() == 0) continue;
                        audioCodecDefinitionType.setAudioCodec(codecType);
                        audioCodecDefinitionType.setBitrate(64000);
                        audioCodecsType.getAudioCodecDefinition().add(audioCodecDefinitionType);
                    }
                    audioCapabilitiesType.setAudioCodecs(audioCodecsType);
                } else {
                    audioCapabilitiesType.setAudioCodecs(null);
                }
                boolean audioOutValue = this.getAudioOutAvailability(parameters);
                audioCapabilitiesType.setCanAudioOut(audioOutValue);
                deviceDefinition.setAudioCapabilities(audioCapabilitiesType);
                AvailableIOsType availableIOsType = new AvailableIOsType();
                boolean ioAvailable = this.getIOAvailable(parameters);
                if (ioAvailable) {
                    int i;
                    int numberOfInputs = this.getInputsNumber();
                    int numberOfOutputs = this.getOutputsNumber();
                    for (i = 0; i < numberOfInputs; ++i) {
                        availableIOsType.getInputOutputCapabilities().add(0);
                    }
                    for (i = 0; i < numberOfOutputs; ++i) {
                        availableIOsType.getInputOutputCapabilities().add(1);
                    }
                }
                deviceDefinition.setAvailableIOs(availableIOsType);
                int numVMF = this.getVMFNum();
                MiscVideoServerCapabilitiesType miscVideoServerCapabilitiesType = new MiscVideoServerCapabilitiesType();
                boolean superImposeAvailable = this.getSuperImposeAvailable(parameters);
                miscVideoServerCapabilitiesType.setCanTimeDate(superImposeAvailable);
                miscVideoServerCapabilitiesType.setCanTitle(superImposeAvailable);
                String tamperingValue = this.getTamperingValue();
                miscVideoServerCapabilitiesType.setCanDetectTampering(tamperingValue != null);
                miscVideoServerCapabilitiesType.setNoOfRS232S(0);
                miscVideoServerCapabilitiesType.setCanTimeshift(false);
                miscVideoServerCapabilitiesType.setPTZSpeedMultiplier(100);
                miscVideoServerCapabilitiesType.setCanPTZ(this.getPanTiltFunc(parameters));
                deviceDefinition.setMiscVideoServerCapabilities(miscVideoServerCapabilitiesType);
                SupportedVideoSourceEntityTypesType supportedVideoSourceEntityTypesType = new SupportedVideoSourceEntityTypesType();
                supportedVideoSourceEntityTypesType.getLong().add(210553L);
                deviceDefinition.setSupportedVideoSourceEntityTypes(supportedVideoSourceEntityTypesType);
                DeviceGroupMembershipsType deviceGroupMembershipsType = new DeviceGroupMembershipsType();
                deviceGroupMembershipsType.getDeviceGroups().add("GenericDriver");
                deviceGroupMembershipsType.getDeviceGroups().add("GenericEventTrigger");
                deviceGroupMembershipsType.getDeviceGroups().add("OpticalZoomAreaSupported");
                deviceGroupMembershipsType.getDeviceGroups().add("MultistreamResolutionCombinationWarning");
                deviceGroupMembershipsType.getDeviceGroups().add("PresetsImportable");
                if (numVMF > 0) {
                    deviceGroupMembershipsType.getDeviceGroups().add("SonyHWMotionDetectionName2");
                } else {
                    deviceGroupMembershipsType.getDeviceGroups().add("SonyHWMotionDetectionName1");
                }
                deviceDefinition.setSupportedGenericEvents(this.getGenericEventTrigger());
                deviceGroupMembershipsType.getDeviceGroups().add("CheckDeviceInfos");
                deviceDefinition.setDeviceGroupMemberships(deviceGroupMembershipsType);
                deviceDefinition.setEntityType(200655L);
                deviceDefinition.setName(this.currentName);
                return deviceDefinition;
            }
        }
        catch (Throwable t) {
            this.getLogger().error("Problems while geting definition from device for " + this, t);
        }
        return null;
    }

    @Override
    protected VideoCameraDefinition getVideoCameraDefinitionFromDevice() throws SeeTecException {
        try {
            Map<String, String> deviceInfo = this.getCameraResponse("/command/inquiry.cgi?inqjs=system");
            boolean ptzAvailable = this.getPanTiltFunc(deviceInfo);
            VideoCameraDefinition videoCameraDefinition = new VideoCameraDefinition();
            videoCameraDefinition.setManufacturer("Generic Sony Driver");
            videoCameraDefinition.setComment("");
            videoCameraDefinition.setDefaultMediaID(ptzAvailable ? MediaID.VIDEO_SOURCE_PTZ.getType() : MediaID.VIDEO_SOURCE_DIGITAL.getType());
            videoCameraDefinition.setName(deviceInfo.get("var ModelName"));
            videoCameraDefinition.setEntityType(210553L);
            videoCameraDefinition.setPreferAbsolutePTZ(false);
            FeaturesType featuresType = new FeaturesType();
            if (ptzAvailable) {
                AbsolutePTZCapabilities ptzCapabilities = this.getPTZCapabilities(deviceInfo);
                featuresType.setCanAbsolutePan(ptzCapabilities.isSupportsAbsolutePan());
                featuresType.setMinPan(ptzCapabilities.getAbsolutePanMin());
                featuresType.setMaxPan(ptzCapabilities.getAbsolutePanMax());
                featuresType.setCanAbsoluteTilt(ptzCapabilities.isSupportsAbsoluteTilt());
                featuresType.setMinTilt(ptzCapabilities.getAbsoluteTiltMin());
                featuresType.setMaxTilt(ptzCapabilities.getAbsoluteTiltMax());
                featuresType.setCanAbsoluteZoom(ptzCapabilities.isSupportsAbsoluteZoom());
                featuresType.setMinAbsoluteZoom(ptzCapabilities.getAbsoluteZoomMin());
                featuresType.setMaxAbsoluteZoom(ptzCapabilities.getAbsoluteZoomMax());
                featuresType.setMinZoom(0);
                featuresType.setMaxZoom(100000);
                featuresType.setCanContinuousPan(this.getContinuousPan(deviceInfo));
                featuresType.setCanContinuousZoom(this.getContinuousZoom(deviceInfo));
                featuresType.setCanContinuousTilt(this.getContinuousTilt(deviceInfo));
                featuresType.setCanFocus(this.getCanFocus(deviceInfo));
                featuresType.setCanAutoFocus(this.getCanAutoFocus());
                featuresType.setCanIris(this.getCanIris());
                featuresType.setCanAutoIris(this.getCanAutoIris());
                featuresType.setCanNullLux(this.getCanNullLux());
                featuresType.setCanAutoNullLux(this.getCanAutoNullLux());
                featuresType.setCanPreset(this.getCanPreset());
                featuresType.setCanRelativePan(false);
                featuresType.setCanRelativeTilt(false);
                featuresType.setCanRelativeZoom(false);
                featuresType.setCanCenterPT(true);
                featuresType.setMinSpeed(0);
                featuresType.setMaxSpeed(100000);
                featuresType.setPTZMinContinuousLevel(10000);
                featuresType.setPTZMaxContinuousLevel(100000);
                featuresType.setPTZContinuousSpeedFactor(1000);
            }
            videoCameraDefinition.setFeatures(featuresType);
            return videoCameraDefinition;
        }
        catch (ConfigurationException exception) {
            this.getLogger().warn("Error while reading information from " + this, (Throwable)exception);
            throw new SeeTecException(-21600, exception.getMessage());
        }
    }

    protected String getParameters(String url) throws SeeTecException, ConfigurationException {
        try {
            byte[] result = NetworkHelper.readGetRequest((NetworkParameter)this.getDeviceCnf().getNetworkParameter(), (String)url, (int)Integer.MAX_VALUE, (boolean)true);
            String responseFromCamera = null;
            if (result != null) {
                responseFromCamera = new String(result);
            }
            return responseFromCamera;
        }
        catch (Exception e) {
            this.getLogger().error("Error while sending URL. " + e);
            return null;
        }
    }

    protected int getCGIVersion(Map<String, String> system) {
        String cgiValue;
        if (system == null || system.isEmpty()) {
            try {
                system = this.getCameraResponse("/command/inquiry.cgi?inqjs=system");
            }
            catch (SeeTecException ex) {
                this.getLogger().error("Can't read system parameters for: " + this);
                return 0;
            }
            catch (ConfigurationException ex) {
                this.getLogger().error("Can't read system parameters for: " + this);
                return 0;
            }
        }
        if ((cgiValue = system.get("var CGIVersion")) != null) {
            try {
                return Integer.parseInt(cgiValue.substring(0, 1));
            }
            catch (NumberFormatException ex) {
                this.getLogger().error("Can't parse CGIVersion for " + this + ": " + cgiValue);
            }
        }
        return 0;
    }

    private int getNumberOfStreams(Map<String, String> camera) {
        String streamValue = camera.get("var ImageCodecMaxNum");
        int streamNumber = Integer.parseInt(streamValue);
        if (streamNumber == 0) {
            streamNumber = 1;
            this.getLogger().error("Problem while reading stream number");
        }
        return streamNumber;
    }

    private VirtualCameraDefinitionType getVirtualCameraDefinitionType() {
        VirtualCameraDefinitionType virtualCameraDefinitionType = new VirtualCameraDefinitionType();
        virtualCameraDefinitionType.setCanVirtualCamera(false);
        virtualCameraDefinitionType.setCanVirtualCameraCropping(false);
        virtualCameraDefinitionType.setNoOfVirtualCameras(0);
        return virtualCameraDefinitionType;
    }

    @SuppressFBWarnings(value={"HARD_CODE_PASSWORD"}, justification="Mentionned hard-coded password is just Sony default pass which is a proper default setting in this case.")
    private DeviceNetworkDefinitionType getDeviceNetworkDefinitionType(Map<String, String> network) {
        DeviceNetworkDefinitionType deviceNetworkDefinitionType = new DeviceNetworkDefinitionType();
        deviceNetworkDefinitionType.setCanChangeHttpPort(true);
        deviceNetworkDefinitionType.setCanChangeHttpsPort(false);
        deviceNetworkDefinitionType.setCanHttps(network.containsKey("var HttpsPort"));
        deviceNetworkDefinitionType.setDefaultHttpPort(80);
        deviceNetworkDefinitionType.setDefaultHttpsPort(443);
        deviceNetworkDefinitionType.setDefaultPassword("12345");
        deviceNetworkDefinitionType.setDefaultUserName("admin");
        deviceNetworkDefinitionType.setUseAuthentication(true);
        return deviceNetworkDefinitionType;
    }

    public int getBiggestWidth(String[] resolutions) {
        int biggestWidth = 0;
        for (String resolution : resolutions) {
            try {
                int width = Integer.parseInt(resolution);
                if (width <= biggestWidth) continue;
                biggestWidth = width;
            }
            catch (Exception ex) {
                this.getLogger().error("Wrong Syntax for Resolution. Expected '*' as separator. String to parse: " + resolution + " error: " + ex);
            }
        }
        return biggestWidth;
    }

    public int getBiggestHeight(String[] resolutions, int biggestWidth) {
        int biggestHeight = 0;
        int[] resolutionsInt = new int[resolutions.length];
        for (int resolutionsPosition = 0; resolutionsPosition < resolutionsInt.length; ++resolutionsPosition) {
            try {
                resolutionsInt[resolutionsPosition] = Integer.parseInt(resolutions[resolutionsPosition]);
                continue;
            }
            catch (Exception ex) {
                this.getLogger().error("Wrong Syntax for Resolution. Expected '*' as separator. " + ex);
            }
        }
        for (int resolutionInt = 0; resolutionInt < resolutionsInt.length; ++resolutionInt) {
            if (resolutionsInt[resolutionInt] != biggestWidth) continue;
            return resolutionsInt[resolutionInt + 1];
        }
        return biggestHeight;
    }

    protected int getBiggestFps(String[] fpsList) {
        int biggestFps = 0;
        for (String fpsString : fpsList) {
            try {
                double d = Double.parseDouble(fpsString);
                int fps = (int)(d * 1000.0);
                if (fps <= biggestFps) continue;
                biggestFps = fps;
            }
            catch (Exception ex) {
                this.getLogger().error("Wrong Syntax for Resolution. Expected '*' as separator. " + ex);
            }
        }
        return biggestFps;
    }

    protected String[] extractCommaSeparatedValues(String inputData) {
        HTTPResponse httpResponse = new HTTPResponse(inputData.getBytes());
        String data = inputData;
        if (httpResponse.hasBody()) {
            data = httpResponse.getHttpBody().getData();
        }
        return data.substring(data.indexOf(61) + 1).split(",");
    }

    private CameraParameters getResolutionAndFramerate(String captureModeString) {
        CameraParameters cameraParameters = new CameraParameters();
        String regex = "([\\p{Digit}]+)x([\\p{Digit}]+)\\p{Blank}([\\p{Digit}]+)[fps]?";
        Matcher matcher = Pattern.compile("([\\p{Digit}]+)x([\\p{Digit}]+)\\p{Blank}([\\p{Digit}]+)[fps]?").matcher(captureModeString);
        if (matcher.find()) {
            cameraParameters.biggestWidth = Integer.parseInt(matcher.group(2));
            cameraParameters.biggestHeight = Integer.parseInt(matcher.group(1));
            try {
                cameraParameters.biggestFps = Integer.parseInt(matcher.group(3));
            }
            catch (Throwable throwable) {
                cameraParameters.biggestFps = -1;
            }
        }
        return cameraParameters;
    }

    private SupportedMPEGProfileIDs getSupportedMPEGProfileIds(int channel) throws SeeTecException, ConfigurationException {
        SupportedMPEGProfileIDs supportedMPEGProfileIds = new SupportedMPEGProfileIDs();
        String urlProfile = "/command/capability-video?Target=H264Profile" + channel;
        String parametersProfile = this.getParameters(urlProfile);
        HashMap<String, String> profile = new HashMap<String, String>();
        Tools.parseParameters(profile, parametersProfile);
        String h264ProfilesValue = (String)profile.get("CapableH264Profile" + channel);
        if (h264ProfilesValue != null) {
            String[] H264Profiles;
            for (String H264Profile2 : H264Profiles = h264ProfilesValue.split(",")) {
                if (H264Profile2.equals("baseline")) {
                    supportedMPEGProfileIds.getInt().add(MpegProfile.BASELINE.getType());
                    continue;
                }
                if (H264Profile2.equals("main")) {
                    supportedMPEGProfileIds.getInt().add(MpegProfile.MAIN.getType());
                    continue;
                }
                if (!H264Profile2.equals("high")) continue;
                supportedMPEGProfileIds.getInt().add(MpegProfile.HIGH.getType());
            }
        }
        return supportedMPEGProfileIds;
    }

    private CameraParameters setResolutionAndFramerate(ImageRotation rotation) throws SeeTecException, ConfigurationException {
        String capabilityCommand = "/command/capability-video?Target=";
        String mainStreamResolution = capabilityCommand + "ImageSize1";
        String mainStreamFps = capabilityCommand + "FrameRate1";
        String[] fpsList = this.extractCommaSeparatedValues(this.getParameters(mainStreamFps));
        String[] resolutions = this.extractCommaSeparatedValues(this.getParameters(mainStreamResolution));
        this.rearrangeResolutions(resolutions, rotation);
        int biggestWidth = this.getBiggestWidth(resolutions);
        int biggestHeight = this.getBiggestHeight(resolutions, biggestWidth);
        if (rotation == ImageRotation._90 || rotation == ImageRotation._270) {
            biggestWidth ^= biggestHeight;
            biggestHeight = biggestWidth ^ biggestHeight;
            biggestWidth ^= biggestHeight;
        }
        int biggestFps = this.getBiggestFps(fpsList);
        CameraParameters cameraParameters = new CameraParameters();
        cameraParameters.biggestFps = biggestFps;
        cameraParameters.biggestWidth = biggestWidth;
        cameraParameters.biggestHeight = biggestHeight;
        return cameraParameters;
    }

    private void rearrangeResolutions(String[] resolutions, ImageRotation rotation) {
        if (resolutions == null || resolutions.length == 0) {
            return;
        }
        if (rotation == ImageRotation._0 || rotation == ImageRotation._180) {
            return;
        }
        for (int i = 0; i < resolutions.length - 1; i += 2) {
            String tmp = resolutions[i];
            resolutions[i] = resolutions[i + 1];
            resolutions[i + 1] = tmp;
        }
    }

    private String[] getResolution(int channel) throws SeeTecException, ConfigurationException {
        String urlResolution = "/command/capability-video?Target=ImageSize" + channel;
        String parametersCameraInfo = this.getParameters(urlResolution);
        HashMap<String, String> resolutionString = new HashMap<String, String>();
        Tools.parseParameters(resolutionString, parametersCameraInfo);
        String[] resolution = ((String)resolutionString.get("CapableImageSize" + channel)).split(",");
        return resolution;
    }

    private ImageRotationCapabilitiesType getImageRotationCapabilitiesType(Map<String, String> deviceInfo) throws SeeTecException, ConfigurationException {
        ImageRotationCapabilitiesType imageRotationCapabilitiesType = new ImageRotationCapabilitiesType();
        boolean canRotate = this.getRotateAvailable(deviceInfo);
        imageRotationCapabilitiesType.setCanRotateJPEGImage(canRotate);
        imageRotationCapabilitiesType.setCanRotateMPEGImage(canRotate);
        SupportedRotationAnglesType supportedRotationAnglesType = new SupportedRotationAnglesType();
        supportedRotationAnglesType.getInt().add(0);
        supportedRotationAnglesType.getInt().add(180000);
        imageRotationCapabilitiesType.setSupportedRotationAngles(supportedRotationAnglesType);
        return imageRotationCapabilitiesType;
    }

    private boolean getAudioAvailability(Map<String, String> deviceInfo) throws SeeTecException, ConfigurationException {
        return deviceInfo.get("var AudioInFunc").contains("1");
    }

    private boolean getAudioOutAvailability(Map<String, String> deviceInfo) throws SeeTecException, ConfigurationException {
        return deviceInfo.get("var AudioOutFunc").contains("1");
    }

    private String[] getAudioCodecs(Map<String, String> deviceInfo) throws SeeTecException, ConfigurationException {
        String[] codecsList = deviceInfo.get("var AudioOutSupportedCodec").split("/");
        return codecsList;
    }

    private boolean getIOAvailable(Map<String, String> deviceInfo) throws SeeTecException, ConfigurationException {
        return deviceInfo.get("var SensorInFunc").contains("1");
    }

    private boolean getSuperImposeAvailable(Map<String, String> deviceInfo) throws SeeTecException, ConfigurationException {
        return deviceInfo.get("var SuperImposeFunc").contains("1");
    }

    private boolean getRotateAvailable(Map<String, String> deviceInfo) throws SeeTecException, ConfigurationException {
        return deviceInfo.get("var EflipFunc").contains("1");
    }

    private int getInputsNumber() throws SeeTecException, ConfigurationException {
        String urlResolution = "/command/inquiry.cgi?inqjs=sensor";
        String parametersCameraInfo = this.getParameters(urlResolution);
        HashMap<String, String> responceString = new HashMap<String, String>();
        Tools.parseParameters(responceString, parametersCameraInfo);
        int input = Integer.parseInt((String)responceString.get("var SensorNum"));
        return input;
    }

    private String getTamperingValue() throws SeeTecException, ConfigurationException {
        String urlResolution = "/command/inquiry.cgi?inqjs=tamper";
        String parametersCameraInfo = this.getParameters(urlResolution);
        HashMap<String, String> responceString = new HashMap<String, String>();
        Tools.parseParameters(responceString, parametersCameraInfo);
        return (String)responceString.get("var TamperingFunc");
    }

    private boolean getPanTiltFunc(Map<String, String> deviceInfo) throws SeeTecException, ConfigurationException {
        return deviceInfo.get("var PanTiltFunc").contains("1");
    }

    private boolean getContinuousPan(Map<String, String> deviceInfo) throws SeeTecException, ConfigurationException {
        return deviceInfo.get("var PanTiltFunc").contains("1");
    }

    private boolean getContinuousZoom(Map<String, String> deviceInfo) throws SeeTecException, ConfigurationException {
        return deviceInfo.get("var ZoomFunc").contains("1");
    }

    private boolean getContinuousTilt(Map<String, String> deviceInfo) throws SeeTecException, ConfigurationException {
        return deviceInfo.get("var PanTiltFunc").contains("1");
    }

    private boolean getAbsoluteZoom(Map<String, String> deviceInfo) {
        return deviceInfo.get("var ZoomFunc").contains("1");
    }

    private boolean getCanFocus(Map<String, String> deviceInfo) throws SeeTecException, ConfigurationException {
        return deviceInfo.get("var FocusFunc").contains("1");
    }

    private boolean getCanAutoFocus() {
        return true;
    }

    private boolean getCanIris() {
        return true;
    }

    private boolean getCanAutoIris() {
        return true;
    }

    private boolean getCanNullLux() {
        return true;
    }

    private boolean getCanAutoNullLux() {
        return true;
    }

    private boolean getCanPreset() {
        return true;
    }

    private int getMotionDetection() throws SeeTecException, ConfigurationException {
        String urlResolution = "/command/inquiry.cgi?inqjs=objectdetection";
        String parametersCameraInfo = this.getParameters(urlResolution);
        HashMap<String, String> responceString = new HashMap<String, String>();
        Tools.parseParameters(responceString, parametersCameraInfo);
        return Integer.parseInt((String)responceString.get("var DetWinNum"));
    }

    private AbsolutePTZCapabilities getPTZCapabilities(Map<String, String> systemInfo) throws SeeTecException, ConfigurationException {
        String parameters = this.getParameters(SonyQuery.inquiry().ptzf().toString());
        HashMap<String, String> cameraInfo = new HashMap<String, String>();
        Tools.parseParameters(cameraInfo, parameters);
        AbsolutePTZCapabilities absolutePTZCapabilities = new AbsolutePTZCapabilities();
        absolutePTZCapabilities.setAbsoluteTiltMin(SonyCamResponseHelper.getIntParameter(cameraInfo, SonyCamResponseHelper.INQUIRY_PTZF_PARAMETERS.PTZF_TILT_MOVEMENT_RANGE, 0));
        absolutePTZCapabilities.setAbsoluteTiltMax(SonyCamResponseHelper.getIntParameter(cameraInfo, SonyCamResponseHelper.INQUIRY_PTZF_PARAMETERS.PTZF_TILT_MOVEMENT_RANGE, 1));
        absolutePTZCapabilities.setAbsolutePanMin(SonyCamResponseHelper.getIntParameter(cameraInfo, SonyCamResponseHelper.INQUIRY_PTZF_PARAMETERS.PTZF_PAN_MOVEMENT_RANGE, 0));
        absolutePTZCapabilities.setAbsolutePanMax(SonyCamResponseHelper.getIntParameter(cameraInfo, SonyCamResponseHelper.INQUIRY_PTZF_PARAMETERS.PTZF_PAN_MOVEMENT_RANGE, 1));
        absolutePTZCapabilities.setAbsoluteZoomMin(SonyCamResponseHelper.getIntParameter(cameraInfo, SonyCamResponseHelper.INQUIRY_PTZF_PARAMETERS.PTZF_ZOOM_MOVEMENT_RANGE, 0));
        absolutePTZCapabilities.setAbsoluteZoomMax(SonyCamResponseHelper.getIntParameter(cameraInfo, SonyCamResponseHelper.INQUIRY_PTZF_PARAMETERS.PTZF_ZOOM_MOVEMENT_RANGE, 2));
        absolutePTZCapabilities.setSupportsAbsolutePan(this.getPanTiltFunc(systemInfo));
        absolutePTZCapabilities.setSupportsAbsoluteTilt(this.getPanTiltFunc(systemInfo));
        absolutePTZCapabilities.setSupportsAbsoluteZoom(this.getAbsoluteZoom(systemInfo));
        return absolutePTZCapabilities;
    }

    public Map<String, String> getCameraResponse(String url) throws SeeTecException, ConfigurationException {
        String cameraParameters = this.getParameters(url);
        HashMap<String, String> cameraInfo = new HashMap<String, String>();
        Tools.parseParameters(cameraInfo, cameraParameters);
        return cameraInfo;
    }

    protected String getCameraResponse(Map<String, String> responseMap, String parameter) throws SeeTecException, ConfigurationException {
        String value;
        if (responseMap != null && parameter != null && !parameter.isEmpty() && (value = responseMap.get(parameter)) != null) {
            return value;
        }
        return null;
    }

    protected String[] getCameraResponseAsArray(Map<String, String> responseMap, String parameter) throws SeeTecException, ConfigurationException {
        String value = this.getCameraResponse(responseMap, parameter);
        if (value != null && !value.isEmpty()) {
            return this.extractCommaSeparatedValues(value);
        }
        return new String[0];
    }

    private SupportedCaptureModesType getSupportedCaptureModesType(Map<String, String> parameters) throws SeeTecException, ConfigurationException {
        SupportedCaptureModesType supportedCaptureModesType = new SupportedCaptureModesType();
        int maxNumberOfStreams = this.getNumberOfStreams(parameters);
        ImageRotation rotation = ImageRotation.getByStringVal(parameters.get("var ImageRotate"));
        CameraParameters cameraParameters = this.setResolutionAndFramerate(rotation);
        String captureMode = cameraParameters.biggestWidth + "x" + cameraParameters.biggestHeight + " " + cameraParameters.biggestFps + "fps";
        CaptureModeDefinitionType captureModeDefinitionType = new CaptureModeDefinitionType();
        captureModeDefinitionType.setRebootRequired(false);
        captureModeDefinitionType.setModeSuffix("");
        captureModeDefinitionType.setMaxTotalNumberOfStreams(maxNumberOfStreams);
        captureModeDefinitionType.setDefaultStreamDefinitionIndex(0);
        CameraParameters captureModeParameter = this.getResolutionAndFramerate(captureMode);
        int width = captureModeParameter.biggestWidth;
        int height = captureModeParameter.biggestHeight;
        int fps = captureModeParameter.biggestFps > 0 ? captureModeParameter.biggestFps : cameraParameters.biggestFps;
        CameraResolutionType captureModeCameraResolutionType = new CameraResolutionType();
        String sFPS = Tools.convertDoubleToString((double)fps / 1000.0, Locale.ENGLISH);
        String displayResolution = captureModeParameter.biggestFps == 50000 || captureModeParameter.biggestFps == 60000 ? "High Framerate Mode@" + sFPS + "fps" : "Standard Mode@" + sFPS + "fps";
        captureModeCameraResolutionType.setDisplayResolution(displayResolution);
        captureModeCameraResolutionType.setWidth(width);
        captureModeCameraResolutionType.setHeight(height);
        captureModeCameraResolutionType.setMaxMilliFPS(fps);
        captureModeCameraResolutionType.setMinMilliFPS(1);
        captureModeCameraResolutionType.setResolution(width + "x" + height);
        captureModeCameraResolutionType.setSupportedFrameRates(null);
        captureModeDefinitionType.setResolution(captureModeCameraResolutionType);
        MultiStreamingDefinitionsType multiStreamingDefinitionsType = this.getMultiStreamingDefinitionsType(captureMode, parameters);
        captureModeDefinitionType.setMultiStreamingDefinitions(multiStreamingDefinitionsType);
        supportedCaptureModesType.getCaptureModeDefinition().add(captureModeDefinitionType);
        return supportedCaptureModesType;
    }

    private SupportedCaptureModesType getSupportedCaptureModesType7() throws SeeTecException, ConfigurationException {
        SupportedCaptureModesType supportedCaptureModesType = new SupportedCaptureModesType();
        Map<String, String> cameraInfo = this.getCameraResponse("/command/inquiry.cgi?inqjs=camera");
        String aspect = this.getCameraResponse(cameraInfo, "var CameraAspect");
        String operationMode = this.getCameraResponse(cameraInfo, "var OperationMode");
        if (operationMode.toLowerCase().equals("hdmi")) {
            this.getLogger().warn("hdmi mode is not supported for " + this);
            return null;
        }
        this.getLogger().info("Found Capture Mode: " + aspect + "|" + operationMode);
        CaptureModeDefinitionType captureModeDefinitionType = new CaptureModeDefinitionType();
        MultiStreamingDefinitionsType multiStreamingDefinitionsType = new MultiStreamingDefinitionsType();
        captureModeDefinitionType.setMaxTotalNumberOfStreams(1);
        captureModeDefinitionType.setDefaultStreamDefinitionIndex(0);
        captureModeDefinitionType.setRebootRequired(false);
        captureModeDefinitionType.setModeSuffix(aspect.replace("_", ":") + " - " + operationMode.toUpperCase());
        captureModeDefinitionType.setMultiStreamingDefinitions(multiStreamingDefinitionsType);
        supportedCaptureModesType.getCaptureModeDefinition().add(captureModeDefinitionType);
        Map<String, String> capabilityInfo = this.getCameraResponse("/command/capability-video?Target=All&Format=js&OperationMode=" + operationMode);
        int streamCount = 0;
        int maxStreamCount = this.getNumberOfStreams(cameraInfo);
        CameraResolutionType biggestResolution = new CameraResolutionType();
        for (int streamNumber = 1; streamNumber <= maxStreamCount; ++streamNumber) {
            SupportedTransmissionTypeIDsType supportedTransmissionTypeIDsType;
            String[] resolutions = this.getCameraResponseAsArray(capabilityInfo, "var CapableImageSize" + streamNumber);
            if (resolutions.length == 0) continue;
            ++streamCount;
            int maxMilliFPS = this.getMaxMilliFPS(capabilityInfo, streamNumber);
            String[] bitrates = this.getCameraResponseAsArray(capabilityInfo, "var CapableBitRate" + streamNumber);
            int minBitrate = 1024;
            int maxBitrate = 0x2000000;
            try {
                maxBitrate = Integer.parseInt(bitrates[1]) * 1024;
            }
            catch (NumberFormatException ex) {
                this.getLogger().warn("Can't parse bitrate for " + this + ": " + ex.getMessage());
            }
            int maxIFrameDistance = this.getMaxIFrameDistance(capabilityInfo, streamNumber);
            String codec = this.getCameraResponse(capabilityInfo, "var CapableImageCodec" + streamNumber);
            codec = codec.replace(",off", "");
            int numVMF = this.getVMFNum();
            CodecType codecType = new CodecType();
            StreamDefinitionType streamDefinitionType = new StreamDefinitionType();
            streamDefinitionType.setNoOfHWMDInputs(this.getMotionDetection() + numVMF);
            streamDefinitionType.setMaxNumberOfStreams(1);
            streamDefinitionType.setDefaultMilliFPS(8000);
            streamDefinitionType.setHideFPSField(false);
            streamDefinitionType.setHideIFrameField(false);
            streamDefinitionType.setMinIFrameDistance(1000);
            streamDefinitionType.setMaxIFrameDistance(maxIFrameDistance * 1000);
            streamDefinitionType.setHideKompressionField(false);
            streamDefinitionType.setEncodingIntervalMin(0);
            streamDefinitionType.setEncodingIntervalMax(0);
            streamDefinitionType.setStreamingMode(codecType);
            streamDefinitionType.setDefaultCameraResolutionIndex(0);
            streamDefinitionType.setDefaultTransmissionTypeIndex(0);
            streamDefinitionType.setName("Stream " + streamNumber);
            multiStreamingDefinitionsType.getStreamDefinition().add(streamDefinitionType);
            BitrateSettingsType bitrateSettingsType = new BitrateSettingsType();
            bitrateSettingsType.setMaxBandwidth(maxBitrate);
            bitrateSettingsType.setMinBandwidth(minBitrate);
            bitrateSettingsType.setSupportedBitrates(null);
            streamDefinitionType.setBitrateSettings(bitrateSettingsType);
            RtspSettingsType rtspSettingsType = new RtspSettingsType();
            rtspSettingsType.setDefaultRtspPort(554);
            rtspSettingsType.setCanChangeRtspPort(true);
            rtspSettingsType.setCanMultipleRtspPorts(false);
            streamDefinitionType.setRtspSettings(rtspSettingsType);
            if (codec.equals("h264")) {
                codecType.setValue(Codec.H264.getType());
                SupportedMPEGProfileIDs supportedMPEGProfileIds = this.getSupportedMPEGProfileIds(1);
                streamDefinitionType.setSupportedMPEGProfileIDs(supportedMPEGProfileIds);
                SupportedTransmissionTypeIDsType supportedTransmissionTypeIDsType2 = new SupportedTransmissionTypeIDsType();
                supportedTransmissionTypeIDsType2.getInt().add(TransmissionType.RTP_OVER_UDP_UNICAST.getType());
                supportedTransmissionTypeIDsType2.getInt().add(TransmissionType.RTP_OVER_RTSP_OVER_TCP.getType());
                if (this.sonyGeneration > 6) {
                    supportedTransmissionTypeIDsType2.getInt().add(TransmissionType.RTP_OVER_UDP_MULTICAST.getType());
                }
                streamDefinitionType.setSupportedTransmissionTypeIDs(supportedTransmissionTypeIDsType2);
                bitrateSettingsType.setCanVBR(true);
                bitrateSettingsType.setCanVBRQuality(this.sonyGeneration != 7);
                bitrateSettingsType.setCanVBRBandwidth(true);
                bitrateSettingsType.setCanCBR(true);
                bitrateSettingsType.setCanCBRQuality(false);
                streamDefinitionType.setHideBandwithField(false);
            } else if (codec.equals("mjpeg4")) {
                codecType.setValue(Codec.MPEG4.getType());
                supportedTransmissionTypeIDsType = new SupportedTransmissionTypeIDsType();
                supportedTransmissionTypeIDsType.getInt().add(TransmissionType.RTP_OVER_UDP_UNICAST.getType());
                supportedTransmissionTypeIDsType.getInt().add(TransmissionType.RTP_OVER_RTSP_OVER_TCP.getType());
                streamDefinitionType.setSupportedTransmissionTypeIDs(supportedTransmissionTypeIDsType);
                bitrateSettingsType.setCanVBR(true);
                bitrateSettingsType.setCanVBRQuality(true);
                bitrateSettingsType.setCanCBR(true);
                bitrateSettingsType.setCanCBRQuality(true);
            } else if (codec.equals("jpeg")) {
                codecType.setValue(Codec.MJPEG.getType());
                supportedTransmissionTypeIDsType = new SupportedTransmissionTypeIDsType();
                supportedTransmissionTypeIDsType.getInt().add(TransmissionType.HTTP_SERVERPUSH.getType());
                streamDefinitionType.setSupportedTransmissionTypeIDs(supportedTransmissionTypeIDsType);
                streamDefinitionType.setHideBandwithField(true);
                bitrateSettingsType.setCanVBR(false);
                bitrateSettingsType.setCanVBRQuality(false);
                bitrateSettingsType.setCanCBR(false);
                bitrateSettingsType.setCanCBRQuality(false);
            }
            SupportedCameraResolutionsType supportedCameraResolutionsType = new SupportedCameraResolutionsType();
            for (int resPos = 0; resPos < resolutions.length; resPos += 2) {
                int width = Integer.parseInt(resolutions[resPos]);
                int height = Integer.parseInt(resolutions[resPos + 1]);
                CameraResolutionType cameraResolutionType = new CameraResolutionType();
                cameraResolutionType.setDisplayResolution(resolutions[resPos] + "x" + resolutions[resPos + 1]);
                cameraResolutionType.setWidth(width);
                cameraResolutionType.setHeight(height);
                cameraResolutionType.setMaxMilliFPS(maxMilliFPS);
                cameraResolutionType.setMinMilliFPS(1);
                if (streamDefinitionType.getName() != null && !streamDefinitionType.getName().equals("")) {
                    cameraResolutionType.setResolution(streamDefinitionType.getName());
                } else {
                    cameraResolutionType.setResolution(width + "x" + height);
                }
                cameraResolutionType.setSupportedFrameRates(null);
                supportedCameraResolutionsType.getCameraResolution().add(cameraResolutionType);
                if (width * height <= biggestResolution.getWidth() * biggestResolution.getHeight()) continue;
                biggestResolution.setWidth(width);
                biggestResolution.setHeight(height);
                biggestResolution.setResolution(width + "x" + height);
                biggestResolution.setMinMilliFPS(1);
                biggestResolution.setMaxMilliFPS(maxMilliFPS);
                biggestResolution.setSupportedFrameRates(null);
                biggestResolution.setResolution("CameraAspect=" + aspect + "&OperationMode=" + operationMode);
            }
            streamDefinitionType.setSupportedCameraResolutions(supportedCameraResolutionsType);
        }
        captureModeDefinitionType.setMaxTotalNumberOfStreams(streamCount);
        captureModeDefinitionType.setResolution(biggestResolution);
        return supportedCaptureModesType;
    }

    private SupportedCameraResolutionsType getSupportedCameraResolutionsType(String captureMode, ImageRotation rotation) throws SeeTecException, ConfigurationException {
        CameraParameters cameraParameters = this.setResolutionAndFramerate(rotation);
        CameraParameters captureModeParameter = this.getResolutionAndFramerate(captureMode);
        int fps = captureModeParameter.biggestFps > 0 ? captureModeParameter.biggestFps : cameraParameters.biggestFps;
        SupportedCameraResolutionsType supportedCameraResolutionsType = new SupportedCameraResolutionsType();
        int channel = 1;
        String[] resolutions = this.getResolution(channel);
        for (int resPos = 0; resPos < resolutions.length; resPos += 2) {
            CameraResolutionType cameraResolutionType = new CameraResolutionType();
            cameraResolutionType.setDisplayResolution(resolutions[resPos] + "x" + resolutions[resPos + 1]);
            cameraResolutionType.setWidth(Integer.parseInt(resolutions[resPos]));
            cameraResolutionType.setHeight(Integer.parseInt(resolutions[resPos + 1]));
            cameraResolutionType.setMaxMilliFPS(fps);
            cameraResolutionType.setMinMilliFPS(1);
            cameraResolutionType.setResolution(resolutions[resPos] + "x" + resolutions[resPos + 1]);
            cameraResolutionType.setSupportedFrameRates(null);
            supportedCameraResolutionsType.getCameraResolution().add(cameraResolutionType);
        }
        return supportedCameraResolutionsType;
    }

    private MultiStreamingDefinitionsType getMultiStreamingDefinitionsType(String captureMode, Map<String, String> cameraInfo) throws SeeTecException, ConfigurationException {
        MultiStreamingDefinitionsType multiStreamingDefinitionsType = new MultiStreamingDefinitionsType();
        HashSet codecsSet = new HashSet();
        int maxNumberOfStreams = this.getNumberOfStreams(cameraInfo);
        String capabilityCommand = "/command/capability-video?Target=";
        String allCodecs = capabilityCommand + "ImageCodec";
        for (int stream = 1; stream < maxNumberOfStreams; ++stream) {
            Collections.addAll(codecsSet, this.extractCommaSeparatedValues(this.getParameters(allCodecs + stream)));
        }
        if (codecsSet.contains("off")) {
            codecsSet.remove("off");
        }
        if (codecsSet.contains("h264") && codecsSet.contains("mpeg4")) {
            codecsSet.remove("mpeg4");
        }
        for (String codec : codecsSet) {
            BitrateSettingsType bitrateSettingsType;
            CodecType codecType = new CodecType();
            StreamDefinitionType streamDefinitionType = new StreamDefinitionType();
            SupportedMPEGProfileIDs supportedMPEGProfileIds = new SupportedMPEGProfileIDs();
            if (codec.equals("h264")) {
                codecType.setValue(Codec.H264.getType());
                int channel = 1;
                supportedMPEGProfileIds = this.getSupportedMPEGProfileIds(channel);
                SupportedTransmissionTypeIDsType supportedTransmissionTypeIDsType = new SupportedTransmissionTypeIDsType();
                supportedTransmissionTypeIDsType.getInt().add(TransmissionType.RTP_OVER_UDP_UNICAST.getType());
                supportedTransmissionTypeIDsType.getInt().add(TransmissionType.RTP_OVER_RTSP_OVER_TCP.getType());
                if (this.sonyGeneration >= 6) {
                    supportedTransmissionTypeIDsType.getInt().add(TransmissionType.RTP_OVER_UDP_MULTICAST.getType());
                }
                streamDefinitionType.setSupportedTransmissionTypeIDs(supportedTransmissionTypeIDsType);
                BitrateSettingsType bitrateSettingsType2 = new BitrateSettingsType();
                bitrateSettingsType2.setCanVBR(true);
                bitrateSettingsType2.setCanVBRQuality(true);
                bitrateSettingsType2.setCanVBRBandwidth(true);
                bitrateSettingsType2.setCanCBR(true);
                bitrateSettingsType2.setCanCBRQuality(false);
                streamDefinitionType.setHideBandwithField(false);
                bitrateSettingsType2.setMaxBandwidth(0x2000000);
                bitrateSettingsType2.setMinBandwidth(1024);
                bitrateSettingsType2.setSupportedBitrates(null);
                streamDefinitionType.setBitrateSettings(bitrateSettingsType2);
            } else if (codec.equals("mjpeg4")) {
                codecType = new CodecType();
                codecType.setValue(Codec.MPEG4.getType());
                SupportedTransmissionTypeIDsType supportedTransmissionTypeIDsType = new SupportedTransmissionTypeIDsType();
                supportedTransmissionTypeIDsType.getInt().add(TransmissionType.RTP_OVER_UDP_UNICAST.getType());
                supportedTransmissionTypeIDsType.getInt().add(TransmissionType.RTP_OVER_RTSP_OVER_TCP.getType());
                streamDefinitionType.setSupportedTransmissionTypeIDs(supportedTransmissionTypeIDsType);
                bitrateSettingsType = new BitrateSettingsType();
                bitrateSettingsType.setCanVBR(true);
                bitrateSettingsType.setCanVBRQuality(true);
                bitrateSettingsType.setCanCBR(true);
                bitrateSettingsType.setCanCBRQuality(true);
                bitrateSettingsType.setMaxBandwidth(0x2000000);
                bitrateSettingsType.setMinBandwidth(1024);
                bitrateSettingsType.setSupportedBitrates(null);
                streamDefinitionType.setBitrateSettings(bitrateSettingsType);
            } else {
                if (!codec.equals("jpeg")) continue;
                codecType = new CodecType();
                codecType.setValue(Codec.MJPEG.getType());
                SupportedTransmissionTypeIDsType supportedTransmissionTypeIDsType = new SupportedTransmissionTypeIDsType();
                supportedTransmissionTypeIDsType.getInt().add(TransmissionType.HTTP_SERVERPUSH.getType());
                streamDefinitionType.setSupportedTransmissionTypeIDs(supportedTransmissionTypeIDsType);
                bitrateSettingsType = new BitrateSettingsType();
                bitrateSettingsType.setCanVBR(false);
                bitrateSettingsType.setCanVBRQuality(false);
                bitrateSettingsType.setCanCBR(false);
                bitrateSettingsType.setCanCBRQuality(false);
                bitrateSettingsType.setMaxBandwidth(0x2000000);
                bitrateSettingsType.setMinBandwidth(1024);
                bitrateSettingsType.setSupportedBitrates(null);
                streamDefinitionType.setBitrateSettings(bitrateSettingsType);
                streamDefinitionType.setHideBandwithField(true);
            }
            int numVMF = this.getVMFNum();
            streamDefinitionType.setNoOfHWMDInputs(this.getMotionDetection() + numVMF);
            streamDefinitionType.setMaxNumberOfStreams(maxNumberOfStreams);
            streamDefinitionType.setDefaultMilliFPS(8000);
            streamDefinitionType.setHideFPSField(false);
            streamDefinitionType.setHideIFrameField(false);
            streamDefinitionType.setMinIFrameDistance(1);
            streamDefinitionType.setMaxIFrameDistance(Integer.MAX_VALUE);
            streamDefinitionType.setHideKompressionField(false);
            streamDefinitionType.setEncodingIntervalMin(0);
            streamDefinitionType.setEncodingIntervalMax(0);
            streamDefinitionType.setStreamingMode(codecType);
            RtspSettingsType rtspSettingsType = new RtspSettingsType();
            rtspSettingsType.setDefaultRtspPort(554);
            rtspSettingsType.setCanChangeRtspPort(true);
            rtspSettingsType.setCanMultipleRtspPorts(false);
            streamDefinitionType.setRtspSettings(rtspSettingsType);
            streamDefinitionType.setName(codec.toUpperCase());
            ImageRotation rotation = ImageRotation.getByStringVal(cameraInfo.get("var ImageRotate"));
            SupportedCameraResolutionsType supportedCameraResolutionsType = this.getSupportedCameraResolutionsType(captureMode, rotation);
            streamDefinitionType.setSupportedCameraResolutions(supportedCameraResolutionsType);
            streamDefinitionType.setSupportedMPEGProfileIDs(supportedMPEGProfileIds);
            streamDefinitionType.setDefaultCameraResolutionIndex(0);
            streamDefinitionType.setDefaultTransmissionTypeIndex(0);
            multiStreamingDefinitionsType.getStreamDefinition().add(streamDefinitionType);
        }
        return multiStreamingDefinitionsType;
    }

    private int getMaxMilliFPS(Map<String, String> capabilityInfo, int streamNumber) throws SeeTecException, ConfigurationException {
        String[] list = this.getCameraResponseAsArray(capabilityInfo, "var CapableFrameRate" + streamNumber);
        double maxFps = 0.0;
        for (String value : list) {
            double fps = Double.parseDouble(value);
            if (!(fps > maxFps)) continue;
            maxFps = fps;
        }
        return (int)(maxFps * 1000.0);
    }

    private int getMaxIFrameDistance(Map<String, String> capabilityInfo, int streamNumber) throws SeeTecException, ConfigurationException {
        String[] list = this.getCameraResponseAsArray(capabilityInfo, "var CapableIFrameInterval" + streamNumber);
        int maxDistance = 0;
        for (String value : list) {
            int distance = Integer.parseInt(value);
            if (distance <= maxDistance) continue;
            maxDistance = distance;
        }
        return maxDistance;
    }

    private int getVMFNum() throws SeeTecException, ConfigurationException {
        String urlResolution = "/command/inquiry.cgi?inqjs=vmf";
        String parametersCameraInfo = this.getParameters(urlResolution);
        HashMap<String, String> responceString = new HashMap<String, String>();
        Tools.parseParameters(responceString, parametersCameraInfo);
        try {
            return Integer.parseInt((String)responceString.get("var VMFNum"));
        }
        catch (Exception e) {
            return 0;
        }
    }

    private int getOutputsNumber() throws SeeTecException, ConfigurationException {
        String urlResolution = "/command/inquiry.cgi?inqjs=alarmout";
        String parametersCameraInfo = this.getParameters(urlResolution);
        HashMap<String, String> responceString = new HashMap<String, String>();
        Tools.parseParameters(responceString, parametersCameraInfo);
        try {
            return Integer.parseInt((String)responceString.get("var AlmAoNum"));
        }
        catch (Exception e) {
            return 0;
        }
    }

    private Map<String, String> getEventsList() throws SeeTecException, ConfigurationException {
        String enableString = "/command/system.cgi?AlarmData=on";
        NetworkHelper.readGetRequest((NetworkParameter)this.getDeviceCnf().getNetworkParameter(), (String)enableString, (int)Integer.MIN_VALUE, (boolean)false, null, (boolean)true);
        String urlResolution = "/command/alarmdata.cgi?interval=1";
        String parametersCameraInfo = this.getParameters(urlResolution);
        HashMap<String, String> resolutionString = new HashMap<String, String>();
        if (parametersCameraInfo != null) {
            parametersCameraInfo = parametersCameraInfo.substring(parametersCameraInfo.indexOf("CamTim"));
            Tools.parseParameters(resolutionString, parametersCameraInfo);
        }
        return resolutionString;
    }

    @Override
    protected SupportedGenericEventsType getGenericEventTrigger() throws SeeTecException, ConfigurationException {
        SupportedGenericEventsType supportedGenericEventsType = new SupportedGenericEventsType();
        Map<String, String> resultLines = this.getEventsList();
        if (!resultLines.isEmpty()) {
            for (Map.Entry<String, String> event : resultLines.entrySet()) {
                GenericEventDefinitionType genericEventDefinitionType = new GenericEventDefinitionType();
                genericEventDefinitionType.setEventType(event.getKey());
                genericEventDefinitionType.setSourceNumber(0);
                supportedGenericEventsType.getGenericEventDefinition().add(genericEventDefinitionType);
            }
        }
        return supportedGenericEventsType;
    }

    protected Logger getLogger() {
        return this.logger;
    }

    public static final int checkDeviceInfos(long type, String host, int port, boolean useAuthorization, String user, String pass, int timeout) {
        String url;
        String[] stringArray;
        if (useAuthorization) {
            String[] stringArray2 = new String[2];
            stringArray2[0] = user;
            stringArray = stringArray2;
            stringArray2[1] = pass;
        } else {
            stringArray = null;
        }
        NetworkParameter networkParameter = NetworkParameterFactory.createNetworkParameter((String)host, (int)port, (boolean)false, (int)-1, (int)timeout, stringArray);
        try {
            url = "/command/inquiry.cgi?inq=system";
            NetworkHelper.readGetRequest((NetworkParameter)networkParameter, (String)"/command/inquiry.cgi?inq=system", (int)Integer.MAX_VALUE, (boolean)true);
        }
        catch (Exception e) {
            return -21697;
        }
        try {
            url = "/command/inquiry.cgi?inq=user";
            NetworkHelper.readGetRequest((NetworkParameter)networkParameter, (String)"/command/inquiry.cgi?inq=user", (int)Integer.MAX_VALUE, (boolean)true);
        }
        catch (Exception e) {
            return -21701;
        }
        return 0;
    }

    public NetworkParameter getNetworkParameter() throws ConfigurationException {
        if (this.networkParameter == null) {
            this.networkParameter = this.getDeviceCnf().getNetworkParameter();
        }
        return this.networkParameter;
    }

    protected String getCurrentlySetCaptureMode() {
        try {
            Map<String, String> cameraInfo = this.getCameraResponse("/command/inquiry.cgi?inqjs=camera");
            String aspect = this.getCameraResponse(cameraInfo, "var CameraAspect");
            String operationMode = this.getCameraResponse(cameraInfo, "var OperationMode");
            return aspect.replace("_", ":") + " - " + operationMode.toUpperCase();
        }
        catch (Exception e) {
            this.getLogger().debug("Could not find out currently set capture mode [" + e.getMessage() + "] for " + this);
            return "";
        }
    }

    protected String getCurrentCaptureModeFromDefinition() {
        try {
            List<CaptureModeDefinitionType> list = this.getDeviceDefinitionFromConfiguration().getSupportedCaptureModes().getCaptureModeDefinition();
            if (!list.isEmpty()) {
                return list.get(0).getModeSuffix();
            }
        }
        catch (Exception e) {
            this.getLogger().debug("Could not find out current capture mode in definition [" + e.getMessage() + "] for " + this);
        }
        return "";
    }

    private static class CameraParameters {
        int biggestWidth = 0;
        int biggestHeight = 0;
        int biggestFps = 0;

        private CameraParameters() {
        }
    }
}

