/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.cm.device.video.sony;

import de.seetec.v5.re.cm.Core;
import de.seetec.v5.re.cm.device.shared.LiveCameraSrv;
import de.seetec.v5.re.cm.device.shared.cameracontrol.CameraControl;
import de.seetec.v5.re.cm.device.shared.genericevent.GenericEventTriggerHandler;
import de.seetec.v5.re.cm.device.shared.motiondetection.HardwareMotionDetection;
import de.seetec.v5.re.cm.device.shared.motiondetection.MotionDetectionHandler;
import de.seetec.v5.re.cm.device.shared.videoprofile.VideoProfileHandler;
import de.seetec.v5.re.cm.device.shared.videosource.VideoSourceClient;
import de.seetec.v5.re.cm.device.video.sony.SonyAudioOutServer;
import de.seetec.v5.re.cm.device.video.sony.SonyCameraControl;
import de.seetec.v5.re.cm.device.video.sony.SonyDevice;
import de.seetec.v5.re.cm.device.video.sony.SonyTriggerHandler;
import de.seetec.v5.re.cm.device.video.sony.SonyVideoSourceClient_6thGen;
import de.seetec.v5.re.cm.device.video.sony.SonyVideoSourceClient_Fisheye;
import de.seetec.v5.re.cm.device.video.sony.StreamConfiguration;
import de.seetec.v5.re.cm.device.video.sony.jpeg.SonyJPEGVideoSourceClient;
import de.seetec.v5.re.cm.device.video.sony.mpeg.SonyH264VideoSourceClient_5thGen;
import de.seetec.v5.re.cm.device.video.sony.mpeg.SonyMPEGVideoSourceClient;
import de.seetec.v5.re.cm.device.video.sony.mpeg.SonyMPEGVideoSourceClient_Vx;
import de.seetec.v5.re.cm.shared.Tools;
import de.seetec.v5.re.shared.CnfDeviceCaptureMode;
import de.seetec.v5.re.shared.Codec;
import de.seetec.v5.re.shared.ContentFrame;
import de.seetec.v5.shared.net.NetworkHelper;
import de.seetec.v5.shared.net.NetworkParameter;
import de.seetec.v5.shared.util.ConfigurationException;
import de.seetec.v5.shared.util.SeeTecException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Hashtable;

public class SonyCameraSrv
extends LiveCameraSrv {
    private static final String CLASS_NAME = "de.seetec.v5.re.cm.device.video.sony.SonyCameraSrv";
    private Hashtable<String, Integer> dynToStream = new Hashtable();
    private boolean isMultiStreamingUsed;
    private int streamID = 1;
    private NetworkParameter networkParameter;
    private byte[] result;
    private Boolean isPalFormat;
    private int sonyGeneration;
    private final Object SONY_RTSP_SEMAPHORE = new Object();
    private final HashMap<String, String> cameraParameters = new HashMap();
    private final HashMap<String, Object> cameraVideoParameters = new HashMap();

    @Override
    public CameraControl createCameraControl(Long entityType) {
        return new SonyCameraControl();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public VideoSourceClient createVideoSourceClient(Core core, VideoProfileHandler listener) throws SeeTecException {
        VideoSourceClient videoSourceClient;
        block42: {
            videoSourceClient = null;
            try {
                this.networkParameter = this.getDevice().getDeviceCnf().getNetworkParameter();
            }
            catch (ConfigurationException ex) {
                this.logger.error("Exception while retrieving network parameters for " + this + ": " + ex.getMessage());
            }
            this.sonyGeneration = ((SonyDevice)this.getDevice()).getSonyGeneration();
            long deviceType = this.getDevice().getDeviceType();
            if (this.sonyGeneration == 5) {
                try {
                    this.isPalFormat = this.isPalFormat();
                }
                catch (SeeTecException ex) {
                    int errorCode = ex.getErrorCode();
                    this.logger.error("Initializing [VideoSourceClient] for " + this + " failed with error [" + errorCode + "] :-(");
                    throw new SeeTecException(errorCode, "Initializing [VideoSourceClient] for " + this + " failed with error [" + errorCode + "]");
                }
            }
            if (this.sonyGeneration > 5) {
                try {
                    this.isPalFormat = this.isPalFormat();
                }
                catch (SeeTecException ex) {
                    int errorCode = ex.getErrorCode();
                    this.logger.error("Initializing [VideoSourceClient] for " + this + " failed with error [" + errorCode + "]");
                    throw new SeeTecException(errorCode, "Initializing [VideoSourceClient] for " + this + " failed with error [" + errorCode + "]");
                }
            }
            try {
                videoSourceClient = this.sonyGeneration > 5 ? new SonyVideoSourceClient_6thGen() : (deviceType == 200650L ? new SonyVideoSourceClient_Fisheye() : (listener.getVideoSourceParameter().getMediaCodec() == Codec.MPEG4 || listener.getVideoSourceParameter().getMediaCodec() == Codec.H264 ? (deviceType == 200623L ? new SonyMPEGVideoSourceClient_Vx() : (this.sonyGeneration == 5 ? new SonyH264VideoSourceClient_5thGen() : new SonyMPEGVideoSourceClient())) : new SonyJPEGVideoSourceClient()));
                boolean bl = this.isMultiStreamingUsed = this.getAdditionalVideoProfileHandler().length >= 1;
                if (this.isMultiStreamingUsed) {
                    if (this.dynToStream.isEmpty()) {
                        SonyCameraSrv ex = this;
                        synchronized (ex) {
                            int i;
                            CnfDeviceCaptureMode cnfDeviceCaptureMode;
                            StringBuilder url = new StringBuilder("/command/camera.cgi?");
                            int numberOfStreams = 1 + this.getAdditionalVideoProfileHandler().length;
                            if (this.getSonyGeneration() > 5 && (cnfDeviceCaptureMode = this.getDevice().getDeviceCnf().getCaptureMode()) != null && cnfDeviceCaptureMode.isEnabled() && this.getDevice().getDeviceCnf().getCaptureMode().getDisplayResolution().contains("60")) {
                                numberOfStreams = 2;
                            }
                            VideoProfileHandler[] videoProfileHandler = new VideoProfileHandler[numberOfStreams];
                            videoProfileHandler[0] = this.getBasicVideoProfileHandler();
                            for (int i2 = 1; i2 < videoProfileHandler.length; ++i2) {
                                videoProfileHandler[i2] = this.getAdditionalVideoProfileHandler()[i2 - 1];
                            }
                            StreamConfiguration[] streamConfiguration = new StreamConfiguration[numberOfStreams];
                            for (i = 0; i < streamConfiguration.length; ++i) {
                                streamConfiguration[i] = new StreamConfiguration(videoProfileHandler[i].getDynamicVideoProfileID(), videoProfileHandler[i].getVideoSourceParameter().getMediaCodec().getType(), videoProfileHandler[i].getVideoSourceParameter().getImageSize()[0], videoProfileHandler[i].getVideoSourceParameter().getImageSize()[1], i);
                                if (!this.isPalFormat() && deviceType != 200640L && deviceType != 200641L && deviceType != 200642L && deviceType != 200643L && streamConfiguration[i].width == 720 && streamConfiguration[i].height == 576) {
                                    streamConfiguration[i].width = 480;
                                }
                                if (this.sonyGeneration > 6) {
                                    String resolutionTag = videoProfileHandler[i].getVideoSourceParameter().getResolution();
                                    try {
                                        streamConfiguration[i].streamNumberOnCamera = Integer.parseInt(resolutionTag.toLowerCase().substring("stream ".length()));
                                    }
                                    catch (Exception ex2) {
                                        streamConfiguration[i].streamNumberOnCamera = this.streamID;
                                        this.logger.warn("Can't get streamNumber (" + resolutionTag + "). Using stream " + this.streamID + " for " + this);
                                    }
                                } else {
                                    streamConfiguration[i].streamNumberOnCamera = this.streamID;
                                }
                                this.dynToStream.put("" + streamConfiguration[i].dynamicVideoProfileID, streamConfiguration[i].streamNumberOnCamera);
                            }
                            Arrays.sort(streamConfiguration, Collections.reverseOrder());
                            for (i = 0; i < streamConfiguration.length; ++i) {
                                streamConfiguration[i].streamNumberOnCamera = this.streamID = i + 1;
                                this.dynToStream.put("" + streamConfiguration[i].dynamicVideoProfileID, this.streamID);
                                url.append(streamConfiguration[i].getUrlPart());
                            }
                            if (this.sonyGeneration > 6) {
                                url.append("&H264BFrameEnable=off");
                            }
                            String urlString = url.toString().replace("?&", "?");
                            NetworkHelper.readGetRequest((NetworkParameter)this.networkParameter, (String)urlString, (int)Integer.MAX_VALUE, (boolean)false, null, (boolean)true);
                        }
                    }
                } else if (deviceType != 200650L) {
                    int widthBasic = this.getBasicVideoProfileHandler().getVideoSourceParameter().getImageSize()[0];
                    int heightBasic = this.getBasicVideoProfileHandler().getVideoSourceParameter().getImageSize()[1];
                    if (!this.isPalFormat() && deviceType != 200640L && deviceType != 200641L && deviceType != 200642L && deviceType != 200643L && this.sonyGeneration < 6 && widthBasic == 720 && heightBasic == 576) {
                        heightBasic = 480;
                    }
                    StringBuilder url = new StringBuilder("/command/camera.cgi?ImageSize" + this.streamID + "=");
                    url.append(widthBasic).append("%2C").append(heightBasic);
                    if (this.sonyGeneration > 6) {
                        String resolutionTag = this.getBasicVideoProfileHandler().getVideoSourceParameter().getResolution();
                        try {
                            this.streamID = Integer.parseInt(resolutionTag.toLowerCase().substring("stream ".length()));
                        }
                        catch (Exception ex) {
                            this.streamID = 1;
                            this.logger.warn("Can't get streamNumber (" + resolutionTag + "). Using stream " + this.streamID + " for " + this);
                        }
                        url.append("&H264BFrameEnable=off");
                    } else {
                        this.streamID = 1;
                    }
                    this.logger.info("Setting stream resolutions: " + url.toString());
                    NetworkHelper.readGetRequest((NetworkParameter)this.networkParameter, (String)url.toString(), (int)Integer.MAX_VALUE, (boolean)false, null, (boolean)true);
                    if (this.dynToStream.isEmpty()) {
                        this.dynToStream.put("" + this.getBasicVideoProfileHandler().getDynamicVideoProfileID(), this.streamID);
                    }
                }
                if (deviceType == 200641L && this.getAdditionalVideoProfileHandler().length == 0) {
                    this.result = NetworkHelper.readGetRequest((NetworkParameter)this.networkParameter, (String)"/command/camera.cgi?ImageCodec2=off", (int)Integer.MAX_VALUE, (boolean)false, null, (boolean)true);
                }
                if (this.getVideoSourceCnf().getMediaCodec() == Codec.H264) {
                    Object widthBasic = this.SONY_RTSP_SEMAPHORE;
                    synchronized (widthBasic) {
                        int errorCode = videoSourceClient.init(core, this, listener);
                        if (errorCode != 0) {
                            videoSourceClient.shutdown();
                            videoSourceClient = null;
                            this.logger.error("Initializing [VideoSourceClient] for " + this + " failed with error [" + errorCode + "]");
                            throw new SeeTecException(errorCode, "Initializing [VideoSourceClient] for " + this + " failed with error [" + errorCode + "]");
                        }
                        break block42;
                    }
                }
                int errorCode = videoSourceClient.init(core, this, listener);
                if (errorCode != 0) {
                    videoSourceClient.shutdown();
                    videoSourceClient = null;
                    this.logger.error("Initializing [VideoSourceClient] for " + this + " failed with error [" + errorCode + "]");
                    throw new SeeTecException(errorCode, "Initializing [VideoSourceClient] for " + this + " failed with error [" + errorCode + "]");
                }
            }
            catch (SeeTecException seetecEx) {
                this.logger.info("Exception while setting initial parameters for " + this + " : " + seetecEx.getMessage());
                int errorCode = seetecEx.getErrorCode() == -21657 ? -21657 : seetecEx.getErrorCode();
                throw new SeeTecException(errorCode, seetecEx.getMessage());
            }
            catch (Exception ex) {
                if (videoSourceClient != null) {
                    videoSourceClient.shutdown();
                    videoSourceClient = null;
                }
                this.logger.error((Object)ex, (Throwable)ex);
                this.logger.error("Creating [VideoSourceClient] for " + this + " failed");
                throw new SeeTecException(-20001, "Creating [VideoSourceClient] for " + this + " failed");
            }
        }
        return videoSourceClient;
    }

    @Override
    public ContentFrame getJpegSnapshot(Integer[] nResolution) throws SeeTecException {
        throw new SeeTecException(-20009, "NOT YET IMPLEMENTED :-(");
    }

    @Override
    public GenericEventTriggerHandler createNewGenericEventTriggerHandler() {
        return new SonyTriggerHandler(this);
    }

    public int getSonyGeneration() {
        return this.sonyGeneration;
    }

    public void setHardwareMotionDetection(HardwareMotionDetection<? extends MotionDetectionHandler> hardwareMotionDetection) {
        this.hardwareMotionDetection = hardwareMotionDetection;
    }

    public boolean isPalFormat() throws SeeTecException {
        return this.isPalFormat(false);
    }

    public boolean isPalFormat(boolean isFisheye) throws SeeTecException {
        if (this.isPalFormat != null) {
            return this.isPalFormat;
        }
        this.isPalFormat = Boolean.FALSE;
        if (isFisheye) {
            String resultString;
            this.result = NetworkHelper.readGetRequest((NetworkParameter)this.networkParameter, (String)"/cgi-bin/admin/getparam.cgi?", (int)Integer.MAX_VALUE, (boolean)true);
            if (this.result != null && (resultString = new String(this.result)).contains("videoin_cmosfreq='50'")) {
                this.isPalFormat = Boolean.TRUE;
            }
        } else {
            String resultString;
            this.result = NetworkHelper.readGetRequest((NetworkParameter)this.networkParameter, (String)"/command/inquiry.cgi?inqjs=camera", (int)Integer.MAX_VALUE, (boolean)false, (String)"VideoStd");
            if (this.result != null && (resultString = new String(this.result)).toLowerCase().contains("videostd=\"pal\"")) {
                this.isPalFormat = Boolean.TRUE;
            }
        }
        return this.isPalFormat;
    }

    private float[] readPossibleParameters(String parameter) {
        String localParameter = parameter;
        if (parameter.startsWith("JpegQuality")) {
            localParameter = parameter.replace("Jpeg", "");
        }
        float[] ret = null;
        try {
            byte[] result = NetworkHelper.readGetRequest((NetworkParameter)this.networkParameter, (String)("/command/capability-video?Target=" + localParameter), (int)Integer.MAX_VALUE, (boolean)true);
            String valuesList = new String(result);
            String[] possibleValues = ((SonyDevice)this.getDevice()).extractCommaSeparatedValues(valuesList);
            ret = new float[possibleValues.length];
            for (int i = 0; i < possibleValues.length; ++i) {
                ret[i] = Float.parseFloat(possibleValues[i]);
            }
        }
        catch (SeeTecException ex) {
            this.logger.error("Exception while reading possible configuration parameters for " + this);
        }
        catch (NumberFormatException ex) {
            this.logger.warn("Number format exception for value " + localParameter);
            return new float[]{0.0f};
        }
        return ret;
    }

    public int[] getVideoParameterAsInt(String key) {
        Object value = this.cameraVideoParameters.get(key);
        if (value == null) {
            value = this.readPossibleParameters(key);
            int[] intValues = Tools.convertArrayToIntArray((float[])value);
            this.cameraVideoParameters.put(key, intValues);
            return intValues;
        }
        if (value instanceof int[]) {
            return (int[])value;
        }
        if (value instanceof float[]) {
            return Tools.convertArrayToIntArray((float[])value);
        }
        return new int[0];
    }

    public float[] getVideoParameterAsFloat(String key) {
        Object value = this.cameraVideoParameters.get(key);
        if (value == null) {
            value = this.readPossibleParameters(key);
            this.cameraVideoParameters.put(key, value);
            return (float[])value;
        }
        if (value instanceof float[]) {
            return (float[])value;
        }
        return new float[0];
    }

    public int getStreamNumber(int dynamicVideoProfileID) throws SeeTecException {
        if (this.dynToStream == null || this.dynToStream.isEmpty() || this.dynToStream.get("" + dynamicVideoProfileID) == null) {
            this.logger.error("Streamnumber not set for " + this);
            throw new SeeTecException(-21600, "Streamnumber was not set properly");
        }
        return this.dynToStream.get("" + dynamicVideoProfileID);
    }

    String readConfiguration(String parameter, boolean readNew) {
        return this.readConfiguration("/command/inquiry.cgi?inqjs=camera", parameter, readNew);
    }

    String readOSDConfiguration(String parameter, boolean readNew) {
        String value = this.readConfiguration("/command/inquiry.cgi?inq=superimpose", parameter, readNew);
        return value != null ? value : "";
    }

    String readSystemConfiguration(String parameter, boolean readNew) {
        String value = this.readConfiguration("/command/inquiry.cgi?inq=system", parameter, readNew);
        return value != null ? value : "";
    }

    private String readConfiguration(String url, String parameter, boolean readNew) {
        try {
            if (readNew || this.cameraParameters.isEmpty()) {
                String[] parameterLines;
                String parameters = new String(NetworkHelper.readGetRequest((NetworkParameter)this.networkParameter, (String)url, (int)Integer.MAX_VALUE, (boolean)true)).toLowerCase();
                for (String parameterLine : parameterLines = parameters.split("[\r\n&]")) {
                    String[] nameValuePair = (parameterLine = parameterLine.replace("var ", "").replace("\"", "")).split("=");
                    if (nameValuePair.length != 2) continue;
                    this.cameraParameters.put(nameValuePair[0].toLowerCase(), nameValuePair[1]);
                }
            }
            return this.cameraParameters.get(parameter.toLowerCase());
        }
        catch (SeeTecException ex) {
            this.logger.error("Exception while reading camera configuration for " + this + " : " + ex.getMessage());
            return this.cameraParameters.get(parameter.toLowerCase());
        }
    }

    @Override
    protected SonyAudioOutServer createAudioOutServer() {
        NetworkParameter networkParameter = null;
        try {
            networkParameter = this.getDevice().getDeviceCnf().getNetworkParameter();
        }
        catch (ConfigurationException configurationException) {
            this.logger.error("Could not read Network parameter [" + configurationException.getMessage() + "] for " + this);
        }
        SonyAudioOutServer sonyAudioOutServer = null;
        try {
            sonyAudioOutServer = new SonyAudioOutServer(networkParameter);
            sonyAudioOutServer.init();
        }
        catch (Exception ex) {
            this.logger.warn("Sony Audio Out Server could not be initialized : " + ex.getMessage());
        }
        return sonyAudioOutServer;
    }
}

