/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.cm.device.video.sony;

import de.seetec.v5.re.cm.configuration.definition.camera.VideoCameraDefinition;
import de.seetec.v5.re.cm.configuration.device.shared.ArrayOfCameraPreset.ArrayOfCameraPreset;
import de.seetec.v5.re.cm.configuration.device.shared.ArrayOfCameraPreset.CameraPreset;
import de.seetec.v5.re.cm.device.shared.VideoSrv;
import de.seetec.v5.re.cm.device.shared.cameracontrol.CameraControl;
import de.seetec.v5.re.cm.device.shared.cameracontrol.PresetCnf;
import de.seetec.v5.re.cm.device.video.sony.CameraPosition;
import de.seetec.v5.re.cm.device.video.sony.SonyCamResponseHelper;
import de.seetec.v5.re.cm.device.video.sony.SonyDevice;
import de.seetec.v5.re.cm.device.video.sony.SonyQuery;
import de.seetec.v5.re.cm.shared.PtzInfo;
import de.seetec.v5.re.cm.shared.Tools;
import de.seetec.v5.re.cm.shared.communication.VideoServiceClientRequestHandler;
import de.seetec.v5.shared.net.NetworkHelper;
import de.seetec.v5.shared.net.NetworkParameter;
import de.seetec.v5.shared.util.ConfigurationException;
import de.seetec.v5.shared.util.SeeTecException;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.List;
import java.util.Vector;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.input.SAXBuilder;

public class SonyCameraControl
extends CameraControl {
    private VideoCameraDefinition cameraConfig;
    private int errorCode;
    private long time;
    private int interval = 400;
    private static final int TOLERANCE = 40000;
    private static final int TOLERANCE_ENCODER = 40000;
    private int oldPan;
    private int oldTilt;
    private int oldZoom;
    private static final int TILT_TOLERANCE = 5000;
    private static final int PAN_TOLERANCE = 5000;
    private Object previousUrl;

    private int sendCameraCommand(String url) {
        return this.sendCameraCommand(url, false);
    }

    @Override
    public int init(VideoSrv videoSrv, String api, String host, int port, String usr, String pwd, Vector<PresetCnf> presetList) {
        int errorCode = super.init(videoSrv, api, host, port, usr, pwd, presetList);
        this.cameraConfig = videoSrv.getDevice().getVideoCameraDefinitionFromConfiguration();
        this.ptzInfo = new PtzInfo();
        this.refreshAbsolutePosition(true);
        return errorCode;
    }

    private int sendCameraCommand(String url, boolean urlIsComplete) {
        String completeURL;
        if (urlIsComplete) {
            completeURL = url;
        } else {
            String seeTecID = Long.toHexString(System.currentTimeMillis() & 0xFFFFFFFFL);
            completeURL = "/command/ptzf.cgi?sid=" + seeTecID + url;
        }
        try {
            this.videoSrv.notifyForCameraControl();
            if (this.videoSrv.getEntityType() == 210514L) {
                if (url.equals(this.previousUrl)) {
                    return 0;
                }
                this.previousUrl = url;
                NetworkHelper.readGetRequest((NetworkParameter)this.networkParameter, (String)url, (int)Integer.MAX_VALUE, (boolean)true, null, (boolean)true);
            } else {
                NetworkHelper.readGetRequest((NetworkParameter)this.networkParameter, (String)completeURL, (int)Integer.MIN_VALUE);
            }
            return 0;
        }
        catch (SeeTecException ex) {
            this.logger.error("Sending HTTP request [ " + completeURL + " ] failed with error [ " + ex.getErrorCode() + " ]");
            return ex.getErrorCode();
        }
        catch (Throwable ex) {
            this.logger.error((Object)ex, ex);
            return -21600;
        }
    }

    private int sendContinuousCommand(String sCMD, Integer value) {
        if (value != null) {
            return this.sendCameraCommand("&continuous" + sCMD + "move=" + value / 1000);
        }
        return this.sendCameraCommand("&continuous" + sCMD + "move=0");
    }

    @Override
    public int setAbsolutePTZ(VideoServiceClientRequestHandler sender, Integer pan, Integer tilt, Integer zoom) {
        int errorCode = 0;
        if (this.videoSrv.getEntityType() == 210553L) {
            if (zoom != null) {
                int zoomValue = 16384 * zoom / 100000;
                String sAbsoluteZoomCMD = Long.toHexString(zoomValue);
                errorCode = this.sendPostRequest("/command/ptzf.cgi", sAbsoluteZoomCMD);
            }
            return errorCode;
        }
        try {
            long hex;
            int minpan = -170000;
            int maxPan = 170000;
            long viscaPanMax = 2448L;
            long viscaPanMin = -viscaPanMax;
            String maxPanSpeed = "18";
            int minTilt = -25000;
            int maxTilt = 90000;
            long viscaTiltMax = 828L;
            long viscaTiltMin = -viscaTiltMax;
            String maxTiltSpeed = "14";
            int minZoom = 0;
            int maxZoom = 100000;
            long viscaZoomMin = 0L;
            long viscaZoomMax = 16384L;
            if (this.videoSrv.getEntityType() == 210505L || this.videoSrv.getEntityType() == 210509L || this.videoSrv.getEntityType() == 210510L) {
                minpan = -170000;
                maxPan = 170000;
                viscaPanMax = 2267L;
                viscaPanMin = -viscaPanMax;
                maxPanSpeed = "24";
                minTilt = -90000;
                maxTilt = 30000;
                viscaTiltMax = 400L;
                viscaTiltMin = -viscaTiltMax;
                maxTiltSpeed = "24";
                minZoom = 0;
                maxZoom = 100000;
                viscaZoomMin = 0L;
                viscaZoomMax = 16384L;
            }
            if (pan != null && tilt != null) {
                int i;
                int panRange = maxPan - minpan;
                long viscaPanRange = viscaPanMax - viscaPanMin;
                hex = -(viscaPanMax - viscaPanRange * (long)(pan - minpan) / (long)panRange);
                StringBuffer sbPanHex = new StringBuffer(Long.toHexString(hex & 0xFFFFL));
                while (sbPanHex.length() < 4) {
                    sbPanHex.insert(0, '0');
                }
                int tiltRange = maxTilt - minTilt;
                long viscaTiltRange = viscaTiltMax - viscaTiltMin;
                hex = -(viscaTiltMax - viscaTiltRange * (long)(tilt - minTilt) / (long)tiltRange);
                StringBuffer sbTiltHex = new StringBuffer(Long.toHexString(hex & 0xFFFFL));
                while (sbTiltHex.length() < 4) {
                    sbTiltHex.insert(0, '0');
                }
                String sYYYY = sbPanHex.toString();
                String sZZZZ = sbTiltHex.toString();
                StringBuilder sb = new StringBuilder(256);
                sb.append("VISCA=81010602");
                sb.append(maxPanSpeed);
                sb.append(maxTiltSpeed);
                for (i = 0; i < 4; ++i) {
                    sb.append('0');
                    sb.append(sYYYY.substring(i, i + 1));
                }
                for (i = 0; i < 4; ++i) {
                    sb.append('0');
                    sb.append(sZZZZ.substring(i, i + 1));
                }
                sb.append("FF");
                String sAbsolutePanTiltCMD = sb.toString();
                errorCode = this.sendPostRequest("/command/ptzf.cgi", sAbsolutePanTiltCMD);
                if (errorCode != 0) {
                    return errorCode;
                }
            }
            if (zoom != null) {
                int zoomRange = maxZoom - minZoom;
                long viscaZoomRange = viscaZoomMax - viscaZoomMin;
                hex = viscaZoomMin + viscaZoomRange * (long)(zoom - minZoom) / (long)zoomRange;
                StringBuilder sbZoomHex = new StringBuilder(Long.toHexString(hex));
                while (sbZoomHex.length() < 4) {
                    sbZoomHex.insert(0, '0');
                }
                String sZoom = sbZoomHex.toString();
                StringBuilder sb = new StringBuilder(256);
                sb.append("VISCA=81010447");
                for (int i = 0; i < 4; ++i) {
                    sb.append('0');
                    sb.append(sZoom.substring(i, i + 1));
                }
                sb.append("FF");
                String absoluteZoomCMD = sb.toString();
                errorCode = this.sendPostRequest("/command/ptzf.cgi", absoluteZoomCMD);
                if (errorCode != 0) {
                    return errorCode;
                }
            }
            if ((errorCode = this.videoSrv.sendStatusAbsolutePTZ(sender, pan, tilt, zoom)) != 0) {
                this.logger.error("Send HTTP request failed with error [ " + errorCode + " ] :-( ");
                return errorCode;
            }
            return 0;
        }
        catch (Throwable ex) {
            this.logger.error((Object)ex, ex);
            return -21600;
        }
    }

    @Override
    public int setAbsoluteZ(VideoServiceClientRequestHandler sender, Integer zoom) {
        if (this.videoSrv.getEntityType() == 210553L) {
            this.sendCameraCommand(SonyQuery.ptzCommand().zoom(zoom).toString(), true);
            this.refreshAbsolutePosition(false);
        }
        return 0;
    }

    @Override
    public int setContinuousPTZ(Integer panSpeed, Integer tiltSpeed, Integer zoomSpeed) {
        int zoom;
        int tilt;
        int pan;
        if (panSpeed != null) {
            this.previousPanSpeed = pan = panSpeed.intValue();
        } else {
            pan = this.previousPanSpeed;
        }
        if (tiltSpeed != null) {
            this.previousTiltSpeed = tilt = tiltSpeed.intValue();
        } else {
            tilt = this.previousTiltSpeed;
        }
        if (zoomSpeed != null) {
            this.previousZoomSpeed = zoom = zoomSpeed.intValue();
        } else {
            zoom = this.previousZoomSpeed;
        }
        try {
            this.videoSrv.notifyForCameraControl();
            if (this.videoSrv.getEntityType() == 210509L || this.videoSrv.getEntityType() == 210510L) {
                int speedStep;
                if (zoomSpeed != null) {
                    int speedStep2 = (zoomSpeed + 12499) / 12500;
                    if (zoomSpeed == 0) {
                        return this.sendCameraCommand("/command/ptzf.cgi?Move=stop,zoom", true);
                    }
                    if (speedStep2 > 0) {
                        return this.sendCameraCommand("/command/ptzf.cgi?Move=tele," + speedStep2, true);
                    }
                    return this.sendCameraCommand("/command/ptzf.cgi?Move=wide," + -speedStep2, true);
                }
                if (panSpeed != null && tiltSpeed != null && panSpeed == 0 && tiltSpeed == 0) {
                    return this.sendCameraCommand("/command/ptzf.cgi?Move=stop,motor", true);
                }
                if (panSpeed != null) {
                    speedStep = (panSpeed + 4166) / 4167;
                    if (speedStep > 0) {
                        this.sendCameraCommand("/command/ptzf.cgi?Move=right," + speedStep, true);
                    } else if (speedStep < 0) {
                        this.sendCameraCommand("/command/ptzf.cgi?Move=left," + -speedStep, true);
                    }
                }
                if (tiltSpeed != null) {
                    speedStep = (tiltSpeed + 4166) / 4167;
                    if (speedStep > 0) {
                        return this.sendCameraCommand("/command/ptzf.cgi?Move=up," + speedStep, true);
                    }
                    if (speedStep < 0) {
                        return this.sendCameraCommand("/command/ptzf.cgi?Move=down," + -speedStep, true);
                    }
                }
            } else if (this.videoSrv.getEntityType() == 210514L) {
                if (zoomSpeed != null && ((zoom = (zoom + 12499) / 12500) == 0 ? (this.errorCode = this.sendCameraCommand("/command/ptzf.cgi?Move=stop,zoom", true)) != 0 : (zoom > 0 ? (this.errorCode = this.sendCameraCommand("/command/ptzf.cgi?Move=tele," + zoom, true)) != 0 : (this.errorCode = this.sendCameraCommand("/command/ptzf.cgi?Move=wide," + -zoom, true)) != 0))) {
                    return this.errorCode;
                }
                if ((panSpeed != null || tiltSpeed != null) && pan == 0 && tilt == 0) {
                    return this.sendCameraCommand("/command/ptzf.cgi?Move=stop,motor", true);
                }
                if (panSpeed != null || tiltSpeed != null) {
                    int range = 6;
                    pan = (pan + 4166) / 4167;
                    tilt = (tilt + 4166) / 4167;
                    if (pan >= range) {
                        if (Math.abs(tilt) < range) {
                            this.sendCameraCommand("/command/ptzf.cgi?Move=right," + pan, true);
                        } else if (tilt >= range) {
                            this.sendCameraCommand("/command/ptzf.cgi?Move=up-right," + pan, true);
                        } else if (tilt <= -range) {
                            this.sendCameraCommand("/command/ptzf.cgi?Move=down-right," + pan, true);
                        }
                    } else if (pan <= -range) {
                        if (Math.abs(tilt) < range) {
                            this.sendCameraCommand("/command/ptzf.cgi?Move=left," + -pan, true);
                        } else if (tilt >= range) {
                            this.sendCameraCommand("/command/ptzf.cgi?Move=up-left," + -pan, true);
                        } else if (tilt <= -range) {
                            this.sendCameraCommand("/command/ptzf.cgi?Move=down-left," + -pan, true);
                        }
                    } else if (Math.abs(pan) < range && Math.abs(tilt) < range) {
                        if (pan < 0) {
                            if (tilt < 0) {
                                this.sendCameraCommand("/command/ptzf.cgi?Move=down-left," + -pan, true);
                            } else if (tilt > 0) {
                                this.sendCameraCommand("/command/ptzf.cgi?Move=up-left," + -pan, true);
                            } else {
                                this.sendCameraCommand("/command/ptzf.cgi?Move=left," + -pan, true);
                            }
                        } else if (pan > 0) {
                            if (tilt < 0) {
                                this.sendCameraCommand("/command/ptzf.cgi?Move=down-right," + pan, true);
                            } else if (tilt > 0) {
                                this.sendCameraCommand("/command/ptzf.cgi?Move=up-right," + pan, true);
                            } else {
                                this.sendCameraCommand("/command/ptzf.cgi?Move=right," + pan, true);
                            }
                        } else if (tilt > 0) {
                            this.sendCameraCommand("/command/ptzf.cgi?Move=up," + tilt, true);
                        } else if (tilt < 0) {
                            this.sendCameraCommand("/command/ptzf.cgi?Move=down," + -tilt, true);
                        }
                    } else if (tilt >= range) {
                        this.sendCameraCommand("/command/ptzf.cgi?Move=up," + tilt, true);
                    } else if (tilt <= -range) {
                        this.sendCameraCommand("/command/ptzf.cgi?Move=down," + -tilt, true);
                    }
                }
            } else {
                if (this.videoSrv.getDevice().getDeviceType() == 200623L) {
                    int channelNo = this.videoSrv.getVideoSourceCnf().getServerEntryNo();
                    if (zoomSpeed != null && (zoom == 0 ? (this.errorCode = this.sendCameraCommand("/command/ptzf.cgi?ChannelNo=" + channelNo + "&Ptzfzstop", true)) != 0 : (zoom > 0 ? (this.errorCode = this.sendCameraCommand("/command/ptzf.cgi?ChannelNo=" + channelNo + "&Ptzftele", true)) != 0 : (this.errorCode = this.sendCameraCommand("/command/ptzf.cgi?ChannelNo=" + channelNo + "&Ptzfwide", true)) != 0))) {
                        return this.errorCode;
                    }
                    if (pan == 0 && tilt == 0 && zoom == 0 && (this.errorCode = this.sendCameraCommand("/command/ptzf.cgi?ChannelNo=" + channelNo + "&Ptzfstop", true)) != 0) {
                        return this.errorCode;
                    }
                    if (panSpeed != null || tiltSpeed != null) {
                        boolean setSomething = false;
                        StringBuilder url = new StringBuilder("/command/ptzf.cgi?ChannelNo=" + channelNo);
                        if (tilt > 0) {
                            setSomething = true;
                            url.append("&Ptzfup");
                            if (pan > 0) {
                                url.append("right");
                            } else if (pan < 0) {
                                url.append("left");
                            }
                        } else if (tilt < 0) {
                            setSomething = true;
                            url.append("&Ptzfdown");
                            if (pan > 0) {
                                url.append("right");
                            } else if (pan < 0) {
                                url.append("left");
                            }
                        } else if (pan > 0) {
                            setSomething = true;
                            url.append("&Ptzfright");
                        } else if (pan < 0) {
                            setSomething = true;
                            url.append("&Ptzfleft");
                        }
                        if (setSomething && (this.errorCode = this.sendCameraCommand(url.toString(), true)) != 0) {
                            return this.errorCode;
                        }
                    }
                    return this.errorCode;
                }
                if (this.videoSrv.getDevice().getDeviceType() == 200628L || this.videoSrv.getDevice().getDeviceType() == 200629L || this.videoSrv.getDevice().getDeviceType() == 200640L || this.videoSrv.getDevice().getDeviceType() == 200641L || this.videoSrv.getDevice().getDeviceType() == 200642L || this.videoSrv.getDevice().getDeviceType() == 200643L || ((SonyDevice)this.videoSrv.getDevice()).getSonyGeneration() > 5) {
                    if (System.currentTimeMillis() - this.time < (long)this.interval && Math.abs(pan - this.oldPan) < 40000 && Math.abs(tilt - this.oldTilt) < 40000 && Math.abs(zoom - this.oldZoom) < 40000 && pan != 0 && tilt != 0) {
                        return 0;
                    }
                    this.oldPan = pan;
                    this.oldTilt = tilt;
                    this.oldZoom = zoom;
                    this.time = System.currentTimeMillis();
                    String url = "/command/ptzf.cgi?ContinuousPanTiltZoom=" + (pan /= 1000) + "," + (tilt /= 1000) + "," + (zoom /= 1000);
                    try {
                        if (NetworkHelper.readGetRequest((NetworkParameter)this.networkParameter, (String)url, (int)Integer.MAX_VALUE, (boolean)false, null, (boolean)true) == null) {
                            this.logger.error("Error while sending PTZ command: ");
                        }
                        this.interval = (9 * this.interval + (int)(System.currentTimeMillis() - this.time)) / 10;
                        this.time = System.currentTimeMillis();
                    }
                    catch (SeeTecException ste) {
                        this.logger.error("Timeout. Wait..." + (Object)((Object)ste));
                        Thread.sleep(1000L);
                        if (NetworkHelper.readGetRequest((NetworkParameter)this.networkParameter, (String)"/command/ptzf.cgi?ContinuousPanTiltZoom=0,0,0", (int)Integer.MAX_VALUE, (boolean)false, null, (boolean)true) == null) {
                            this.logger.error("Error while stopping camera" + url);
                        }
                    }
                } else if (this.videoSrv.getDevice().getDeviceType() == 200630L || this.videoSrv.getDevice().getDeviceType() == 200631L || this.videoSrv.getDevice().getDeviceType() == 200632L) {
                    if (System.currentTimeMillis() - this.time < (long)this.interval && (Math.abs(pan - this.oldPan) < 40000 && Math.abs(tilt - this.oldTilt) < 40000 && Math.abs(zoom - this.oldZoom) < 40000 && pan != 0 || tilt != 0)) {
                        return 0;
                    }
                    this.oldPan = pan;
                    this.oldTilt = tilt;
                    this.oldZoom = zoom;
                    this.time = System.currentTimeMillis();
                    if (zoomSpeed != null) {
                        if (zoom == 0) {
                            this.time = System.currentTimeMillis();
                            NetworkHelper.readGetRequest((NetworkParameter)this.networkParameter, (String)"/command/ptzf.cgi?Move=stop,zoom", (int)Integer.MAX_VALUE, (boolean)false, null, (boolean)true);
                            this.interval = (9 * this.interval + (int)(System.currentTimeMillis() - this.time)) / 10;
                        } else {
                            zoom = Math.abs(zoom);
                            zoom = (zoom = zoom / 12501 + 1) < 1 ? 1 : zoom;
                            int n = zoom = zoom > 8 ? 8 : zoom;
                            if (zoomSpeed > 0) {
                                this.time = System.currentTimeMillis();
                                NetworkHelper.readGetRequest((NetworkParameter)this.networkParameter, (String)("/command/ptzf.cgi?Move=tele," + zoom), (int)Integer.MAX_VALUE, (boolean)false, null, (boolean)true);
                                this.interval = (9 * this.interval + (int)(System.currentTimeMillis() - this.time)) / 10;
                            } else {
                                this.time = System.currentTimeMillis();
                                NetworkHelper.readGetRequest((NetworkParameter)this.networkParameter, (String)("/command/ptzf.cgi?Move=wide," + zoom), (int)Integer.MAX_VALUE, (boolean)false, null, (boolean)true);
                                this.interval = (9 * this.interval + (int)(System.currentTimeMillis() - this.time)) / 10;
                            }
                        }
                    }
                    if (tiltSpeed != null || panSpeed != null) {
                        if (pan == 0 && tilt == 0) {
                            this.time = System.currentTimeMillis();
                            NetworkHelper.readGetRequest((NetworkParameter)this.networkParameter, (String)"/command/ptzf.cgi?Move=stop,motor", (int)Integer.MAX_VALUE, (boolean)false, null, (boolean)true);
                            this.interval = (9 * this.interval + (int)(System.currentTimeMillis() - this.time)) / 10;
                        } else {
                            String direction = "";
                            if (tilt > 5000 && pan > 5000) {
                                direction = "up-right";
                            } else if (Math.abs(tilt) < 5000 && pan > 5000) {
                                direction = "right";
                            } else if (tilt < -5000 && pan > 5000) {
                                direction = "down-right";
                            } else if (tilt < -5000 && Math.abs(pan) < 5000) {
                                direction = "down";
                            } else if (tilt < -5000 && pan < -5000) {
                                direction = "down-left";
                            } else if (Math.abs(tilt) < 5000 && pan < -5000) {
                                direction = "left";
                            } else if (tilt > 5000 && pan < -5000) {
                                direction = "up-left";
                            } else if (tilt > 5000 && Math.abs(pan) < 5000) {
                                direction = "up";
                            }
                            int speed = 0;
                            speed = direction.equals("up") || direction.equals("down") ? Math.abs(tilt) : (direction.equals("right") || direction.equals("left") ? Math.abs(pan) : (2 * Math.abs(pan /= 1000) + Math.abs(tilt /= 1000)) / 3);
                            if (!direction.isEmpty()) {
                                this.time = System.currentTimeMillis();
                                NetworkHelper.readGetRequest((NetworkParameter)this.networkParameter, (String)("/command/ptzf.cgi?Move=" + direction + "," + speed), (int)Integer.MAX_VALUE, (boolean)false, null, (boolean)true);
                                this.interval = (9 * this.interval + (int)(System.currentTimeMillis() - this.time)) / 10;
                            }
                        }
                    }
                } else {
                    if (zoomSpeed != null) {
                        int speedStep = this.scaleToMaxSeven(zoom);
                        if (zoom == 0) {
                            if (this.videoSrv.getEntityType() == 210505L) {
                                this.sendPostRequest("/command/ptzf.cgi", "VISCA=8101040700FF");
                            }
                            return this.sendPostRequest("/command/ptzf.cgi", "VISCA=8101040700FF");
                        }
                        if (speedStep > 0) {
                            return this.sendPostRequest("/command/ptzf.cgi", "VISCA=810104072" + speedStep + "FF");
                        }
                        return this.sendPostRequest("/command/ptzf.cgi", "VISCA=810104073" + -speedStep + "FF");
                    }
                    if (pan == 0 && tilt == 0) {
                        return this.sendPostRequest("/command/ptzf.cgi", "VISCA=8101060100000303FF");
                    }
                    this.sendPostRequest("/command/ptzf.cgi", "VISCA=8101062403FF");
                    String sPanSpeedStep = null;
                    int panSpeedStep = 0;
                    if (pan != 0) {
                        panSpeedStep = pan / 4000;
                        if (panSpeedStep > 0) {
                            sPanSpeedStep = "0" + Integer.toHexString(panSpeedStep);
                            sPanSpeedStep = sPanSpeedStep.substring(sPanSpeedStep.length() - 2);
                        } else {
                            sPanSpeedStep = "0" + Integer.toHexString(-panSpeedStep);
                            sPanSpeedStep = sPanSpeedStep.substring(sPanSpeedStep.length() - 2);
                        }
                    }
                    String sTiltSpeedStep = null;
                    int tiltSpeedStep = 0;
                    if (tilt != 0) {
                        tiltSpeedStep = tilt / 4761;
                        if (tiltSpeedStep > 0) {
                            sTiltSpeedStep = "0" + Integer.toHexString(tiltSpeedStep);
                            sTiltSpeedStep = sTiltSpeedStep.substring(sTiltSpeedStep.length() - 2);
                        } else {
                            sTiltSpeedStep = "0" + Integer.toHexString(-tiltSpeedStep);
                            sTiltSpeedStep = sTiltSpeedStep.substring(sTiltSpeedStep.length() - 2);
                        }
                    }
                    if (panSpeedStep != 0 && tiltSpeedStep == 0) {
                        if (panSpeedStep > 0) {
                            return this.sendPostRequest("/command/ptzf.cgi", "VISCA=81010601" + sPanSpeedStep + "000103FF");
                        }
                        return this.sendPostRequest("/command/ptzf.cgi", "VISCA=81010601" + sPanSpeedStep + "000203FF");
                    }
                    if (panSpeedStep == 0 && tiltSpeedStep != 0) {
                        if (tiltSpeedStep > 0) {
                            return this.sendPostRequest("/command/ptzf.cgi", "VISCA=8101060100" + sTiltSpeedStep + "0302FF");
                        }
                        return this.sendPostRequest("/command/ptzf.cgi", "VISCA=8101060100" + sTiltSpeedStep + "0301FF");
                    }
                    if (panSpeedStep != 0 && tiltSpeedStep != 0) {
                        if (panSpeedStep > 0 && tiltSpeedStep > 0) {
                            return this.sendPostRequest("/command/ptzf.cgi", "VISCA=81010601" + sPanSpeedStep + sTiltSpeedStep + "0102FF");
                        }
                        if (panSpeedStep > 0 && tiltSpeedStep <= 0) {
                            return this.sendPostRequest("/command/ptzf.cgi", "VISCA=81010601" + sPanSpeedStep + sTiltSpeedStep + "0101FF");
                        }
                        if (panSpeedStep <= 0 && tiltSpeedStep > 0) {
                            return this.sendPostRequest("/command/ptzf.cgi", "VISCA=81010601" + sPanSpeedStep + sTiltSpeedStep + "0202FF");
                        }
                        if (panSpeedStep <= 0 && tiltSpeedStep <= 0) {
                            return this.sendPostRequest("/command/ptzf.cgi", "VISCA=81010601" + sPanSpeedStep + sTiltSpeedStep + "0201FF");
                        }
                    }
                }
            }
            return 0;
        }
        catch (Throwable ex) {
            this.logger.error((Object)ex, ex);
            return -21600;
        }
    }

    protected int scaleToMaxSeven(int zoom) {
        zoom = zoom >= 0 ? zoom - 1 : zoom + 1;
        return zoom / 12500;
    }

    @Override
    public int setCenterPT(Integer xPosition, Integer yPosition, int[] resolution) {
        try {
            int[] pos = this.calcCenterPT(xPosition, yPosition, resolution[0], resolution[1]);
            if (((SonyDevice)this.videoSrv.getDevice()).getSonyGeneration() > 5) {
                return this.sendCameraCommand("/command/ptzf.cgi?AreaZoom=" + pos[0] + "," + pos[1] + "," + resolution[0] + "," + resolution[1], true);
            }
            if (((SonyDevice)this.videoSrv.getDevice()).getSonyGeneration() == 5) {
                return this.sendCameraCommand("/command/ptzf.cgi?AreaZoom=" + pos[0] + "," + pos[1] + "," + resolution[0] + "," + resolution[1], true);
            }
        }
        catch (Exception ex) {
            this.logger.error("Exception while reading PTZ configuration for: " + this, (Throwable)ex);
        }
        return 0;
    }

    protected final int[] calcCenterPT(Integer x, Integer y, int w, int h) throws SeeTecException {
        if (x == null || x < 0 || x > 100 || y == null || y < 0 || y > 100 || w <= 0 || h <= 0) {
            throw new SeeTecException(-21653, "Invalid CenterPT parameters for " + this.videoSrv + ": x=" + x + ",y=" + y + ",w=" + w + ",h=" + h);
        }
        return new int[]{w * (x - 50) / 100, h * (y - 50) / 100};
    }

    @Override
    public int setZoomArea(Integer xPosition, Integer yPosition, Integer width, Integer height, int[] res) {
        try {
            CameraPosition camPos = this.calculateZoomAreaPoints(xPosition, yPosition, width, height, res);
            if (this.videoSrv.getDevice().getDeviceType() == 200610L || this.videoSrv.getDevice().getDeviceType() == 200655L || this.videoSrv.getDevice().getDeviceType() == 200654L || this.videoSrv.getDevice().getDeviceType() == 200652L || this.videoSrv.getDevice().getDeviceType() == 200640L || this.videoSrv.getDevice().getDeviceType() == 200641L || this.videoSrv.getDevice().getDeviceType() == 200642L || this.videoSrv.getDevice().getDeviceType() == 200643L || this.videoSrv.getDevice().getDeviceType() == 200628L || this.videoSrv.getDevice().getDeviceType() == 200629L || this.videoSrv.getDevice().getDeviceType() == 200630L || this.videoSrv.getDevice().getDeviceType() == 200631L || this.videoSrv.getDevice().getDeviceType() == 200632L) {
                return this.sendCameraCommand("/command/ptzf.cgi?AreaZoom=" + camPos.absolutMiddleX + "," + camPos.absolutMiddleY + "," + camPos.absolutWidth + "," + camPos.absolutHeigth, true);
            }
        }
        catch (Exception ex) {
            this.logger.error("Exception while reading PTZ configuration for: " + this, (Throwable)ex);
        }
        return 0;
    }

    private void refreshAbsolutePosition(boolean sendStatus) {
        try {
            if (this.cameraConfig != null) {
                byte[] readGetRequest = NetworkHelper.readGetRequest((NetworkParameter)this.networkParameter, (String)SonyQuery.inquiry().ptzf().toString(), (int)Integer.MAX_VALUE, (boolean)true);
                String parameters = new String(readGetRequest);
                HashMap<String, String> cameraInfo = new HashMap<String, String>();
                Tools.parseParameters(cameraInfo, parameters);
                this.ptzInfo.setMinZoom(this.cameraConfig.getFeatures().getMinAbsoluteZoom());
                this.ptzInfo.setMaxZoom(this.cameraConfig.getFeatures().getMaxAbsoluteZoom());
                this.ptzInfo.setPan(SonyCamResponseHelper.getIntParameter(cameraInfo, SonyCamResponseHelper.INQUIRY_PTZF_PARAMETERS.PTZF_ABSOLUTE_PTZF, 0));
                this.ptzInfo.setTilt(SonyCamResponseHelper.getIntParameter(cameraInfo, SonyCamResponseHelper.INQUIRY_PTZF_PARAMETERS.PTZF_ABSOLUTE_PTZF, 1));
                this.ptzInfo.setZoom(SonyCamResponseHelper.getIntParameter(cameraInfo, SonyCamResponseHelper.INQUIRY_PTZF_PARAMETERS.PTZF_ABSOLUTE_PTZF, 2));
                if (sendStatus) {
                    this.videoSrv.sendStatusAbsolutePTZ(null, this.ptzInfo.getPan(), this.ptzInfo.getTilt(), this.ptzInfo.getZoom());
                }
            }
        }
        catch (SeeTecException ex) {
            this.logger.error((Object)((Object)ex) + " for " + this, (Throwable)ex);
        }
    }

    public CameraPosition calculateZoomAreaPoints(Integer nXPosition, Integer nYPosition, Integer nWidth, Integer nHeigth, int[] resolution) {
        CameraPosition camPos = new CameraPosition(0, 0, 0, 0, 0, 0);
        if (resolution != null) {
            int width = resolution[0];
            int heigth = resolution[1];
            camPos.absolutX = width * nXPosition / 100;
            camPos.absolutY = heigth * nYPosition / 100;
            camPos.absolutWidth = width * nWidth / 100;
            camPos.absolutHeigth = heigth * nHeigth / 100;
            camPos.absolutMiddleX = camPos.absolutWidth / 2 + camPos.absolutX - width / 2;
            camPos.absolutMiddleY = camPos.absolutHeigth / 2 + camPos.absolutY - heigth / 2;
        }
        return camPos;
    }

    @Override
    public int setAbsoluteIris(Integer value) {
        return this.sendCameraCommand("&iris=" + value / 1000);
    }

    @Override
    public int setContinuousIris(Integer value) {
        if (this.videoSrv.getDevice().getDeviceType() == 200623L) {
            try {
                int channelNo = this.videoSrv.getVideoSourceCnf().getServerEntryNo();
                if (value != null) {
                    if (value > 0) {
                        return this.sendCameraCommand("/command/ptzf.cgi?ChannelNo=" + channelNo + "&Ptzfopen", true);
                    }
                    if (value < 0) {
                        return this.sendCameraCommand("/command/ptzf.cgi?ChannelNo=" + channelNo + "&Ptzfclose", true);
                    }
                    return this.sendCameraCommand("/command/ptzf.cgi?ChannelNo=" + channelNo + "&Ptzfistop", true);
                }
            }
            catch (Exception e) {
                this.logger.warn("Unable to get channelNo for " + this.videoSrv);
            }
            return 0;
        }
        if (this.videoSrv.getDevice().getDeviceType() == 200624L || this.videoSrv.getDevice().getDeviceType() == 200634L || this.videoSrv.getDevice().getDeviceType() == 200625L || this.videoSrv.getDevice().getDeviceType() == 200635L || this.videoSrv.getDevice().getDeviceType() == 200626L || this.videoSrv.getDevice().getDeviceType() == 200627L || this.videoSrv.getDevice().getDeviceType() == 200636L || this.videoSrv.getDevice().getDeviceType() == 200630L || this.videoSrv.getDevice().getDeviceType() == 200631L || this.videoSrv.getDevice().getDeviceType() == 200632L || ((SonyDevice)this.videoSrv.getDevice()).getSonyGeneration() > 5) {
            if (value != null) {
                int irisValue = value;
                if (irisValue < 0) {
                    this.sendCameraCommand("/command/camera.cgi?Irismove=close", true);
                } else if (irisValue > 0) {
                    this.sendCameraCommand("/command/camera.cgi?Irismove=open", true);
                } else {
                    this.sendCameraCommand("/command/camera.cgi?Irismove=stop", true);
                }
            }
            return 0;
        }
        return this.sendContinuousCommand("iris", value);
    }

    @Override
    public int setAutoIris(Boolean active) {
        if (this.videoSrv.getDevice().getDeviceType() == 200624L || this.videoSrv.getDevice().getDeviceType() == 200634L || this.videoSrv.getDevice().getDeviceType() == 200625L || this.videoSrv.getDevice().getDeviceType() == 200635L || this.videoSrv.getDevice().getDeviceType() == 200626L || this.videoSrv.getDevice().getDeviceType() == 200627L || this.videoSrv.getDevice().getDeviceType() == 200636L || this.videoSrv.getDevice().getDeviceType() == 200630L || this.videoSrv.getDevice().getDeviceType() == 200631L || this.videoSrv.getDevice().getDeviceType() == 200632L || ((SonyDevice)this.videoSrv.getDevice()).getSonyGeneration() > 5) {
            if (active.booleanValue()) {
                this.sendCameraCommand("/command/camera.cgi?IrisMode=auto", true);
            } else {
                this.sendCameraCommand("/command/camera.cgi?IrisMode=manual", true);
            }
        }
        if (active.booleanValue()) {
            return this.sendCameraCommand("&autoiris=on");
        }
        return this.sendCameraCommand("&autoiris=off");
    }

    @Override
    public int setAbsoluteFocus(Integer value) {
        return this.sendCameraCommand("&focus=" + value / 1000);
    }

    @Override
    public int setContinuousFocus(Integer value) {
        if (this.videoSrv.getDevice().getDeviceType() == 200623L) {
            try {
                int channelNo = this.videoSrv.getVideoSourceCnf().getServerEntryNo();
                if (value != null) {
                    if (value > 0) {
                        return this.sendCameraCommand("/command/ptzf.cgi?ChannelNo=" + channelNo + "&Ptzfnear", true);
                    }
                    if (value < 0) {
                        return this.sendCameraCommand("/command/ptzf.cgi?ChannelNo=" + channelNo + "&Ptzffar", true);
                    }
                    return this.sendCameraCommand("/command/ptzf.cgi?ChannelNo=" + channelNo + "&Ptzffstop", true);
                }
            }
            catch (Exception e) {
                this.logger.warn("Unable to get channelNo for " + this.videoSrv);
            }
            return 0;
        }
        if (this.videoSrv.getDevice().getDeviceType() == 200625L || this.videoSrv.getDevice().getDeviceType() == 200635L || this.videoSrv.getDevice().getDeviceType() == 200626L || this.videoSrv.getDevice().getDeviceType() == 200627L || this.videoSrv.getDevice().getDeviceType() == 200636L || this.videoSrv.getDevice().getDeviceType() == 200628L || this.videoSrv.getDevice().getDeviceType() == 200629L || this.videoSrv.getDevice().getDeviceType() == 200630L || this.videoSrv.getDevice().getDeviceType() == 200631L || this.videoSrv.getDevice().getDeviceType() == 200632L || this.videoSrv.getDevice().getDeviceType() == 200640L || this.videoSrv.getDevice().getDeviceType() == 200641L || this.videoSrv.getDevice().getDeviceType() == 200642L || this.videoSrv.getDevice().getDeviceType() == 200643L) {
            if (value != null) {
                int focusValue = value;
                if (focusValue < 0) {
                    this.sendCameraCommand("/command/ptzf.cgi?Mode=near,4", true);
                } else if (focusValue > 0) {
                    this.sendCameraCommand("/command/ptzf.cgi?Mode=far,4", true);
                } else {
                    this.sendCameraCommand("/command/ptzf.cgi?Move=stop,focus", true);
                }
            }
            return 0;
        }
        if (((SonyDevice)this.videoSrv.getDevice()).getSonyGeneration() > 5) {
            if (value != null) {
                int focusValue = value;
                if (focusValue > 0) {
                    this.sendCameraCommand("/command/camera.cgi?FocusMode=manual", true);
                    this.sendCameraCommand("/command/ptzf.cgi?Move=near,4", true);
                } else if (focusValue < 0) {
                    this.sendCameraCommand("/command/camera.cgi?FocusMode=manual", true);
                    this.sendCameraCommand("/command/ptzf.cgi?Move=far,4", true);
                } else {
                    this.sendCameraCommand("/command/ptzf.cgi?Move=stop,focus", true);
                }
            }
            return 0;
        }
        return this.sendContinuousCommand("focus", value);
    }

    @Override
    public int setAutoFocus(Boolean active) {
        if (this.videoSrv.getDevice().getDeviceType() == 200624L || this.videoSrv.getDevice().getDeviceType() == 200634L || this.videoSrv.getDevice().getDeviceType() == 200625L || this.videoSrv.getDevice().getDeviceType() == 200635L || this.videoSrv.getDevice().getDeviceType() == 200626L || this.videoSrv.getDevice().getDeviceType() == 200627L || this.videoSrv.getDevice().getDeviceType() == 200636L || this.videoSrv.getDevice().getDeviceType() == 200630L || this.videoSrv.getDevice().getDeviceType() == 200631L || this.videoSrv.getDevice().getDeviceType() == 200632L || this.videoSrv.getDevice().getDeviceType() == 200611L || ((SonyDevice)this.videoSrv.getDevice()).getSonyGeneration() > 5) {
            if (active.booleanValue()) {
                this.sendCameraCommand("/command/camera.cgi?FocusMode=auto", true);
            } else {
                this.sendCameraCommand("/command/camera.cgi?FocusMode=manual", true);
            }
        }
        if (active.booleanValue()) {
            return this.sendCameraCommand("&autofocus=on");
        }
        return this.sendCameraCommand("&autofocus=off");
    }

    @Override
    public int setZeroLux(Boolean active) {
        if (this.videoSrv.getDevice().getDeviceType() == 200624L || this.videoSrv.getDevice().getDeviceType() == 200634L || this.videoSrv.getDevice().getDeviceType() == 200625L || this.videoSrv.getDevice().getDeviceType() == 200635L || this.videoSrv.getDevice().getDeviceType() == 200626L || this.videoSrv.getDevice().getDeviceType() == 200627L || this.videoSrv.getDevice().getDeviceType() == 200636L || this.videoSrv.getDevice().getDeviceType() == 200628L || this.videoSrv.getDevice().getDeviceType() == 200629L || this.videoSrv.getDevice().getDeviceType() == 200640L || this.videoSrv.getDevice().getDeviceType() == 200641L || this.videoSrv.getDevice().getDeviceType() == 200642L || this.videoSrv.getDevice().getDeviceType() == 200643L) {
            this.sendCameraCommand("/command/camera.cgi?DayNightMode=manual", true);
            this.sendCameraCommand("/command/camera.cgi?DnManualFunc=on", true);
            if (active.booleanValue()) {
                this.sendCameraCommand("/command/main.cgi?Trigger=daynighton", true);
            } else {
                this.sendCameraCommand("/command/main.cgi?Trigger=daynightoff", true);
            }
        } else if (((SonyDevice)this.videoSrv.getDevice()).getSonyGeneration() > 5) {
            this.sendCameraCommand("/command/ircf.cgi?IRCutFilterMode=manual", true);
            if (active.booleanValue()) {
                this.sendCameraCommand("command/ircf.cgi?IRCutFilterManual=on", true);
            } else {
                this.sendCameraCommand("/command/ircf.cgi?IRCutFilterManual=off", true);
            }
        } else {
            try {
                String cmd = active != false ? "VISCA=8101040102FF" : "VISCA=8101040103FF";
                int errorCode = this.sendPostRequest("/command/ptzf.cgi", cmd);
                if (errorCode != 0) {
                    return errorCode;
                }
            }
            catch (Throwable ex) {
                this.logger.error((Object)ex, ex);
                return -21600;
            }
        }
        return 0;
    }

    @Override
    public int setAutoZeroLux(Boolean active) {
        this.logger.warn("Feature [ setAutoZeroLux ] not yet implemented!");
        return 0;
    }

    @Override
    public int setHomePosition() {
        this.videoSrv.notifyForCameraControl();
        try {
            if (this.videoSrv.getEntityType() == 210505L || this.videoSrv.getEntityType() == 210509L || this.videoSrv.getEntityType() == 210510L) {
                return 0;
            }
            if (this.videoSrv.getDevice().getDeviceType() == 200623L) {
                int channelNo = this.videoSrv.getVideoSourceCnf().getServerEntryNo();
                return this.sendCameraCommand("/command/ptzf.cgi?ChannelNo=" + channelNo + "&Ptzfhome", true);
            }
            return this.sendPostRequest("/command/ptzf.cgi", "VISCA=81010604FF");
        }
        catch (Throwable ex) {
            this.logger.error((Object)ex, ex);
            return -21600;
        }
    }

    @Override
    public int addPresetPosition(Vector<byte[]> vResult, Long presetID, String presetName) {
        int presetPosition = -1;
        String encodedPresetName = null;
        try {
            int i;
            int bitVector = 0;
            for (i = 0; i < this.presetList.size(); ++i) {
                PresetCnf presetCnf = this.presetList.elementAt(i);
                bitVector |= 1 << Integer.parseInt(presetCnf.getPresetPosition());
            }
            for (i = 1; i <= 30; ++i) {
                if ((bitVector & 1 << i) != 0) continue;
                presetPosition = i;
                break;
            }
            if (presetPosition < 0) {
                this.logger.error("Cannot add preset [ " + presetName + " ], 'cause no more free preset positions are available for " + this + " :-( ");
                return -21600;
            }
            encodedPresetName = URLEncoder.encode(presetName.trim(), "UTF-8");
            if (this.videoSrv.getEntityType() == 210509L || this.videoSrv.getEntityType() == 210510L) {
                this.sendCameraCommand("/command/ptzf.cgi?PresetSet=" + presetPosition + "," + encodedPresetName, true);
            } else if (this.videoSrv.getDevice().getDeviceType() == 200623L) {
                int channelNo = this.videoSrv.getVideoSourceCnf().getServerEntryNo();
                this.sendCameraCommand("/command/presetset.cgi?ChannelNo=" + channelNo + "&PresetNo=" + presetPosition + "&PresetName=" + encodedPresetName, true);
            } else if (this.videoSrv.getDevice().getDeviceType() == 200628L || this.videoSrv.getDevice().getDeviceType() == 200629L || this.videoSrv.getDevice().getDeviceType() == 200630L || this.videoSrv.getDevice().getDeviceType() == 200631L || this.videoSrv.getDevice().getDeviceType() == 200632L || this.videoSrv.getDevice().getDeviceType() == 200640L || this.videoSrv.getDevice().getDeviceType() == 200641L || this.videoSrv.getDevice().getDeviceType() == 200642L || this.videoSrv.getDevice().getDeviceType() == 200643L || ((SonyDevice)this.videoSrv.getDevice()).getSonyGeneration() > 5) {
                encodedPresetName = SonyCameraControl.encodeAndLimitPresetName(32, presetName);
                if (NetworkHelper.readGetRequest((NetworkParameter)this.networkParameter, (String)("/command/presetposition.cgi?PresetSet=" + presetPosition + "," + encodedPresetName + ",on"), (int)Integer.MIN_VALUE) == null) {
                    this.logger.error("Error setting preset");
                }
                NetworkHelper.readGetRequest((NetworkParameter)this.networkParameter, (String)"/command/inquiry.cgi?inqjs=camera", (int)Integer.MAX_VALUE, (boolean)true);
            } else {
                String visca = "VISCA=8101043F010" + Integer.toHexString((presetPosition - 1) % 15) + "FF";
                this.sendPostRequest("/command/ptzf.cgi", visca);
            }
            PresetCnf presetCnf = PresetCnf.createPresetCnf(presetID, "" + presetPosition, encodedPresetName);
            this.presetList.addElement(presetCnf);
            vResult.addElement(presetCnf.getPresetCnf());
            return 0;
        }
        catch (Throwable ex) {
            this.logger.error((Object)ex, ex);
            this.logger.error("Adding preset [ " + presetName + " ] failed");
            return -21600;
        }
    }

    @Override
    public int setPresetPosition(String presetName) {
        this.videoSrv.notifyForCameraControl();
        try {
            String encodedPresetName = URLEncoder.encode(presetName.trim(), "UTF-8");
            String encodedAndLimitedPresetName = SonyCameraControl.encodeAndLimitPresetName(32, presetName);
            for (int i = 0; i < this.presetList.size(); ++i) {
                PresetCnf presetCnf = this.presetList.elementAt(i);
                if (!encodedPresetName.equals(presetCnf.getPresetName()) && !encodedAndLimitedPresetName.equals(presetCnf.getPresetName()) && !presetName.equals(presetCnf.getPresetName())) continue;
                if (this.videoSrv.getEntityType() == 210509L || this.videoSrv.getEntityType() == 210510L) {
                    String sCMD = "PresetCall=" + Integer.parseInt(presetCnf.getPresetPosition()) + ",24";
                    return this.sendPostRequest("/command/presetposition.cgi", sCMD);
                }
                if (this.videoSrv.getDevice().getDeviceType() == 200628L || this.videoSrv.getDevice().getDeviceType() == 200629L || this.videoSrv.getDevice().getDeviceType() == 200630L || this.videoSrv.getDevice().getDeviceType() == 200631L || this.videoSrv.getDevice().getDeviceType() == 200632L || this.videoSrv.getDevice().getDeviceType() == 200640L || this.videoSrv.getDevice().getDeviceType() == 200641L || this.videoSrv.getDevice().getDeviceType() == 200642L || this.videoSrv.getDevice().getDeviceType() == 200643L || ((SonyDevice)this.videoSrv.getDevice()).getSonyGeneration() > 5) {
                    String cmd = "PresetCall=" + Integer.parseInt(presetCnf.getPresetPosition()) + ",24";
                    if (NetworkHelper.readGetRequest((NetworkParameter)this.networkParameter, (String)("/command/presetposition.cgi?" + cmd), (int)Integer.MAX_VALUE, (boolean)false, null, (boolean)true) == null) {
                        this.logger.error("Error going to preset position");
                    }
                    NetworkHelper.readGetRequest((NetworkParameter)this.networkParameter, (String)"/command/inquiry.cgi?inqjs=camera", (int)Integer.MAX_VALUE, (boolean)true);
                    return 0;
                }
                if (this.videoSrv.getDevice().getDeviceType() == 200623L) {
                    int channelNo = this.videoSrv.getVideoSourceCnf().getServerEntryNo();
                    return this.sendCameraCommand("/command/presetcall.cgi?ChannelNo=" + channelNo + "&PresetNo=" + Integer.parseInt(presetCnf.getPresetPosition()), true);
                }
                String visca = "VISCA=8101043F020" + Integer.toHexString((Integer.parseInt(presetCnf.getPresetPosition()) - 1) % 15) + "FF";
                return this.sendPostRequest("/command/ptzf.cgi", visca);
            }
        }
        catch (Throwable ex) {
            this.logger.error((Object)ex, ex);
            this.logger.error("Setting preset [ " + presetName + " ] failed");
            return -21600;
        }
        this.logger.error("Preset [ " + presetName + " ] not available");
        this.logger.error("PresetList=" + this.presetList);
        return -21683;
    }

    @Override
    public int removePresetPosition(String presetName) {
        try {
            String encodedPresetName = URLEncoder.encode(presetName.trim(), "UTF-8");
            String encodedAndLimitedPresetName = SonyCameraControl.encodeAndLimitPresetName(32, presetName);
            for (int i = 0; i < this.presetList.size(); ++i) {
                PresetCnf presetCnf = this.presetList.elementAt(i);
                if (!encodedPresetName.equals(presetCnf.getPresetName()) && !encodedAndLimitedPresetName.equals(presetCnf.getPresetName()) && !presetName.equals(presetCnf.getPresetName())) continue;
                this.logger.info("Removing preset: " + new String(presetCnf.getPresetCnf()));
                this.presetList.removeElementAt(i);
                if (this.videoSrv.getEntityType() == 210509L || this.videoSrv.getEntityType() == 210510L) {
                    String sCMD = "PresetClear=" + Integer.parseInt(presetCnf.getPresetPosition());
                    return this.sendPostRequest("/command/presetposition.cgi", sCMD);
                }
                if (this.videoSrv.getDevice().getDeviceType() == 200623L) {
                    int channelNo = this.videoSrv.getVideoSourceCnf().getServerEntryNo();
                    return this.sendCameraCommand("/command/presetclear.cgi?ChannelNo=" + channelNo + "&PresetNo=" + Integer.parseInt(presetCnf.getPresetPosition()), true);
                }
                if (this.videoSrv.getDevice().getDeviceType() == 200628L || this.videoSrv.getDevice().getDeviceType() == 200629L || this.videoSrv.getDevice().getDeviceType() == 200630L || this.videoSrv.getDevice().getDeviceType() == 200631L || this.videoSrv.getDevice().getDeviceType() == 200632L || this.videoSrv.getDevice().getDeviceType() == 200640L || this.videoSrv.getDevice().getDeviceType() == 200641L || this.videoSrv.getDevice().getDeviceType() == 200642L || this.videoSrv.getDevice().getDeviceType() == 200643L || ((SonyDevice)this.videoSrv.getDevice()).getSonyGeneration() > 5) {
                    if (NetworkHelper.readGetRequest((NetworkParameter)this.networkParameter, (String)("/command/presetposition.cgi?PresetClear=" + Integer.parseInt(presetCnf.getPresetPosition())), (int)Integer.MIN_VALUE) == null) {
                        this.logger.error("Error removing preset");
                    }
                    NetworkHelper.readGetRequest((NetworkParameter)this.networkParameter, (String)"/command/inquiry.cgi?inqjs=camera", (int)Integer.MAX_VALUE, (boolean)true);
                    return 0;
                }
                String visca = "VISCA=8101043F000" + Integer.toHexString((Integer.parseInt(presetCnf.getPresetPosition()) - 1) % 15) + "FF";
                return this.sendPostRequest("/command/ptzf.cgi", visca);
            }
        }
        catch (Exception ex) {
            this.logger.error((Object)ex, (Throwable)ex);
            this.logger.error("Removing preset [ " + presetName + " ] failed");
            return -21600;
        }
        this.logger.error("Preset [ " + presetName + " ] not available");
        this.logger.error("PresetList=" + this.presetList);
        return -21683;
    }

    private int sendPostRequest(String url, String body) {
        try {
            NetworkHelper.readPostRequest((NetworkParameter)this.networkParameter, (String)url, (String)body, (boolean)true);
        }
        catch (SeeTecException ex) {
            return ex.getErrorCode();
        }
        return 0;
    }

    @Override
    public int addCameraPresets(ArrayOfCameraPreset presets) {
        if (presets == null) {
            this.logger.warn("Received null camera presets object in addCameraPresets!");
            return -20002;
        }
        List<CameraPreset> cameraPresets = presets.getCameraPreset();
        for (CameraPreset cameraPreset : cameraPresets) {
            try {
                Element ptzPosition;
                byte[] cameraPresetPtzData = cameraPreset.getPtzData().getBytes(StandardCharsets.UTF_8);
                ByteArrayInputStream bais = new ByteArrayInputStream(cameraPresetPtzData);
                Document ptzDocument = new SAXBuilder().build((InputStream)bais);
                String presetPosition = "1";
                Element root = ptzDocument.getRootElement();
                if (root != null && (ptzPosition = root.getChild("PresetPosition")) != null) {
                    presetPosition = ptzPosition.getText().trim();
                }
                PresetCnf presetCnf = PresetCnf.createPresetCnf(cameraPreset.getId(), presetPosition, this.getEncodedPresetName(cameraPreset.getName()));
                this.presetList.addElement(presetCnf);
            }
            catch (Throwable ex) {
                this.logger.error("Error while setting camera preset for " + this);
            }
        }
        return 0;
    }

    @Override
    public ArrayOfCameraPreset getPresetsFromCamera() {
        try {
            String url = "/command/inquiry.cgi?inq=presetposition";
            String result = new String(NetworkHelper.readGetRequest((NetworkParameter)this.networkParameter, (String)url, (int)Integer.MAX_VALUE), StandardCharsets.UTF_8);
            String[] results = result.split("&");
            ArrayOfCameraPreset cameraPresets = new ArrayOfCameraPreset();
            for (String resultLine : results) {
                if (!resultLine.toLowerCase().contains("presetpos")) continue;
                String[] presetPosLines = resultLine.split("=", 2);
                if (presetPosLines.length > 1) {
                    String presetPosLine = presetPosLines[1];
                    String[] presetData = presetPosLine.split(",");
                    for (int i = 0; i < presetData.length; i += 6) {
                        String position = presetData[i];
                        String name = presetData[i + 1];
                        if (name.toLowerCase().equals("homeposition")) continue;
                        CameraPreset cameraPreset = new CameraPreset();
                        cameraPreset.setName(name);
                        PresetCnf presetCnf = PresetCnf.createPresetCnf(cameraPreset.getId(), position, name);
                        try {
                            cameraPreset.setPtzData(new String(presetCnf.getPresetCnf(), "UTF-8"));
                            cameraPreset.setName(presetCnf.getPresetName());
                        }
                        catch (ConfigurationException ex) {
                            this.logger.error("Exception while adding preset position for " + this + " : " + ex.getMessage());
                        }
                        cameraPresets.getCameraPreset().add(cameraPreset);
                    }
                }
                return cameraPresets;
            }
        }
        catch (SeeTecException ex) {
            this.logger.error((Object)((Object)ex) + " for " + this, (Throwable)ex);
        }
        catch (UnsupportedEncodingException ex) {
            throw new RuntimeException(ex.getMessage());
        }
        return new ArrayOfCameraPreset();
    }

    public static String encodeAndLimitPresetName(int numberOfDigits, String presetName) throws UnsupportedEncodingException {
        String encodedPresetName = URLEncoder.encode(presetName, "UTF-8");
        while (SonyCameraControl.countEncodedLength(encodedPresetName) > numberOfDigits) {
            encodedPresetName = URLDecoder.decode(encodedPresetName, "UTF-8");
            encodedPresetName = encodedPresetName.substring(0, encodedPresetName.length() - 1);
            encodedPresetName = URLEncoder.encode(encodedPresetName, "UTF-8");
        }
        return encodedPresetName;
    }

    public static int countEncodedLength(String presetName) {
        int length = presetName.length();
        String presetNameWithoutEscape = presetName.replace("%", "");
        int numberOfEscapeCharacters = presetName.length() - presetNameWithoutEscape.length();
        return length - 2 * numberOfEscapeCharacters;
    }
}

