/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.cm.device.video.sony;

import de.seetec.v5.re.cm.device.shared.AudioOutServer;
import de.seetec.v5.re.shared.MediaFrame;
import de.seetec.v5.shared.net.HTTPHeader;
import de.seetec.v5.shared.net.HTTPResponse;
import de.seetec.v5.shared.net.HTTPStatusCode;
import de.seetec.v5.shared.net.NetworkHelper;
import de.seetec.v5.shared.net.NetworkParameter;
import de.seetec.v5.shared.util.SeeTecException;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.net.SocketException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SonyAudioOutServer
extends AudioOutServer
implements Runnable {
    private final NetworkParameter networkParameter;
    private final Logger logger;
    private Socket postSocket;
    private boolean isShutdown = false;
    private Thread thread;
    private boolean initializing;
    private String urlSendAudio;
    private String urlOpenAudio;

    public SonyAudioOutServer(NetworkParameter networkParameter) {
        if (networkParameter == null) {
            throw new IllegalArgumentException("NetworkParameter is null for HikvisionAudioOutServer");
        }
        this.networkParameter = networkParameter;
        this.logger = LogManager.getLogger(this.getClass());
        this.urlSendAudio = "/audio-out/g711_64.cgi";
        this.urlOpenAudio = "/command/camera.cgi?AudioOut=on";
    }

    public int init() {
        this.initializing = true;
        this.thread = new Thread((Runnable)this, this.getClass().getName());
        this.thread.start();
        return 0;
    }

    private void sendAudio(byte[] audioData) {
        try {
            this.establishStream();
            OutputStream os = this.postSocket.getOutputStream();
            os.write(audioData);
            os.flush();
        }
        catch (IOException iOException) {
            try {
                this.postSocket.close();
                this.postSocket = null;
                this.establishStream();
                OutputStream os = this.postSocket.getOutputStream();
                os.write(audioData);
                os.flush();
            }
            catch (IOException ioe) {
                this.logger.error("Sending audio data failed [" + iOException.getMessage() + "] for " + this);
            }
        }
    }

    private void establishStream() throws IOException {
        if (this.postSocket == null || this.postSocket.isClosed()) {
            if (!this.initializing) {
                this.closeConnection();
            }
            this.initializing = false;
            this.openConnection();
            this.postSocket = this.getPostSocket();
            this.establishPostStream();
        }
    }

    private Socket getPostSocket() {
        try {
            this.postSocket = this.networkParameter.useHTTPS() ? NetworkHelper.createNetworkConnection((String)this.networkParameter.getHost(), (int)this.networkParameter.getSSLport(), (boolean)true, (int)this.networkParameter.getSoTimeout()) : NetworkHelper.createNetworkConnection((String)this.networkParameter.getHost(), (int)this.networkParameter.getHTTPport(), (boolean)false, (int)this.networkParameter.getSoTimeout());
            this.postSocket.setSoTimeout(0);
            this.postSocket.setTcpNoDelay(true);
        }
        catch (SocketException ex) {
            this.logger.error("Error creating socket for " + this + " : " + ex.getMessage());
        }
        catch (Exception ex) {
            this.logger.error("Unexpected error while creating socket for " + this + " : " + ex.getMessage());
        }
        return this.postSocket;
    }

    private void establishPostStream() throws IOException {
        String authentication = this.createAudioOutAuthentication();
        OutputStream os = this.postSocket.getOutputStream();
        String postRequest = this.buildPostRequest(this.networkParameter.getHost(), authentication);
        os.write(postRequest.getBytes());
        os.flush();
        InputStream in = this.postSocket.getInputStream();
        if (in.available() > 0) {
            byte[] buffer = new byte[512];
            int bytesRead = in.read(buffer);
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            while (bytesRead > 0) {
                baos.write(buffer, 0, bytesRead);
                bytesRead = in.read(buffer);
            }
            HTTPResponse httpResponse = new HTTPResponse(baos.toByteArray());
            HTTPHeader httpHeader = httpResponse.getHttpHeader();
            if (httpHeader != null && httpHeader.getStatusCode() == HTTPStatusCode.HTTP_UNAUTHORIZED.getStatusCode()) {
                if (httpHeader.getRealm() != null) {
                    this.networkParameter.setRealm(httpHeader.getRealm());
                }
                if (httpHeader.getNonce() != null) {
                    this.networkParameter.setNonce(httpHeader.getNonce());
                }
                if (httpHeader.getQop() != null) {
                    this.networkParameter.setQop(httpHeader.getQop());
                }
                this.postSocket.close();
                this.getPostSocket();
                os = this.postSocket.getOutputStream();
                authentication = this.createAudioOutAuthentication();
                postRequest = this.buildPostRequest(this.networkParameter.getHost(), authentication);
                os.write(postRequest.getBytes());
                os.flush();
            }
        }
    }

    private String createAudioOutAuthentication() {
        String authentication = "";
        String realm = this.networkParameter.getRealm();
        String nonce = this.networkParameter.getNonce();
        String qop = this.networkParameter.getQop();
        if (realm != null && nonce != null) {
            try {
                String requestURL = "http://" + this.networkParameter.getHost() + this.urlSendAudio;
                authentication = NetworkHelper.createDigestAuthorization((NetworkParameter)this.networkParameter, (String)realm, (String)nonce, (String)"POST", (String)requestURL, (String)qop);
            }
            catch (Exception ex) {
                this.logger.error("Error creating authentication for " + this + " : " + ex.getMessage());
            }
        } else {
            authentication = NetworkHelper.createBasicAuthorization((String[])this.networkParameter.getUserPWD());
        }
        return authentication;
    }

    private String buildPostRequest(String host, String authentication) {
        String postRequest = "POST " + this.urlSendAudio + " HTTP/1.1" + "\r\n" + "Connection: Keep-Alive" + "\r\n" + "Host: " + host + "\r\n" + authentication + "\r\n";
        return postRequest;
    }

    @Override
    public void run() {
        while (!this.isShutdown) {
            try {
                MediaFrame mediaFrameToSend = this.take();
                for (byte[] singlePayLoad : mediaFrameToSend.getPayload()) {
                    this.sendAudio(singlePayLoad);
                }
            }
            catch (InterruptedException exception) {
                this.logger.info("Sending thread interrupted for " + this);
            }
        }
        this.logger.info("Shutting down " + this);
    }

    @Override
    public int shutdown() {
        this.isShutdown = true;
        this.thread.interrupt();
        try {
            if (this.postSocket != null) {
                this.postSocket.close();
            }
        }
        catch (IOException ioe) {
            this.logger.info("Error closing socket for " + this);
        }
        this.postSocket = null;
        return super.shutdown();
    }

    private void closeConnection() {
        try {
            this.postSocket.close();
        }
        catch (Exception ex) {
            this.logger.error("Error closing audio connection for " + this + " : " + ex.getMessage());
        }
    }

    private void openConnection() {
        try {
            NetworkHelper.readGetRequest((NetworkParameter)this.networkParameter, (String)this.urlOpenAudio, (int)Integer.MAX_VALUE);
        }
        catch (SeeTecException ex) {
            this.logger.error("Error opening audio connection for " + this + " : " + ex.getMessage());
        }
    }
}

