/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.cm.device.video.siqura;

import de.seetec.v5.re.cm.device.shared.io.DigitalInputSrv;
import de.seetec.v5.re.cm.device.shared.io.DigitalOutputSrv;
import de.seetec.v5.re.cm.device.shared.io.IOHandler;
import de.seetec.v5.re.cm.device.shared.onvif.OnvifCore;
import de.seetec.v5.re.cm.device.video.siqura.SiquraDevice;
import de.seetec.v5.shared.net.NetworkHelper;
import de.seetec.v5.shared.net.NetworkParameter;
import de.seetec.v5.shared.util.SeeTecException;
import java.io.IOException;
import java.net.ConnectException;
import java.net.NoRouteToHostException;
import java.net.UnknownHostException;
import java.util.List;
import org.onvif.ver10.deviceio.wsdl.DeviceIOPort;
import org.onvif.ver10.schema.RelayLogicalState;
import org.onvif.ver10.schema.RelayOutput;

public class SiquraIOHandler
extends IOHandler {
    private static final String CLASS_NAME = "de.seetec.v5.re.cm.device.video.siqura.SiquraIOHandler";
    private int errorCode;
    private DeviceIOPort deviceIOservice = null;
    private boolean alarm = false;

    @Override
    public void run() {
        super.setRunFinished(CLASS_NAME, false);
        try {
            boolean previousLoopWithError = false;
            while (!(this.isShutdown(CLASS_NAME) || super.isShutdown() || this.device.isShutdown())) {
                try {
                    long duration;
                    long ts = System.currentTimeMillis();
                    this.readDigitalInputs();
                    if (previousLoopWithError) {
                        previousLoopWithError = false;
                        this.logger.info("Publishing input stati after error for " + this + " ...");
                        DigitalInputSrv[] iServices = super.getDigitalInputSrv();
                        for (int i = 0; i < iServices.length; ++i) {
                            if (!iServices[i].getEntity().isEnabled().booleanValue()) continue;
                            iServices[i].publishServiceStatus(iServices[i].getInputStatus());
                        }
                    }
                    if ((duration = System.currentTimeMillis() - ts) < 0L || duration >= 190L) continue;
                    try {
                        Thread.sleep(200L - duration);
                    }
                    catch (InterruptedException interruptedException) {}
                }
                catch (Throwable ex) {
                    previousLoopWithError = true;
                    if (ex instanceof IOException || ex instanceof UnknownHostException || ex instanceof NoRouteToHostException || ex instanceof ConnectException) {
                        this.logger.warn("Network trouble for " + this);
                    } else {
                        this.logger.warn((Object)ex, ex);
                        if (ex.getMessage().contains("Address already in use")) {
                            this.logger.warn("TCP stack seems to be overloaded, so there are problems for " + this);
                        } else {
                            this.logger.warn("Unknown trouble for " + this);
                        }
                    }
                    try {
                        DigitalInputSrv[] iServices = super.getDigitalInputSrv();
                        for (int i = 0; i < iServices.length; ++i) {
                            if (!iServices[i].getEntity().isEnabled().booleanValue()) continue;
                            iServices[i].publishServiceStatus(-21603);
                        }
                    }
                    catch (Throwable t) {
                        this.logger.warn((Object)t, t);
                    }
                    long tsTimeout = System.currentTimeMillis() + 10000L;
                    while (tsTimeout > System.currentTimeMillis() && !this.isShutdown(CLASS_NAME) && !this.device.isShutdown()) {
                        try {
                            Thread.sleep(250L);
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                }
            }
        }
        catch (Throwable ex) {
            this.logger.error((Object)ex, ex);
        }
        this.logger.info("Thread of this " + this + " finished :-)");
        super.setRunFinished(CLASS_NAME, true);
        this.shutdown();
    }

    public void setAlarm(boolean alarm) {
        this.alarm = alarm;
    }

    @Override
    public DigitalInputSrv[] getDigitalInputSrv() {
        return super.getDigitalInputSrv();
    }

    private int readDigitalInputs() throws Exception {
        DigitalInputSrv[] iServices = super.getDigitalInputSrv();
        SiquraDevice siquraDevice = (SiquraDevice)this.device;
        if (siquraDevice.isOnvifDevice()) {
            if (this.alarm) {
                iServices[0].checkInput(1);
                iServices[1].checkInput(1);
            } else {
                iServices[0].checkInput(0);
                iServices[1].checkInput(0);
            }
        } else {
            StringBuilder sbURL = new StringBuilder(512);
            sbURL.append("/params/get.cgi?Cc-1.Input-*.CcDetectAlarm");
            String digitalInput = new String(NetworkHelper.readGetRequest((NetworkParameter)this.networkParameter, (String)sbURL.toString(), (int)Integer.MAX_VALUE));
            for (int i = 0; i < iServices.length; ++i) {
                int inputNumber = iServices[i].getInputNumber();
                String[] alarmData = digitalInput.split("\r\n");
                for (int j = 0; j < alarmData.length; ++j) {
                    String[] alarmLine;
                    if (alarmData[j].toLowerCase().indexOf("input-" + inputNumber) == -1 || (alarmLine = alarmData[j].split("CcDetectAlarm=")).length != 2) continue;
                    if (alarmLine[1].toLowerCase().indexOf("on") != -1) {
                        iServices[i].checkInput(1);
                        continue;
                    }
                    iServices[i].checkInput(0);
                }
            }
        }
        return 0;
    }

    @Override
    public int writeDigitalOutput(int outputNumber, int value, long holdTime) {
        DigitalOutputSrv service = super.getDigitalOutputSrv(outputNumber);
        if (service == null) {
            this.logger.error(this + " has no digital output service configured for [" + outputNumber + "] :-(");
            return -21601;
        }
        if (value < 0) {
            this.logger.error("Value [" + value + "] is not valid for " + this + " :-(");
            return -21601;
        }
        SiquraDevice siquraDevice = (SiquraDevice)this.device;
        if (siquraDevice.isOnvifDevice()) {
            try {
                IOHandler.HoldTimer holdTimer;
                this.logger.info("holdTime: " + holdTime);
                this.logger.info("value: " + value);
                OnvifCore onvifCore = siquraDevice.getOnvifCore();
                this.deviceIOservice = onvifCore.getDeviceIoService().getOnvifDeviceIoService();
                List relayOutputs = this.deviceIOservice.getRelayOutputs();
                RelayOutput relayOutput = (RelayOutput)relayOutputs.get(outputNumber);
                RelayLogicalState relayLogicalState = value > 0 ? RelayLogicalState.ACTIVE : RelayLogicalState.INACTIVE;
                this.deviceIOservice.setRelayOutputState(relayOutput.getToken(), relayLogicalState);
                if (holdTime > 0L && (this.errorCode = (holdTimer = new IOHandler.HoldTimer()).init(outputNumber, value > 0 ? 0 : 1, holdTime)) != 0) {
                    holdTimer.shutdown();
                    this.logger.warn("Creating " + holdTimer + " failed with error [" + this.errorCode + "] :-(");
                }
            }
            catch (Throwable throwable) {
                this.logger.warn((Object)throwable, throwable);
                this.logger.warn("Problems setting output [" + outputNumber + "] of " + this + " :-(");
            }
        } else {
            try {
                IOHandler.HoldTimer holdTimer;
                if (holdTime > 0L && (this.errorCode = (holdTimer = new IOHandler.HoldTimer()).init(outputNumber, value > 0 ? 0 : 1, holdTime)) != 0) {
                    holdTimer.shutdown();
                    this.logger.warn("Creating " + holdTimer + " failed with error [" + this.errorCode + "] :-(");
                }
                StringBuilder url = new StringBuilder(256);
                if (siquraDevice.hasAuxOutput()) {
                    url.append("/api/ptz.cgi?SetAux");
                    if (value == 1) {
                        url.append("On");
                    } else {
                        url.append("Off");
                    }
                    url.append("=").append(outputNumber);
                } else {
                    url.append("/params/set.cgi?Cc-1.Output-").append(outputNumber).append(".OperationalMode=");
                    if (value == 1) {
                        url.append("Force%20active");
                    } else {
                        url.append("Force%20inactive");
                    }
                }
                if (NetworkHelper.readGetRequest((NetworkParameter)this.networkParameter, (String)url.toString(), (int)Integer.MAX_VALUE) == null) {
                    this.logger.error("Could not send Data to digital Output ");
                }
            }
            catch (SeeTecException ex) {
                this.logger.error((Object)ex);
                throw new RuntimeException("Cannot write value [" + value + "] to output [" + outputNumber + "] :-(" + ex.getMessage());
            }
            catch (Exception ex) {
                this.logger.error((Object)ex);
                throw new RuntimeException("Cannot write value [" + value + "] to output [" + outputNumber + "] :-(");
            }
        }
        return 0;
    }
}

