/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.cm.device.video.siemens.mpeg;

import de.seetec.v5.re.cm.device.shared.net.rtsp.RTSPStreamSettings;
import de.seetec.v5.re.cm.device.shared.videosource.StreamingVideoSourceClientRTSP;
import de.seetec.v5.re.cm.shared.Tools;
import de.seetec.v5.shared.net.NetworkHelper;
import de.seetec.v5.shared.net.NetworkParameter;
import de.seetec.v5.shared.util.ConfigurationException;
import de.seetec.v5.shared.util.SeeTecException;

public class SiemensMPEGVideoSourceClient_1345
extends StreamingVideoSourceClientRTSP {
    private static final String CLASS_NAME = "de.seetec.v5.re.cm.device.video.siemens.mpeg.SiemensMPEGVideoSourceClient";
    private int resolutionFromCamera = -1;
    private int framerateFromCamera = -1;
    private String codecFromCamera = "";

    @Override
    public int init() {
        block30: {
            byte[] result = null;
            this.errorCode = super.init();
            if (this.errorCode != 0) {
                this.logger.error("Error while initializing. Code: " + this.errorCode + " for " + this);
                return this.errorCode;
            }
            try {
                StringBuilder postParameters = new StringBuilder(256);
                int resolution = -1;
                int[] allowedValues = new int[]{4, 5, 6, 8, 12, 25};
                this.fps = Tools.convertToCameraValues(allowedValues, (int)(this.fps / 1000L));
                resolution = this.width <= 176 ? 0 : (this.width <= 352 ? 1 : (this.height <= 288 ? 3 : 2));
                StringBuilder postURL = new StringBuilder("/cgi-bin/cfg/access");
                postParameters.append("rdbOn=106");
                String pwd = "";
                if (this.networkParameter.getUserPWD() != null && this.networkParameter.getUserPWD().length == 2) {
                    pwd = this.networkParameter.getUserPWD()[1];
                }
                String[] userPassword = new String[]{"config", pwd};
                this.networkParameter.setUserPWD(userPassword);
                try {
                    NetworkHelper.readPostRequest((NetworkParameter)this.networkParameter, (String)postURL.toString(), (String)postParameters.toString(), (int)Integer.MAX_VALUE, (boolean)true);
                }
                catch (SeeTecException ex) {
                    this.logger.error("Error disabling SISTORE authentication for " + this + ": " + ex.getMessage() + ". Disable it on camera.");
                }
                postURL = new StringBuilder("/cgi-bin/cfg/image");
                result = NetworkHelper.readGetRequest((NetworkParameter)this.networkParameter, (String)"/cgi-bin/cfg/image", (int)Integer.MAX_VALUE);
                try {
                    String[] selectData;
                    String resultString = new String(result);
                    String[] formsData = resultString.split("<form");
                    int beginIndex = -1;
                    int endIndex = -1;
                    if (formsData.length >= 2 && (selectData = formsData[1].split("<select")).length >= 5) {
                        String[] framerateStrings;
                        String[] protocolsStrings;
                        String[] resolutionStrings = selectData[1].split("\n");
                        if (resolutionStrings.length >= 1) {
                            for (String resolutionString1 : resolutionStrings) {
                                if (!resolutionString1.contains("selected")) continue;
                                beginIndex = resolutionString1.indexOf("'");
                                endIndex = resolutionString1.lastIndexOf("'");
                                String resolutionString = resolutionString1.substring(beginIndex + 1, endIndex);
                                if (beginIndex == -1 || endIndex == -1 || endIndex <= beginIndex) continue;
                                this.resolutionFromCamera = Integer.parseInt(resolutionString);
                            }
                        }
                        if ((protocolsStrings = selectData[3].split("\n")).length >= 0) {
                            for (String protocolsString : protocolsStrings) {
                                if (!protocolsString.contains("selected")) continue;
                                beginIndex = protocolsString.indexOf("'");
                                endIndex = protocolsString.lastIndexOf("'");
                                if (beginIndex == -1 || endIndex == -1 || endIndex <= beginIndex) continue;
                                this.codecFromCamera = protocolsString.substring(beginIndex + 1, endIndex);
                            }
                        }
                        if ((framerateStrings = selectData[4].split("\n")).length >= 0) {
                            for (String framerateString1 : framerateStrings) {
                                if (!framerateString1.contains("selected")) continue;
                                beginIndex = framerateString1.indexOf("'");
                                endIndex = framerateString1.lastIndexOf("'");
                                if (beginIndex == -1 || endIndex == -1 || endIndex <= beginIndex) continue;
                                String framerateString = framerateString1.substring(beginIndex + 1, endIndex);
                                this.framerateFromCamera = Integer.parseInt(framerateString);
                            }
                        }
                    }
                }
                catch (NumberFormatException resultString) {
                    // empty catch block
                }
                postParameters = new StringBuilder(256);
                if (this.codecFromCamera.equals("mpeg4") && this.resolutionFromCamera == resolution && (long)this.framerateFromCamera == this.fps) break block30;
                if (!this.codecFromCamera.equals("mpeg4")) {
                    postParameters.append("&streamingProtocol=mpeg4");
                }
                if (this.resolutionFromCamera != resolution) {
                    postParameters.append("&resolution=");
                    postParameters.append(resolution);
                }
                if ((long)this.framerateFromCamera != this.fps) {
                    postParameters.append("&frameRate=");
                    postParameters.append(this.fps);
                }
                postParameters.append("&formChanged=formMovie");
                try {
                    NetworkHelper.readPostRequest((NetworkParameter)this.networkParameter, (String)postURL.toString(), (String)postParameters.toString(), (int)Integer.MIN_VALUE, (boolean)true);
                }
                catch (SeeTecException ex) {
                    this.logger.error("Error while setting parameters for " + this.getVideoSrv());
                    return ex.getErrorCode();
                }
                try {
                    Thread.sleep(2000L);
                }
                catch (InterruptedException interruptedException) {}
            }
            catch (SeeTecException e) {
                this.logger.error("Exception setting stream parameters for " + this.toString() + ": " + (Object)((Object)e));
                return e.getErrorCode();
            }
        }
        try {
            this.rtspUrl = "rtsp://" + this.getHost() + ":" + this.listener.getVideoSourceParameter().getRtspPort();
        }
        catch (ConfigurationException exception) {
            this.logger.warn("RTSP port could not be read", (Throwable)exception);
        }
        this.rtspSettings = new RTSPStreamSettings();
        try {
            this.errorCode = this.rtspSettings.init(this, this.audioSourceClient, this.networkParameter, this.listener.getVideoSourceParameter().getRtspPort(), this.rtspUrl, this.printDebug, this.transmissionID, this.networkParameter.getSoTimeout(), this.isAudioEnabled);
            if (this.errorCode != 0) {
                this.logger.error("Initialization of RTSPSettings failed with errorCode: " + this.errorCode + " for " + this.getVideoSrv());
                return this.errorCode;
            }
        }
        catch (ConfigurationException ex) {
            this.logger.warn("Could not initialize rtspSettings for " + this);
            this.logger.warn((Object)ex, (Throwable)ex);
        }
        try {
            this.rtspHandler = this.rtspSettings.getRTSPHandler();
        }
        catch (SeeTecException ex) {
            this.logger.error("Exception while initializing RTSPHandler : " + ex.getMessage() + " for " + this.getVideoSrv());
            return ex.getErrorCode();
        }
        this.errorCode = this.rtspHandler.start();
        if (this.errorCode != 0) {
            this.logger.error("Start of RTSPHandler failed with errorCode: " + this.errorCode + " for " + this.getVideoSrv());
            return this.errorCode;
        }
        this.logger.info("init done for" + this.getVideoSrv());
        return 0;
    }

    @Override
    public void onNetworkError(int error) {
        if (this.isShutdown()) {
            return;
        }
        this.logger.warn("Shutting down : " + error);
        this.listener.sendStatusService(error);
        this.shutdown();
    }

    @Override
    public synchronized int shutdown() {
        if (this.startShutdown(CLASS_NAME)) {
            return 0;
        }
        return super.shutdown();
    }

    @Override
    public void sendStatusService(int nStatusCode) {
        this.listener.sendStatusService(nStatusCode);
    }

    @Override
    public final boolean isShutdown() {
        return this.isShutdown(CLASS_NAME);
    }

    public void notifyForNetworkProblems() {
        this.sendStatusService(-21603);
        this.listener.notifyForNetworkProblems();
        this.shutdown();
    }

    @Override
    public void processData(byte[] data) {
        this.processRtpData(data);
    }
}

