/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.cm.device.video.siemens.mpeg;

import de.seetec.v5.re.cm.device.shared.net.rtsp.RTSPStreamSettings;
import de.seetec.v5.re.cm.device.shared.videosource.StreamingVideoSourceClientRTSP;
import de.seetec.v5.re.cm.device.video.siemens.SiemensCameraSrv;
import de.seetec.v5.re.cm.device.video.siemens.SiemensDevice;
import de.seetec.v5.re.cm.shared.Tools;
import de.seetec.v5.shared.net.HTTPStatusCode;
import de.seetec.v5.shared.net.NetworkHelper;
import de.seetec.v5.shared.net.NetworkParameter;
import de.seetec.v5.shared.util.ConfigurationException;
import de.seetec.v5.shared.util.SeeTecException;

public class SiemensMPEGVideoSourceClient
extends StreamingVideoSourceClientRTSP {
    private static final String CLASS_NAME = "de.seetec.v5.re.cm.device.video.siemens.mpeg.SiemensMPEGVideoSourceClient";
    private int resolution = Integer.MIN_VALUE;
    private boolean isPal = true;
    private int bandwidthCode;
    private int counter = 0;

    @Override
    public int init() {
        byte[] result = null;
        this.errorCode = super.init();
        if (this.errorCode != 0) {
            this.logger.error("Error while initializing. Code: " + this.errorCode + " for " + this);
            return this.errorCode;
        }
        SiemensDevice siemensDevice = (SiemensDevice)this.getVideoSrv().getDevice();
        try {
            result = NetworkHelper.readGetRequest((NetworkParameter)this.networkParameter, (String)"/cgi-bin/read?30.0.5", (int)Integer.MAX_VALUE);
            if (result == null) {
                this.logger.error("Error reading PAL/NTSC configuration for " + this);
            } else {
                String videoStandard = siemensDevice.readOidValue(new String(result), "30.0.5");
                if (videoStandard == null) {
                    this.logger.error("Could not read video standard. Will asume PAL is used for " + this);
                } else {
                    this.isPal = videoStandard.equals("1");
                }
            }
        }
        catch (SeeTecException ex) {
            this.logger.error("Exception occured while reading PAL/NTSC configuration for " + this + ": " + (Object)((Object)ex));
        }
        try {
            int[] allowedValues;
            StringBuilder sb = new StringBuilder(256);
            long nFPS = this.fps / 1000L;
            int framerate = -1;
            if (this.isPal) {
                allowedValues = new int[]{1, 2, 3, 5, 10, 12, 25};
                framerate = Tools.convertToCameraValues(allowedValues, (int)nFPS);
            } else {
                allowedValues = new int[]{1, 2, 3, 5, 10, 15, 30};
                framerate = Tools.convertToCameraValues(allowedValues, (int)nFPS);
            }
            this.resolution = this.width == 320 ? 2 : 3;
            int iFrameDistance = (int)((double)framerate * ((double)this.iFrameDistMS / 1000.0));
            iFrameDistance = iFrameDistance < 1 ? 1 : iFrameDistance;
            iFrameDistance = iFrameDistance > 64 ? 64 : iFrameDistance;
            this.bandwidth /= 1024;
            this.bandwidthCode = this.bandwidth < 384 ? 7 : (this.bandwidth < 768 ? 5 : (this.bandwidth < 1536 ? 3 : 1));
            if (this.authorization && (result = NetworkHelper.readGetRequest((NetworkParameter)this.networkParameter, (String)"/cgi-bin/check.cgi", (int)Integer.MAX_VALUE)) == null) {
                this.logger.error("Error while checking authorization");
            }
            if ((this.errorCode = ((SiemensCameraSrv)this.getVideoSrv()).setVideoSourceParameters(this.networkParameter, this.useDateTime, this.rotationAngle, this.useTitle, this.title)) != 0) {
                this.logger.error("Could not set general camera parameters for " + this);
                return this.errorCode;
            }
            sb.append("/cgi-bin/set?");
            sb.append("10.0.1=2");
            sb.append("&10.1.2=").append(this.resolution);
            sb.append("&10.1.5=").append(iFrameDistance);
            sb.append("&10.1.4=").append(this.bandwidthCode);
            sb.append("&10.0.3=").append(framerate);
            if (NetworkHelper.readGetRequest((NetworkParameter)this.networkParameter, (String)sb.toString(), (int)Integer.MAX_VALUE) == null) {
                this.logger.error("Error occured while setting stream parameters for " + this);
            }
        }
        catch (SeeTecException e) {
            if (e.getNetworkStatus() == HTTPStatusCode.HTTP_UNAUTHORIZED) {
                this.shutdown();
                return -21657;
            }
            this.logger.error("Exception setting stream parameters for " + this.toString() + ": " + (Object)((Object)e));
            return e.getErrorCode();
        }
        try {
            int res = -1;
            while (res != this.resolution && this.counter < 10) {
                if (this.counter > 0) {
                    this.logger.info("The correct resolution is not yet set on camera. Waiting...");
                    Thread.sleep(1500L);
                }
                String resolutionOnCamera = new String(NetworkHelper.readGetRequest((NetworkParameter)this.networkParameter, (String)"/cgi-bin/read?10.1.2", (int)Integer.MAX_VALUE, (boolean)false));
                res = Integer.parseInt(siemensDevice.readOidValue(resolutionOnCamera, "10.1.2"));
                ++this.counter;
            }
            if (this.counter < 10) {
                this.logger.info("Resolution was set correctly to " + this.width + "x" + this.height);
            } else {
                this.logger.info("Resolution could not be set. Continuing with resolution available on camera ");
            }
        }
        catch (SeeTecException ex) {
            this.logger.error("Exception while waiting for resolution to be set on camera for " + this + ": " + ex.getMessage());
            return ex.getErrorCode();
        }
        catch (InterruptedException ex) {
            // empty catch block
        }
        try {
            this.rtspUrl = "rtsp://" + this.getHost() + ":" + this.listener.getVideoSourceParameter().getRtspPort() + "/livestream/";
        }
        catch (ConfigurationException exception) {
            this.logger.warn("RTSP port could not be read", (Throwable)exception);
        }
        this.rtspSettings = new RTSPStreamSettings();
        try {
            this.errorCode = this.rtspSettings.init(this, this.audioSourceClient, this.networkParameter, this.listener.getVideoSourceParameter().getRtspPort(), this.rtspUrl, this.printDebug, this.transmissionID, this.networkParameter.getSoTimeout(), this.isAudioEnabled, 1);
            if (this.errorCode != 0) {
                this.logger.error("Initialization of RTSPSettings failed with errorCode: " + this.errorCode + " for " + this.getVideoSrv());
                return this.errorCode;
            }
        }
        catch (ConfigurationException ex) {
            this.logger.warn("Could not initialize rtspSettings for " + this);
            this.logger.warn((Object)ex, (Throwable)ex);
        }
        this.rtspSettings.setKeepAliveInterval(5000);
        try {
            this.rtspHandler = this.rtspSettings.getRTSPHandler();
        }
        catch (SeeTecException ex) {
            this.logger.error("Exception while initializing RTSPHandler : " + ex.getMessage() + " for " + this.getVideoSrv());
            return ex.getErrorCode();
        }
        this.errorCode = this.rtspHandler.start();
        if (this.errorCode != 0) {
            this.logger.error("Start of RTSPHandler failed with errorCode: " + this.errorCode + " for " + this.getVideoSrv());
            return this.errorCode;
        }
        this.logger.info("init done for" + this.getVideoSrv());
        return 0;
    }

    @Override
    public void onNetworkError(int error) {
        if (this.isShutdown()) {
            return;
        }
        this.logger.warn("Shutting down : " + error);
        this.listener.sendStatusService(error);
        this.shutdown();
    }

    @Override
    public synchronized int shutdown() {
        if (this.startShutdown(CLASS_NAME)) {
            return 0;
        }
        return super.shutdown();
    }

    @Override
    public void sendStatusService(int statusCode) {
        this.listener.sendStatusService(statusCode);
    }

    @Override
    public final boolean isShutdown() {
        return this.isShutdown(CLASS_NAME);
    }

    public void notifyForNetworkProblems() {
        this.sendStatusService(-21603);
        this.listener.notifyForNetworkProblems();
        this.shutdown();
    }

    @Override
    public void processData(byte[] data) {
        this.processRtpData(data);
    }
}

