/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.cm.device.video.siemens.jpeg;

import de.seetec.v5.re.cm.device.shared.net.httpserverpush.HttpServerPushHandler;
import de.seetec.v5.re.cm.device.shared.net.httpserverpush.HttpServerPushListenerIntf;
import de.seetec.v5.re.cm.device.shared.videosource.JPEGVideoSourceClient;
import de.seetec.v5.re.cm.shared.Tools;
import de.seetec.v5.shared.net.NetworkHelper;
import de.seetec.v5.shared.net.NetworkParameter;
import de.seetec.v5.shared.util.SeeTecException;

public class SiemensJPEGVideoSourceClient_1345
extends JPEGVideoSourceClient
implements HttpServerPushListenerIntf {
    private static final String CLASS_NAME = "de.seetec.v5.re.cm.device.video.siemens.jpeg.SiemensJPEGVideoSourceClient";
    private HttpServerPushHandler httpServerPushHandler = null;
    private int resolutionFromCamera = -1;
    private int framerateFromCamera = -1;
    private String codecFromCamera = "";

    @Override
    protected boolean isRunFinished() {
        return super.isRunFinished(CLASS_NAME);
    }

    @Override
    public int init() {
        int errorCode;
        block33: {
            errorCode = 0;
            errorCode = super.init(false);
            if (errorCode != 0) {
                this.logger.error("Error while initializing. Code: " + errorCode + " for " + this);
                return errorCode;
            }
            try {
                byte[] result = null;
                StringBuilder postParameters = new StringBuilder(256);
                int resolution = -1;
                int[] allowedValues = new int[]{4, 5, 6, 8, 12, 25};
                int fps = Tools.convertToCameraValues(allowedValues, (int)(this.highestFramerate / 1000L));
                resolution = this.width <= 176 ? 0 : (this.width <= 352 ? 1 : (this.height <= 288 ? 3 : 2));
                StringBuilder postURL = new StringBuilder("/cgi-bin/cfg/access");
                postParameters.append("rdbOn=106");
                String pwd = "";
                if (this.networkParameter.getUserPWD() != null && this.networkParameter.getUserPWD().length == 2) {
                    pwd = this.networkParameter.getUserPWD()[1];
                }
                String[] userPassword = new String[]{"config", pwd};
                this.networkParameter.setUserPWD(userPassword);
                try {
                    NetworkHelper.readPostRequest((NetworkParameter)this.networkParameter, (String)postURL.toString(), (String)postParameters.toString(), (int)Integer.MAX_VALUE, (boolean)true);
                }
                catch (SeeTecException ex) {
                    this.logger.error("Exception while changing access mode for " + this + ": " + ex.getMessage());
                    return ex.getErrorCode();
                }
                postURL = new StringBuilder("/cgi-bin/cfg/image");
                postParameters = new StringBuilder(256);
                boolean startedPostParameters = false;
                this.networkParameter.setSoTimeout(5000);
                try {
                    result = NetworkHelper.readGetRequest((NetworkParameter)this.networkParameter, (String)"/cgi-bin/cfg/image", (int)Integer.MAX_VALUE);
                    try {
                        String[] selectData;
                        String resultString = new String(result);
                        String[] formsData = resultString.split("<form");
                        int beginIndex = -1;
                        int endIndex = -1;
                        if (formsData.length >= 2 && (selectData = formsData[1].split("<select")).length >= 5) {
                            String[] framerateStrings;
                            String[] protocolsStrings;
                            String[] resolutionStrings = selectData[1].split("\n");
                            if (resolutionStrings.length >= 1) {
                                for (String resolutionString1 : resolutionStrings) {
                                    if (!resolutionString1.contains("selected")) continue;
                                    beginIndex = resolutionString1.indexOf("'");
                                    endIndex = resolutionString1.lastIndexOf("'");
                                    String resolutionString = resolutionString1.substring(beginIndex + 1, endIndex);
                                    if (beginIndex == -1 || endIndex == -1 || endIndex <= beginIndex) continue;
                                    this.resolutionFromCamera = Integer.parseInt(resolutionString);
                                }
                            }
                            if ((protocolsStrings = selectData[3].split("\n")).length >= 0) {
                                for (String protocolsString : protocolsStrings) {
                                    if (!protocolsString.contains("selected")) continue;
                                    beginIndex = protocolsString.indexOf("'");
                                    endIndex = protocolsString.lastIndexOf("'");
                                    if (beginIndex == -1 || endIndex == -1 || endIndex <= beginIndex) continue;
                                    this.codecFromCamera = protocolsString.substring(beginIndex + 1, endIndex);
                                }
                            }
                            if ((framerateStrings = selectData[4].split("\n")).length >= 0) {
                                for (String framerateString1 : framerateStrings) {
                                    if (!framerateString1.contains("selected")) continue;
                                    beginIndex = framerateString1.indexOf("'");
                                    endIndex = framerateString1.lastIndexOf("'");
                                    if (beginIndex == -1 || endIndex == -1 || endIndex <= beginIndex) continue;
                                    String framerateString = framerateString1.substring(beginIndex + 1, endIndex);
                                    this.framerateFromCamera = Integer.parseInt(framerateString);
                                }
                            }
                        }
                    }
                    catch (NumberFormatException resultString) {
                    }
                }
                catch (SeeTecException ste) {
                    this.logger.error("Exception while reading camera configuration: " + (Object)((Object)ste));
                    return ste.getErrorCode();
                }
                if (this.codecFromCamera.equals("server_push") && this.resolutionFromCamera == resolution && this.framerateFromCamera == fps) break block33;
                if (!this.codecFromCamera.equals("server_push")) {
                    if (startedPostParameters) {
                        postParameters.append("&");
                    } else {
                        startedPostParameters = true;
                    }
                    postParameters.append("streamingProtocol=server_push");
                }
                if (this.resolutionFromCamera != resolution) {
                    if (startedPostParameters) {
                        postParameters.append("&");
                    } else {
                        startedPostParameters = true;
                    }
                    postParameters.append("resolution=");
                    postParameters.append(resolution);
                }
                if (this.framerateFromCamera != fps) {
                    if (startedPostParameters) {
                        postParameters.append("&");
                    } else {
                        startedPostParameters = true;
                    }
                    postParameters.append("frameRate=");
                    postParameters.append(fps);
                    this.highestFramerate = (long)fps * 1000L;
                }
                if (startedPostParameters) {
                    postParameters.append("&");
                } else {
                    startedPostParameters = true;
                }
                postParameters.append("formChanged=formMovie");
                try {
                    NetworkHelper.readPostRequest((NetworkParameter)this.networkParameter, (String)postURL.toString(), (String)postParameters.toString(), (int)Integer.MAX_VALUE, (boolean)true);
                }
                catch (SeeTecException ex) {
                    this.logger.error("Error while setting parameters for " + this + ": " + ex.getMessage());
                    return ex.getErrorCode();
                }
                try {
                    Thread.sleep(2000L);
                }
                catch (InterruptedException interruptedException) {}
            }
            catch (Throwable ex) {
                this.logger.error("Trouble with JPEGServerPushStream of " + super.getVideoSrv());
                this.logger.error((Object)ex, ex);
                return -21651;
            }
        }
        this.myThread = new Thread((Runnable)this, this.toString());
        this.myThread.start();
        return errorCode;
    }

    @Override
    public void run() {
        int errorCode = 0;
        super.setRunFinished(CLASS_NAME, false);
        this.networkParameter.setSoTimeout(5000);
        String pwd = "";
        if (this.networkParameter.getUserPWD() != null && this.networkParameter.getUserPWD().length == 2) {
            pwd = this.networkParameter.getUserPWD()[1];
        }
        String[] userPassword = new String[]{"image", pwd};
        this.networkParameter.setUserPWD(userPassword);
        boolean asynchronous = false;
        String serverPushURL = "/cgi-bin/livejpeg";
        this.httpServerPushHandler = new HttpServerPushHandler();
        errorCode = this.httpServerPushHandler.init(this, this.networkParameter, serverPushURL);
        if (errorCode != 0) {
            this.logger.error("Error [" + errorCode + "]with " + this.httpServerPushHandler);
        } else {
            errorCode = this.httpServerPushHandler.startServerPush(asynchronous);
            if (errorCode != 0) {
                this.logger.warn("ServerPush of " + this.httpServerPushHandler + " terminated with error [" + errorCode + "]");
            }
        }
        if (this.httpServerPushHandler != null) {
            this.httpServerPushHandler.shutdown();
            this.httpServerPushHandler = null;
        }
        super.setRunFinished(CLASS_NAME, true);
        this.shutdown();
    }

    public int setImageParameter(long frameRate) {
        int errorCode = 0;
        this.logger.info("Setting new image Parameter. Framerate = " + frameRate / 1000L);
        if (frameRate == 0L) {
            this.shutdown();
        }
        int[] allowedValues = new int[]{4, 5, 6, 8, 12, 25};
        int fps = Tools.convertToCameraValues(allowedValues, (int)(frameRate / 1000L));
        this.highestFramerate = (long)fps * 1000L;
        String postURL = "/cgi-bin/cfg/image";
        StringBuilder postParameters = new StringBuilder(256);
        postParameters.append("frameRate=");
        postParameters.append(fps);
        postParameters.append("&formChanged=formMovie");
        if (this.networkParameter.getUserPWD() != null && this.networkParameter.getUserPWD().length == 2) {
            String pwd = this.networkParameter.getUserPWD()[1];
            String[] userPassword = new String[]{"config", pwd};
            this.networkParameter.setUserPWD(userPassword);
        }
        try {
            NetworkHelper.readPostRequest((NetworkParameter)this.networkParameter, (String)postURL, (String)postParameters.toString(), (int)Integer.MIN_VALUE, (boolean)true);
        }
        catch (SeeTecException ex) {
            this.logger.error("Exception while setting new framerate: " + (Object)((Object)ex));
            errorCode = ex.getErrorCode();
        }
        return errorCode;
    }

    @Override
    public void sendStatusService(int nStatusCode) {
        this.listener.sendStatusService(nStatusCode);
    }

    @Override
    public void notifyForNetworkProblems() {
        this.listener.notifyForNetworkProblems();
    }
}

