/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.cm.device.video.siemens.jpeg;

import de.seetec.v5.re.cm.device.shared.net.httpserverpush.HttpServerPushHandler;
import de.seetec.v5.re.cm.device.shared.net.httpserverpush.HttpServerPushListenerIntf;
import de.seetec.v5.re.cm.device.shared.videosource.JPEGVideoSourceClient;
import de.seetec.v5.re.cm.device.video.siemens.SiemensCameraSrv;
import de.seetec.v5.re.cm.shared.Tools;
import de.seetec.v5.shared.net.NetworkHelper;
import de.seetec.v5.shared.net.NetworkParameter;
import de.seetec.v5.shared.util.SeeTecException;

public class SiemensJPEGVideoSourceClient
extends JPEGVideoSourceClient
implements HttpServerPushListenerIntf {
    private static final String CLASS_NAME = "de.seetec.v5.re.cm.device.video.siemens.jpeg.SiemensJPEGVideoSourceClient_1315";
    private boolean isPal = true;
    private HttpServerPushHandler httpServerPushHandler = null;

    @Override
    protected boolean isRunFinished() {
        return super.isRunFinished(CLASS_NAME);
    }

    @Override
    public int init() {
        int errorCode = 0;
        errorCode = super.init(false);
        if (errorCode != 0) {
            this.logger.error("Error while initializing. Code: " + errorCode + " for " + this);
            return errorCode;
        }
        this.isPal = ((SiemensCameraSrv)this.getVideoSrv()).isPal(this.networkParameter);
        try {
            int[] allowedValues;
            StringBuilder sb = new StringBuilder(256);
            long nFPS = this.highestFramerate / 1000L;
            int fps = -1;
            if (this.isPal) {
                allowedValues = new int[]{1, 2, 3, 5, 10, 12, 25};
                fps = Tools.convertToCameraValues(allowedValues, (int)nFPS);
            } else {
                allowedValues = new int[]{1, 2, 3, 5, 10, 15, 30};
                fps = Tools.convertToCameraValues(allowedValues, (int)nFPS);
            }
            this.compression = (this.compression + 19999) / 20000;
            this.compression = this.compression <= 0 ? 1 : this.compression;
            this.compression = this.compression > 5 ? 5 : this.compression;
            int resolution = -1;
            resolution = this.width == 320 ? 2 : (this.width == 640 ? 3 : 5);
            errorCode = ((SiemensCameraSrv)this.getVideoSrv()).setVideoSourceParameters(this.networkParameter, this.useDateTime, this.rotationAngle, this.useTitle, this.title);
            if (errorCode != 0) {
                this.logger.error("Could not set general camera parameters for " + this);
                return errorCode;
            }
            sb.append("/cgi-bin/set?");
            sb.append("&10.0.2=").append(resolution);
            sb.append("&10.0.4=").append(this.compression);
            sb.append("&10.1.3=").append(fps);
            String url = sb.toString();
            url = url.replace("?&", "?");
            if (NetworkHelper.readGetRequest((NetworkParameter)this.networkParameter, (String)url, (int)Integer.MAX_VALUE) == null) {
                this.logger.error("Error occured while setting stream parameters for " + this);
            }
        }
        catch (SeeTecException ex) {
            this.logger.error("Trouble setting stream parameters for " + super.getVideoSrv());
            this.logger.error((Object)ex, (Throwable)ex);
            return ex.getErrorCode();
        }
        this.myThread = new Thread((Runnable)this, this.toString());
        this.myThread.start();
        return errorCode;
    }

    @Override
    public void run() {
        super.setRunFinished(CLASS_NAME, false);
        int errorCode = 0;
        this.networkParameter.setSoTimeout(15000);
        String serverPushUrl = "/cgi-bin/getstream.cgi?VideoType=2";
        boolean asynchronous = false;
        try {
            this.httpServerPushHandler = new HttpServerPushHandler();
            errorCode = this.httpServerPushHandler.init(this, this.networkParameter, serverPushUrl);
            if (errorCode != 0) {
                this.logger.error("Error [" + errorCode + "]with " + this.httpServerPushHandler);
            } else {
                errorCode = this.httpServerPushHandler.startServerPush(asynchronous);
                if (errorCode != 0) {
                    this.logger.warn("ServerPush of " + this.httpServerPushHandler + " terminated with error [" + errorCode + "]");
                }
            }
        }
        catch (Throwable ex) {
            this.logger.error("Trouble with JPEGServerPushStream of " + super.getVideoSrv());
            this.logger.error((Object)ex, ex);
            errorCode = -21651;
        }
        if (this.httpServerPushHandler != null) {
            this.httpServerPushHandler.shutdown();
            this.httpServerPushHandler = null;
        }
        this.logger.info("End grabbing images for " + this);
        super.setRunFinished(CLASS_NAME, true);
        this.shutdown();
    }

    @Override
    public void sendStatusService(int nStatusCode) {
        this.listener.sendStatusService(nStatusCode);
    }

    @Override
    public void notifyForNetworkProblems() {
        this.sendStatusService(-21603);
        this.listener.notifyForNetworkProblems();
        this.shutdown();
    }
}

