/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.cm.device.video.siemens;

import de.seetec.v5.re.cm.device.shared.net.rtsp.RTSPStreamSettings;
import de.seetec.v5.re.cm.device.shared.videosource.StreamingHelper;
import de.seetec.v5.re.cm.device.shared.videosource.StreamingVideoSourceClientRTSP;
import de.seetec.v5.re.cm.device.video.siemens.SiemensCameraSrv;
import de.seetec.v5.re.cm.device.video.siemens.SiemensDevice;
import de.seetec.v5.re.cm.shared.Tools;
import de.seetec.v5.re.shared.Codec;
import de.seetec.v5.shared.net.HTTPStatusCode;
import de.seetec.v5.shared.net.NetworkHelper;
import de.seetec.v5.shared.net.NetworkParameter;
import de.seetec.v5.shared.util.ConfigurationException;
import de.seetec.v5.shared.util.SeeTecException;
import java.util.Arrays;

public class SiemensVideoSourceClient
extends StreamingVideoSourceClientRTSP {
    private static final String CLASS_NAME = "de.seetec.v5.re.cm.device.video.siemens.SiemensVideoSourceClient";
    private static final String getParamUrl = "/cgi-bin/read?";
    private static final String setParamUrl = "/cgi-bin/set?";
    private static final String checkAuthUrl = "/cgi-bin/check.cgi";
    private boolean isPal = true;
    private int streamNumber;
    private SiemensDevice siemensDevice;

    @Override
    public int init() {
        if (this.siemensDevice == null) {
            this.siemensDevice = (SiemensDevice)this.getVideoSrv().getDevice();
        }
        this.siemensDevice.setModelInformation();
        this.errorCode = super.init();
        if (this.errorCode != 0) {
            this.logger.error("Error while initializing. Code: " + this.errorCode + " for " + this);
            return this.errorCode;
        }
        this.isPal = ((SiemensCameraSrv)this.getVideoSrv()).isPal(this.networkParameter);
        try {
            this.transmissionID = this.listener.getVideoSourceParameter().getTransmissionID();
        }
        catch (ConfigurationException ex) {
            this.logger.error("Exception while getting streaming configuration for " + this + ": " + ex.getMessage());
            return -20001;
        }
        this.networkParameter.setSoTimeout(5000);
        try {
            int[] allowedValues;
            this.streamNumber = ((SiemensCameraSrv)this.getVideoSrv()).getStreamNumber(this.listener.getVideoProfileHandler().getDynamicVideoProfileID());
            if (this.siemensDevice.getFramerateMode() == 2) {
                allowedValues = new int[]{1, 2, 3, 5, 10, 12, 15, 25, 30};
                this.fps = Tools.convertToCameraValues(allowedValues, (int)(this.fps / 1000L));
            } else if (this.isPal) {
                allowedValues = new int[]{1, 2, 3, 5, 10, 12, 25};
                this.fps = Tools.convertToCameraValues(allowedValues, (int)(this.fps / 1000L));
            } else {
                allowedValues = new int[]{1, 2, 3, 5, 10, 15, 30};
                this.fps = Tools.convertToCameraValues(allowedValues, (int)(this.fps / 1000L));
            }
            StringBuilder sb = new StringBuilder(setParamUrl);
            String parametersOnCamera = new String(NetworkHelper.readGetRequest((NetworkParameter)this.networkParameter, (String)"/cgi-bin/read?11.99.1", (int)Integer.MAX_VALUE, (boolean)false));
            int resolutionCode = this.siemensDevice.getResolutionCode(this.width, this.height);
            if (!this.siemensDevice.readOidValue(parametersOnCamera, "11." + this.streamNumber + ".0.2").equals("" + resolutionCode)) {
                sb.append("&11.").append(this.streamNumber).append(".0.2=").append(resolutionCode);
            }
            if (this.videoCodec == Codec.H264) {
                if (this.siemensDevice.getH264Mode() == 1) {
                    int iFrameDistance = (int)((double)this.fps * ((double)this.iFrameDistMS / 1000.0));
                    iFrameDistance = iFrameDistance < 1 ? 1 : iFrameDistance;
                    int iFrameDistanceLimit = (int)Math.min(3L * this.fps, 64L);
                    int n = iFrameDistance = iFrameDistance > iFrameDistanceLimit ? iFrameDistanceLimit : iFrameDistance;
                    if (!this.siemensDevice.readOidValue(parametersOnCamera, "11." + this.streamNumber + ".0.1").equals("3")) {
                        sb.append("&11.").append(this.streamNumber).append(".0.1=3");
                    }
                    if (!this.siemensDevice.readOidValue(parametersOnCamera, "11." + this.streamNumber + ".3.1").equals("" + this.fps)) {
                        if (this.siemensDevice.getEntityType() == 202209L) {
                            sb.append("&11.").append(this.streamNumber).append(".1.1=").append(this.fps);
                        } else {
                            sb.append("&11.").append(this.streamNumber).append(".3.1=").append(this.fps);
                        }
                    }
                    if (!this.siemensDevice.readOidValue(parametersOnCamera, "11." + this.streamNumber + ".3.6").equals("" + iFrameDistance)) {
                        sb.append("&11.").append(this.streamNumber).append(".3.6=").append(iFrameDistance);
                    }
                    if (!this.siemensDevice.readOidValue(parametersOnCamera, "11." + this.streamNumber + ".3.2").equals(this.isConstantBitrateUsed ? "2" : "1")) {
                        sb.append("&11.").append(this.streamNumber).append(".3.2=");
                        sb.append(this.isConstantBitrateUsed ? "2" : "1");
                    }
                    if (this.isConstantBitrateUsed) {
                        int bandwidthCode = this.siemensDevice.getConstantBandwidthCode(this.width, this.height, this.bandwidth);
                        if (!this.siemensDevice.readOidValue(parametersOnCamera, "11." + this.streamNumber + ".3.5").equals("" + bandwidthCode)) {
                            sb.append("&11.").append(this.streamNumber).append(".3.5=").append(bandwidthCode);
                        }
                    } else {
                        this.quality = this.quality / 3333 + 1;
                        this.quality = this.quality < 1 ? 1 : this.quality;
                        int n2 = this.quality = this.quality > 31 ? 31 : this.quality;
                        if (!this.siemensDevice.readOidValue(parametersOnCamera, "11." + this.streamNumber + ".3.3").equals("0")) {
                            sb.append("&11.").append(this.streamNumber).append(".3.3=0");
                        }
                        if (!this.siemensDevice.readOidValue(parametersOnCamera, "11." + this.streamNumber + ".3.4").equals("" + this.quality)) {
                            sb.append("&11.").append(this.streamNumber).append(".3.4=").append(this.quality);
                        }
                    }
                } else if (this.siemensDevice.getH264Mode() == 2) {
                    int iFrameDistance = (int)((double)this.fps * ((double)this.iFrameDistMS / 1000.0));
                    iFrameDistance = iFrameDistance < 1 ? 1 : iFrameDistance;
                    int n = iFrameDistance = iFrameDistance > 64 ? 64 : iFrameDistance;
                    if (!this.siemensDevice.readOidValue(parametersOnCamera, "11." + this.streamNumber + ".0.1").equals("3")) {
                        sb.append("&11.").append(this.streamNumber).append(".0.1=3");
                    }
                    if (!this.siemensDevice.readOidValue(parametersOnCamera, "11." + this.streamNumber + ".3.1").equals("" + this.fps)) {
                        sb.append("&11.").append(this.streamNumber).append(".3.1=").append(this.fps);
                    }
                    if (!this.siemensDevice.readOidValue(parametersOnCamera, "11." + this.streamNumber + ".3.6").equals("" + iFrameDistance)) {
                        sb.append("&11.").append(this.streamNumber).append(".3.6=").append(iFrameDistance);
                    }
                    if (!this.siemensDevice.readOidValue(parametersOnCamera, "11." + this.streamNumber + ".3.2").equals(this.isConstantBitrateUsed ? "2" : "1")) {
                        sb.append("&11.").append(this.streamNumber).append(".3.2=");
                        sb.append(this.isConstantBitrateUsed ? "2" : "1");
                    }
                    if (this.isConstantBitrateUsed) {
                        this.bandwidth = this.bandwidth > 4000000 ? 4000000 : this.bandwidth;
                        int n3 = this.bandwidth = this.bandwidth < 1000 ? 1000 : this.bandwidth;
                        if (!this.siemensDevice.readOidValue(parametersOnCamera, "11." + this.streamNumber + ".3.5").equals("" + this.bandwidth)) {
                            sb.append("&11.").append(this.streamNumber).append(".3.5=").append(this.bandwidth);
                        }
                    } else {
                        this.quality = this.quality / 1960 + 1;
                        this.quality = this.quality < 1 ? 1 : this.quality;
                        int n4 = this.quality = this.quality > 51 ? 51 : this.quality;
                        if (!this.siemensDevice.readOidValue(parametersOnCamera, "11." + this.streamNumber + ".3.3").equals("0")) {
                            sb.append("&11.").append(this.streamNumber).append(".3.3=0");
                        }
                        if (!this.siemensDevice.readOidValue(parametersOnCamera, "11." + this.streamNumber + ".3.4").equals("" + this.quality)) {
                            sb.append("&11.").append(this.streamNumber).append(".3.4=").append(this.quality);
                        }
                    }
                } else {
                    this.logger.error("H.264 Mode not set for " + this);
                }
            } else {
                if (!this.siemensDevice.readOidValue(parametersOnCamera, "11." + this.streamNumber + ".0.1").equals("1")) {
                    sb.append("&11.").append(this.streamNumber).append(".0.1=1");
                }
                if (!this.siemensDevice.readOidValue(parametersOnCamera, "11." + this.streamNumber + ".1.1").equals("" + this.fps)) {
                    sb.append("&11.").append(this.streamNumber).append(".1.1=").append(this.fps);
                }
                String qualityMode = "0";
                if (this.siemensDevice.getJPEGMode() == 2) {
                    this.quality = this.quality / 1052 + 2;
                    this.quality = this.quality < 2 ? 2 : this.quality;
                    this.quality = this.quality > 97 ? 97 : this.quality;
                } else if (this.siemensDevice.getJPEGMode() == 3) {
                    float desiredQuality = (float)this.quality / 20000.0f;
                    float[] allowedValues2 = new float[]{1.0f, 3.0f, 5.0f};
                    qualityMode = "" + (int)Tools.convertToCameraValues(allowedValues2, desiredQuality);
                } else {
                    this.quality = this.quality / 1111 + 3;
                    this.quality = this.quality < 3 ? 3 : this.quality;
                    int n = this.quality = this.quality > 90 ? 90 : this.quality;
                }
                if (!this.siemensDevice.readOidValue(parametersOnCamera, "11." + this.streamNumber + ".1.3").equals(qualityMode)) {
                    sb.append("&11.").append(this.streamNumber).append(".1.3=" + qualityMode);
                }
                if (this.siemensDevice.getJPEGMode() != 3 && !this.siemensDevice.readOidValue(parametersOnCamera, "11." + this.streamNumber + ".1.4").equals("" + this.quality)) {
                    sb.append("&11.").append(this.streamNumber).append(".1.4=").append(this.quality);
                }
            }
            if (this.authorization && NetworkHelper.readGetRequest((NetworkParameter)this.networkParameter, (String)checkAuthUrl, (int)Integer.MAX_VALUE) == null) {
                this.logger.error("Error while checking authorization");
            }
            if ((this.errorCode = ((SiemensCameraSrv)this.getVideoSrv()).setVideoSourceParameters(this.networkParameter, this.useDateTime, this.rotationAngle, this.useTitle, this.title)) != 0) {
                this.logger.error("Could not set general camera parameters for " + this);
                return this.errorCode;
            }
            String url = sb.toString().replace("?&", "?");
            if (!url.equals(setParamUrl)) {
                if (NetworkHelper.readGetRequest((NetworkParameter)this.networkParameter, (String)url, (int)Integer.MAX_VALUE) == null) {
                    this.logger.error("Error occured while setting stream parameters for " + this);
                }
                try {
                    Thread.sleep(3000L);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
        catch (SeeTecException e) {
            if (e.getNetworkStatus() == HTTPStatusCode.HTTP_UNAUTHORIZED) {
                this.shutdown();
                return -21657;
            }
            this.logger.error("Exception setting stream parameters for " + this.toString() + ": " + (Object)((Object)e));
            return e.getErrorCode();
        }
        try {
            String rtspPort = "" + this.listener.getVideoSourceParameter().getRtspPort();
            if (this.siemensDevice.getRtspMode() == 1) {
                rtspPort = this.siemensDevice.getOidValue(this.networkParameter, "10." + (this.streamNumber + 4) + ".3", "10." + (this.streamNumber + 4) + ".3");
                this.listener.getVideoSourceParameter().setRtspPort(Integer.parseInt(rtspPort));
            }
        }
        catch (Exception ex) {
            this.logger.error("Exception while getting RTSP Settings from camera for " + this + ": " + ex.getMessage());
        }
        this.rtspUrl = this.siemensDevice.getEntityType() == 202209L ? "rtsp://" + this.getHost() + "/stream" + (this.streamNumber + 1) : "rtsp://" + this.getHost() + "/livestream";
        if (this.siemensDevice.getRtspMode() == 2) {
            if (this.streamNumber == 1) {
                this.rtspUrl = this.rtspUrl + "2";
            } else if (this.streamNumber == 2) {
                this.rtspUrl = this.rtspUrl + "3";
            }
            try {
                if (Integer.parseInt(this.siemensDevice.getOidValue(this.networkParameter, "10.6.3", "10.6.3")) != this.listener.getVideoSourceParameter().getRtspPort()) {
                    NetworkHelper.readGetRequest((NetworkParameter)this.networkParameter, (String)("/cgi-bin/set?10.6.3=" + this.listener.getVideoSourceParameter().getRtspPort()));
                }
            }
            catch (SeeTecException ex) {
                this.logger.error("Exception while reading or setting RTSP port for " + this + ": " + ex.getMessage());
                return ex.getErrorCode();
            }
            catch (Exception ex) {
                this.logger.error("Exception while reading or setting RTSP port for " + this + ": " + ex.getMessage());
            }
        }
        try {
            this.initAudio();
        }
        catch (SeeTecException ex) {
            this.logger.error("Exception while initializing audio for " + this, (Throwable)ex);
        }
        this.rtspSettings = new RTSPStreamSettings();
        if (this.siemensDevice.getEntityType() == 202201L || this.siemensDevice.getEntityType() == 202202L) {
            this.rtspSettings.setIgnoreSSRC(true);
        }
        try {
            this.errorCode = this.rtspSettings.init(this, this.audioSourceClient, this.networkParameter, this.listener.getVideoSourceParameter().getRtspPort(), this.rtspUrl, this.printDebug, this.transmissionID, this.networkParameter.getSoTimeout(), this.isAudioEnabled, 1, this.rtspUrl);
            if (this.errorCode != 0) {
                this.logger.error("Initialization of RTSPSettings failed with errorCode: " + this.errorCode + " for " + this.getVideoSrv());
                return this.errorCode;
            }
        }
        catch (ConfigurationException ex) {
            this.logger.warn("Could not initialize rtspSettings for " + this);
            this.logger.warn((Object)ex, (Throwable)ex);
        }
        try {
            Thread.sleep(18000L);
        }
        catch (InterruptedException ex) {
            // empty catch block
        }
        try {
            this.rtspHandler = this.rtspSettings.getRTSPHandler();
            this.rtspHandler.start();
        }
        catch (SeeTecException ex) {
            this.logger.error("Exception while starting RTSP Handler for " + this + ": " + ex.getMessage());
            return ex.getErrorCode();
        }
        this.logger.info("init done for" + this.getVideoSrv());
        return 0;
    }

    public void initAudio() throws SeeTecException {
        if (this.isAudioEnabled) {
            String audioCodecOidValue;
            String url;
            if (this.siemensDevice.getAudioMode() == 1) {
                url = "/cgi-bin/set?60.0.1=2&60.2.1=1";
                NetworkHelper.readGetRequest((NetworkParameter)this.networkParameter, (String)url, (int)Integer.MAX_VALUE, (boolean)false);
                audioCodecOidValue = this.siemensDevice.getOidValue(this.networkParameter, "60.2.2", "60.2.2");
                if (audioCodecOidValue.equals("1")) {
                    this.audioCodec = Codec.G711A;
                }
            } else if (this.siemensDevice.getAudioMode() == 2) {
                url = "/cgi-bin/set??60.0.1=1&60.2.1=1";
                NetworkHelper.readGetRequest((NetworkParameter)this.networkParameter, (String)url, (int)Integer.MAX_VALUE, (boolean)false);
                audioCodecOidValue = this.siemensDevice.getOidValue(this.networkParameter, "60.2.2", "60.2.2");
                if (audioCodecOidValue.equals("1")) {
                    this.audioCodec = Codec.G711A;
                }
            }
        }
        if (this.siemensDevice.getAudioMode() == 3) {
            String audioEnabled = this.isAudioEnabled ? "2&60.2.1=1&60.2.2=1" : "1";
            String url = "/cgi-bin/set??60.0.1=" + audioEnabled;
            NetworkHelper.readGetRequest((NetworkParameter)this.networkParameter, (String)url, (int)Integer.MAX_VALUE, (boolean)false);
            if (this.isAudioEnabled) {
                String audioCodecOidValue = this.siemensDevice.getOidValue(this.networkParameter, "60.2.2", "60.2.2");
                if (audioCodecOidValue.equals("1")) {
                    this.audioCodec = Codec.G711U;
                    this.audioBitrate = 64000;
                } else {
                    this.audioCodec = Codec.G711A;
                    this.audioBitrate = 64000;
                }
            }
        }
    }

    @Override
    public void onNetworkError(int error) {
        if (this.isShutdown()) {
            return;
        }
        this.listener.sendStatusService(error);
        this.shutdown();
    }

    @Override
    public synchronized int shutdown() {
        if (this.startShutdown(CLASS_NAME)) {
            return 0;
        }
        return super.shutdown();
    }

    @Override
    public void sendStatusService(int nStatusCode) {
        this.listener.sendStatusService(nStatusCode);
    }

    @Override
    public void processData(byte[] data) {
        this.processRtpData(data);
    }

    @Override
    public final boolean isShutdown() {
        return this.isShutdown(CLASS_NAME);
    }

    public void notifyForNetworkProblems() {
        this.sendStatusService(-21603);
        this.listener.notifyForNetworkProblems();
        this.shutdown();
    }

    public int setFramerate(int framerate) {
        try {
            int[] allowedValues;
            if (this.siemensDevice.getFramerateMode() == 2) {
                allowedValues = new int[]{1, 2, 3, 5, 10, 12, 15, 25, 30};
                this.fps = Tools.convertToCameraValues(allowedValues, framerate / 1000);
            } else if (this.isPal) {
                allowedValues = new int[]{1, 2, 3, 5, 10, 12, 25};
                this.fps = Tools.convertToCameraValues(allowedValues, framerate / 1000);
            } else {
                allowedValues = new int[]{1, 2, 3, 5, 10, 15, 30};
                this.fps = Tools.convertToCameraValues(allowedValues, framerate / 1000);
            }
            this.streamNumber = ((SiemensCameraSrv)this.getVideoSrv()).getStreamNumber(this.listener.getVideoProfileHandler().getDynamicVideoProfileID());
            String url = "/cgi-bin/set?11." + this.streamNumber + (this.videoCodec == Codec.H264 && this.siemensDevice.getEntityType() != 202209L ? ".3" : ".1") + ".1=" + this.fps;
            NetworkHelper.readGetRequest((NetworkParameter)this.networkParameter, (String)url, (int)Integer.MAX_VALUE);
        }
        catch (SeeTecException e) {
            this.logger.error("Exception setting stream parameters for " + this.toString() + ": " + (Object)((Object)e));
            return e.getErrorCode();
        }
        return 0;
    }

    @Override
    protected void deliverH264Data(byte[] data, boolean checkResolution, long timeStamp) throws SeeTecException {
        if (this.siemensDevice.getEntityType() == 202201L || this.siemensDevice.getEntityType() == 202202L) {
            int firstIndex = 0;
            int secondIndex = 0;
            byte[] result = null;
            while (firstIndex >= 0) {
                byte[] tmp;
                secondIndex = SiemensVideoSourceClient.indexOfByteArray((byte[])data, (byte[])StreamingHelper.START_SEQUENCE_0001, (int)(firstIndex + 3), (boolean)true);
                int temp = SiemensVideoSourceClient.indexOfByteArray((byte[])data, (byte[])StreamingHelper.START_SEQUENCE_001, (int)(firstIndex + 3), (boolean)true);
                int n = secondIndex = temp < secondIndex ? temp : secondIndex;
                if (secondIndex > firstIndex) {
                    result = Arrays.copyOfRange(data, firstIndex, secondIndex);
                    if (result[2] == 0) {
                        result = tmp = Arrays.copyOfRange(result, 1, result.length);
                    }
                    firstIndex = secondIndex;
                } else if (secondIndex == -1) {
                    result = Arrays.copyOfRange(data, firstIndex, data.length);
                    if (result.length > 1 && result[2] == 0) {
                        result = tmp = Arrays.copyOfRange(result, 1, result.length);
                    }
                    firstIndex = secondIndex;
                }
                if (result == null) continue;
                super.deliverH264Data(result, checkResolution, timeStamp);
            }
        } else {
            super.deliverH264Data(data, checkResolution, timeStamp);
        }
    }
}

