/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.cm.device.video.siemens;

import de.seetec.v5.re.cm.configuration.definition.camera.VideoCameraDefinition;
import de.seetec.v5.re.cm.configuration.definition.device.DeviceDefinition;
import de.seetec.v5.re.cm.device.shared.VideoServer;
import de.seetec.v5.re.cm.device.shared.io.IOHandler;
import de.seetec.v5.re.cm.shared.Tools;
import de.seetec.v5.shared.net.HTTPStatusCode;
import de.seetec.v5.shared.net.NetworkHelper;
import de.seetec.v5.shared.net.NetworkParameter;
import de.seetec.v5.shared.util.SeeTecException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class SiemensDevice
extends VideoServer {
    private String resultString = null;
    @Deprecated
    private boolean dualVideoSystemMode = false;
    private int h264Mode = 1;
    private int resolutionMode = 1;
    private int cameraTitleMode = 1;
    private int audioMode = 1;
    private int rtspMode = 1;
    private int jpegMode = 1;
    private int ptzMode = 1;
    private int framerateMode = 1;
    private int imageFlipMode = 1;

    @Override
    protected IOHandler createIOHandler() {
        throw new RuntimeException("UNSUPPORTED :-(");
    }

    @Override
    protected boolean isSupportingIO() {
        return false;
    }

    @Override
    protected DeviceDefinition getDeviceDefinitionFromDevice(String signature, String manufacturer, String name, String comments) throws SeeTecException {
        return null;
    }

    @Override
    protected VideoCameraDefinition getVideoCameraDefinitionFromDevice() throws SeeTecException {
        return null;
    }

    public String getOidValue(NetworkParameter networkParameter, String parameterGroup, String oid) throws SeeTecException {
        this.resultString = new String(NetworkHelper.readGetRequest((NetworkParameter)networkParameter, (String)("/cgi-bin/read?" + parameterGroup), (int)Integer.MAX_VALUE));
        if (NetworkHelper.getStatusCode((NetworkParameter)networkParameter, (String)this.resultString) == HTTPStatusCode.HTTP_UNAUTHORIZED) {
            this.logger.error("Unauthorized access for " + this);
            throw new SeeTecException(-21657, "Unauthorized access");
        }
        return this.readOidValue(this.resultString, oid);
    }

    public String readOidValue(String htmlString, String oid) {
        block8: {
            String oidBodyString;
            block9: {
                if (htmlString == null || htmlString.length() == 0) {
                    return "";
                }
                if (this.getEntityType() == 202209L) {
                    Pattern p = Pattern.compile("<td\\s+id=\"" + oid + "\"\\s*>(\\d+)</td>", 2);
                    Matcher matcher = p.matcher(htmlString);
                    if (matcher.find()) {
                        return matcher.group(1);
                    }
                    return "";
                }
                if (this.getEntityType() == 202203L) {
                    String searchOid = "<TD ID=\"" + oid + "\">";
                    int startIndex = htmlString.indexOf(searchOid) + searchOid.length();
                    if (startIndex == -1) {
                        return "";
                    }
                    int endIndex = htmlString.indexOf("<", startIndex);
                    if (endIndex == -1) {
                        return "";
                    }
                    return htmlString.substring(startIndex, endIndex);
                }
                String[] oidBody = htmlString.split("\r\n\r\n");
                if (oidBody.length != 2) break block8;
                oidBodyString = oidBody[1].toLowerCase();
                int startIndex = oidBodyString.indexOf("<table>");
                if (startIndex == -1) break block9;
                int endIndex = oidBodyString.indexOf("</table>", startIndex) + 8;
                if (endIndex == -1) break block8;
                String body = oidBodyString.substring(startIndex, endIndex);
                String[] oidLines = body.split("\n");
                for (int i = 0; i < oidLines.length; ++i) {
                    String oidLine = oidLines[i];
                    if (oidLine.indexOf(oid) == -1) continue;
                    String oidValue = oidLine.replace(oid, "").replace("\r", "").replaceAll("\\<.*?\\>", "").trim();
                    return oidValue;
                }
                break block8;
            }
            String[] oidLines = oidBodyString.split("\n");
            for (int i = 0; i < oidLines.length; ++i) {
                String[] oidLine = oidLines[i].split("\t+");
                if (oidLine[0].indexOf(oid) == -1) continue;
                return oidLine[1].trim().replace("\r", "").replace("\n", "");
            }
        }
        return "";
    }

    public int getConstantBandwidthCode(int width, int height, int bandwidth) {
        int result = 0;
        if (this.getEntityType() == 202209L) {
            bandwidth /= 1024;
            HashMap<Integer, Integer> allowedValues = new HashMap<Integer, Integer>();
            allowedValues.put(4096, 1);
            allowedValues.put(2048, 3);
            allowedValues.put(1024, 4);
            allowedValues.put(512, 5);
            allowedValues.put(6144, 7);
            allowedValues.put(8192, 8);
            Integer key = Tools.getNearestAllowedValue(new ArrayList<Integer>(allowedValues.keySet()), bandwidth);
            if (key != null) {
                result = (Integer)allowedValues.get(key);
                this.logger.info("Bandwidth: " + bandwidth + " Oid-Value: " + result);
            } else {
                result = 1;
                this.logger.error("Couldn't determine constant bandwith code! Using 4096kb.");
            }
        } else {
            int resolutionCode;
            result = (bandwidth /= 1024) < 384 ? 6 : (bandwidth < 768 ? 5 : (bandwidth < 1536 ? 4 : (bandwidth < 2560 ? 3 : (bandwidth < 3584 ? 2 : ((resolutionCode = this.getResolutionCode(width, height)) < 9 || bandwidth < 5120 ? 1 : (bandwidth < 7168 ? 7 : 8))))));
        }
        return result;
    }

    public int getResolutionCode(int width, int height) {
        if (this.resolutionMode == 1) {
            if (width == 320 && height == 240) {
                return 2;
            }
            if (width == 352) {
                return 3;
            }
            if (width == 640 && height == 480) {
                return 4;
            }
            if (width == 704 && (height == 240 || height == 288)) {
                return 5;
            }
            if (width == 704 && (height == 480 || height == 576)) {
                return 6;
            }
            if (width == 720 && (height == 480 || height == 576)) {
                return 7;
            }
            if (width == 800 && height == 600) {
                return 8;
            }
            if (width == 1280 && height == 720) {
                return 9;
            }
            if (width == 1280 && height == 960) {
                return 10;
            }
            if (width == 1280 && height == 1024) {
                return 10;
            }
            if (width == 1920 && height == 1080) {
                return 11;
            }
            if (width == 2048 && height == 1536) {
                return 13;
            }
        } else if (this.resolutionMode == 2) {
            if (width == 176) {
                return 1;
            }
            if (width == 320) {
                return 2;
            }
            if (width == 640) {
                return 3;
            }
            if (width == 704) {
                return 4;
            }
            if (width == 720) {
                return 5;
            }
        }
        this.logger.warn("Resolution " + width + " x " + height + " unknown.");
        return 2;
    }

    protected void setModelInformation() {
        if (this.getEntityType() == 202203L) {
            this.dualVideoSystemMode = true;
        } else if (this.getEntityType() == 202207L) {
            this.h264Mode = 2;
            this.resolutionMode = 2;
            this.cameraTitleMode = 2;
            this.audioMode = 2;
            this.rtspMode = 2;
            this.jpegMode = 2;
            this.framerateMode = 2;
        } else if (this.getEntityType() == 202206L) {
            this.ptzMode = 2;
            this.imageFlipMode = 2;
        } else if (this.getEntityType() == 202209L) {
            this.audioMode = 3;
            this.jpegMode = 3;
        }
    }

    protected long getEntityType() {
        return this.getDeviceType();
    }

    protected int getAudioMode() {
        return this.audioMode;
    }

    protected int getRtspMode() {
        return this.rtspMode;
    }

    protected int getJPEGMode() {
        return this.jpegMode;
    }

    protected int getFramerateMode() {
        return this.framerateMode;
    }

    protected int getPtzMode() {
        return this.ptzMode;
    }

    protected int getH264Mode() {
        return this.h264Mode;
    }

    protected int getResolutionMode() {
        return this.resolutionMode;
    }

    protected int getCameraTitleMode() {
        return this.cameraTitleMode;
    }

    protected int getImageFlipMode() {
        return this.imageFlipMode;
    }

    @Deprecated
    protected boolean isDualVideoSystemMode() {
        return this.dualVideoSystemMode;
    }
}

