/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.cm.device.video.sanyo.mpeg;

import de.seetec.v5.re.cm.device.shared.net.NetworkCallback;
import de.seetec.v5.re.cm.device.shared.net.udp.UdpReaderUnicast;
import de.seetec.v5.re.cm.device.shared.net.udp.UdpWriterUnicast;
import de.seetec.v5.re.cm.device.shared.videosource.StreamingHelper;
import de.seetec.v5.re.cm.device.shared.videosource.StreamingHelperH264;
import de.seetec.v5.re.cm.device.shared.videosource.StreamingVideoSourceClient;
import de.seetec.v5.re.cm.device.video.sanyo.SanyoCameraSrv;
import de.seetec.v5.re.cm.device.video.sanyo.SanyoDevice;
import de.seetec.v5.re.cm.device.video.sanyo.SanyoHardwareMotionDetection;
import de.seetec.v5.re.cm.device.video.sanyo.SanyoMotionDetectionHandler;
import de.seetec.v5.re.shared.Codec;
import de.seetec.v5.re.shared.MediaFrame;
import de.seetec.v5.shared.Basic;
import de.seetec.v5.shared.net.NetworkHelper;
import de.seetec.v5.shared.net.NetworkParameter;
import de.seetec.v5.shared.util.SeeTecException;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.net.InetAddress;

public class SanyoMPEGVideoSourceClient
extends StreamingVideoSourceClient
implements NetworkCallback,
Runnable {
    private static final String CLASS_NAME = "de.seetec.v5.re.cm.sanyo.device.video.mpeg.SanyoMPEGVideoSourceClient";
    private static final int COMMAND_START = 1;
    private static final int COMMAND_STOP = 2;
    private static final int COMMAND_KEEP_ALIVE = 3;
    private static final int DEFAULT_UNICAST_PORT = 3939;
    private Thread myThread = null;
    private int aspect_ratio = 3;
    private UdpReaderUnicast udpReader = null;
    private UdpWriterUnicast udpWriter = null;
    private int mediaType = Integer.MIN_VALUE;
    private String cookie = null;
    private boolean startAcknowledged = false;
    private int startCounter = 0;
    private boolean isHDCamera = false;
    protected ByteArrayOutputStream nonHDFrame = new ByteArrayOutputStream();

    @Override
    public int init() {
        this.logger.info("init started for" + this.getVideoSrv());
        if (this.getVideoSrv().getEntityType() == 211900L) {
            this.isHDCamera = true;
        }
        this.completeFrame = new ByteArrayOutputStream();
        this.errorCode = super.init();
        if (this.errorCode != 0) {
            this.logger.error("Error while initializing. Code: " + this.errorCode + " for " + this);
            return this.errorCode;
        }
        try {
            StringBuilder sb;
            String[] lines;
            byte[] result = null;
            int resolution = -1;
            result = NetworkHelper.readGetRequest((NetworkParameter)this.networkParameter, (String)"/cgi-bin/lang.cgi", (int)Integer.MAX_VALUE);
            for (String line : lines = new String(result).split("\r\n")) {
                String[] cookieLine;
                if (!line.contains("Set-Cookie") || (cookieLine = line.split("=")).length < 2) continue;
                this.cookie = cookieLine[1].substring(0, cookieLine[1].indexOf(";"));
                break;
            }
            if (this.cookie == null) {
                this.logger.error("Not possible to get a cookie for " + this.getVideoSrv());
                return -20053;
            }
            this.cookie = "Cookie: NOBSESS=" + this.cookie + "\r\n";
            ((SanyoDevice)((SanyoCameraSrv)this.getVideoSrv()).getDevice()).setCookie(this.cookie);
            this.networkParameter.setAdditionalData(this.cookie);
            this.fps /= 1000L;
            this.quality /= 20000;
            int n = this.quality = this.quality > 4 ? 4 : this.quality;
            if (this.isHDCamera) {
                long l = this.fps = this.fps <= 15L ? 1L : 2L;
                if (this.width == 320) {
                    resolution = 0;
                } else if (this.width == 360) {
                    resolution = 0;
                    this.aspect_ratio = 1;
                } else if (this.width == 640) {
                    resolution = 1;
                } else if (this.width == 720) {
                    resolution = 1;
                    this.aspect_ratio = 1;
                } else if (this.width == 960) {
                    resolution = 2;
                } else if (this.width == 1080) {
                    resolution = 2;
                    this.aspect_ratio = 1;
                } else if (this.width == 1280) {
                    resolution = 3;
                } else if (this.width == 1920) {
                    resolution = 4;
                }
                sb = new StringBuilder("/cgi-bin/aspect.cgi?aspect_ratio=");
                sb.append(this.aspect_ratio);
                result = NetworkHelper.readGetRequest((NetworkParameter)this.networkParameter, (String)sb.toString(), (int)Integer.MAX_VALUE);
            } else {
                if (this.getVideoSrv().getEntityType() == 211920L || this.getVideoSrv().getEntityType() == 211921L) {
                    if (this.fps <= 7L) {
                        this.fps = 0L;
                    } else if (this.fps > 7L && this.fps <= 12L) {
                        this.fps = 1L;
                    } else if (this.fps > 12L && this.fps <= 17L) {
                        this.fps = 2L;
                    } else if (this.fps > 17L) {
                        this.fps = 3L;
                    }
                } else {
                    long l = this.fps = this.fps <= 15L ? 1L : 0L;
                }
                if (this.width == 176) {
                    resolution = 0;
                } else if (this.width == 352) {
                    resolution = 1;
                } else if (this.width == 720) {
                    resolution = 2;
                }
            }
            sb = new StringBuilder("/cgi-bin/codec_stream.cgi?");
            if (resolution == -1) {
                this.logger.warn("Given resolution '" + this.width + ":" + this.height + " not supported for " + this.getVideoSrv());
                return -21601;
            }
            sb.append("h264_resol=");
            sb.append(resolution);
            sb.append("&h264_quality=");
            sb.append(this.quality);
            sb.append("&h264_frame_rate=");
            sb.append(this.fps);
            sb.append("&h264_protocol=0");
            sb.append("&mul_set=0");
            result = NetworkHelper.readGetRequest((NetworkParameter)this.networkParameter, (String)sb.toString(), (int)Integer.MAX_VALUE);
            this.udpReader = new UdpReaderUnicast(this);
            this.udpReader.init(524288, 10000, true, true);
            try {
                this.udpWriter = new UdpWriterUnicast(InetAddress.getByName(this.getHost()), this.udpReader.getSocket(), 3939);
            }
            catch (Exception e) {
                this.logger.error((Object)e, (Throwable)e);
                return -20001;
            }
            this.logger.info("UDP port '" + this.udpReader.getPort() + "' opened for " + this.getVideoSrv());
            long initialWait = System.currentTimeMillis();
            this.sendUDPCommand(1);
            while (!this.startAcknowledged && this.startCounter < 100) {
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                if (System.currentTimeMillis() <= initialWait + 3000L) continue;
                this.sendUDPCommand(1);
                ++this.startCounter;
            }
        }
        catch (Throwable ex) {
            this.logger.error("Exception while initializing " + this.getVideoSrv());
            this.logger.error((Object)ex, ex);
            return -20001;
        }
        this.myThread = new Thread((Runnable)this, this.toString());
        this.myThread.start();
        this.logger.info("init done for" + this.getVideoSrv());
        return 0;
    }

    @Override
    public void onNetworkError(int error) {
        if (this.isShutdown()) {
            return;
        }
        this.logger.warn("Shutting down : " + error);
        this.listener.sendStatusService(error);
        this.shutdown();
    }

    @Override
    public synchronized int shutdown() {
        if (this.startShutdown(CLASS_NAME)) {
            return 0;
        }
        this.sendUDPCommand(2);
        this.sendUDPCommand(2);
        this.sendUDPCommand(2);
        try {
            Thread.sleep(500L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        if (this.udpReader != null) {
            this.udpReader.shutdown();
            this.udpReader = null;
        }
        if (this.udpWriter != null) {
            this.udpWriter.shutdown();
            this.udpWriter = null;
        }
        this.logger.info("shutdown done for " + this.getVideoSrv());
        return 0;
    }

    public void sendStatusService(int nStatusCode) {
        this.listener.sendStatusService(nStatusCode);
    }

    private void sendUDPCommand(int commandID) {
        byte[] command = new byte[]{0, 4, 112, 0};
        if (commandID != 1 && commandID != 2 && commandID != 3) {
            this.logger.warn("Unknwon udp command. Ignore it.");
        } else {
            command[3] = (byte)commandID;
            if (this.udpWriter != null) {
                this.udpWriter.send(command);
            }
        }
    }

    @Override
    public synchronized void onUdpData(byte[] data) {
        block30: {
            byte[] completeFrameAsByteArray = null;
            int alarmInformation = -128;
            if (this.isShutdown()) {
                return;
            }
            if (data == null) {
                this.logger.error("Incoming data is null for " + this.getVideoSrv());
                return;
            }
            try {
                if (data[0] == 72 && data[1] == 78 && data[2] == 67 && data[3] == 86) {
                    try {
                        int lengthHeader = Basic.byteArrayToInt4((byte[])new byte[]{data[4], data[5]});
                        this.completeFrame.write(data, lengthHeader, data.length - lengthHeader);
                        this.completeFrame.flush();
                        if (data[7] == 1) {
                            this.mediaType = data[lengthHeader - 1] == 0 ? 33 : 35;
                            alarmInformation = data[20];
                            if ((alarmInformation = (int)((byte)(alarmInformation >>> 4 & 7))) != 0 && (alarmInformation == 3 || alarmInformation == 4 || alarmInformation == 5) && this.getVideoSrv() != null && this.getVideoSrv().getHardwareMotionDetection() != null) {
                                ((SanyoMotionDetectionHandler)((Object)((SanyoHardwareMotionDetection)this.getVideoSrv().getHardwareMotionDetection()).getMotionDetectionHandler())).processMotionDetection();
                            }
                            if (data[16] == 0) {
                                completeFrameAsByteArray = this.completeFrame.toByteArray();
                                this.completeFrame.reset();
                            }
                        } else if (data[8] == 0) {
                            completeFrameAsByteArray = this.completeFrame.toByteArray();
                            this.completeFrame.reset();
                        }
                    }
                    catch (IOException ioe) {
                        this.logger.error((Object)ioe, (Throwable)ioe);
                    }
                } else {
                    if (data[0] == 72 && data[1] == 68 && data[2] == 78 && data[3] == 67) {
                        this.width = Basic.byteArrayToInt4((byte[])new byte[]{data[28], data[29]});
                        this.height = Basic.byteArrayToInt4((byte[])new byte[]{data[30], data[31]});
                        if (data[48] == 0 && data[49] == 0) {
                            this.startAcknowledged = true;
                        }
                        return;
                    }
                    if (data[0] == 68 && data[1] == 67 && data[2] == 78 && data[3] == 67) {
                        if (data[6] == 113 && data[7] == 0) {
                            this.width = Basic.byteArrayToInt4((byte[])new byte[]{data[26], data[27]});
                            this.height = Basic.byteArrayToInt4((byte[])new byte[]{data[28], data[29]});
                            if (data[46] == 0 && data[47] == 0) {
                                this.startAcknowledged = true;
                            }
                            return;
                        }
                        if (data[6] == 113 && (data[7] == 1 || data[7] == 2)) {
                            try {
                                int lengthHeader = Basic.byteArrayToInt4((byte[])new byte[]{data[4], data[5]});
                                this.completeFrame.write(data, lengthHeader, data.length - lengthHeader);
                                this.completeFrame.flush();
                                if (data[7] == 1) {
                                    alarmInformation = data[24];
                                    if (alarmInformation != 0 && this.getVideoSrv() != null && this.getVideoSrv().getHardwareMotionDetection() != null) {
                                        ((SanyoMotionDetectionHandler)((Object)((SanyoHardwareMotionDetection)this.getVideoSrv().getHardwareMotionDetection()).getMotionDetectionHandler())).processMotionDetection();
                                    }
                                    if (data[14] == 0) {
                                        completeFrameAsByteArray = this.completeFrame.toByteArray();
                                        this.completeFrame.reset();
                                    }
                                } else if (data[8] == 0) {
                                    completeFrameAsByteArray = this.completeFrame.toByteArray();
                                    this.completeFrame.reset();
                                }
                            }
                            catch (IOException ioe) {
                                this.logger.error((Object)ioe, (Throwable)ioe);
                            }
                        }
                    }
                }
                if (completeFrameAsByteArray == null) break block30;
                if (!this.isHDCamera) {
                    this.depacketizeAndDeliverFrame(completeFrameAsByteArray);
                    break block30;
                }
                if (this.mediaType < 0) break block30;
                try {
                    MediaFrame mediaFrame = StreamingHelper.createSeeTecVideoFrameHeader(Codec.H264, this.width, this.height, completeFrameAsByteArray);
                    this.deliverFrameCreateServerTimestamp(this.mediaType, mediaFrame);
                }
                catch (SeeTecException ex) {
                    this.logger.error("Exception while creating I-Frame for " + this + ": " + ex.getMessage());
                }
                this.mediaType = Integer.MIN_VALUE;
            }
            catch (Throwable t) {
                this.logger.error("Ignoring packet due to unexpected error: " + t.getMessage(), t);
            }
        }
    }

    private void depacketizeAndDeliverFrame(byte[] data) {
        byte[] boundary = new byte[]{0, 0, 1, -32};
        int index = 0;
        int packetLength = -1;
        int packetHeaderLength = -1;
        byte[] completeFrameAsByteArray = null;
        byte[] pes = null;
        try {
            while ((index = Basic.indexOfByteArray((byte[])data, (byte[])boundary, (int)index, (int)(data.length - index), (boolean)true)) != -1) {
                packetLength = Basic.byteArrayToInt4((byte[])new byte[]{data[index + 4], data[index + 5]});
                packetHeaderLength = data[index + 8];
                pes = new byte[packetLength - 3 - packetHeaderLength];
                System.arraycopy(data, index + 9 + packetHeaderLength, pes, 0, packetLength - 3 - packetHeaderLength);
                index += 6 + packetLength;
                if (Basic.indexOfByteArray((byte[])pes, (byte[])StreamingHelper.START_SEQUENCE, (int)1, (int)(pes.length - StreamingHelper.START_SEQUENCE.length), (boolean)true) == 1 && this.nonHDFrame.size() > 0) {
                    completeFrameAsByteArray = this.nonHDFrame.toByteArray();
                    this.nonHDFrame.reset();
                    this.core.deviceManagerStatistic.incrementGrabbedVideoFrames();
                    this.core.deviceManagerStatistic.incrementGrabbedData(completeFrameAsByteArray.length);
                    if (this.listener != null) {
                        this.mediaType = StreamingHelperH264.checkForH264MediaType(this.getVideoSrv().getDevice(), completeFrameAsByteArray, 1);
                        if (this.mediaType < 0) {
                            return;
                        }
                        if (this.mediaType == 7) {
                            this.mediaType = 33;
                        }
                        try {
                            MediaFrame mediaFrame = StreamingHelper.createSeeTecVideoFrameHeader(Codec.H264, this.width, this.height, completeFrameAsByteArray);
                            this.deliverFrameCreateServerTimestamp(this.mediaType, mediaFrame);
                        }
                        catch (SeeTecException ex) {
                            this.logger.error("Exception while creating I-Frame for " + this + ": " + ex.getMessage());
                        }
                        this.mediaType = Integer.MIN_VALUE;
                    }
                }
                this.nonHDFrame.write(pes);
            }
        }
        catch (Exception e) {
            this.logger.error((Object)e, (Throwable)e);
        }
    }

    @Override
    public void run() {
        long time = System.currentTimeMillis();
        long keepAliveInterval = 2000L;
        while (!this.isShutdown()) {
            try {
                Thread.sleep(200L);
            }
            catch (Exception e) {
                this.logger.fatal("Error while sleep. " + e.getMessage());
            }
            if (System.currentTimeMillis() <= time + keepAliveInterval) continue;
            this.sendUDPCommand(3);
            try {
                NetworkHelper.readGetRequest((NetworkParameter)this.networkParameter, (String)"/cgi-bin/codec_stream.cgi?status", (int)Integer.MIN_VALUE);
            }
            catch (Exception e) {
                this.logger.error((Object)e, (Throwable)e);
            }
            time = System.currentTimeMillis();
        }
    }

    @Override
    public final boolean isShutdown() {
        return this.isShutdown(CLASS_NAME);
    }

    public void notifyForNetworkProblems() {
        this.sendStatusService(-21603);
        this.listener.notifyForNetworkProblems();
        this.shutdown();
    }
}

