/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.cm.device.video.sanyo.mpeg;

import de.seetec.v5.re.cm.device.shared.net.rtsp.RTSPStreamSettings;
import de.seetec.v5.re.cm.device.shared.videosource.StreamingVideoSourceClientRTSP;
import de.seetec.v5.re.cm.device.video.sanyo.SanyoCameraSrv;
import de.seetec.v5.re.cm.device.video.sanyo.SanyoDevice;
import de.seetec.v5.re.cm.device.video.sanyo.SanyoHardwareMotionDetection;
import de.seetec.v5.re.cm.device.video.sanyo.SanyoMotionDetectionHandler;
import de.seetec.v5.shared.util.SeeTecException;
import java.io.ByteArrayOutputStream;

public class SanyoH264VideoSourceClient1
extends StreamingVideoSourceClientRTSP {
    static final String CONTENTLENGTH = "Content-Length: ";
    private static final String CLASS_NAME = "de.seetec.v5.re.cm.device.video.sanyo.mpeg.SanyoVideoSourceClient1";
    private int streamNumber = 0;
    private String videoInputStream = "/VideoInput/1/h264/";
    private SanyoDevice sanyoDevice = null;
    private boolean isPalFormat = false;

    private int setHttpParameters(int resolution, int aspectRatio, long frameRate, int pictureQuality) {
        byte[] result = null;
        StringBuilder sb = new StringBuilder("/cgi-bin/codec_stream.cgi?stream_set=");
        sb.append(this.streamNumber);
        sb.append("&codec=1");
        sb.append("&aspect_ratio=");
        sb.append(aspectRatio);
        sb.append("&h264_resol=");
        sb.append(resolution);
        sb.append("&h264_frame_rate=");
        sb.append(frameRate);
        sb.append("&rec_tregger=0");
        sb.append("&h264_priority_sw=0");
        sb.append("&h264_protocol=0");
        sb.append("&h264_quality=").append(pictureQuality);
        try {
            result = this.sanyoDevice.readGetRequest(this.networkParameter, sb.toString(), Integer.MAX_VALUE);
            if (result == null) {
                this.logger.error("Error while setting stream parameter for " + this.getVideoSrv());
                return -21601;
            }
        }
        catch (SeeTecException ex) {
            this.logger.error("Error setting parameters on camera: " + (Object)((Object)ex));
            return ex.getErrorCode();
        }
        return 0;
    }

    @Override
    protected int init() {
        try {
            int resolution = 0;
            byte[] result = null;
            this.errorCode = super.init();
            if (this.errorCode != 0) {
                this.logger.error("Error while initializing. Code: " + this.errorCode + " for " + this);
                return this.errorCode;
            }
            float aspectRatioValue = (float)this.width / (float)this.height;
            int aspectRatio = (double)aspectRatioValue < 1.5 ? 1 : 0;
            this.networkParameter.setSoTimeout(5000);
            this.sanyoDevice = (SanyoDevice)((SanyoCameraSrv)this.getVideoSrv()).getDevice();
            this.errorCode = this.sanyoDevice.setGlobalCameraParameters(this.networkParameter, this.rotationAngle, this.getVideoSrv().getEntityType(), this.streamNumber, this.listener.getVideoSourceParameter().getRtspPort());
            if (this.errorCode != 0) {
                this.listener.sendStatusService(this.errorCode);
            }
            this.sanyoDevice.setStartingStream(true);
            this.streamNumber = 0;
            this.videoInputStream = this.videoInputStream + (this.streamNumber + 1);
            this.logger.info("Starting stream number " + this.streamNumber);
            try {
                result = this.sanyoDevice.readGetRequest(this.networkParameter, "/cgi-bin/cam_set.cgi?status=1", 512);
                if (result != null) {
                    String resultString = new String(result);
                    this.isPalFormat = !resultString.contains("tv_format:(0)");
                }
            }
            catch (SeeTecException ex) {
                this.logger.error("Error checking for tv format: " + (Object)((Object)ex));
            }
            this.completeFrame = new ByteArrayOutputStream();
            this.quality /= 20000;
            this.quality = this.quality >= 5 ? 4 : this.quality;
            int n = this.quality = this.quality < 0 ? 0 : this.quality;
            this.fps = this.isPalFormat ? (this.fps <= 18750L ? 2L : 3L) : (this.fps <= 22500L ? 2L : 3L);
            resolution = this.width == 320 ? 0 : (this.width == 640 ? 1 : (this.width == 1024 ? 2 : (this.width == 1280 ? (this.height == 720 ? 2 : 3) : (this.width == 1600 ? 4 : 3))));
            this.errorCode = this.setHttpParameters(resolution, aspectRatio, this.fps, this.quality);
            if (this.errorCode != 0) {
                this.logger.error("Could not set Video Parameters using HTTP. Errorcode = " + this.errorCode + " for " + this.getVideoSrv());
                return this.errorCode;
            }
            this.sanyoDevice.addStream();
            try {
                Thread.sleep(2000L);
            }
            catch (InterruptedException ex) {
                this.logger.error("Error waiting for RTSP to start: " + ex);
            }
            this.rtspUrl = "rtsp://" + this.getHost() + this.videoInputStream;
            this.rtspSettings = new RTSPStreamSettings();
            this.errorCode = this.rtspSettings.init(this, null, this.networkParameter, this.listener.getVideoSourceParameter().getRtspPort(), this.rtspUrl, this.printDebug, this.transmissionID, this.networkParameter.getSoTimeout(), this.isAudioEnabled, 4, this.rtspUrl);
            if (this.errorCode != 0) {
                this.logger.error("Initialization of RTSPSettings failed with errorCode: " + this.errorCode + " for " + this.getVideoSrv());
                return this.errorCode;
            }
            this.rtspSettings.setReceiverReportsEnabled(false);
            this.rtspHandler = this.rtspSettings.getRTSPHandler();
            for (int rtspStarts = 0; rtspStarts < 10 && (this.errorCode = this.rtspHandler.start()) != 0; ++rtspStarts) {
                this.logger.warn("RTSPHandler could not start. Will retry in 2 seconds...");
                try {
                    Thread.sleep(2000L);
                    continue;
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            this.sanyoDevice.setStartingStream(false);
            this.logger.info("init done for" + this.getVideoSrv());
            return 0;
        }
        catch (Throwable t) {
            this.logger.error("Unexpected exception while initialization for " + this, t);
            return -20000;
        }
    }

    @Override
    public synchronized int shutdown() {
        if (this.startShutdown(CLASS_NAME)) {
            return 0;
        }
        if (this.sanyoDevice != null) {
            this.sanyoDevice.setStartingStream(false);
            this.sanyoDevice.removeStream();
        }
        return super.shutdown();
    }

    @Override
    public boolean isShutdown() {
        return this.isShutdown(CLASS_NAME);
    }

    @Override
    public void onNetworkError(int error) {
        if (this.isShutdown()) {
            return;
        }
        this.logger.warn("Shutting down : " + error);
        this.listener.sendStatusService(error);
        this.shutdown();
    }

    @Override
    public void processData(byte[] data) {
        if (data.length > 24 && this.listener.hasHardwareMotionDetection() && (data[1] & 0x6F) == 111 && (data[23] & 2) == 2 && this.getVideoSrv() != null && this.getVideoSrv().getHardwareMotionDetection() != null) {
            ((SanyoMotionDetectionHandler)((Object)((SanyoHardwareMotionDetection)this.getVideoSrv().getHardwareMotionDetection()).getMotionDetectionHandler())).processMotionDetection();
        }
        this.processRtpData(data);
    }

    @Override
    public void sendStatusService(int errorCode) {
        this.listener.sendStatusService(errorCode);
    }
}

