/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.cm.device.video.sanyo.jpeg;

import de.seetec.v5.re.cm.device.shared.net.httpserverpush.HttpServerPushContent;
import de.seetec.v5.re.cm.device.shared.net.httpserverpush.HttpServerPushHandler;
import de.seetec.v5.re.cm.device.shared.net.httpserverpush.HttpServerPushListenerIntf;
import de.seetec.v5.re.cm.device.shared.videosource.JPEGVideoSourceClient;
import de.seetec.v5.re.cm.device.video.sanyo.SanyoCameraSrv;
import de.seetec.v5.re.cm.device.video.sanyo.SanyoDevice;
import de.seetec.v5.re.cm.device.video.sanyo.SanyoHardwareMotionDetection;
import de.seetec.v5.re.cm.device.video.sanyo.SanyoMotionDetectionHandler;
import de.seetec.v5.shared.Basic;
import de.seetec.v5.shared.net.NetworkHelper;
import de.seetec.v5.shared.net.NetworkParameter;
import de.seetec.v5.shared.util.SeeTecException;

public class SanyoJPEGVideoSourceClient
extends JPEGVideoSourceClient
implements HttpServerPushListenerIntf {
    private static final String CLASS_NAME = "de.seetec.v5.re.cm.device.video.sanyo.jpeg.SanyoJPEGVideoSourceClient";
    private final byte[] END_OF_JPEG = new byte[]{-1, -39};
    private boolean isHDCamera = false;
    private KeepAlive keepAliveThread = null;

    @Override
    protected boolean isRunFinished() {
        return super.isRunFinished(CLASS_NAME);
    }

    @Override
    public int init() {
        int errorCode = 0;
        if (this.getVideoSrv().getEntityType() == 211900L) {
            this.isHDCamera = true;
        }
        if ((errorCode = super.init(false)) != 0) {
            this.logger.error("Error while initializing. Code: " + errorCode + " for " + this);
            return errorCode;
        }
        byte[] result = null;
        StringBuilder sb = new StringBuilder(256);
        int fps = 12;
        int resolution = -1;
        String cookie = null;
        int aspect_ratio = 2;
        try {
            String[] lines;
            result = NetworkHelper.readGetRequest((NetworkParameter)this.networkParameter, (String)"/cgi-bin/lang.cgi", (int)Integer.MAX_VALUE);
            for (String line : lines = new String(result).split("\r\n")) {
                String[] cookieLine;
                if (!line.contains("Set-Cookie") || (cookieLine = line.split("=")).length < 2) continue;
                cookie = cookieLine[1].substring(0, cookieLine[1].indexOf(";"));
                break;
            }
            if (cookie == null) {
                this.logger.error("Not possible to get a cookie for " + this.getVideoSrv());
            } else {
                cookie = "Cookie: NOBSESS=" + cookie + "\r\n";
                ((SanyoDevice)((SanyoCameraSrv)this.getVideoSrv()).getDevice()).setCookie(cookie);
                this.networkParameter.setAdditionalData(cookie);
                this.quality /= 20000;
                int n = this.quality = this.quality > 4 ? 4 : this.quality;
                if (this.highestFramerate <= 150L) {
                    fps = 0;
                } else if (this.highestFramerate > 150L && this.highestFramerate <= 250L) {
                    fps = 1;
                } else if (this.highestFramerate > 250L && this.highestFramerate <= 400L) {
                    fps = 2;
                } else if (this.highestFramerate > 400L && this.highestFramerate <= 750L) {
                    fps = 3;
                } else if (this.highestFramerate > 750L && this.highestFramerate <= 1500L) {
                    fps = 4;
                } else if (this.highestFramerate > 1500L && this.highestFramerate <= 2500L) {
                    fps = 5;
                } else if (this.highestFramerate > 2500L && this.highestFramerate <= 4000L) {
                    fps = 6;
                } else if (this.highestFramerate > 4000L && this.highestFramerate <= 7500L) {
                    fps = 7;
                } else if (this.highestFramerate > 7500L && this.highestFramerate <= 12500L) {
                    fps = 8;
                } else if (this.highestFramerate > 12500L && this.highestFramerate <= 17500L) {
                    fps = 9;
                } else if (this.highestFramerate > 17500L && this.highestFramerate <= 22500L) {
                    fps = 10;
                } else if (this.highestFramerate > 22500L && this.highestFramerate <= 26000L) {
                    fps = 11;
                } else if (this.highestFramerate > 26000L) {
                    fps = 12;
                }
                if (this.isHDCamera) {
                    if (this.width == 320) {
                        resolution = 0;
                    } else if (this.width == 640) {
                        if (this.height == 480) {
                            resolution = 1;
                        } else {
                            resolution = 0;
                            aspect_ratio = 0;
                        }
                    } else if (this.width == 800) {
                        resolution = 2;
                    } else if (this.width == 1024) {
                        if (this.height == 768) {
                            resolution = 3;
                        } else {
                            resolution = 1;
                            aspect_ratio = 0;
                        }
                    } else if (this.width == 1280) {
                        if (this.height == 960) {
                            resolution = 4;
                        } else {
                            resolution = 2;
                            aspect_ratio = 0;
                        }
                    } else if (this.width == 1600) {
                        resolution = 5;
                    } else if (this.width == 2288) {
                        resolution = 6;
                    }
                } else if (this.width == 176) {
                    resolution = 0;
                } else if (this.width == 360) {
                    resolution = 1;
                } else if (this.width == 720) {
                    resolution = this.height == 288 ? 2 : 4;
                } else if (this.width == 640) {
                    resolution = 3;
                }
                sb.append("/cgi-bin/record_set.cgi?record_sw=0");
                NetworkHelper.readGetRequest((NetworkParameter)this.networkParameter, (String)sb.toString(), (int)Integer.MAX_VALUE);
                if (this.isHDCamera) {
                    sb = new StringBuilder(256);
                    sb.append("/cgi-bin/aspect.cgi?aspect_ratio=");
                    sb.append(aspect_ratio);
                    NetworkHelper.readGetRequest((NetworkParameter)this.networkParameter, (String)sb.toString(), (int)Integer.MAX_VALUE);
                }
                sb = new StringBuilder("/cgi-bin/codec_stream.cgi?jframe_rate_admin=");
                sb.append(fps);
                sb.append("&jpeg_quality=");
                sb.append(this.quality);
                sb.append("&jpeg_resol=");
                sb.append(resolution);
                NetworkHelper.readGetRequest((NetworkParameter)this.networkParameter, (String)sb.toString(), (int)Integer.MAX_VALUE);
            }
        }
        catch (SeeTecException ex) {
            this.logger.error("Exception while setting camera parameters for " + this + ": " + ex.getMessage());
            return ex.getErrorCode();
        }
        this.keepAliveThread = new KeepAlive();
        this.keepAliveThread.init();
        this.myThread = new Thread((Runnable)this, this.toString());
        this.myThread.start();
        return errorCode;
    }

    @Override
    public void run() {
        int errorCode = 0;
        HttpServerPushHandler httpServerPushHandler = null;
        super.setRunFinished(CLASS_NAME, false);
        try {
            StringBuilder sb = new StringBuilder("/liveimg.cgi?serverpush=1");
            boolean asynchronous = false;
            httpServerPushHandler = new HttpServerPushHandler();
            this.networkParameter.setSoTimeout(5000);
            errorCode = httpServerPushHandler.init(this, this.networkParameter, sb.toString());
            if (errorCode != 0) {
                this.logger.error("Error [" + errorCode + "] with " + httpServerPushHandler);
            } else {
                httpServerPushHandler.startServerPush(asynchronous);
            }
        }
        catch (Exception e) {
            this.logger.error("Reading configuration from " + this.getVideoSrv().getDevice() + " failed :-(", (Throwable)e);
        }
        catch (Throwable ex) {
            this.logger.error((Object)ex, ex);
        }
        super.setRunFinished(CLASS_NAME, true);
        this.shutdown();
    }

    @Override
    public void sendStatusService(int nStatusCode) {
        this.listener.sendStatusService(nStatusCode);
    }

    @Override
    public void notifyForNetworkProblems() {
        this.sendStatusService(-21603);
        this.listener.notifyForNetworkProblems();
        this.shutdown();
    }

    @Override
    public void deliverContent(HttpServerPushContent httpServerPushContent) {
        byte[] contentData = httpServerPushContent.getContentBody();
        if (contentData != null) {
            int endOfJPEG = -1;
            endOfJPEG = Basic.indexOfByteArray((byte[])contentData, (byte[])this.END_OF_JPEG, (int)0);
            if (endOfJPEG != -1) {
                byte alarmInformation = contentData[endOfJPEG + 1];
                if (this.isHDCamera) {
                    alarmInformation = (byte)(alarmInformation >>> 4 & 7);
                }
                if (alarmInformation != 0) {
                    if (!this.isHDCamera && this.getVideoSrv() != null && this.getVideoSrv().getHardwareMotionDetection() != null) {
                        ((SanyoMotionDetectionHandler)((Object)((SanyoHardwareMotionDetection)this.getVideoSrv().getHardwareMotionDetection()).getMotionDetectionHandler())).processMotionDetection();
                    }
                    if ((alarmInformation == 3 || alarmInformation == 4 || alarmInformation == 5) && this.getVideoSrv() != null && this.getVideoSrv().getHardwareMotionDetection() != null) {
                        ((SanyoMotionDetectionHandler)((Object)((SanyoHardwareMotionDetection)this.getVideoSrv().getHardwareMotionDetection()).getMotionDetectionHandler())).processMotionDetection();
                    }
                }
            }
            this.deliverContent(contentData);
        }
    }

    private class KeepAlive
    implements Runnable {
        Thread keepAliveThread = null;

        private KeepAlive() {
        }

        public void init() {
            this.keepAliveThread = new Thread((Runnable)this, this.toString());
            this.keepAliveThread.start();
        }

        @Override
        public void run() {
            long time = System.currentTimeMillis();
            SanyoJPEGVideoSourceClient.this.logger.info("Start keep alive for " + SanyoJPEGVideoSourceClient.this.getVideoSrv().getDevice());
            try {
                while (!SanyoJPEGVideoSourceClient.this.isShutdown()) {
                    if (System.currentTimeMillis() > time + 60000L) {
                        NetworkHelper.readGetRequest((NetworkParameter)SanyoJPEGVideoSourceClient.this.networkParameter, (String)"/cgi-bin/codec_stream.cgi?status", (int)Integer.MIN_VALUE);
                        time = System.currentTimeMillis();
                    }
                    Thread.sleep(100L);
                }
            }
            catch (Exception e) {
                SanyoJPEGVideoSourceClient.this.logger.error((Object)e, (Throwable)e);
            }
        }
    }
}

