/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.cm.device.video.sanyo;

import de.seetec.v5.re.cm.device.shared.motiondetection.HardwareMotionDetection;
import de.seetec.v5.re.cm.device.shared.motiondetection.MotionDetectionHandler;
import de.seetec.v5.re.cm.device.video.sanyo.SanyoDevice;
import de.seetec.v5.shared.net.NetworkParameter;
import de.seetec.v5.shared.util.SeeTecException;
import org.apache.logging.log4j.LogManager;

public class SanyoMotionDetectionHandler
extends MotionDetectionHandler {
    private static final String CLASS_NAME = "de.seetec.v5.re.cm.device.video.sanyo.SanyoMotionDetectionHandler";
    private NetworkParameter networkParameter = null;
    private boolean motionEnabled = false;
    private boolean analyticsEnabled;
    private boolean motionWindowEnabled = false;
    private SanyoDevice sanyoDevice = null;
    private boolean motionMaskingEnabled = false;
    private int errorCode = 0;
    private byte[] result = null;

    public SanyoMotionDetectionHandler() {
        this.logger = LogManager.getLogger((String)CLASS_NAME);
    }

    @Override
    public int init(HardwareMotionDetection<? extends MotionDetectionHandler> hardwareMotionDetection) {
        this.listener = hardwareMotionDetection;
        if (this.listener == null) {
            return -20003;
        }
        try {
            this.networkParameter = this.listener.getVideoSrv().getDevice().getDeviceCnf().getNetworkParameter();
            this.sanyoDevice = (SanyoDevice)this.listener.getVideoSrv().getDevice();
            while (!this.sanyoDevice.isGlobalParametersSet()) {
                Thread.sleep(100L);
            }
            long entityType = this.listener.getVideoSrv().getEntityType();
            if (entityType == 211909L || entityType == 211918L || entityType == 211910L || entityType == 211919L) {
                String resultString;
                this.result = this.sanyoDevice.readGetRequest(this.networkParameter, "/cgi-bin/motion.cgi?status=1", Integer.MAX_VALUE, false, "\r\nend\r\n");
                if (this.result == null) {
                    this.logger.error("Error while getting motion detection settings from camera" + this.listener.getVideoSrv());
                } else {
                    resultString = new String(this.result);
                    if (resultString.toLowerCase().contains("unauthorized")) {
                        this.logger.error("Unauthorized access to camera on " + this.listener.getVideoSrv());
                        return -20053;
                    }
                    if (!resultString.contains("motion_sw:(3)") && !resultString.contains("motion_sw:(2)")) {
                        this.logger.warn("Motion Detection and Motion Masking / Analytics on camera DISABLED for " + this.listener.getVideoSrv());
                        return -21664;
                    }
                    if (resultString.contains("motion_sw:(2)")) {
                        this.motionWindowEnabled = false;
                        for (int j = 0; j < 32; ++j) {
                            if (!resultString.contains("m_detect_start_x" + (j + 1) + ":(") || resultString.contains("m_detect_start_x" + (j + 1) + ":(-1)") || !resultString.contains("m_detect_start_y" + (j + 1) + ":(") || resultString.contains("m_detect_start_y" + (j + 1) + ":(-1)") || !resultString.contains("m_detect_end_x" + (j + 1) + ":(") || resultString.contains("m_detect_end_x" + (j + 1) + ":(-1)") || !resultString.contains("m_detect_end_y" + (j + 1) + ":(") || resultString.contains("m_detect_end_y" + (j + 1) + ":(-1)")) continue;
                            this.motionWindowEnabled = true;
                        }
                        if (!this.motionWindowEnabled) {
                            this.logger.info("No motion window found on camera. Enable it on the camera or disable motion detection windows in SeeTec 5 system: " + this.listener.getVideoSrv());
                            return -21664;
                        }
                    }
                }
                this.result = this.sanyoDevice.readGetRequest(this.networkParameter, "/cgi-bin/camera_quality.cgi?status=1", Integer.MAX_VALUE, false, "\r\nend\r\n");
                if (this.result == null) {
                    this.logger.error("Error while getting motion detection settings from camera" + this.listener.getVideoSrv());
                } else {
                    resultString = new String(this.result);
                    if (resultString.toLowerCase().contains("unauthorized")) {
                        this.logger.error("Unauthorized access to camera on " + this.listener.getVideoSrv());
                        return -20053;
                    }
                    if (!resultString.contains("motion_sw:(1)")) {
                        this.logger.warn("Motion Detection DISABLED on Camera settings for " + this.listener.getVideoSrv());
                        this.logger.warn("Enable Motion Detection in the Browser Window, using MENU -> CAMERA -> MOTION ");
                        return -21664;
                    }
                }
            } else if (entityType == 211902L || entityType == 211911L || entityType == 211903L || entityType == 211912L || entityType == 211905L || entityType == 211914L || entityType == 211906L || entityType == 211915L || entityType == 211904L || entityType == 211913L || entityType == 211907L || entityType == 211916L || entityType == 211908L || entityType == 211917L) {
                this.result = this.sanyoDevice.readGetRequest(this.networkParameter, "/cgi-bin/motion.cgi?status=1", Integer.MAX_VALUE, false, "\r\nend\r\n");
                if (this.result == null) {
                    this.logger.error("Error while getting motion detection settings from camera for " + this.listener.getVideoSrv());
                } else {
                    String resultString = new String(this.result);
                    for (int i = 0; i < 5; ++i) {
                        int endIndex;
                        if (!resultString.contains("m_detect_sw" + (i + 1) + ":(1)")) continue;
                        this.motionWindowEnabled = true;
                        int beginIndex = resultString.indexOf("m_detect_area_data:(") + 20;
                        if (beginIndex != -1 && (endIndex = resultString.indexOf(")", beginIndex)) != -1) {
                            String motionDetectArea = resultString.substring(beginIndex, endIndex);
                            String[] motionDetectAreaData = motionDetectArea.split(",");
                            for (int j = i * 4; j < Math.min(i * 4 + 4, motionDetectArea.length()); ++j) {
                                if (!motionDetectAreaData[j].equals("-1")) continue;
                                this.motionWindowEnabled = false;
                            }
                        }
                        if (this.motionWindowEnabled) break;
                    }
                    if (resultString.contains("m_detect_area_data:()")) {
                        this.motionWindowEnabled = false;
                    }
                    this.analyticsEnabled = resultString.contains("motion_sw:(3)");
                    this.motionEnabled = resultString.contains("motion_sw:(2)");
                    this.motionMaskingEnabled = resultString.contains("motion_sw:(1)");
                    if (!(this.motionEnabled && this.motionWindowEnabled || this.motionMaskingEnabled || this.analyticsEnabled)) {
                        this.logger.warn("Motion Detection, Motion Masking and Analytics on camera DISABLED for " + this.listener.getVideoSrv());
                        return -21664;
                    }
                }
            }
        }
        catch (SeeTecException ste) {
            this.logger.error("Exception occured while configuring motion detection windows: " + (Object)((Object)ste), (Throwable)ste);
        }
        catch (Exception e) {
            this.logger.error("Error while reading configuration of MD windows for " + this.listener.getVideoSrv(), (Throwable)e);
        }
        return this.errorCode;
    }

    public void processMotionDetection() {
        if (this.listener != null) {
            this.listener.evaluateWindow(0);
        }
    }

    public void notifyForNetworkProblems() {
        this.logger.info("Network problem signaled for " + this.listener.getVideoSrv());
    }
}

