/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.cm.device.video.sanyo;

import de.seetec.v5.re.cm.device.shared.io.DigitalInputSrv;
import de.seetec.v5.re.cm.device.shared.io.DigitalOutputSrv;
import de.seetec.v5.re.cm.device.shared.io.IOHandler;
import de.seetec.v5.re.cm.device.video.sanyo.SanyoDevice;
import de.seetec.v5.shared.util.SeeTecException;

public class SanyoIOHandler
extends IOHandler {
    private static final String CLASS_NAME = "de.seetec.v5.re.cm.device.video.sanyo.SanyoIOHandler";
    private SanyoDevice sanyoDevice = null;
    private int errorCode = 0;
    private byte[] result = null;
    private String resultString;
    private boolean outputsEnabled = false;

    @Override
    public void run() {
        StringBuilder enableIOUrl;
        super.setRunFinished(CLASS_NAME, false);
        this.sanyoDevice = (SanyoDevice)this.device;
        while (!this.sanyoDevice.isGlobalParametersSet()) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        DigitalInputSrv[] inputs = super.getDigitalInputSrv();
        int entityID = this.sanyoDevice.getDeviceEntity().getEntityType().intValue();
        if ((long)entityID == 201909L || (long)entityID == 201918L) {
            try {
                for (int i = 0; i < 4; ++i) {
                    StringBuilder enableIOUrl2 = new StringBuilder("/cgi-bin/alarm_set.cgi?");
                    enableIOUrl2.append("alarm_num=").append(i).append("&alarm_in1=1&alarm_in_duration1=11");
                    this.result = this.sanyoDevice.readGetRequest(this.networkParameter, enableIOUrl2.toString(), Integer.MIN_VALUE);
                    if (this.result != null) continue;
                    this.logger.error("Error enabling input Nr." + i + " on Camera for " + this);
                }
                enableIOUrl = new StringBuilder("/cgi-bin/alarm_set.cgi?");
                enableIOUrl.append("alarm_out_sw=2&alarm_out_polarity=0&alarm_out_time=10&alarm_out_sw2=2&alarm_out_polarity2=0&alarm_out_time2=10&status=1");
                this.result = this.sanyoDevice.readGetRequest(this.networkParameter, enableIOUrl.toString(), Integer.MIN_VALUE);
                if (this.result == null) {
                    this.logger.error("Error enabling outputs on Camera for " + this);
                }
            }
            catch (SeeTecException ex) {
                this.logger.error("Exception occured enabling IO's on Camera : " + (Object)((Object)ex) + " on " + this);
            }
        } else if ((long)entityID == 201910L || (long)entityID == 201919L) {
            try {
                for (int i = 0; i < 8; ++i) {
                    StringBuilder enableIOUrl3 = new StringBuilder("/cgi-bin/alarm_set.cgi?");
                    enableIOUrl3.append("alarm_num=").append(i).append("&alarm_in1=1&alarm_in_duration1=11&status=1");
                    this.result = this.sanyoDevice.readGetRequest(this.networkParameter, enableIOUrl3.toString(), Integer.MIN_VALUE);
                    if (this.result != null) continue;
                    this.logger.error("Error enabling input Nr." + i + " on Camera");
                }
                enableIOUrl = new StringBuilder("/cgi-bin/alarm_set.cgi?");
                enableIOUrl.append("alarm_out_sw=2&alarm_out_polarity=0&alarm_out_time=10&alarm_out_sw2=2&alarm_out_polarity2=0&alarm_out_time2=10");
                this.result = this.sanyoDevice.readGetRequest(this.networkParameter, enableIOUrl.toString(), Integer.MIN_VALUE);
                if (this.result == null) {
                    this.logger.error("Error enabling outputs on Camera for " + this);
                }
            }
            catch (SeeTecException ex) {
                this.logger.error("Exception occured enabling IO's on Camera: " + (Object)((Object)ex) + " for " + this);
            }
        } else {
            StringBuilder enableInputUrl = new StringBuilder("/cgi-bin/alarm_set.cgi?");
            for (int i = 0; i < inputs.length; ++i) {
                if (i != 0) {
                    enableInputUrl.append("&");
                }
                enableInputUrl.append("alarm_in").append(i + 1).append("=1");
                enableInputUrl.append("&alarm_in_duration").append(i + 1).append("=11&status=1");
            }
            try {
                this.result = this.sanyoDevice.readGetRequest(this.networkParameter, enableInputUrl.toString(), Integer.MAX_VALUE, false, "\r\nend\r\n\r\n");
                if (this.result == null) {
                    this.logger.error("Could not enable digital input for " + this);
                }
            }
            catch (SeeTecException ex) {
                this.logger.error("Exception occured while enabling digital inputs: " + ex.getMessage());
            }
            if (this.result != null) {
                this.resultString = new String(this.result);
            }
        }
        while (!(this.isShutdown(CLASS_NAME) || super.isShutdown() || this.device.isShutdown())) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException ex) {
                this.logger.error("Exception while waiting to read next digital input. " + ex);
            }
            if ((this.errorCode = this.readDigitalInputs()) == 0) continue;
            this.logger.error("An Error occured reading digital inputs on " + this);
        }
        this.logger.info("Thread of this " + this + " finished :-)");
        super.setRunFinished(CLASS_NAME, true);
        this.shutdown();
    }

    private int readDigitalInputs() {
        block11: {
            String readInputsUrl = "/liveimg.cgi?pol=1";
            if (this.resultString == null) {
                try {
                    this.resultString = new String(this.sanyoDevice.readGetRequest(this.networkParameter, "/cgi-bin/alarm_set.cgi?status=1", Integer.MAX_VALUE, false, "\r\nend\r\n\r\n"));
                }
                catch (SeeTecException ex) {
                    this.logger.error("Error reading alarm configuration for " + this);
                }
            }
            if (this.sanyoDevice != null && !this.sanyoDevice.getIsStartingStream()) {
                try {
                    this.networkParameter.setSoTimeout(5000);
                    this.result = this.sanyoDevice.readGetRequest(this.networkParameter, readInputsUrl, Integer.MAX_VALUE, true);
                    if (this.result != null && this.result.length > 15) {
                        byte alarmInformation = this.result[this.result.length - 15];
                        DigitalInputSrv[] iServices = super.getDigitalInputSrv();
                        for (int i = 0; i < iServices.length / 2; ++i) {
                            if (((byte)(alarmInformation >>> i) & 1) == 1) {
                                if (this.resultString.contains("alarm_in_polarity" + (i + 1) + ":(1)")) {
                                    iServices[2 * i].checkInput(0);
                                    iServices[2 * i + 1].checkInput(0);
                                    continue;
                                }
                                iServices[2 * i].checkInput(1);
                                iServices[2 * i + 1].checkInput(1);
                                continue;
                            }
                            if (this.resultString.contains("alarm_in_polarity" + (i + 1) + ":(1)")) {
                                iServices[2 * i].checkInput(1);
                                iServices[2 * i + 1].checkInput(1);
                                continue;
                            }
                            iServices[2 * i].checkInput(0);
                            iServices[2 * i + 1].checkInput(0);
                        }
                    }
                }
                catch (SeeTecException ex) {
                    if (!this.logger.isDebugEnabled()) break block11;
                    this.logger.error("Could not read digital input: " + (Object)((Object)ex));
                }
            }
        }
        return 0;
    }

    @Override
    public int writeDigitalOutput(int outputNumber, int value, long holdTime) {
        DigitalOutputSrv service;
        this.networkParameter.setSoTimeout(5000);
        if (this.sanyoDevice == null) {
            this.sanyoDevice = (SanyoDevice)this.device;
        }
        if (!this.outputsEnabled) {
            this.errorCode = this.enableOutputs();
        }
        if ((service = super.getDigitalOutputSrv(outputNumber)) == null) {
            this.errorCode = -21601;
            return this.errorCode;
        }
        if (value < 0) {
            this.logger.error("Value [" + value + "] is not valid for " + this);
            this.errorCode = -21601;
            return this.errorCode;
        }
        try {
            IOHandler.HoldTimer holdTimer;
            String sURL = "/cgi-bin/opecmd.cgi?ope=53&num=" + value + "&port=" + (outputNumber - 1);
            this.result = this.sanyoDevice.readGetRequest(this.networkParameter, sURL, Integer.MIN_VALUE);
            if (this.result == null) {
                this.logger.error("Could not write digital output");
                return -21679;
            }
            if (holdTime > 0L && (this.errorCode = (holdTimer = new IOHandler.HoldTimer()).init(outputNumber, value > 0 ? 0 : 1, holdTime)) != 0) {
                holdTimer.shutdown();
                this.logger.warn("Creating " + holdTimer + " failed with error [" + this.errorCode + "]");
            }
        }
        catch (Throwable ex) {
            this.logger.warn("Problems setting output [" + outputNumber + "] of " + this, ex);
        }
        return this.errorCode;
    }

    private int enableOutputs() {
        DigitalOutputSrv output1 = super.getDigitalOutputSrv(1);
        DigitalOutputSrv output2 = super.getDigitalOutputSrv(2);
        StringBuilder enableOutputUrl = new StringBuilder("/cgi-bin/alarm_set.cgi?");
        if (output1 != null) {
            enableOutputUrl.append("&alarm_out_sw=2&alarm_out_time=11");
        }
        if (output2 != null) {
            enableOutputUrl.append("&alarm_out_sw2=2&alarm_out_time2=11");
        }
        String url = enableOutputUrl.toString();
        url = url.replace("?&", "?");
        try {
            this.result = this.sanyoDevice.readGetRequest(this.networkParameter, url, Integer.MIN_VALUE, false, "\r\nend\r\n\r\n");
            if (this.result == null) {
                this.logger.error("Could not enable digital output for " + this);
                this.errorCode = -21601;
            }
        }
        catch (SeeTecException ex) {
            this.logger.error("Exception occured while enabling digital outputs: " + ex.getMessage());
            this.errorCode = -21601;
        }
        this.outputsEnabled = true;
        return this.errorCode;
    }
}

