/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.cm.device.video.sanyo;

import de.seetec.v5.re.cm.configuration.definition.camera.VideoCameraDefinition;
import de.seetec.v5.re.cm.configuration.definition.device.DeviceDefinition;
import de.seetec.v5.re.cm.device.shared.VideoServer;
import de.seetec.v5.re.cm.device.shared.io.IOHandler;
import de.seetec.v5.re.cm.device.video.sanyo.SanyoIOHandler;
import de.seetec.v5.shared.net.NetworkHelper;
import de.seetec.v5.shared.net.NetworkParameter;
import de.seetec.v5.shared.util.ConfigurationException;
import de.seetec.v5.shared.util.SeeTecException;

public class SanyoDevice
extends VideoServer {
    private String cookie = null;
    private boolean isStartingStream = false;
    private boolean isStarted = false;
    private int motionDetectionStream = 0;
    private String tempCookie;
    private NetworkParameter networkParameter = null;
    static final String CONTENTLENGTH = "Content-Length: ";
    private boolean globalParametersSet = false;
    private int activeStreams = 0;
    private StringBuffer cameraParameters;
    private byte[] result = null;

    public void addStream() {
        ++this.activeStreams;
    }

    public void removeStream() {
        --this.activeStreams;
        this.activeStreams = this.activeStreams < 0 ? 0 : this.activeStreams;
    }

    public int getNumberOfStream() {
        return this.activeStreams;
    }

    public boolean isGlobalParametersSet() {
        return this.globalParametersSet;
    }

    public void setGlobalParametersSet(boolean globalParametersSet) {
        this.globalParametersSet = globalParametersSet;
    }

    public void setIsStarted(boolean isStarted) {
        this.isStarted = isStarted;
    }

    public boolean isIsStarted() {
        return this.isStarted;
    }

    public void setMotionDetectionStream(int streamNumber) {
        this.motionDetectionStream = streamNumber;
    }

    public int getMotionDetectionStream() {
        return this.motionDetectionStream;
    }

    public String getCookie() {
        return this.cookie;
    }

    public void setCookie(String value) {
        this.cookie = value;
    }

    public void setStartingStream(boolean startStream) {
        this.isStartingStream = startStream;
    }

    public boolean getIsStartingStream() {
        return this.isStartingStream;
    }

    @Override
    public int initializeDevice(long nSrvType) {
        super.initializeDevice(nSrvType);
        try {
            this.networkParameter = this.getDeviceCnf().getNetworkParameter();
        }
        catch (ConfigurationException ex) {
            this.logger.error("Exception while retrieving network Parameters: " + (Object)((Object)ex));
        }
        return 0;
    }

    @Override
    protected IOHandler createIOHandler() {
        return new SanyoIOHandler();
    }

    @Override
    protected boolean isSupportingIO() {
        return true;
    }

    @Override
    public String getFirmwareVersion() {
        String ret = null;
        try {
            this.result = this.readGetRequest(this.networkParameter, "/cgi-bin/cam_set.cgi?status=1", Integer.MAX_VALUE, true);
            if (this.result != null) {
                String[] camSet = new String(this.result).split("\r\n");
                for (int i = 0; i < camSet.length; ++i) {
                    if (camSet[i].indexOf("CAM") == -1 && camSet[i].indexOf("NET") == -1 && camSet[i].indexOf("I/O") == -1 && camSet[i].indexOf("MEC") == -1) continue;
                    ret = ret == null ? "\t\t" + camSet[i] + "\r\n" : ret + "\t\t" + camSet[i] + "\r\n";
                }
            }
            if (ret != null) {
                ret = ret.substring(0, ret.length() - 2);
            }
        }
        catch (SeeTecException ex) {
            this.logger.warn("Could not read camera firmware: " + ex.getMessage());
        }
        if (ret == null) {
            return "<unknown>";
        }
        return ret;
    }

    public synchronized int setGlobalCameraParameters(NetworkParameter networkParameter, int rotationAngle, long entityID, int streamNumber, int rtspPort) {
        if (!this.isGlobalParametersSet()) {
            byte[] result = null;
            this.setGlobalParametersSet(true);
            if (entityID == 211904L || entityID == 211913L || entityID == 211907L || entityID == 211916L || entityID == 211908L || entityID == 211917L || entityID == 211909L || entityID == 211918L || entityID == 211910L || entityID == 211919L) {
                try {
                    String checkStreams = "/cgi-bin/codec_stream.cgi?status=1";
                    result = this.readGetRequest(networkParameter, checkStreams, Integer.MAX_VALUE);
                    if (result == null) {
                        this.logger.error("Error while setting camera parameters for " + this);
                    } else {
                        String streamSetting = new String(result);
                        String deleteStreams = "/cgi-bin/codec_stream.cgi?stream_set=1&resol=0&frame_rate=0";
                        if (streamSetting.indexOf("stream2_sw:(1)") != -1 && (result = this.readGetRequest(networkParameter, deleteStreams, Integer.MAX_VALUE)) == null) {
                            this.logger.error("Error while setting camera parameters for " + this);
                        }
                        deleteStreams = "/cgi-bin/codec_stream.cgi?stream_set=2&resol=0&frame_rate=0";
                        if (streamSetting.indexOf("stream3_sw:(1)") != -1 && (result = this.readGetRequest(networkParameter, deleteStreams, Integer.MAX_VALUE)) == null) {
                            this.logger.error("Error while setting camera parameters for " + this);
                        }
                        deleteStreams = "/cgi-bin/codec_stream.cgi?stream_set=3&resol=0&frame_rate=0";
                        if (streamSetting.indexOf("stream4_sw:(1)") != -1 && (result = this.readGetRequest(networkParameter, deleteStreams, Integer.MAX_VALUE)) == null) {
                            this.logger.error("Error while setting camera parameters for " + this);
                        }
                        deleteStreams = "/cgi-bin/codec_stream.cgi?submit=1";
                        if ((streamSetting.indexOf("stream2_sw:(1)") != -1 || streamSetting.indexOf("stream3_sw:(1)") != -1 || streamSetting.indexOf("stream4_sw:(1)") != -1) && (result = this.readGetRequest(networkParameter, deleteStreams, Integer.MAX_VALUE)) == null) {
                            this.logger.error("Error while setting camera parameters for " + this);
                        }
                    }
                }
                catch (SeeTecException ex) {
                    this.logger.error("Exception occured while deleting streams on " + this + ": " + ex.getMessage());
                    return ex.getErrorCode();
                }
            }
            try {
                this.cameraParameters = new StringBuffer(256);
                this.cameraParameters.append("/cgi-bin/camera_quality.cgi?mirror_sw=");
                if (rotationAngle == 180) {
                    this.cameraParameters.append("3");
                } else {
                    this.cameraParameters.append("0");
                }
                result = this.readGetRequest(networkParameter, this.cameraParameters.toString(), Integer.MAX_VALUE);
                if (result == null) {
                    this.logger.error("Error while setting camera parameters for " + this);
                    return -20037;
                }
                StringBuilder rtspPortCurrentValue = new StringBuilder(256);
                rtspPortCurrentValue.append("/cgi-bin/net.cgi?status=1");
                result = this.readGetRequest(networkParameter, rtspPortCurrentValue.toString(), Integer.MAX_VALUE, false, "\r\nend\r\n");
                if (result == null) {
                    this.logger.error("Error while reading Network Configuration " + this);
                    return -21601;
                }
                int startIndex = -1;
                int endIndex = -1;
                String resultString = new String(result);
                startIndex = resultString.indexOf("rtsp_port:(");
                if (startIndex != -1 && (endIndex = resultString.indexOf(")", startIndex)) != -1 && (rtspPort = Integer.parseInt(resultString.substring(startIndex + 11, endIndex))) != rtspPort) {
                    StringBuilder rtspSetPort = new StringBuilder(256);
                    rtspSetPort.append("/cgi-bin/net.cgi?rtsp_port=").append(rtspPort);
                    result = this.readGetRequest(this.networkParameter, rtspSetPort.toString(), Integer.MAX_VALUE);
                    if (result == null) {
                        this.logger.error("Error setting RTSP Port for " + this);
                        return -21601;
                    }
                }
            }
            catch (SeeTecException ex) {
                this.logger.error("Exception while setting camera parameters for " + this + ": " + (Object)((Object)ex) + "errorcode: " + ex.getErrorCode());
                return ex.getErrorCode();
            }
            this.logger.info("Firmware on " + this + ":\r\n" + this.getFirmwareVersion());
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String readCookie(byte[] result, String url) throws SeeTecException {
        String[] lines;
        String urlToUse = "/";
        if (url != null) {
            urlToUse = url;
        }
        String localCookie = "";
        int loopCounter = 0;
        while (loopCounter < 10 && result == null) {
            this.networkParameter.setAdditionalData("");
            try {
                result = this.readGetRequest(this.networkParameter, urlToUse, Integer.MAX_VALUE);
                if (loopCounter <= 0) continue;
                Thread.sleep(1000L);
            }
            catch (SeeTecException ex) {
                this.logger.error("Could not establish connection for " + this + ", Errorcode: " + ex.getErrorCode());
                throw ex;
            }
            catch (InterruptedException ex) {
                this.logger.error("Error putting Thread to sleep: " + ex);
            }
            finally {
                ++loopCounter;
            }
        }
        for (String line : lines = new String(result).split("\r\n")) {
            String[] cookieLine;
            if (!line.contains("Set-Cookie") || (cookieLine = line.split("=")).length < 2) continue;
            localCookie = cookieLine[1].substring(0, cookieLine[1].indexOf(";"));
            break;
        }
        if (!localCookie.isEmpty()) {
            localCookie = "Cookie: NOBSESS=" + localCookie + "\r\n";
        }
        return localCookie;
    }

    public String readCookie(byte[] result) throws SeeTecException {
        return this.readCookie(result, null);
    }

    public byte[] readGetRequest(NetworkParameter networkParameter, String url, int wantedLength) throws SeeTecException {
        return this.readGetRequest(networkParameter, url, wantedLength, false);
    }

    public byte[] readGetRequest(NetworkParameter networkParameter, String url, int wantedLength, boolean useContentLength) throws SeeTecException {
        return this.readGetRequest(networkParameter, url, wantedLength, useContentLength, null);
    }

    public byte[] readGetRequest(NetworkParameter networkParameter, String url, int wantedLength, boolean useContentLength, String returnAt) throws SeeTecException {
        if (this.cookie == null) {
            if (url.equals("/")) {
                networkParameter.setAdditionalData("");
            } else {
                networkParameter.setAdditionalData(this.readCookie(null));
            }
        } else {
            networkParameter.setAdditionalData(this.cookie);
        }
        this.result = NetworkHelper.readGetRequest((NetworkParameter)networkParameter, (String)url, (int)wantedLength, (boolean)useContentLength, (String)returnAt);
        this.tempCookie = this.readCookie(this.result);
        if (!this.tempCookie.isEmpty()) {
            this.cookie = this.tempCookie;
            this.setCookie(this.tempCookie);
        }
        return this.result;
    }

    @Override
    protected DeviceDefinition getDeviceDefinitionFromDevice(String signature, String manufacturer, String name, String comments) throws SeeTecException {
        return null;
    }

    @Override
    protected VideoCameraDefinition getVideoCameraDefinitionFromDevice() throws SeeTecException {
        return null;
    }
}

