/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.cm.device.video.santec;

import de.seetec.v5.re.cm.device.shared.net.rtsp.RTSPHandlerIntf;
import de.seetec.v5.re.cm.device.shared.net.rtsp.RTSPResponse;
import de.seetec.v5.re.cm.device.shared.net.rtsp.RTSPStreamSettings;
import de.seetec.v5.re.cm.device.shared.net.rtsp.mikey.Mikey;
import de.seetec.v5.re.cm.device.shared.videoprofile.BasicVideoProfileHandler;
import de.seetec.v5.re.cm.device.shared.videosource.StreamingVideoSourceClientRTSP;
import de.seetec.v5.re.cm.device.video.santec.SantecDevice;
import de.seetec.v5.re.cm.device.video.santec.SantecHardwareMotionDetection;
import de.seetec.v5.re.cm.device.video.santec.SantecMotionDetectionHandler;
import de.seetec.v5.re.cm.shared.Tools;
import de.seetec.v5.re.shared.Codec;
import de.seetec.v5.shared.Basic;
import de.seetec.v5.shared.net.NetworkHelper;
import de.seetec.v5.shared.net.NetworkParameter;
import de.seetec.v5.shared.util.SeeTecException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class SantecVideoSourceClient
extends StreamingVideoSourceClientRTSP {
    private static final String CLASS_NAME = "de.seetec.v5.re.cm.device.video.santec.SantecVideoSourceClient";
    private MetadataSourceClient metadataSourceClient = null;
    private String lastPart = null;
    private SantecDevice santecDevice;
    private int streamNumber;
    private boolean isMotionDetectionStream = false;
    private String cameraConfiguration;
    private String codec;

    @Override
    public void processData(byte[] data) {
        this.processRtpData(data);
    }

    @Override
    public void sendStatusService(int errorCode) {
        this.listener.sendStatusService(errorCode);
    }

    @Override
    public int init() {
        try {
            StringBuffer url;
            this.errorCode = super.init();
            if (this.errorCode != 0) {
                this.logger.error("Error while initializing. Code: " + this.errorCode + " for " + this);
                return this.errorCode;
            }
            if (this.santecDevice == null) {
                this.santecDevice = (SantecDevice)this.getVideoSrv().getDevice();
            }
            if (this.videoCodec == Codec.MJPEG) {
                this.codec = "mjpeg";
            } else if (this.videoCodec == Codec.H264) {
                this.codec = "h264";
            } else if (this.videoCodec == Codec.MPEG4) {
                this.codec = "mpeg4";
            } else {
                this.logger.fatal("Unknown encoding type '" + this.videoCodec + "'selected for " + this.getVideoSrv());
                return -21601;
            }
            int n = this.streamNumber = this.listener instanceof BasicVideoProfileHandler ? 0 : 1;
            if (this.streamNumber == 0 && !this.santecDevice.isIpxIpnDevice() && this.getVideoSrv().getDevice().getDeviceType() != 203408L && this.getVideoSrv().getDevice().getDeviceType() != 203807L && this.getVideoSrv().getDevice().getDeviceType() != 200317L) {
                this.logger.info("Motion Detection Stream enabled");
                this.isMotionDetectionStream = true;
            } else {
                this.logger.info("Motion Detection Stream disabled");
            }
            if (this.santecDevice.isIpxIpnDevice()) {
                NetworkHelper.readGetRequest((NetworkParameter)this.networkParameter, (String)"/nvc-cgi/admin/param.fcgi?action=list&group=DIDO.DI.Ch0.trig", (int)Integer.MAX_VALUE, (boolean)false, null, (boolean)true);
            }
            byte[] result = NetworkHelper.readGetRequest((NetworkParameter)this.networkParameter, (String)"/nvc-cgi/admin/param.fcgi?action=list&group=Server,BITXT,Videocodec,System,MD", (int)Integer.MAX_VALUE, (boolean)false);
            this.cameraConfiguration = new String(result);
            this.errorCode = this.santecDevice.setGlobalParameters(this.networkParameter, this.videoSourceNr, this.streamNumber, this.cameraConfiguration, this.listener.getVideoSourceParameter().getRtspPort());
            if (this.errorCode != 0) {
                this.logger.error("Exception while setting global parameters for " + this);
                return this.errorCode;
            }
            this.errorCode = this.setImageParameter(this.fps, Long.valueOf(this.quality), this.isConstantBitrateUsed, this.bandwidth, this.iFrameDistMS, this.resolutionTag, true);
            if (this.errorCode != 0) {
                this.logger.error("Exception while setting stream parameters for " + this);
                return this.errorCode;
            }
            if (this.santecDevice.isIpxIpnDevice()) {
                url = new StringBuffer("/uapi-cgi/param.cgi?action=update");
                try {
                    if (this.useDateTime) {
                        url.append("&BITXT.Ch").append(this.videoSourceNr - 1).append(".St").append(this.streamNumber).append(".enable=yes");
                        url.append("&BITXT.Ch").append(this.videoSourceNr - 1).append(".St").append(this.streamNumber).append(".Time.enable=yes");
                        url.append("&BITXT.Ch").append(this.videoSourceNr - 1).append(".St").append(this.streamNumber).append(".Date.enable=yes");
                    } else {
                        url.append("&BITXT.Ch").append(this.videoSourceNr - 1).append(".St").append(this.streamNumber).append(".Time.enable=no");
                        url.append("&BITXT.Ch").append(this.videoSourceNr - 1).append(".St").append(this.streamNumber).append(".Date.enable=no");
                    }
                    NetworkHelper.readGetRequest((NetworkParameter)this.networkParameter, (String)url.toString(), (int)Integer.MAX_VALUE);
                }
                catch (SeeTecException e) {
                    this.logger.error("Exception while setting date/time for " + this, (Throwable)e);
                    return e.getErrorCode();
                }
                try {
                    url = new StringBuffer("/uapi-cgi/param.cgi?action=update");
                    if (this.useTitle && this.title != null && this.title.trim().length() > 0) {
                        url.append("&BITXT.Ch").append(this.videoSourceNr - 1).append(".St").append(this.streamNumber).append(".enable=yes");
                        url.append("&BITXT.Ch").append(this.videoSourceNr - 1).append(".St").append(this.streamNumber).append(".Name.enable=yes");
                        url.append("&BITXT.Ch").append(this.videoSourceNr - 1).append(".St").append(this.streamNumber).append(".Name.text=");
                        url.append(this.title);
                        NetworkHelper.readGetRequest((NetworkParameter)this.networkParameter, (String)url.toString(), (int)Integer.MAX_VALUE);
                    }
                    url.append("&BITXT.Ch").append(this.videoSourceNr - 1).append(".St").append(this.streamNumber).append(".Name.enable=no");
                    url.append("&BITXT.Ch").append(this.videoSourceNr - 1).append(".St").append(this.streamNumber).append(".Name.text=");
                    NetworkHelper.readGetRequest((NetworkParameter)this.networkParameter, (String)url.toString(), (int)Integer.MAX_VALUE);
                }
                catch (SeeTecException e) {
                    this.logger.error("Exception while setting title for " + this, (Throwable)e);
                    return e.getErrorCode();
                }
            } else {
                url = new StringBuffer("/nvc-cgi/admin/param.fcgi?action=update&group=BITXT.Ch" + (this.videoSourceNr - 1) + ".St" + this.streamNumber);
                try {
                    if (this.useDateTime && this.santecDevice.getCameraConfiguration("BITXT.Ch" + (this.videoSourceNr - 1) + ".St" + this.streamNumber + ".Time0.enable", this.cameraConfiguration).equals("no")) {
                        NetworkHelper.readGetRequest((NetworkParameter)this.networkParameter, (String)(url.toString() + ".Time0&enable=yes&position=138:238"), (int)Integer.MIN_VALUE);
                        NetworkHelper.readGetRequest((NetworkParameter)this.networkParameter, (String)(url.toString() + ".Date0&enable=yes&position=138:538"), (int)Integer.MIN_VALUE);
                    } else if (!this.useDateTime && this.santecDevice.getCameraConfiguration("BITXT.Ch" + (this.videoSourceNr - 1) + ".St" + this.streamNumber + ".Time0.enable", this.cameraConfiguration).equals("yes")) {
                        NetworkHelper.readGetRequest((NetworkParameter)this.networkParameter, (String)(url.toString() + ".Time0&enable=no"), (int)Integer.MIN_VALUE);
                        NetworkHelper.readGetRequest((NetworkParameter)this.networkParameter, (String)(url.toString() + ".Date0&enable=no"), (int)Integer.MIN_VALUE);
                    }
                }
                catch (SeeTecException e) {
                    this.logger.error("Exception while setting date/time for " + this, (Throwable)e);
                    return e.getErrorCode();
                }
                try {
                    if (this.useTitle && this.title != null && this.title.trim().length() > 0 && this.santecDevice.getCameraConfiguration("BITXT.Ch" + (this.videoSourceNr - 1) + ".St" + this.streamNumber + ".Name0.enable", this.cameraConfiguration).equals("no") || !this.santecDevice.getCameraConfiguration("BITXT.Ch" + (this.videoSourceNr - 1) + ".St" + this.streamNumber + ".Name0.text", this.cameraConfiguration).equals(this.title.trim())) {
                        url = new StringBuffer("/nvc-cgi/admin/param.fcgi?action=update&group=");
                        url.append("BITXT.Ch").append(this.videoSourceNr - 1).append(".St").append(this.streamNumber).append(".Name0&enable=yes");
                        url.append("&text=");
                        url.append(this.title);
                        url.append("&position=138:838");
                        NetworkHelper.readGetRequest((NetworkParameter)this.networkParameter, (String)url.toString(), (int)Integer.MIN_VALUE);
                    } else if (this.santecDevice.getCameraConfiguration("BITXT.Ch" + (this.videoSourceNr - 1) + ".St" + this.streamNumber + ".Name0.enable", this.cameraConfiguration).equals("yes")) {
                        url = new StringBuffer("/nvc-cgi/admin/param.fcgi?action=update&group=");
                        url.append("BITXT.Ch").append(this.videoSourceNr - 1).append(".St").append(this.streamNumber).append(".Name0&enable=no");
                        NetworkHelper.readGetRequest((NetworkParameter)this.networkParameter, (String)url.toString(), (int)Integer.MIN_VALUE);
                    }
                }
                catch (SeeTecException e) {
                    this.logger.error("Exception while setting title for " + this, (Throwable)e);
                    return e.getErrorCode();
                }
            }
            if (this.isMotionDetectionStream && this.santecDevice.getCameraConfiguration("Server.RTSP.S0.CH" + (this.videoSourceNr - 1) + ".Unicast.RTP" + this.streamNumber + ".includemeta", this.cameraConfiguration).equals("no")) {
                url = new StringBuffer("/nvc-cgi/admin/param.fcgi?action=update&group=");
                url.append("Server.RTSP.S0.CH").append(this.videoSourceNr - 1).append(".Unicast.RTP").append(this.streamNumber).append("&includemeta=yes");
                NetworkHelper.readGetRequest((NetworkParameter)this.networkParameter, (String)url.toString(), (int)Integer.MIN_VALUE);
            }
            if (!this.santecDevice.getCameraConfiguration("Server.RTSP.S0.h264type", this.cameraConfiguration).equals("vcl")) {
                url = new StringBuffer("/nvc-cgi/admin/param.fcgi?action=update&group=");
                url.append("Server.RTSP.S0&h264type=vcl");
                NetworkHelper.readGetRequest((NetworkParameter)this.networkParameter, (String)url.toString(), (int)Integer.MIN_VALUE);
            }
            if (this.santecDevice.isIpxIpnDevice()) {
                url = new StringBuffer("/nvc-cgi/admin/param.fcgi?action=list&group=Server.RTSP.S0.Unicast.RTP" + this.streamNumber);
                byte[] response = NetworkHelper.readGetRequest((NetworkParameter)this.networkParameter, (String)url.toString(), (int)Integer.MAX_VALUE);
                String responseAsString = new String(response);
                String regex = ".name=([\\p{Print}]+)";
                String sessionName = "";
                Matcher matcher = Pattern.compile(".name=([\\p{Print}]+)").matcher(responseAsString);
                if (matcher.find()) {
                    sessionName = matcher.group(1);
                }
                this.lastPart = "/" + sessionName;
            } else {
                this.lastPart = this.streamNumber == 0 ? "/ch" + (this.videoSourceNr - 1) + "_unicast_firststream" : "/ch" + (this.videoSourceNr - 1) + "_unicast_secondstream";
            }
            this.rtspUrl = "rtsp://" + this.getHost() + this.lastPart;
            this.rtspSettings = new RTSPStreamSettings();
            if (this.santecDevice.isIpxIpnDevice()) {
                this.networkParameter.setSoTimeout(5000);
            }
            if ((this.errorCode = this.rtspSettings.init(this, this.audioSourceClient, this.networkParameter, this.listener.getVideoSourceParameter().getRtspPort(), this.rtspUrl, this.printDebug, this.transmissionID, this.networkParameter.getSoTimeout(), this.isAudioEnabled, 4, this.rtspUrl)) != 0) {
                this.logger.error("Error while initializing RTSP settings for " + this + ". ErrorCode: " + this.errorCode);
                return this.errorCode;
            }
            this.rtspSettings.setUdpBuffer(65535);
            if (this.isMotionDetectionStream) {
                this.metadataSourceClient = new MetadataSourceClient(this);
                this.rtspSettings.enableMetadata(this.metadataSourceClient);
                this.rtspSettings.setMetadataTimeout(0);
            }
            this.rtspHandler = this.rtspSettings.getRTSPHandler();
            this.errorCode = this.rtspHandler.start();
            if (this.errorCode != 0) {
                this.logger.error("Error while starting RTSP Handler for " + this + ". ErrorCode: " + this.errorCode);
                return this.errorCode;
            }
            this.logger.info("init done for" + this.getVideoSrv());
            return 0;
        }
        catch (SeeTecException seeTecException) {
            this.logger.error("Unexpected exception while initialization for " + this, (Throwable)seeTecException);
            return seeTecException.getErrorCode();
        }
        catch (Throwable t) {
            this.logger.error("Unexpected exception while initialization for " + this, t);
            return -20000;
        }
    }

    @Override
    public synchronized int shutdown() {
        if (this.startShutdown(CLASS_NAME)) {
            return 0;
        }
        if (this.metadataSourceClient != null) {
            this.metadataSourceClient.shutdown();
            this.metadataSourceClient = null;
        }
        return super.shutdown();
    }

    @Override
    public void onNetworkError(int error) {
        if (this.isShutdown()) {
            return;
        }
        this.logger.warn("Shutting down : " + error);
        this.listener.sendStatusService(error);
        this.shutdown();
    }

    @Override
    public final boolean isShutdown() {
        return this.isShutdown(CLASS_NAME);
    }

    public int setImageParameter(long frameRate, long compression) {
        return this.setImageParameter(frameRate, compression, null, null, null, null, false);
    }

    public int setImageParameter(long frameRate, Long milliCompression, Boolean bandWidthControl, Integer bandWidth, Integer iFrameDistance, String resolution, boolean newStream) {
        String encoderConfiguration;
        if (frameRate == 0L) {
            this.shutdown();
            return 0;
        }
        this.logger.info("Setting new image Parameter");
        StringBuffer url = null;
        this.quality = (int)(milliCompression / 1000L);
        this.fps = frameRate / 1000L;
        long l = this.fps = this.fps < 1L ? 1L : this.fps;
        if (this.fps > 25L && !this.santecDevice.isIpxIpnDevice()) {
            try {
                encoderConfiguration = new String(NetworkHelper.readGetRequest((NetworkParameter)this.networkParameter, (String)("/nvc-cgi/admin/param.fcgi?action=list&group=System.Status.VideoIn.Ch" + (this.videoSourceNr - 1) + ".standard"), (int)Integer.MAX_VALUE, (boolean)false));
                if (this.santecDevice.getCameraConfiguration("System.Status.VideoIn.Ch" + (this.videoSourceNr - 1) + ".standard", encoderConfiguration).indexOf("NTSC") == -1) {
                    this.fps = 25L;
                }
            }
            catch (SeeTecException ex) {
                this.logger.error("Exception while reading camera configuration for " + this.listener + " : " + ex.getMessage());
            }
        }
        if (newStream) {
            if (this.santecDevice.isIpxIpnDevice()) {
                try {
                    encoderConfiguration = new String(NetworkHelper.readGetRequest((NetworkParameter)this.networkParameter, (String)"/uapi-cgi/param.cgi?action=list&group=ENCODER.Ch0.Videocodec.St0.enable", (int)Integer.MAX_VALUE, (boolean)false));
                    if (this.santecDevice.getCameraConfiguration("ENCODER.Ch" + (this.videoSourceNr - 1) + ".VideoCodec.St" + this.streamNumber + ".enable", encoderConfiguration).indexOf("enable=yes") == -1) {
                        url = new StringBuffer("/uapi-cgi/param.cgi?action=update&group=ENCODER.Ch" + (this.videoSourceNr - 1) + ".Videocodec.St" + this.streamNumber + "&enable=yes");
                        NetworkHelper.readGetRequest((NetworkParameter)this.networkParameter, (String)url.toString(), (int)Integer.MAX_VALUE, (boolean)false);
                    }
                }
                catch (SeeTecException ex) {
                    this.logger.error("Exception while enabling streaming for " + this + " : " + ex.getMessage());
                    return ex.getErrorCode();
                }
            }
            String middlePart = "VideoCodec.Ch" + (this.videoSourceNr - 1) + ".St" + this.streamNumber;
            String codecStringForAPI = null;
            url = new StringBuffer("/nvc-cgi/admin/param.fcgi?action=update&group=");
            url.append(middlePart);
            url.append("&enable=yes");
            if (this.videoCodec == Codec.MJPEG) {
                codecStringForAPI = "mjpeg";
            } else if (this.videoCodec == Codec.H264) {
                codecStringForAPI = "h264";
            } else if (this.videoCodec == Codec.MPEG4) {
                codecStringForAPI = "mpeg4";
            } else {
                this.logger.fatal("Unknown encoding type '" + this.videoCodec + "'selected for " + this.getVideoSrv());
                return -21601;
            }
            url.append("&standard=");
            url.append(codecStringForAPI);
            try {
                if (this.santecDevice.getCameraConfiguration("VideoCodec.Ch" + (this.videoSourceNr - 1) + ".St" + this.streamNumber + ".standard", this.cameraConfiguration).indexOf(codecStringForAPI) == -1) {
                    NetworkHelper.readGetRequest((NetworkParameter)this.networkParameter, (String)url.toString(), (int)Integer.MAX_VALUE);
                }
            }
            catch (SeeTecException e) {
                this.logger.error("Exception while setting codec for " + this.getVideoSrv(), (Throwable)e);
                return e.getErrorCode();
            }
            try {
                if (!this.santecDevice.getCameraConfiguration("Server.RTSP.S0.Unicast.RTP" + this.streamNumber + ".enable", this.cameraConfiguration).equals("yes") || !this.santecDevice.getCameraConfiguration("Server.RTSP.S0.Unicast.RTP" + this.streamNumber + ".includemeta", this.cameraConfiguration).equals("yes")) {
                    url = this.isAudioEnabled && !this.santecDevice.getCameraConfiguration("Server.RTSP.S0.Unicast.RTP" + this.streamNumber + ".includeaudio", this.cameraConfiguration).equals("yes") ? (this.isMotionDetectionStream && !this.santecDevice.getCameraConfiguration("Server.RTSP.S0.Unicast.RTP" + this.streamNumber + ".includemeta", this.cameraConfiguration).equals("yes") ? new StringBuffer("/nvc-cgi/admin/param.fcgi?action=update&group=Server.RTSP.S0.Unicast.RTP" + this.streamNumber + "&enable=yes&includemeta=yes&includeaudio=yes") : new StringBuffer("/nvc-cgi/admin/param.fcgi?action=update&group=Server.RTSP.S0.Unicast.RTP" + this.streamNumber + "&enable=yes&includeaudio=yes")) : (this.isMotionDetectionStream && !this.santecDevice.getCameraConfiguration("Server.RTSP.S0.Unicast.RTP" + this.streamNumber + ".includemeta", this.cameraConfiguration).equals("yes") ? new StringBuffer("/nvc-cgi/admin/param.fcgi?action=update&group=Server.RTSP.S0.Unicast.RTP" + this.streamNumber + "&enable=yes&includemeta=yes") : new StringBuffer("/nvc-cgi/admin/param.fcgi?action=update&group=Server.RTSP.S0.Unicast.RTP" + this.streamNumber + "&enable=yes"));
                    NetworkHelper.readGetRequest((NetworkParameter)this.networkParameter, (String)url.toString(), (int)Integer.MAX_VALUE);
                }
            }
            catch (SeeTecException e) {
                this.logger.error("Exception while setting codec for " + this.getVideoSrv(), (Throwable)e);
                return e.getErrorCode();
            }
        }
        boolean bitrateCtrlAlreadySet = false;
        boolean resolutionAlreadySet = false;
        boolean compressionAlreadySet = false;
        boolean bitrateAlreadySet = false;
        boolean framerateAlreadySet = false;
        boolean iFrameDistanceAlreadySet = false;
        boolean codecAlreadySet = false;
        if (this.codec.equals(this.santecDevice.getCameraConfiguration("VideoCodec.Ch" + (this.videoSourceNr - 1) + ".St" + this.streamNumber + ".standard", this.cameraConfiguration))) {
            codecAlreadySet = true;
        }
        if (this.codec.equals("mjpeg")) {
            iFrameDistanceAlreadySet = true;
        } else if (iFrameDistance != null) {
            this.iFrameDist = Tools.convertIFrameDistMStoFrameCount(this.fps * 1000L, iFrameDistance.intValue(), 0, 127);
            long iFrameDistOnCamera = Long.parseLong(this.santecDevice.getCameraConfiguration("VideoCodec.Ch" + (this.videoSourceNr - 1) + ".St" + this.streamNumber + "." + this.codec + ".pcount", this.cameraConfiguration));
            if (this.iFrameDist == iFrameDistOnCamera) {
                iFrameDistanceAlreadySet = true;
            }
        }
        int fpsOnCamera = Integer.parseInt(this.santecDevice.getCameraConfiguration("VideoCodec.Ch" + (this.videoSourceNr - 1) + ".St" + this.streamNumber + "." + this.codec + ".maxfps", this.cameraConfiguration));
        framerateAlreadySet = this.fps == (long)fpsOnCamera;
        boolean bl = framerateAlreadySet = !newStream ? false : framerateAlreadySet;
        if (resolution != null && (resolution = resolution.toLowerCase()).length() != 0 && this.santecDevice.getCameraConfiguration("VideoCodec.Ch" + (this.videoSourceNr - 1) + ".St" + this.streamNumber + "." + this.codec + ".resolution", this.cameraConfiguration).equals(resolution)) {
            resolutionAlreadySet = true;
        }
        if (!this.codec.equals("mjpeg") && bandWidthControl != null) {
            if (this.isConstantBitrateUsed) {
                if (bandWidth != null) {
                    this.bandwidth = bandWidth / 1024;
                    if (this.santecDevice.is4000LEncoder()) {
                        this.bandwidth = this.bandwidth < 256 ? 256 : this.bandwidth;
                    } else {
                        int n = this.bandwidth = this.bandwidth < 128 ? 128 : this.bandwidth;
                    }
                    this.bandwidth = this.santecDevice.isIpxIpnDevice() ? (this.bandwidth > 6000 ? 6000 : this.bandwidth) : (this.bandwidth > 4096 ? 4096 : this.bandwidth);
                    bitrateAlreadySet = Integer.parseInt(this.santecDevice.getCameraConfiguration("VideoCodec.Ch" + (this.videoSourceNr - 1) + ".St" + this.streamNumber + "." + this.codec + ".bitrate", this.cameraConfiguration)) == this.bandwidth;
                }
                bitrateCtrlAlreadySet = this.santecDevice.getCameraConfiguration("VideoCodec.Ch" + (this.videoSourceNr - 1) + ".St" + this.streamNumber + "." + this.codec + ".bitratectrl", this.cameraConfiguration).equals("cbr");
            } else {
                this.quality = 100000 - this.quality;
                this.quality = (int)(milliCompression / 1000L);
                this.quality = this.quality < 1 ? 1 : this.quality;
                this.quality = (int)((float)this.quality * 2.55f);
                compressionAlreadySet = Integer.parseInt(this.santecDevice.getCameraConfiguration("VideoCodec.Ch" + (this.videoSourceNr - 1) + ".St" + this.streamNumber + "." + this.codec + ".bitrate", this.cameraConfiguration)) == this.quality;
                compressionAlreadySet = !newStream ? true : compressionAlreadySet;
                bitrateCtrlAlreadySet = this.santecDevice.getCameraConfiguration("VideoCodec.Ch" + (this.videoSourceNr - 1) + ".St" + this.streamNumber + "." + this.codec + ".bitratectrl", this.cameraConfiguration).equals("vbr");
            }
        }
        url = new StringBuffer("/nvc-cgi/admin/param.fcgi?action=update&group=");
        String middlePart = "VideoCodec.Ch" + (this.videoSourceNr - 1) + ".St" + this.streamNumber;
        url.append(middlePart);
        if (this.codec.equals("mjpeg")) {
            url.append(".mjpeg");
            if (!resolutionAlreadySet && resolution != null) {
                url.append("&resolution=");
                url.append(resolution);
            }
            this.quality = (int)(milliCompression / 1000L);
            this.quality = this.quality < 0 ? 0 : this.quality;
            url.append("&quality=");
            url.append(this.quality);
            if (!framerateAlreadySet) {
                url.append("&maxfps=");
                url.append(this.fps);
            }
        } else {
            url.append(".").append(this.codec);
            if (!resolutionAlreadySet && resolution != null) {
                url.append("&resolution=");
                url.append(resolution);
            }
            if (this.isConstantBitrateUsed) {
                if (!bitrateCtrlAlreadySet && bandWidthControl != null) {
                    url.append("&bitratectrl=cbr");
                }
                if (!bitrateAlreadySet) {
                    url.append("&bitrate=");
                    url.append(this.bandwidth);
                }
            } else {
                if (!bitrateCtrlAlreadySet && bandWidthControl != null) {
                    url.append("&bitratectrl=vbr");
                }
                if (!compressionAlreadySet) {
                    url.append("&qvalue=");
                    url.append(this.quality);
                }
            }
            if (!framerateAlreadySet) {
                url.append("&maxfps=");
                url.append(this.fps);
            }
            if (!iFrameDistanceAlreadySet && iFrameDistance != null) {
                this.iFrameDist = Tools.convertIFrameDistMStoFrameCount(this.fps * 1000L, iFrameDistance.intValue(), 0, this.santecDevice.isIpxIpnDevice() ? 29 : 127);
                url.append("&pcount=");
                url.append(this.iFrameDist);
            }
        }
        try {
            if (!(bitrateCtrlAlreadySet && resolutionAlreadySet && compressionAlreadySet && bitrateAlreadySet && framerateAlreadySet && iFrameDistanceAlreadySet && codecAlreadySet)) {
                NetworkHelper.readGetRequest((NetworkParameter)this.networkParameter, (String)url.toString(), (int)Integer.MAX_VALUE);
            }
        }
        catch (SeeTecException e) {
            this.logger.error("Exception while setting image parameters for " + this.getVideoSrv(), (Throwable)e);
            return e.getErrorCode();
        }
        try {
            if (this.getVideoSrv().getHardwareMotionDetection() != null) {
                url = new StringBuffer("/nvc-cgi/admin/param.fcgi?action=update&group=MD&enable=yes");
                NetworkHelper.readGetRequest((NetworkParameter)this.networkParameter, (String)url.toString(), (int)Integer.MIN_VALUE);
            }
        }
        catch (SeeTecException e) {
            this.logger.error("Exception while setting MD for " + this.getVideoSrv(), (Throwable)e);
            return e.getErrorCode();
        }
        try {
            if (this.isAudioEnabled) {
                String codecAsString = null;
                if (this.audioCodec == Codec.G711U) {
                    codecAsString = "ulaw";
                } else if (this.audioCodec == Codec.PCM) {
                    codecAsString = "pcm8";
                }
                this.logger.info("Audio Parameter: " + this.audioCodec + " with " + this.audioBitrate + "bit for " + this.getVideoSrv().getDevice());
                url = new StringBuffer("/nvc-cgi/admin/param.fcgi?action=update&group=AudioIn.Ch" + (this.videoSourceNr - 1) + "&enable=yes");
                if (this.santecDevice.isIpxIpnDevice()) {
                    NetworkHelper.readGetRequest((NetworkParameter)this.networkParameter, (String)url.toString(), (int)Integer.MAX_VALUE);
                } else {
                    NetworkHelper.readGetRequest((NetworkParameter)this.networkParameter, (String)url.toString(), (int)Integer.MIN_VALUE);
                }
                url = new StringBuffer("/nvc-cgi/admin/param.fcgi?action=update&group=AudioIn.Ch" + (this.videoSourceNr - 1) + ".adc&frequency=8000");
                this.logger.info((CharSequence)url);
                if (!this.santecDevice.isIpxIpnDevice()) {
                    NetworkHelper.readGetRequest((NetworkParameter)this.networkParameter, (String)url.toString(), (int)Integer.MAX_VALUE);
                } else {
                    url.append("&codec=").append(codecAsString);
                    NetworkHelper.readGetRequest((NetworkParameter)this.networkParameter, (String)url.toString(), (int)Integer.MIN_VALUE);
                }
            }
        }
        catch (SeeTecException e) {
            this.logger.error("Exception while setting Audio " + this.getVideoSrv());
            this.logger.error((Object)e, (Throwable)e);
            return e.getErrorCode();
        }
        return 0;
    }

    protected class MetadataSourceClient
    implements RTSPHandlerIntf {
        private RTSPHandlerIntf listener = null;
        private byte[] receiverReportMetadata = new byte[32];
        int RTP_HEADER_OFFSET = 12;
        private int[] objectSizeSettings = null;
        private long time;

        public MetadataSourceClient(RTSPHandlerIntf listener) {
            this.listener = listener;
            this.receiverReportMetadata[0] = -127;
            this.receiverReportMetadata[1] = -55;
            this.receiverReportMetadata[2] = 0;
            this.receiverReportMetadata[3] = 7;
        }

        @Override
        public void onNetworkError(int error) {
            if (this.listener != null) {
                this.listener.onNetworkError(error);
            }
        }

        @Override
        public void processData(byte[] data) {
            if (!SantecVideoSourceClient.this.isMotionDetectionStream) {
                return;
            }
            if (SantecVideoSourceClient.this.getVideoSrv().getHardwareMotionDetection() != null && (this.objectSizeSettings == null || System.currentTimeMillis() - this.time > 1000L)) {
                this.time = System.currentTimeMillis();
                try {
                    String result = new String(NetworkHelper.readGetRequest((NetworkParameter)SantecVideoSourceClient.this.networkParameter, (String)"/nvc-cgi/admin/param.fcgi?action=list&group=MD.*", (int)Integer.MAX_VALUE));
                    this.objectSizeSettings = new int[8];
                    for (int i = 0; i < 8; ++i) {
                        this.objectSizeSettings[i] = Integer.parseInt(SantecVideoSourceClient.this.santecDevice.getCameraConfiguration("MD.Ch" + (SantecVideoSourceClient.this.videoSourceNr - 1) + ".Z" + i + ".objectsize", result));
                    }
                }
                catch (NumberFormatException ex) {
                    SantecVideoSourceClient.this.logger.error("Exception while reading Motion Detection configuration from camera: " + ex.getMessage());
                }
                catch (SeeTecException ex) {
                    SantecVideoSourceClient.this.logger.error("Exception while reading Motion Detection configuration from camera: " + ex.getMessage());
                }
                catch (Exception ex) {
                    SantecVideoSourceClient.this.logger.error("Exception while reading Motion Detection configuration from camera: " + ex.getMessage());
                }
            }
            int offset = 0;
            if (data[1] != -56 && data[this.RTP_HEADER_OFFSET + 4] == 68 && data[this.RTP_HEADER_OFFSET + 5] == 70 && data[this.RTP_HEADER_OFFSET + 6] == 79 && data[this.RTP_HEADER_OFFSET + 7] == 0) {
                offset = this.RTP_HEADER_OFFSET + 32;
                int nextOffsetToMDMetaHdr = -1;
                while (nextOffsetToMDMetaHdr != 0) {
                    byte[] nextOffsetToMDMetaHdrArray = new byte[]{data[offset + 15], data[offset + 14], data[offset + 13], data[offset + 12]};
                    nextOffsetToMDMetaHdr = Basic.byteArrayToInt4((byte[])nextOffsetToMDMetaHdrArray);
                    byte[] metaDataTypeArray = new byte[]{data[offset + 19], data[offset + 18], data[offset + 17], data[offset + 16]};
                    int metaDataType = Basic.byteArrayToInt4((byte[])metaDataTypeArray);
                    if (metaDataType != 3) {
                        if (metaDataType == 2) {
                            int zoneInfoOffset = offset + 32;
                            int sizeOfZoneInfo = 0;
                            for (int i = 0; i < 8; ++i) {
                                SantecHardwareMotionDetection santecHardwareMotionDetection;
                                byte[] iEnabledArray = new byte[]{data[zoneInfoOffset + 3], data[zoneInfoOffset + 2], data[zoneInfoOffset + 1], data[zoneInfoOffset + 0]};
                                int iEnabled = Basic.byteArrayToInt4((byte[])iEnabledArray);
                                byte[] iZoneIndexArray = new byte[]{data[zoneInfoOffset + 15], data[zoneInfoOffset + 14], data[zoneInfoOffset + 13], data[zoneInfoOffset + 12]};
                                int iZoneIndex = Basic.byteArrayToInt4((byte[])iZoneIndexArray);
                                byte[] iObjectSizeArray = new byte[]{data[zoneInfoOffset + 23], data[zoneInfoOffset + 22], data[zoneInfoOffset + 21], data[zoneInfoOffset + 20]};
                                int iObjectSize = Basic.byteArrayToInt4((byte[])iObjectSizeArray);
                                byte[] iPointNumArray = new byte[]{data[zoneInfoOffset + 27], data[zoneInfoOffset + 26], data[zoneInfoOffset + 25], data[zoneInfoOffset + 24]};
                                int iPointNum = Basic.byteArrayToInt4((byte[])iPointNumArray);
                                sizeOfZoneInfo = 28 + iPointNum * 16;
                                zoneInfoOffset += sizeOfZoneInfo;
                                if (iEnabled != 1 || this.objectSizeSettings == null || iObjectSize < this.objectSizeSettings[i] || (santecHardwareMotionDetection = (SantecHardwareMotionDetection)SantecVideoSourceClient.this.getVideoSrv().getHardwareMotionDetection()) == null) continue;
                                ((SantecMotionDetectionHandler)((Object)((SantecHardwareMotionDetection)SantecVideoSourceClient.this.getVideoSrv().getHardwareMotionDetection()).getMotionDetectionHandler())).processMotionDetection(iZoneIndex);
                            }
                        } else {
                            SantecVideoSourceClient.this.logger.error("Metadata type not known for " + this);
                            return;
                        }
                    }
                    offset += nextOffsetToMDMetaHdr;
                }
            }
        }

        public void shutdown() {
            this.listener = null;
            this.receiverReportMetadata = null;
        }

        @Override
        public void sendStatusService(int errorCode) {
        }

        @Override
        public void sendDescribeResponse(RTSPResponse response) {
        }

        @Override
        public void setSsrcfromRtsp(String ssrc) {
        }

        @Override
        public void setMikey(Mikey mikey) {
        }
    }
}

