/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.cm.device.video.santec;

import de.seetec.v5.re.cm.configuration.definition.camera.VideoCameraDefinition;
import de.seetec.v5.re.cm.configuration.definition.device.DeviceDefinition;
import de.seetec.v5.re.cm.device.shared.VideoServer;
import de.seetec.v5.re.cm.device.shared.io.IOHandler;
import de.seetec.v5.re.cm.device.video.santec.SantecIOHandler;
import de.seetec.v5.shared.net.NetworkHelper;
import de.seetec.v5.shared.net.NetworkParameter;
import de.seetec.v5.shared.util.SeeTecException;

public class SantecDevice
extends VideoServer {
    private boolean globalParametersSet;

    public int setGlobalParameters(NetworkParameter networkParameter, int videoSourceNr, int streamNumber, String cameraConfiguration, int rtspPort) {
        if (this.globalParametersSet) {
            return 0;
        }
        this.globalParametersSet = true;
        StringBuffer url = null;
        byte[] result = null;
        if (networkParameter == null || rtspPort <= 0 || rtspPort != 554 && rtspPort < 1024) {
            this.logger.error("Invalid customized RTSP port: " + rtspPort + ". Valid values 554,1024..65535");
            return -21601;
        }
        this.logger.info("Using RTSP port: " + rtspPort);
        try {
            boolean mdActive = this.getCameraConfiguration("MD.enable", cameraConfiguration).equals("yes");
            if (!mdActive && (result = NetworkHelper.readGetRequest((NetworkParameter)networkParameter, (String)(url = new StringBuffer("/nvc-cgi/admin/param.fcgi?action=update&group=MD&enable=yes")).toString(), (int)Integer.MIN_VALUE)) == null) {
                this.logger.error("Error while enabling Motion Detection for " + this);
                return -21601;
            }
            int rtspPortOnCamera = Integer.parseInt(this.getCameraConfiguration("Server.RTSP.S0.port", cameraConfiguration));
            if (rtspPort != rtspPortOnCamera && (result = NetworkHelper.readGetRequest((NetworkParameter)networkParameter, (String)(url = new StringBuffer("/nvc-cgi/admin/param.fcgi?action=update&group=Server.RTSP.S0&enable=yes&port=" + rtspPort)).toString(), (int)Integer.MIN_VALUE)) == null) {
                this.logger.error("Error while resetting codec for " + this);
                return -21601;
            }
            if ((this.getCameraConfiguration("Server.RTSP.S0.Authen.enable", cameraConfiguration).equals("no") || this.getCameraConfiguration("Server.RTSP.S0.Authen.type", cameraConfiguration).equals("basic") || !this.getCameraConfiguration("Server.RTSP.S0.Authen.privilege", cameraConfiguration).equals("administrator")) && (result = NetworkHelper.readGetRequest((NetworkParameter)networkParameter, (String)(url = new StringBuffer("/nvc-cgi/admin/param.fcgi?action=update&group=Server.RTSP.S0.Authen&enable=yes&type=digest&privilege=administrator")).toString(), (int)Integer.MIN_VALUE)) == null) {
                this.logger.error("Error while resetting codec for " + this);
                return -21601;
            }
        }
        catch (SeeTecException e) {
            this.logger.error("Exception while setting codec for " + this, (Throwable)e);
            return e.getErrorCode();
        }
        return 0;
    }

    @Override
    protected IOHandler createIOHandler() {
        return new SantecIOHandler();
    }

    @Override
    protected boolean isSupportingIO() {
        return true;
    }

    public String getCameraConfiguration(String configurationName, String configurationData) {
        String[] configuration;
        for (String configuration1 : configuration = configurationData.split("\r\n")) {
            String[] configurationLine = configuration1.split("=");
            if (configurationLine.length != 2 || !configurationLine[0].equals(configurationName)) continue;
            return configurationLine[1];
        }
        return "1";
    }

    public final boolean isIpxIpnDevice() {
        return this.getDeviceType() == 203406L || this.getDeviceType() == 203805L;
    }

    @Override
    protected DeviceDefinition getDeviceDefinitionFromDevice(String signature, String manufacturer, String name, String comments) throws SeeTecException {
        return null;
    }

    @Override
    protected VideoCameraDefinition getVideoCameraDefinitionFromDevice() throws SeeTecException {
        return null;
    }

    public boolean is4000LEncoder() {
        return this.getDeviceType() == 203408L || this.getDeviceType() == 203807L || this.getDeviceType() == 200317L;
    }
}

