/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.cm.device.video.santec;

import de.seetec.v5.re.cm.device.shared.VideoSrv;
import de.seetec.v5.re.cm.device.shared.cameracontrol.CameraControl;
import de.seetec.v5.re.cm.device.shared.cameracontrol.PresetCnf;
import de.seetec.v5.re.cm.device.video.santec.SantecDevice;
import de.seetec.v5.re.cm.shared.communication.VideoServiceClientRequestHandler;
import de.seetec.v5.shared.net.NetworkHelper;
import de.seetec.v5.shared.net.NetworkParameter;
import de.seetec.v5.shared.util.ConfigurationException;
import de.seetec.v5.shared.util.SeeTecException;
import java.net.URLEncoder;
import java.util.Vector;

public class SantecCameraControl
extends CameraControl {
    @Override
    public int init(VideoSrv videoSrv, String api, String host, int port, String usr, String pwd, Vector<PresetCnf> presetList) {
        int errorCode = super.init(videoSrv, api, host, port, usr, pwd, presetList);
        try {
            String urlForPtzAddress = "/nvc-cgi/ptz/ptz2.fcgi?ptzaddr=" + this.videoSrv.getVideoSourceCnf().getPtzAddress();
            NetworkHelper.readGetRequest((NetworkParameter)this.networkParameter, (String)urlForPtzAddress, (int)Integer.MAX_VALUE);
        }
        catch (SeeTecException ex) {
            this.logger.warn("Could not set PTZ Address for " + this);
        }
        catch (ConfigurationException ex) {
            this.logger.warn("Could not set PTZ Address for " + this);
        }
        return errorCode;
    }

    private int sendCameraCommand(String url) {
        if (url == null || url.isEmpty()) {
            return 0;
        }
        try {
            String completeURL = "/nvc-cgi/ptz/ptz2.fcgi?ptzid=" + this.videoSrv.getVideoSourceCnf().getPtzAddress() + url;
            if (((SantecDevice)this.videoSrv.getDevice()).isIpxIpnDevice()) {
                completeURL = "/uapi-cgi/uptz.cgi?" + url;
            } else if (this.videoSrv.getDevice().getDeviceType() == 200317L || this.videoSrv.getDevice().getDeviceType() == 203807L || this.videoSrv.getDevice().getDeviceType() == 203408L || this.videoSrv.getDevice().getDeviceType() == 200316L || this.videoSrv.getDevice().getDeviceType() == 203806L || this.videoSrv.getDevice().getDeviceType() == 203407L) {
                completeURL = "/nvc-cgi/ptz/ptz2.fcgi?ptzid=1" + url;
            }
            completeURL = completeURL.replace("?&", "?");
            if (this.logger.isDebugEnabled()) {
                this.logger.info("Sending URL=[ " + completeURL + " ] for " + this + " ...");
            }
            this.videoSrv.notifyForCameraControl();
            NetworkHelper.readGetRequest((NetworkParameter)this.networkParameter, (String)completeURL, (int)Integer.MAX_VALUE);
            return 0;
        }
        catch (Throwable ex) {
            this.logger.error((Object)ex, ex);
            return -21600;
        }
    }

    @Override
    public int setAbsolutePTZ(VideoServiceClientRequestHandler sender, Integer pan, Integer tilt, Integer zoom) {
        throw new RuntimeException("NOT YET IMPLEMENTED :-( ");
    }

    @Override
    public int setContinuousPTZ(Integer panSpeed, Integer tiltSpeed, Integer zoomSpeed) {
        int zoom;
        int tilt;
        int pan;
        if (panSpeed != null) {
            this.previousPanSpeed = pan = panSpeed / 1000;
        } else {
            pan = this.previousPanSpeed;
        }
        if (tiltSpeed != null) {
            this.previousTiltSpeed = tilt = tiltSpeed / 1000;
        } else {
            tilt = this.previousTiltSpeed;
        }
        if (zoomSpeed != null) {
            this.previousZoomSpeed = zoom = zoomSpeed / 1000;
        } else {
            zoom = this.previousZoomSpeed;
        }
        StringBuilder sb = new StringBuilder(256);
        try {
            if (zoomSpeed != null) {
                if (((SantecDevice)this.videoSrv.getDevice()).isIpxIpnDevice()) {
                    if (zoom != 0) {
                        sb.append("&stepmove=");
                        if (zoom > 0) {
                            zoom = (zoom = zoom / 33 + 1) > 3 ? 3 : zoom;
                            sb.append("zoomtele");
                        } else {
                            zoom = (zoom = zoom / 33 - 1) < -3 ? -3 : zoom;
                            sb.append("zoomwide");
                        }
                        sb.append("&step=");
                        sb.append(Math.abs(zoom));
                    }
                } else {
                    sb.append("&czoommove=");
                    sb.append(zoom);
                }
            }
            if (panSpeed != null || tiltSpeed != null) {
                if (this.videoSrv.getEntityType() == 213406L) {
                    sb.append("&cpantiltmove=");
                    if (Math.abs(pan) >= Math.abs(tilt)) {
                        pan = pan > 0 ? 1 : pan;
                        pan = pan < 0 ? -1 : pan;
                        sb.append(pan);
                        sb.append(",0");
                    } else {
                        tilt = tilt > 0 ? 1 : tilt;
                        tilt = tilt < 0 ? -1 : tilt;
                        sb.append("0,");
                        sb.append(tilt);
                    }
                } else {
                    sb.append("&cpantiltmove=");
                    sb.append(pan);
                    sb.append(",");
                    sb.append(tilt);
                }
            }
            if (panSpeed != null || zoomSpeed != null || tiltSpeed != null) {
                return this.sendCameraCommand(sb.toString());
            }
            return 0;
        }
        catch (Throwable ex) {
            this.logger.error((Object)ex, ex);
            return -21600;
        }
    }

    @Override
    public int setCenterPT(Integer xPosition, Integer yPosition, int[] resolution) {
        throw new RuntimeException("NOT YET IMPLEMENTED :-( ");
    }

    @Override
    public int setZoomArea(Integer xPosition, Integer yPosition, Integer width, Integer heigth, int[] resolution) {
        throw new RuntimeException("NOT YET IMPLEMENTED :-( ");
    }

    @Override
    public int setAbsoluteIris(Integer value) {
        throw new RuntimeException("NOT YET IMPLEMENTED :-( ");
    }

    @Override
    public int setContinuousIris(Integer value) {
        if (((SantecDevice)this.videoSrv.getDevice()).isIpxIpnDevice()) {
            if (value != 0) {
                try {
                    String[] irisValueString;
                    String currentIrisValueString = new String(NetworkHelper.readGetRequest((NetworkParameter)this.networkParameter, (String)"/uapi-cgi/param.cgi?action=list&group=VIDEOIN.Ch0.ISP.Exposure.compensation", (int)Integer.MAX_VALUE, (boolean)true));
                    String[] irisValues = currentIrisValueString.split(".compensation=");
                    if (irisValues.length == 2 && (irisValueString = irisValues[1].split("\r\n")).length > 0) {
                        int valueToSet = 0;
                        int irisValue = Integer.parseInt(irisValueString[0]);
                        int[] possibleIrisValues = new int[]{85, 103, 117, 128, 139, 153, 171};
                        for (int i = 0; i < possibleIrisValues.length; ++i) {
                            if (irisValue != possibleIrisValues[i]) continue;
                            if (value > 0) {
                                if (i == possibleIrisValues.length - 1) {
                                    return 0;
                                }
                                valueToSet = possibleIrisValues[i + 1];
                            } else if (value < 0) {
                                if (i == 0) {
                                    return 0;
                                }
                                valueToSet = possibleIrisValues[i - 1];
                            }
                            NetworkHelper.readGetRequest((NetworkParameter)this.networkParameter, (String)("/uapi-cgi/param.cgi?action=update&VIDEOIN.Ch0.ISP.Exposure.compensation=" + valueToSet), (int)Integer.MAX_VALUE, (boolean)true);
                            return 0;
                        }
                    }
                }
                catch (SeeTecException ex) {
                    this.logger.error("Exception while retrieving or setting iris value from " + this.videoSrv);
                    return -20100;
                }
            }
            return 0;
        }
        return this.sendCameraCommand("&cirismove=" + value / 1000);
    }

    @Override
    public int setAutoIris(Boolean active) {
        if (active.booleanValue()) {
            return this.sendCameraCommand("&autoiris=1");
        }
        return this.sendCameraCommand("&autoiris=0");
    }

    @Override
    public int setAbsoluteFocus(Integer value) {
        throw new RuntimeException("NOT YET IMPLEMENTED :-( ");
    }

    @Override
    public int setContinuousFocus(Integer value) {
        return this.sendCameraCommand("&cfocusmove=" + value / 1000);
    }

    @Override
    public int setAutoFocus(Boolean active) {
        if (active.booleanValue()) {
            return this.sendCameraCommand("&autofocus=1");
        }
        return this.sendCameraCommand("&autofocus=0");
    }

    @Override
    public int setZeroLux(Boolean active) {
        if (this.videoSrv.getEntityType() == 213406L) {
            String url = "/uapi-cgi/param.cgi?action=update&VIDEOIN.Ch0.Light.Daynight.mode=";
            url = active != false ? url + "night" : url + "day";
            try {
                NetworkHelper.readGetRequest((NetworkParameter)this.networkParameter, (String)url, (int)Integer.MAX_VALUE);
            }
            catch (SeeTecException ex) {
                this.logger.error("Exception while setting day/night mode for " + this.videoSrv + " : " + ex.getMessage());
                return ex.getErrorCode();
            }
        }
        String testUrl = "/nvc-cgi/admin/param.fcgi?action=list&group=system.Info.option.daynight";
        try {
            String result = new String(NetworkHelper.readGetRequest((NetworkParameter)this.networkParameter, (String)testUrl, (int)Integer.MAX_VALUE));
            if (result.indexOf("daynight=none") >= 0) {
                this.logger.error("Day/Night mode not supported");
            }
        }
        catch (SeeTecException ex) {
            this.logger.error("Error checking for support of day/night mode");
        }
        String url = "/nvc-cgi/admin/param.fcgi?action=update&group=ircut.mode=";
        url = active != false ? url + "night" : url + "day";
        try {
            NetworkHelper.readGetRequest((NetworkParameter)this.networkParameter, (String)url);
        }
        catch (SeeTecException ex) {
            this.logger.error("Error changing day/night mode");
            this.logger.error((Object)ex.getStackTrace());
        }
        return 0;
    }

    @Override
    public int setAutoZeroLux(Boolean active) {
        throw new RuntimeException("NOT YET IMPLEMENTED :-( ");
    }

    @Override
    public int setHomePosition() {
        return this.sendCameraCommand("&aux=home");
    }

    @Override
    public int addPresetPosition(Vector<byte[]> result, Long presetID, String presetName) {
        int presetPosition = -1;
        try {
            int i;
            String encodedPresetName = URLEncoder.encode(presetName.trim(), "UTF-8");
            int bitVector = 0;
            for (i = 0; i < this.presetList.size(); ++i) {
                PresetCnf presetCnf = this.presetList.elementAt(i);
                bitVector |= 1 << Integer.parseInt(presetCnf.getPresetPosition());
            }
            for (i = 1; i <= 30; ++i) {
                if ((bitVector & 1 << i) != 0) continue;
                presetPosition = i;
                break;
            }
            if (presetPosition < 0) {
                this.logger.error("Cannot add preset [ " + presetName + " ], 'cause no more free preset positions are available for " + this + " :-( ");
                return -21600;
            }
            this.logger.info("Creating Preset [ " + presetPosition + " ]/[ " + presetName.trim() + " ] ...");
            this.sendCameraCommand("&storedevicepreset=" + presetPosition);
            PresetCnf presetCnf = PresetCnf.createPresetCnf(presetID, "" + presetPosition, encodedPresetName);
            this.presetList.addElement(presetCnf);
            result.addElement(presetCnf.getPresetCnf());
            this.logger.info("super.presetList=" + this.presetList);
            return 0;
        }
        catch (Throwable ex) {
            this.logger.error("Adding preset [ " + presetName + " ] failed :-( ", ex);
            return -21600;
        }
    }

    @Override
    public int setPresetPosition(String presetName) {
        try {
            String encodedPresetName = URLEncoder.encode(presetName.trim(), "UTF-8");
            for (int i = 0; i < this.presetList.size(); ++i) {
                PresetCnf presetCnf = this.presetList.elementAt(i);
                if (!encodedPresetName.equals(presetCnf.getPresetName())) continue;
                int errorCode = this.sendCameraCommand("&gotodevicepreset=" + Integer.parseInt(presetCnf.getPresetPosition()));
                return errorCode;
            }
        }
        catch (Exception ex) {
            this.logger.error("Setting preset [ " + presetName + " ] failed :-( ", (Throwable)ex);
            return -21600;
        }
        this.logger.error("Preset [ " + presetName + " ] not available :-( ");
        this.logger.error("PresetList=" + this.presetList);
        return -21683;
    }

    @Override
    public int removePresetPosition(String presetName) {
        try {
            String encodedPresetName = URLEncoder.encode(presetName.trim(), "UTF-8");
            for (int i = 0; i < this.presetList.size(); ++i) {
                PresetCnf presetCnf = (PresetCnf)this.presetList.elementAt(i);
                if (!encodedPresetName.equals(presetCnf.getPresetName())) continue;
                this.logger.info("Removing preset: " + new String(presetCnf.getPresetCnf()));
                this.sendCameraCommand("&removedevicepreset=" + Integer.parseInt(presetCnf.getPresetPosition()));
                this.presetList.removeElementAt(i);
                return 0;
            }
        }
        catch (Exception ex) {
            this.logger.error("Removing preset [ " + presetName + " ] failed :-( ", (Throwable)ex);
            return -21600;
        }
        this.logger.error("Preset [ " + presetName + " ] not available :-( ");
        this.logger.error("PresetList=" + this.presetList);
        return -21683;
    }
}

