/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.cm.device.video.samsung.jpeg;

import de.seetec.v5.re.cm.device.shared.net.httpserverpush.HttpServerPushListenerIntf;
import de.seetec.v5.re.cm.device.shared.videosource.JPEGVideoSourceClient;
import de.seetec.v5.re.cm.device.video.samsung.SamsungDevice;
import de.seetec.v5.re.cm.device.video.samsung.SamsungNetworkHelperAdapter;
import de.seetec.v5.re.cm.device.video.samsung.jpeg.SamsungHttpServerPushChunkReader;
import de.seetec.v5.re.cm.device.video.samsung.jpeg.SamsungHttpServerPushHandler;
import de.seetec.v5.re.cm.device.video.samsung.jpeg.SamsungHttpServerPushStreamHandler;
import de.seetec.v5.re.shared.Codec;
import de.seetec.v5.shared.net.SeetecHttpClient;
import de.seetec.v5.shared.util.SeeTecException;
import java.util.HashMap;

public class SamsungJPEGVideoSourceClient
extends JPEGVideoSourceClient
implements HttpServerPushListenerIntf {
    static final String CONTENTLENGTH = "content-length: ";
    private static final String CLASS_NAME = "de.seetec.v5.re.cm.video.device.samsung.jpeg.SamsungJPEGVideoSourceClient";
    private SamsungHttpServerPushHandler httpServerPushHandler = null;
    private final SeetecHttpClient samsungHttpClient = new SamsungNetworkHelperAdapter();
    private int resolution = 0;
    private int compression = 0;
    private SamsungDevice samsungDevice;
    private int fps;
    private int jpegConfigurationMode;
    private boolean restartingServerPush = false;

    public int setImageParameters(int fps) {
        return this.setImageParameters(fps, this.width, this.height);
    }

    public int setImageParameters(int fps, int width, int height) {
        this.restartingServerPush = true;
        int errorCode = 0;
        if (this.samsungDevice == null) {
            this.samsungDevice = (SamsungDevice)this.getVideoSrv().getDevice();
        }
        this.jpegConfigurationMode = this.samsungDevice.getJpegConfigurationMode();
        StringBuilder sb = new StringBuilder(256);
        this.fps = this.samsungDevice.isMultiMode() ? this.samsungDevice.getFramerate(fps, this.samsungDevice.getCaptureMode(), width, this.samsungDevice.getGlobalMaxFps(), Codec.MJPEG) : this.samsungDevice.getFramerate(fps, width, height, Codec.MJPEG);
        this.highestFramerate = (long)this.fps * 1000L;
        this.resolution = this.samsungDevice.getResolution(width, height);
        if (this.httpServerPushHandler != null) {
            this.httpServerPushHandler.shutdown();
            this.httpServerPushHandler = null;
        }
        if (this.jpegConfigurationMode == 1 || this.jpegConfigurationMode == 4 || this.jpegConfigurationMode == 5) {
            sb.append("/cgi-bin/basic.cgi?msubmenu=video&action=apply");
            sb.append("&resolution=");
            sb.append(this.resolution);
            sb.append("&mp_frate=");
            sb.append(this.fps);
            if (this.jpegConfigurationMode == 4) {
                sb.append("&profile_no=4");
                sb.append("&profile_name=SEETECMJPEG");
                sb.append("&encoding_type=0");
            } else if (this.jpegConfigurationMode == 5) {
                sb.append("&profile_no=3");
                sb.append("&profile_name=SEETECMJPEG");
                sb.append("&encoding_type=0");
            }
            try {
                this.samsungHttpClient.readGetRequest(this.networkParameter, sb.toString(), Integer.MIN_VALUE, false);
            }
            catch (SeeTecException ex) {
                this.logger.error("Exception while setting new Camera parameters: " + (Object)((Object)ex));
            }
        }
        String serverPushUrl = this.jpegConfigurationMode == 2 ? "/cgi-bin/video.cgi?msubmenu=mjpg&profile=4&resolution=" + this.resolution + "&frate=" + this.fps : (this.jpegConfigurationMode == 3 || this.jpegConfigurationMode == 5 ? "/cgi-bin/video.cgi?msubmenu=mjpg&profile=3&resolution=" + this.resolution + "&frate=" + this.fps : (this.jpegConfigurationMode == 4 ? "/cgi-bin/video.cgi?msubmenu=mjpg&profile=4" : "/cgi-bin/video.cgi?msubmenu=mjpg"));
        boolean chunkedEncoding = false;
        try {
            byte[] result = this.samsungHttpClient.readGetRequest(this.networkParameter, serverPushUrl, 300, true);
            String serverpushHeader = new String(result);
            if (serverpushHeader.toLowerCase().contains("chunked")) {
                chunkedEncoding = true;
            }
        }
        catch (SeeTecException ex) {
            this.logger.error("Exception while testing MJPEG-Serverpush for " + this + " . Error: " + ex.getMessage() + " . ErrorCode: " + ex.getErrorCode());
            return ex.getErrorCode();
        }
        if (chunkedEncoding) {
            this.logger.info("Using chunked encoding for MJPEG for " + this);
            this.httpServerPushHandler = new SamsungHttpServerPushChunkReader();
        } else {
            this.logger.info("Using standard encoding for MJPEG for " + this);
            this.httpServerPushHandler = new SamsungHttpServerPushStreamHandler();
        }
        boolean asynchronous = true;
        errorCode = this.httpServerPushHandler.init(this, this.networkParameter, serverPushUrl);
        if (errorCode != 0) {
            this.logger.error("Error [" + errorCode + "]with " + (Object)((Object)this.httpServerPushHandler));
        } else {
            errorCode = this.httpServerPushHandler.startServerPush(asynchronous);
            if (errorCode != 0) {
                this.logger.warn("ServerPush of " + (Object)((Object)this.httpServerPushHandler) + " terminated with error [" + errorCode + "]");
            }
        }
        this.restartingServerPush = false;
        return 0;
    }

    @Override
    protected boolean isRunFinished() {
        return super.isRunFinished(CLASS_NAME);
    }

    @Override
    public int init() {
        int errorCode;
        if (this.samsungDevice == null) {
            this.samsungDevice = (SamsungDevice)this.getVideoSrv().getDevice();
        }
        if ((errorCode = super.init(false)) != 0) {
            this.logger.error("Error while initializing. Code: " + errorCode + " for " + this);
            return errorCode;
        }
        this.samsungDevice.setModelInformation();
        this.jpegConfigurationMode = this.samsungDevice.getJpegConfigurationMode();
        errorCode = this.samsungDevice.handleGlobalParameters(this.rotationAngle, this.useDateTime, this.useTitle, this.title, "");
        if (errorCode != 0) {
            if (errorCode == -21657) {
                this.logger.error("Unauthorized access for " + this);
                return errorCode;
            }
            this.logger.error("Error while setting global camera parameters: " + errorCode + " for " + this);
            return errorCode;
        }
        this.logger.info("Start grabbing images for " + this);
        this.networkParameter.setSoTimeout(5000);
        try {
            StringBuilder sb = new StringBuilder(256);
            this.resolution = this.samsungDevice.getResolution(this.width, this.height);
            if (this.samsungDevice.isMultiMode()) {
                HashMap<Integer, Integer>[][] framerates = this.samsungDevice.getGlobalMaxFps();
                int captureMode = this.samsungDevice.getCaptureMode();
                this.fps = this.samsungDevice.getFramerate(this.highestFramerate, captureMode, this.width, framerates, Codec.MJPEG);
            } else {
                this.fps = this.samsungDevice.getFramerate(this.highestFramerate, this.width, this.height, Codec.MJPEG);
            }
            this.highestFramerate = (long)this.fps * 1000L;
            sb.append("/cgi-bin/basic.cgi?msubmenu=video&action=apply");
            if (this.jpegConfigurationMode == 1 || this.jpegConfigurationMode == 4 || this.jpegConfigurationMode == 5) {
                sb.append("&mp_resolution=");
                sb.append(this.resolution);
                sb.append("&mp_frate=");
                sb.append(this.fps);
            }
            if (this.jpegConfigurationMode == 2) {
                sb.append("&profile_no=4");
            } else if (this.jpegConfigurationMode == 3 || this.jpegConfigurationMode == 5) {
                sb.append("&profile_no=3");
            } else if (this.jpegConfigurationMode == 4) {
                sb.append("&profile_no=4");
                sb.append("&profile_name=SEETECMJPEG");
                sb.append("&encoding_type=0");
            }
            int upperBitrate = this.samsungDevice.getBitrateLimits("MJPEG")[1];
            this.compression = 100000 - this.quality;
            if (this.samsungDevice.getMjpegCompressionMode() == 1) {
                this.compression /= 10000;
                ++this.compression;
                this.compression = 10 - this.compression;
                this.compression = this.compression > 9 ? 9 : this.compression;
                this.compression = this.compression < 0 ? 0 : this.compression;
                sb.append("&mjpeg_bitrate=");
                sb.append(this.compression);
            } else if (this.samsungDevice.getMjpegCompressionMode() == 2) {
                this.compression /= 5000;
                this.compression = this.compression > 20 ? 20 : this.compression;
                this.compression = this.compression < 1 ? 1 : this.compression;
                sb.append("&mp_compression=");
                sb.append(this.compression);
            } else if (this.samsungDevice.getMjpegCompressionMode() == 3) {
                this.compression /= 5000;
                this.compression = this.compression > 20 ? 20 : this.compression;
                this.compression = this.compression < 1 ? 1 : this.compression;
                sb.append("&mjpeg_bitrate=").append(upperBitrate);
                sb.append("&mp_compression=");
                sb.append(this.compression);
            }
            this.samsungHttpClient.readGetRequest(this.networkParameter, sb.toString(), 200, true);
        }
        catch (SeeTecException se) {
            this.logger.error("Exception while setting camera parameters for " + this + ": " + se.getMessage());
            return se.getErrorCode();
        }
        catch (Throwable ex) {
            this.logger.error("Trouble with JPEGServerPushStream of " + super.getVideoSrv());
            this.logger.error((Object)ex, ex);
            errorCode = -21651;
        }
        this.myThread = new Thread((Runnable)this, this.toString());
        this.myThread.start();
        return errorCode;
    }

    @Override
    public void run() {
        super.setRunFinished(CLASS_NAME, false);
        int errorCode = 0;
        if (this.httpServerPushHandler != null) {
            this.httpServerPushHandler.shutdown();
            this.httpServerPushHandler = null;
        }
        String serverPushUrl = this.jpegConfigurationMode == 2 ? "/cgi-bin/video.cgi?msubmenu=mjpg&profile=4&resolution=" + this.resolution + "&frate=" + this.fps : (this.jpegConfigurationMode == 3 ? "/cgi-bin/video.cgi?msubmenu=mjpg&profile=3&resolution=" + this.resolution + "&frate=" + this.fps : (this.jpegConfigurationMode == 4 ? "/cgi-bin/video.cgi?msubmenu=mjpg&profile=4" : (this.jpegConfigurationMode == 5 ? "/cgi-bin/video.cgi?msubmenu=mjpg&profile=3" : "/cgi-bin/video.cgi?msubmenu=mjpg")));
        boolean asynchronous = true;
        boolean chunkedEncoding = false;
        try {
            byte[] result = this.samsungHttpClient.readGetRequest(this.networkParameter, serverPushUrl, 300);
            String serverpushHeader = new String(result);
            if (serverpushHeader.toLowerCase().contains("chunked")) {
                chunkedEncoding = true;
            }
        }
        catch (SeeTecException ex) {
            this.logger.error("Exception while testing MJPEG-Serverpush for " + this + " . Error: " + ex.getMessage() + " . ErrorCode: " + ex.getErrorCode());
        }
        this.httpServerPushHandler = chunkedEncoding ? new SamsungHttpServerPushChunkReader() : new SamsungHttpServerPushStreamHandler();
        this.networkParameter.setSoTimeout(10000);
        errorCode = this.httpServerPushHandler.init(this, this.networkParameter, serverPushUrl);
        if (errorCode != 0) {
            this.logger.error("Error [" + errorCode + "]with " + (Object)((Object)this.httpServerPushHandler));
        } else {
            errorCode = this.httpServerPushHandler.startServerPush(asynchronous);
            if (errorCode != 0) {
                this.logger.warn("ServerPush of " + (Object)((Object)this.httpServerPushHandler) + " terminated with error [" + errorCode + "]");
            }
        }
        while (!this.isShutdown()) {
            if (this.isShutdown() || this.restartingServerPush) continue;
            if (this.httpServerPushHandler == null || this.httpServerPushHandler.isShutdown()) {
                this.logger.info("Found ServerPush down for " + this);
                this.shutdown();
            }
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (this.httpServerPushHandler != null) {
            this.httpServerPushHandler.shutdown();
            this.httpServerPushHandler = null;
        }
        this.logger.info("End grabbing images for " + this);
        super.setRunFinished(CLASS_NAME, true);
        this.shutdown();
    }

    @Override
    public int shutdown() {
        if (this.httpServerPushHandler != null) {
            this.httpServerPushHandler.shutdown();
            this.httpServerPushHandler = null;
        }
        return super.shutdown();
    }

    @Override
    public void sendStatusService(int nStatusCode) {
        this.listener.sendStatusService(nStatusCode);
    }

    @Override
    public void notifyForNetworkProblems() {
        this.sendStatusService(-21603);
        this.shutdown();
    }

    public long getMilliCompression() {
        return this.compression;
    }
}

