/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.cm.device.video.samsung.jpeg;

import de.seetec.v5.re.cm.device.shared.net.httpserverpush.HttpServerPushContent;
import de.seetec.v5.re.cm.device.shared.net.httpserverpush.HttpServerPushListenerIntf;
import de.seetec.v5.re.cm.device.video.samsung.jpeg.SamsungHttpServerPushHandler;
import de.seetec.v5.shared.Basic;
import de.seetec.v5.shared.SSLConstantsIntf;
import de.seetec.v5.shared.net.NetworkHelper;
import de.seetec.v5.shared.net.NetworkParameter;
import de.seetec.v5.shared.util.SeeTecException;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.net.Socket;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SamsungHttpServerPushChunkReader
extends SamsungHttpServerPushHandler
implements Runnable {
    private static final String CLASS_NAME = "de.seetec.v5.re.cm.video.device.samsung.jpeg.SamsungHttpServerPushChunkReader";
    private static final String CONTENTLENGTH = "content-length:";
    private final byte[] tagBoundary = "boundary=".getBytes();
    private Logger logger = null;
    private Thread thread = null;
    private HttpServerPushListenerIntf listener = null;
    private NetworkParameter networkParameter = null;
    private Socket socket = null;
    private String url = null;
    private int chunkLength;
    private ByteArrayOutputStream outputStream = null;
    private byte[] contentArray;
    private byte[] chunkLengthByteArray;
    private StringBuilder sbHeader;
    private byte[] inBuffer = new byte[4096];
    private byte[] frameToDeliver = null;
    private byte[] array;
    private byte[] temp;
    private byte[] lengthInformation;
    private byte[] header;
    private String headerString;
    private String[] headerLines;

    public SamsungHttpServerPushChunkReader() {
        this.logger = LogManager.getLogger((String)this.getClass().getName());
    }

    @Override
    public int init(HttpServerPushListenerIntf listener, NetworkParameter networkParameter, String url) {
        this.listener = listener;
        if (this.listener == null) {
            return -20002;
        }
        this.networkParameter = networkParameter;
        if (this.networkParameter == null) {
            return -20002;
        }
        this.url = url;
        if (this.url == null) {
            return -20002;
        }
        return 0;
    }

    @Override
    public final boolean isShutdown() {
        return this.isShutdown(CLASS_NAME);
    }

    public int shutdown() {
        if (this.startShutdown(CLASS_NAME)) {
            return 0;
        }
        this.logger.info("Shutting down " + this + " ...");
        if (this.socket != null) {
            try {
                this.socket.close();
            }
            catch (Throwable ex) {
                this.logger.error("Exception while closing socket for " + this + ": " + ex.getMessage());
            }
            this.socket = null;
        }
        return 0;
    }

    @Override
    public int startServerPush(boolean asynchronous) {
        this.logger.info("Starting HttpServerPush with following Parameter:");
        this.logger.info("   Listener        : " + this.listener);
        this.logger.info("   NetworkParameter: " + this.networkParameter);
        this.logger.info("   URL             : [ " + this.url + " ]");
        try {
            this.establishServerPushStream(this.networkParameter, this.url);
            this.listener.sendStatusService(0);
        }
        catch (Throwable ex) {
            int errorCode = -20100;
            this.logger.error((Object)ex, ex);
            this.listener.sendStatusService(errorCode);
            return errorCode;
        }
        this.thread = new Thread((Runnable)this, this.toString());
        this.thread.start();
        return 0;
    }

    @Override
    public void run() {
        super.setRunFinished(CLASS_NAME, false);
        int errorCode = 0;
        try {
            errorCode = this.readHttpServerPush();
            if (errorCode != 0) {
                this.listener.sendStatusService(errorCode);
            }
        }
        catch (Throwable ex) {
            this.logger.warn((Object)ex, ex);
        }
        super.setRunFinished(CLASS_NAME, true);
        this.shutdown();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int readHttpServerPush() {
        int errorCode = 0;
        int len = -1;
        int index = -1;
        byte[] inBuffer = new byte[1024];
        byte[] array = null;
        byte[] extBoundary = null;
        ByteArrayOutputStream baos = new ByteArrayOutputStream(32768);
        InputStream is = null;
        int firstChunkLength = 0;
        try {
            is = this.socket.getInputStream();
            baos.reset();
            while (!this.isShutdown()) {
                block57: {
                    try {
                        len = is.read(inBuffer, 0, inBuffer.length);
                        if (len >= 0) break block57;
                        if (array == null) {
                            errorCode = -20102;
                            break;
                        }
                        String msg = new String(array);
                        this.logger.error("Invalid server push for " + this + ":\n\r" + msg);
                        if (msg.toLowerCase().indexOf("unauthorized") < 0) {
                            errorCode = -20102;
                            break;
                        }
                        int n = -21657;
                        return n;
                    }
                    catch (InterruptedIOException soTimeoutException) {
                        if (this.networkParameter.getIgnoreSoTimeout()) continue;
                        throw soTimeoutException;
                    }
                    catch (NullPointerException npe) {
                        break;
                    }
                }
                baos.write(inBuffer, 0, len);
                array = baos.toByteArray();
                if (array.length < 512) {
                    try {
                        Thread.sleep(5L);
                    }
                    catch (InterruptedException ex) {
                        this.logger.info("Thread sleep interrupted " + ex.getMessage());
                    }
                    continue;
                }
                if (array.length > 0x100000) {
                    this.logger.error("No boundary found within [ " + Basic.longToFormattedString((long)array.length) + " B ] :-( ");
                    errorCode = -20102;
                    break;
                }
                index = Basic.indexOfByteArray((byte[])array, (byte[])this.networkParameter.getHttpDoubleLineDelimitter(), (int)0);
                if (index <= 0) continue;
                try {
                    int i;
                    int k;
                    byte[] streamHeader = new byte[index - 4];
                    System.arraycopy(array, 0, streamHeader, 0, index - 4);
                    int pos1 = Basic.indexOfByteArray((byte[])array, (byte[])this.tagBoundary, (int)0);
                    int pos2 = Basic.indexOfByteArray((byte[])array, (byte[])this.networkParameter.getHttpSingleLineDelimitter(), (int)pos1);
                    byte[] prefix = null;
                    byte[] simpleBoundary = null;
                    byte[] postfix = null;
                    simpleBoundary = new byte[pos2 - pos1 - this.networkParameter.getHttpSingleLineDelimitter().length];
                    System.arraycopy(array, pos1, simpleBoundary, 0, simpleBoundary.length);
                    if (simpleBoundary[0] == 45 && simpleBoundary[1] == 45) {
                        prefix = new byte[this.networkParameter.getHttpSingleLineDelimitter().length];
                        System.arraycopy(this.networkParameter.getHttpSingleLineDelimitter(), 0, prefix, 0, this.networkParameter.getHttpSingleLineDelimitter().length);
                    } else {
                        prefix = new byte[this.networkParameter.getHttpSingleLineDelimitter().length + 2];
                        System.arraycopy(this.networkParameter.getHttpSingleLineDelimitter(), 0, prefix, 0, this.networkParameter.getHttpSingleLineDelimitter().length);
                        prefix[this.networkParameter.getHttpSingleLineDelimitter().length + 1] = 45;
                        prefix[this.networkParameter.getHttpSingleLineDelimitter().length] = 45;
                    }
                    postfix = new byte[this.networkParameter.getHttpSingleLineDelimitter().length];
                    System.arraycopy(this.networkParameter.getHttpSingleLineDelimitter(), 0, postfix, 0, this.networkParameter.getHttpSingleLineDelimitter().length);
                    extBoundary = new byte[prefix.length + simpleBoundary.length + postfix.length];
                    System.arraycopy(prefix, 0, extBoundary, 0, prefix.length);
                    System.arraycopy(simpleBoundary, 0, extBoundary, prefix.length, simpleBoundary.length);
                    System.arraycopy(postfix, 0, extBoundary, prefix.length + simpleBoundary.length, postfix.length);
                    int beginChunked = Basic.indexOfByteArray((byte[])array, (byte[])DOUBLE_CRLF_BYTE, (int)pos2);
                    int endChunked = Basic.indexOfByteArray((byte[])array, (byte[])CRLF_BYTE, (int)beginChunked, (boolean)true);
                    this.chunkLengthByteArray = new byte[endChunked - beginChunked];
                    System.arraycopy(array, beginChunked, this.chunkLengthByteArray, 0, this.chunkLengthByteArray.length);
                    firstChunkLength = Integer.parseInt(new String(this.chunkLengthByteArray), 16);
                    if (Basic.indexOfByteArray((byte[])array, (byte[])extBoundary, (int)0) >= 0) {
                        baos.reset();
                        baos.write(array, endChunked + CRLF_BYTE.length, array.length - (endChunked + CRLF_BYTE.length));
                        break;
                    }
                    this.logger.error("No boundary found for " + this.networkParameter + " with URL [ " + this.url + " ] :-( ");
                    if (extBoundary.length > 256) {
                        String sHeader = new String(extBoundary, 0, 256);
                        this.logger.error("   extBoundary=[ " + sHeader + " ... ] :-( ");
                        this.sbHeader = new StringBuilder("");
                        for (k = 0; k < 256; ++k) {
                            this.sbHeader.append(extBoundary[k]);
                        }
                        this.logger.error(this.sbHeader.toString());
                    } else {
                        this.logger.error("   extBoundary=[ " + new String(extBoundary) + " ] :-( ");
                        StringBuilder sbHeader = new StringBuilder("      ");
                        for (k = 0; k < extBoundary.length; ++k) {
                            sbHeader.append(Integer.toHexString(extBoundary[k])).append("-");
                        }
                        this.logger.error(sbHeader.toString());
                    }
                    this.logger.error("this.networkParameter.getHttpSingleLineDelimitter( ).length=" + this.networkParameter.getHttpSingleLineDelimitter().length);
                    this.logger.error("prefix.length=" + prefix.length);
                    this.logger.error("postfix.length=" + postfix.length);
                    this.logger.error("simpleBoundary.length=" + simpleBoundary.length);
                    this.logger.error("simpleBoundary=" + new String(simpleBoundary));
                    this.logger.error("extBoundary.length=" + extBoundary.length);
                    StringBuilder sb = new StringBuilder("      ");
                    if (array.length > 256) {
                        for (i = 0; i < 256; ++i) {
                            sb.append(Integer.toHexString(array[i])).append("-");
                        }
                    } else {
                        for (i = 0; i < array.length; ++i) {
                            sb.append(Integer.toHexString(array[i])).append("-");
                        }
                    }
                    this.logger.error(sb.toString());
                    if (array.length > 256) {
                        this.logger.error("   array=[ " + new String(array, 0, 256) + " ... ] :-( ");
                    } else {
                        this.logger.error("   array=[ " + new String(array) + " ] :-( ");
                    }
                    errorCode = -20102;
                    break;
                }
                catch (Exception ex) {
                    String webServerResponse = new String(array, 0, 256);
                    this.logger.warn("Reading [ " + this.socket + this.url + " ] failed!\n\r\n\r" + webServerResponse + "\n", (Throwable)ex);
                    errorCode = !webServerResponse.toLowerCase().contains("unauthorized") ? -20102 : -21657;
                    break;
                }
            }
            if (errorCode == 0) {
                array = baos.toByteArray();
                int n = len = array.length < 256 ? array.length : 256;
                if (this.logger.isDebugEnabled()) {
                    this.logger.info("Reading content stream ...");
                }
                errorCode = this.readChunkedData(is, baos, extBoundary, firstChunkLength);
            } else {
                this.listener.sendStatusService(errorCode);
            }
        }
        catch (IOException ex) {
            if (!this.isShutdown()) {
                this.logger.warn("Network problems for " + this, (Throwable)ex);
                this.listener.notifyForNetworkProblems();
            }
        }
        catch (SeeTecException ex) {
            this.logger.warn((Object)ex, (Throwable)ex);
            this.listener.notifyForNetworkProblems();
        }
        catch (NullPointerException ex) {
            if (!this.isShutdown()) {
                this.listener.notifyForNetworkProblems();
            }
        }
        catch (Throwable ex) {
            this.logger.warn("Unexpected exception occured for " + this, ex);
            this.listener.notifyForNetworkProblems();
        }
        finally {
            try {
                if (this.socket != null) {
                    this.socket.close();
                    this.socket = null;
                }
            }
            catch (IOException ioex) {
                this.logger.warn((Object)ioex, (Throwable)ioex);
            }
        }
        return errorCode;
    }

    protected int readChunkedData(InputStream is, ByteArrayOutputStream baos, byte[] boundary, int chunkLength) throws IOException, SeeTecException {
        int len = 0;
        this.chunkLength = chunkLength;
        this.outputStream = new ByteArrayOutputStream();
        this.array = baos.toByteArray();
        baos.reset();
        len = this.array.length;
        while (!this.isShutdown()) {
            try {
                if (len > this.chunkLength + 32) {
                    this.temp = new byte[this.chunkLength];
                    System.arraycopy(this.array, 0, this.temp, 0, this.temp.length);
                    this.outputStream.write(this.temp);
                    this.readContent(boundary);
                    int startIndex = Basic.indexOfByteArray((byte[])this.array, (byte[])CRLF_BYTE, (int)this.chunkLength);
                    if (startIndex < 0) {
                        this.logger.error("Could not find length information of next chunk");
                        return -20103;
                    }
                    int endIndex = Basic.indexOfByteArray((byte[])this.array, (byte[])CRLF_BYTE, (int)startIndex, (boolean)true);
                    if (endIndex < 0) {
                        this.logger.error("Could not find length information of next chunk ( end ) ");
                        return -20103;
                    }
                    this.lengthInformation = new byte[endIndex - startIndex];
                    System.arraycopy(this.array, startIndex, this.lengthInformation, 0, this.lengthInformation.length);
                    this.chunkLength = Integer.parseInt(new String(this.lengthInformation), 16);
                    baos.write(this.array, endIndex + CRLF_BYTE.length, this.array.length - (endIndex + CRLF_BYTE.length));
                    this.array = baos.toByteArray();
                    baos.reset();
                    len = this.array.length;
                    continue;
                }
                baos.write(this.array);
                int bytesRead = is.read(this.inBuffer);
                if (bytesRead < 0) {
                    this.logger.error("Could not read serverpush");
                    return -20103;
                }
                baos.write(this.inBuffer, 0, bytesRead);
                len = baos.size();
                this.array = baos.toByteArray();
                baos.reset();
            }
            catch (NullPointerException npe) {
                this.shutdown();
                return 0;
            }
        }
        return 0;
    }

    public String toString() {
        String sThis = this.getClass().getName() + "@" + Integer.toHexString(this.hashCode());
        return "[ " + sThis.substring(sThis.lastIndexOf(46) + 1) + ", Listener=" + this.listener + ", " + this.networkParameter + ", " + this.socket + ", URL=[ " + this.url + " ] ]";
    }

    private void readContent(byte[] boundary) {
        block2: while (true) {
            this.contentArray = this.outputStream.toByteArray();
            int startIndex = Basic.indexOfByteArray((byte[])this.contentArray, (byte[])boundary, (int)0);
            if (startIndex < 0) {
                return;
            }
            int endOfHeader = Basic.indexOfByteArray((byte[])this.contentArray, (byte[])SSLConstantsIntf.DOUBLE_CRLF_BYTE, (int)startIndex);
            if (endOfHeader < 0) {
                return;
            }
            this.header = new byte[endOfHeader - startIndex];
            System.arraycopy(this.contentArray, startIndex, this.header, 0, this.header.length);
            this.headerString = new String(this.header);
            this.headerLines = this.headerString.split("\r\n");
            int i = 0;
            while (true) {
                if (i >= this.headerLines.length) continue block2;
                if (this.headerLines[i].toLowerCase().indexOf(CONTENTLENGTH) != -1) {
                    String lengthString = this.headerLines[i].substring(this.headerLines[i].indexOf(32)).trim();
                    int contentLength = Integer.parseInt(lengthString);
                    if (this.contentArray.length - startIndex < contentLength + this.header.length) {
                        return;
                    }
                    this.frameToDeliver = new byte[contentLength];
                    try {
                        int j;
                        System.arraycopy(this.contentArray, endOfHeader, this.frameToDeliver, 0, this.frameToDeliver.length);
                        for (j = this.frameToDeliver.length; (this.frameToDeliver[j - 1] & 0xFF) != 217 && (this.frameToDeliver[j - 2] & 0xFF) != 255 && j > 1 && j > this.frameToDeliver.length - 40; --j) {
                        }
                        if (j != this.frameToDeliver.length) {
                            byte[] tempFrame = new byte[j];
                            System.arraycopy(this.frameToDeliver, 0, tempFrame, 0, j);
                            this.frameToDeliver = tempFrame;
                        }
                    }
                    catch (ArrayIndexOutOfBoundsException e) {
                        this.logger.info("Exception while reading MJPEG frame: " + e);
                    }
                    this.listener.deliverContent(new HttpServerPushContent(this.headerString, this.frameToDeliver));
                    this.outputStream.reset();
                    this.outputStream.write(this.contentArray, endOfHeader + contentLength, this.contentArray.length - endOfHeader - contentLength);
                }
                ++i;
            }
            break;
        }
    }

    private void establishServerPushStream(NetworkParameter networkParameter, String url) throws Exception {
        String authentication = "";
        String realm = networkParameter.getRealm();
        String nonce = networkParameter.getNonce();
        String qop = networkParameter.getQop();
        if (realm != null && nonce != null && qop != null) {
            authentication = NetworkHelper.createDigestAuthorization((NetworkParameter)networkParameter, (String)realm, (String)nonce, (String)"GET", (String)url, (String)qop);
        }
        String additionalData = networkParameter.getAdditionalData() != null ? networkParameter.getAdditionalData() : "";
        String request = "GET " + url + " HTTP/1.1\r\n" + additionalData + authentication + "User-Agent: Java/1.4.2\r\nHost: " + networkParameter.getHost() + "\r\nAccept: text/html, image/gif, image/jpeg, *; q=.2, */*; q=.2\r\nConnection: keep-alive\r\n\r\n";
        this.socket = networkParameter.useHTTPS() ? NetworkHelper.createNetworkConnection((String)networkParameter.getHost(), (int)networkParameter.getSSLport(), (boolean)true) : NetworkHelper.createNetworkConnection((String)networkParameter.getHost(), (int)networkParameter.getHTTPport(), (boolean)false);
        this.socket.setSoTimeout(networkParameter.getSoTimeout());
        OutputStream os = this.socket.getOutputStream();
        os.write(request.getBytes());
        os.flush();
    }
}

