/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.cm.device.video.samsung;

import de.seetec.v5.re.cm.device.shared.MotionRecording;
import de.seetec.v5.re.cm.device.shared.genericevent.GenericEventTriggerCnf;
import de.seetec.v5.re.cm.device.shared.genericevent.GenericEventTriggerHandler;
import de.seetec.v5.re.cm.device.video.samsung.AlarmType;
import de.seetec.v5.re.cm.device.video.samsung.SamsungAlarmHandlerIntf;
import de.seetec.v5.re.cm.device.video.samsung.SamsungDevice;
import de.seetec.v5.re.cm.device.video.samsung.SamsungEventMessage;
import de.seetec.v5.re.cm.device.video.samsung.SamsungEventReader;
import de.seetec.v5.shared.util.ConfigurationException;
import de.seetec.v5.shared.util.SeeTecException;
import java.util.List;

public class SamsungTriggerHandler
extends GenericEventTriggerHandler
implements SamsungAlarmHandlerIntf {
    private static final String CLASS_NAME = "de.seetec.v5.re.cm.device.video.samsung.SamsungTriggerHandler";
    private SamsungDevice samsungDevice;
    private int videoServerNumber;
    private SamsungEventReader samsungEventReader;

    public SamsungTriggerHandler(MotionRecording motionRecording) {
        super(motionRecording);
    }

    @Override
    public int shutdown() {
        if (this.isShutdown()) {
            return 0;
        }
        this.deregister();
        super.shutdown();
        return 0;
    }

    @Override
    public void run() {
        if (this.device instanceof SamsungDevice) {
            this.samsungDevice = (SamsungDevice)this.device;
            this.samsungDevice.setModelInformation();
        }
        this.samsungEventReader = this.samsungDevice.getEventReader();
        this.samsungEventReader.register(this);
    }

    @Override
    public AlarmType getAlarmType() {
        return AlarmType.GENERIC;
    }

    @Override
    public void receiveAlarm(SamsungEventMessage samsungEventMessage) {
        if (!this.isShutdown() && samsungEventMessage.isTriggered()) {
            List triggerEvents = this.genericEventTriggerCnfs;
            for (GenericEventTriggerCnf event : triggerEvents) {
                try {
                    if (event == null || !event.isEnabled()) continue;
                    String eventName = event.getGenericEventTriggerType();
                    if (!samsungEventMessage.getEventName().equals(eventName)) continue;
                    this.forwardTrigger(event);
                }
                catch (ConfigurationException ex) {
                    this.logger.warn("Configuration exception while receiving alarm for " + this);
                }
            }
        }
    }

    @Override
    public void deregister() {
        if (this.samsungEventReader != null) {
            this.samsungEventReader.deregister(this);
        }
    }

    @Override
    public void notifyForNetworkProblems() {
    }

    @Override
    public int getChannel() {
        return this.videoServerNumber;
    }

    protected void setVideoSourceNumber(int serverEntryNo) throws SeeTecException {
        if (serverEntryNo <= 0) {
            throw new SeeTecException(-21601, "Video Source number " + serverEntryNo + " invalid.");
        }
        this.videoServerNumber = serverEntryNo;
    }
}

