/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.cm.device.video.samsung;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonProcessingException;
import de.seetec.v5.re.cm.QognifyMetadataManagerRepository;
import de.seetec.v5.re.cm.device.shared.Device;
import de.seetec.v5.re.cm.device.shared.LiveCameraSrv;
import de.seetec.v5.re.cm.device.shared.Resolution;
import de.seetec.v5.re.cm.device.shared.metadata.Metadata;
import de.seetec.v5.re.cm.device.shared.metadata.MetadataReader;
import de.seetec.v5.re.cm.device.shared.metadata.QmmData;
import de.seetec.v5.re.cm.device.shared.metadata.capabilities.AccessoryCapabilities;
import de.seetec.v5.re.cm.device.shared.metadata.capabilities.BelongingCapabilities;
import de.seetec.v5.re.cm.device.shared.metadata.capabilities.BottomsCapabilities;
import de.seetec.v5.re.cm.device.shared.metadata.capabilities.ClassCapabilities;
import de.seetec.v5.re.cm.device.shared.metadata.capabilities.ClothingCapabilities;
import de.seetec.v5.re.cm.device.shared.metadata.capabilities.ColorDescriptorType;
import de.seetec.v5.re.cm.device.shared.metadata.capabilities.DataType;
import de.seetec.v5.re.cm.device.shared.metadata.capabilities.HumanBodyCapabilities;
import de.seetec.v5.re.cm.device.shared.metadata.capabilities.HumanFaceCapabilities;
import de.seetec.v5.re.cm.device.shared.metadata.capabilities.MetadataCapabilities;
import de.seetec.v5.re.cm.device.shared.metadata.capabilities.Parameter;
import de.seetec.v5.re.cm.device.shared.metadata.capabilities.PositioningUnits;
import de.seetec.v5.re.cm.device.shared.metadata.capabilities.TopsCapabilities;
import de.seetec.v5.re.cm.device.shared.metadata.capabilities.VehicleInfoCapabilities;
import de.seetec.v5.re.cm.device.shared.net.rtsp.RTSPHandlerIntf;
import de.seetec.v5.re.cm.device.shared.net.rtsp.RTSPHandlerSuper;
import de.seetec.v5.re.cm.device.shared.net.rtsp.RTSPResponse;
import de.seetec.v5.re.cm.device.shared.net.rtsp.RTSPStreamSettings;
import de.seetec.v5.re.cm.device.shared.net.rtsp.mikey.Mikey;
import de.seetec.v5.re.cm.device.shared.onvif.metadata.Frame;
import de.seetec.v5.re.cm.device.shared.onvif.metadata.MetadataObject;
import de.seetec.v5.re.cm.device.shared.onvif.metadata.MetadataStream;
import de.seetec.v5.re.cm.device.shared.onvif.metadata.VideoAnalytics;
import de.seetec.v5.re.cm.device.shared.videosource.PacketType;
import de.seetec.v5.re.cm.device.shared.videosource.PacketTypeParser;
import de.seetec.v5.re.cm.device.shared.videosource.RtpPacket;
import de.seetec.v5.re.cm.device.video.samsung.MetadataCameraType;
import de.seetec.v5.re.cm.device.video.samsung.SamsungDevice;
import de.seetec.v5.re.cm.device.video.samsung.SamsungHelper;
import de.seetec.v5.re.cm.device.video.samsung.SamsungMetadataHelper;
import de.seetec.v5.re.shared.Codec;
import de.seetec.v5.re.shared.TransmissionType;
import de.seetec.v5.shared.Basic;
import de.seetec.v5.shared.net.NetworkParameter;
import de.seetec.v5.shared.util.ConfigurationException;
import de.seetec.v5.shared.util.SeeTecException;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import org.jdom.Document;
import org.jdom.input.SAXBuilder;
import org.jdom.output.XMLOutputter;

public class SamsungMetadataReader
extends MetadataReader
implements RTSPHandlerIntf {
    public static final String CLASSNAME = "de.seetec.v5.re.cm.device.video.samsung.SamsungMetadataReader";
    private static final int MAX_SEQUENCE_NUMBER = 65535;
    private static final long RTPPACKET_CLEANING_RANGE = 1000L;
    private static final byte LESS_THAN = 60;
    private static final byte QUESTION_MARK = 63;
    private SamsungDevice samsungDevice;
    private String rtspUrl;
    private RTSPStreamSettings rtspSettings;
    private boolean isMultiChannelDevice;
    private final ByteArrayOutputStream buffer = new ByteArrayOutputStream();
    private final int videoSource;
    private RTSPHandlerSuper rtspHandler;
    private final long videoSourceEntityId;
    private final String videoSourceName;
    private final TransmissionType transmissionType;
    private List<RtpPacket> rtpPacketList;
    private long lastCleanUp;
    private long previousRtpSequenceNumber = -1L;
    private long rolloverCounter = 0L;
    private int distanceFromLastRollover = Short.MAX_VALUE;
    private long previousExtendedSequenceNumber;
    private Resolution resolution;

    public SamsungMetadataReader(LiveCameraSrv liveCameraSrv, QognifyMetadataManagerRepository qognifyMetadataManagerRepository) throws ConfigurationException {
        super(qognifyMetadataManagerRepository);
        this.videoSource = liveCameraSrv.getVideoSourceCnf().getServerEntryNo();
        this.videoSourceName = liveCameraSrv.getVideoSourceCnf().getEntity().getEntityName();
        this.videoSourceEntityId = liveCameraSrv.getVideoSourceCnf().getEntityID();
        this.transmissionType = liveCameraSrv.getBasicVideoProfileHandler().getVideoSourceParameter().getTransmissionID();
    }

    @Override
    public int shutdown() {
        this.getLogger().info("Shutting down " + this);
        this.startShutdown(CLASSNAME);
        if (this.rtspHandler != null) {
            this.rtspHandler.shutdown();
        }
        return super.shutdown();
    }

    @Override
    public int init(Device device) {
        int errorCode = 0;
        super.init(device);
        this.rtpPacketList = new ArrayList<RtpPacket>();
        try {
            MetadataCapabilities metadataCapabilities = this.getMetadataCapabilities(this.videoSource, this.videoSourceEntityId);
            this.getLogger().info(metadataCapabilities.toString());
            this.deliverMetadata(metadataCapabilities);
            errorCode = this.startMetadataStream();
        }
        catch (Exception ex) {
            this.getLogger().warn("Exception while starting metadata reading for " + this + " : " + ex.getMessage());
        }
        return errorCode;
    }

    public Resolution getResolution() {
        return this.resolution;
    }

    private int startMetadataStream() {
        int errorCode;
        this.getLogger().info("Starting metadata stream for " + this);
        this.previousRtpSequenceNumber = -1L;
        this.rolloverCounter = 0L;
        this.distanceFromLastRollover = Short.MAX_VALUE;
        try {
            int numberOfVideoSources = this.getSamsungDevice().getNumberOfVideoSourcesFromDevice();
            if (numberOfVideoSources > 1) {
                this.isMultiChannelDevice = true;
            }
            this.resolution = this.getResolutionFromCamera();
            NetworkParameter networkParameter = this.getSamsungDevice().getDeviceCnf().getNetworkParameter();
            String rtspPath = (this.isMultiChannelDevice ? "/" + (this.videoSource - 1) : "") + "/profile1/media.smp";
            this.rtspUrl = "rtsp://" + networkParameter.getHost() + rtspPath;
            this.rtspSettings = new RTSPStreamSettings();
            String keepAliveUrl = this.isMultiChannelDevice ? this.rtspUrl : "*";
            errorCode = this.rtspSettings.init(this, null, networkParameter, 554, this.rtspUrl, false, this.transmissionType, 5000, false, 4, keepAliveUrl);
            if (errorCode != 0) {
                this.getLogger().error("Initialization of RTSPsettings failes with errorCode: " + errorCode + " for " + this);
            }
            this.rtspSettings.setIsVideoEnabled(false);
            this.rtspSettings.enableMetadata(this);
            this.rtspSettings.setMetadataTimeout(0);
            this.rtspSettings.setUseSdpData(true);
            this.rtspSettings.setPlaybackCodec(Codec.MJPEG);
            this.rtspHandler = this.rtspSettings.getRTSPHandler();
            this.rtspHandler.start();
        }
        catch (Exception ex) {
            this.getLogger().error("Exception while starting metadata stream for " + this + " : " + ex.getMessage());
            errorCode = -20100;
        }
        return errorCode;
    }

    protected SamsungDevice getSamsungDevice() {
        if (this.samsungDevice == null) {
            this.samsungDevice = (SamsungDevice)this.getDevice();
        }
        return this.samsungDevice;
    }

    @Override
    public void processData(byte[] data) {
        try {
            PacketType packetType = PacketTypeParser.parsePacketType(data);
            if (packetType == PacketType.RTCP_SENDER_REPORT) {
                byte[] receiverReport = this.generateRTCPReceiverReport(data);
                if (this.rtspHandler != null) {
                    this.rtspHandler.sendReceiverReportMetadata(receiverReport);
                }
            } else {
                RtpPacket rtpPacket = new RtpPacket(data);
                if (this.previousRtpSequenceNumber != -1L && rtpPacket.getSequenceNumber() < this.previousRtpSequenceNumber - 32767L && this.distanceFromLastRollover > Short.MAX_VALUE) {
                    ++this.rolloverCounter;
                    this.distanceFromLastRollover = 0;
                }
                ++this.distanceFromLastRollover;
                this.previousRtpSequenceNumber = rtpPacket.getSequenceNumber();
                long extendedSequenceNumber = (this.rolloverCounter << 16) + rtpPacket.getSequenceNumber();
                if (this.rolloverCounter > 0L && extendedSequenceNumber > this.previousExtendedSequenceNumber + 32767L) {
                    extendedSequenceNumber = (this.rolloverCounter - 1L << 16) + rtpPacket.getSequenceNumber();
                }
                this.previousExtendedSequenceNumber = extendedSequenceNumber;
                rtpPacket.setExtendedSequenceNumber(extendedSequenceNumber);
                this.rtpPacketList.add(rtpPacket);
                Collections.sort(this.rtpPacketList);
                long startExtendedSequenceNumber = this.getStartSequenceNumberOfCompleteSequence();
                if (startExtendedSequenceNumber != -1L) {
                    Iterator<RtpPacket> itr = this.rtpPacketList.iterator();
                    while (itr.hasNext()) {
                        RtpPacket packet = itr.next();
                        if (packet.getExtendedSequenceNumber() < startExtendedSequenceNumber) continue;
                        this.buffer.write(packet.getContent());
                        itr.remove();
                        if (!packet.hasMarkerFlag()) continue;
                        ByteArrayInputStream bais = new ByteArrayInputStream(this.buffer.toByteArray());
                        if (this.isDebugLogging()) {
                            this.getLogger().info(new String(this.buffer.toByteArray()));
                        }
                        this.buffer.reset();
                        Document document = new SAXBuilder().build((InputStream)bais);
                        List<QmmData> metadataList = this.createMetadata(document, this.videoSourceEntityId);
                        super.deliverMetadata(metadataList);
                        break;
                    }
                }
                if (this.lastCleanUp != 0L && (rtpPacket.getSequenceNumber() == 0L || System.currentTimeMillis() - this.lastCleanUp > TimeUnit.HOURS.toMillis(1L))) {
                    this.getLogger().info("Cleanup of RTP Packets for Metadata started for " + this + ". List contains " + this.rtpPacketList.size() + " elements");
                    Iterator<RtpPacket> cleanupIterator = this.rtpPacketList.iterator();
                    while (cleanupIterator.hasNext()) {
                        long sequenceNumber = cleanupIterator.next().getSequenceNumber();
                        if (!this.isOldSequenceNumber(sequenceNumber, rtpPacket.getSequenceNumber(), 1000L)) continue;
                        cleanupIterator.remove();
                    }
                    this.lastCleanUp = System.currentTimeMillis();
                    this.getLogger().info("Cleanup of RTP Packets for Metadata finished for " + this + ". List contains " + this.rtpPacketList.size() + " elements");
                }
            }
        }
        catch (Exception ex) {
            this.getLogger().warn("RTP Data not correct for " + this);
        }
    }

    protected List<QmmData> createMetadata(Document document, long videoSourceEntityId) {
        try {
            if (this.isDebugLogging()) {
                XMLOutputter xmlOutputter = new XMLOutputter();
                this.getLogger().info(xmlOutputter.outputString(document));
            }
            MetadataStream metadataStream = new MetadataStream(document);
            List<VideoAnalytics> videoAnalyticsList = metadataStream.getVideoAnalytics();
            ArrayList<QmmData> metadataList = new ArrayList<QmmData>();
            for (VideoAnalytics videoAnalytics : videoAnalyticsList) {
                List<Frame> frameList = videoAnalytics.getFrames();
                for (Frame frame : frameList) {
                    String timestamp = frame.getUtcTime();
                    List<MetadataObject> objectList = frame.getObjects();
                    for (MetadataObject object : objectList) {
                        Metadata metadata = new Metadata();
                        metadata.setSource("Qognify VMS");
                        metadata.setPlace(this.videoSourceName);
                        metadata.setMessageId(UUID.randomUUID());
                        metadata.setCameraId(videoSourceEntityId);
                        metadata.setExternalCameraId(videoSourceEntityId);
                        if (this.getResolution() != null) {
                            metadata.setResolutionWidth(this.getResolution().getWidth());
                            metadata.setResolutionHeight(this.getResolution().getHeight());
                        }
                        if (object.getAppearance().getClassDescriptor().getClassTypes().isEmpty()) continue;
                        try {
                            metadata.setVmsAssumedLikelihood(object.getAppearance().getClassDescriptor().getClassTypes().get(0).getLikelihood());
                        }
                        catch (Exception ex) {
                            this.getLogger().warn("Could not calculate VMS Assumed Likelihood for " + this.videoSourceName + ": " + ex.getMessage());
                        }
                        metadata.setTimestamp(timestamp);
                        metadata.setObject(object);
                        metadataList.add(metadata);
                    }
                }
            }
            return metadataList;
        }
        catch (Exception ex) {
            this.getLogger().warn("Exception while reading metadata for " + this.getSamsungDevice() + (ex.getMessage() != null ? " : " + ex.getMessage() : ""));
            return null;
        }
    }

    @Override
    public void onNetworkError(int errorCode) {
        if (!this.isShutdown(CLASSNAME)) {
            this.getLogger().error("Network error while reading metadata for " + this);
            if (this.rtspHandler != null) {
                int error = errorCode;
                while (!this.isShutdown(CLASSNAME) && error != 0) {
                    this.getLogger().info("Will restart metadata stream for " + this);
                    this.rtspHandler.shutdown();
                    error = this.startMetadataStream();
                }
            }
        } else {
            this.getLogger().info(this + " is already shutting down");
        }
    }

    @Override
    public void sendStatusService(int errorCode) {
    }

    @Override
    public void sendDescribeResponse(RTSPResponse response) {
    }

    @Override
    public void setSsrcfromRtsp(String ssrc) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    private byte[] generateRTCPReceiverReport(byte[] data) {
        byte[] receiverReport = new byte[32];
        receiverReport[0] = -127;
        receiverReport[1] = -55;
        receiverReport[2] = 0;
        receiverReport[3] = 7;
        byte[] receiverSsrc = new byte[4];
        new Random().nextBytes(receiverSsrc);
        System.arraycopy(receiverSsrc, 0, receiverReport, 4, 4);
        System.arraycopy(data, 4, receiverReport, 8, 4);
        System.arraycopy(data, 10, receiverReport, 24, 4);
        return receiverReport;
    }

    @Override
    public void setMikey(Mikey mikey) throws Exception {
    }

    private long getStartSequenceNumberOfCompleteSequence() throws SeeTecException {
        boolean startOfPacket = false;
        boolean completeSequenceFound = false;
        long returnValue = -1L;
        long sequenceNumber = 0L;
        for (RtpPacket rtpPacket : this.rtpPacketList) {
            if (this.isXmlStartPacket(rtpPacket)) {
                sequenceNumber = returnValue = rtpPacket.getExtendedSequenceNumber();
                if (rtpPacket.hasMarkerFlag()) {
                    completeSequenceFound = true;
                    break;
                }
                startOfPacket = true;
                continue;
            }
            if (startOfPacket && rtpPacket.getExtendedSequenceNumber() - 1L != sequenceNumber && (sequenceNumber != 65535L || rtpPacket.getExtendedSequenceNumber() != 0L)) {
                startOfPacket = false;
                continue;
            }
            if (startOfPacket && rtpPacket.hasMarkerFlag()) {
                completeSequenceFound = true;
                break;
            }
            sequenceNumber = rtpPacket.getExtendedSequenceNumber();
        }
        return completeSequenceFound ? returnValue : -1L;
    }

    protected boolean isXmlStartPacket(RtpPacket rtpPacket) {
        byte[] content = rtpPacket.getContent();
        return content[0] == 60 && content[1] == 63;
    }

    protected boolean isOldSequenceNumber(long sequenceNumberToCheck, long currentSequenceNumber, long rtpPacketCleaningRange) {
        boolean result = false;
        if (sequenceNumberToCheck < currentSequenceNumber) {
            result = sequenceNumberToCheck < currentSequenceNumber - rtpPacketCleaningRange;
        } else if (sequenceNumberToCheck > currentSequenceNumber) {
            result = currentSequenceNumber + 65536L - sequenceNumberToCheck > rtpPacketCleaningRange;
        }
        return result;
    }

    private Resolution getResolutionFromCamera() throws Exception {
        String[] resolutionParts;
        String currentResolution = this.getSamsungDevice().readCameraParameters("/stw-cgi/media.cgi?msubmenu=videoprofile&action=view", "Channel." + (this.videoSource - 1) + ".Profile.1.Resolution", null);
        Resolution resolutionOnCamera = null;
        if (currentResolution != null && (resolutionParts = currentResolution.split("x")).length == 2) {
            resolutionOnCamera = new Resolution(Integer.parseInt(resolutionParts[0]), Integer.parseInt(resolutionParts[1]));
        }
        return resolutionOnCamera;
    }

    private MetadataCapabilities getMetadataCapabilities(int videoSource, long cameraId) throws JsonProcessingException, JsonParseException, SeeTecException, IOException {
        MetadataCameraType metadataCameraType = this.getMetadataCameraType(videoSource);
        MetadataCapabilities metadataCapabilities = new MetadataCapabilities(false);
        metadataCapabilities.setVideoSource(cameraId);
        metadataCapabilities.setPositioningUnits(PositioningUnits.Pixel);
        if (metadataCameraType == MetadataCameraType.BASIC) {
            ClassCapabilities classCapabilities = new ClassCapabilities(true);
            VehicleInfoCapabilities vehicleInfoCapabilities = new VehicleInfoCapabilities(false);
            Parameter vehicleType = new Parameter();
            vehicleType.setName("Vehicle type");
            vehicleType.setDataType(DataType.STRING_LIKELIHOOD);
            vehicleType.setPath("Object.Appearance.VehicleInfo.Type.Value");
            String[] vehicleTypes = new String[]{"Car", "Bus", "Truck", "Bicycle", "Motorcycle"};
            vehicleType.addAvailableStringValues(vehicleTypes);
            vehicleInfoCapabilities.setVehicleType(vehicleType);
            metadataCapabilities.setVehicleInfoCapabilities(vehicleInfoCapabilities);
            metadataCapabilities.setClassCapabilities(classCapabilities);
        } else if (metadataCameraType == MetadataCameraType.WISE_AI) {
            String url = "/stw-cgi/opensdk.cgi?msubmenu=metaframecapability&action=view";
            String capabilities = this.getSamsungDevice().getHttpHandler().readGetRequest(url);
            VehicleInfoCapabilities vehicleInfoCapabilities = SamsungMetadataHelper.getWiseAiVehicleInfoCapabilities(capabilities, videoSource);
            metadataCapabilities.setVehicleInfoCapabilities(vehicleInfoCapabilities);
            HumanFaceCapabilities humanFaceCapabilities = SamsungMetadataHelper.getWiseAiHumanFaceCapabilities(capabilities, videoSource);
            metadataCapabilities.setHumanFaceCapabilities(humanFaceCapabilities);
            HumanBodyCapabilities humanBodyCapabilities = SamsungMetadataHelper.getWiseAiHumanBodyCapabilities(capabilities, videoSource);
            metadataCapabilities.setHumanBodyCapabilities(humanBodyCapabilities);
            ClassCapabilities classCapabilities = SamsungMetadataHelper.getWiseAiClassCapabilities(capabilities, videoSource);
            metadataCapabilities.setClassCapabilities(classCapabilities);
        } else if (metadataCameraType == MetadataCameraType.BUILT_IN) {
            VehicleInfoCapabilities vehicleInfoCapabilities = new VehicleInfoCapabilities(false);
            Parameter vehicleType = new Parameter();
            vehicleType.setName("Vehicle type");
            vehicleType.setPath("Object.Appearance.VehicleInfo.Type.Value");
            String[] availableVehicleTypes = new String[]{"Car", "Truck", "Bicycle", "Motorcycle", "Bus"};
            vehicleType.addAvailableStringValues(availableVehicleTypes);
            vehicleType.setDataType(DataType.STRING);
            vehicleInfoCapabilities.setVehicleType(vehicleType);
            Parameter color = new Parameter();
            color.setDataType(DataType.COLOR);
            color.setColorType(ColorDescriptorType.ColorString);
            color.setName("Vehicle color");
            color.setPath("Object.Appearance.VehicleInfo.Color.ColorCluster");
            String[] colorValues = new String[]{"Yellow", "White", "Red", "Purple", "Orange", "Gray", "Green", "Blue", "Black", "Other"};
            color.addAvailableStringValues(Arrays.asList(colorValues));
            vehicleInfoCapabilities.addExtension(color);
            metadataCapabilities.setVehicleInfoCapabilities(vehicleInfoCapabilities);
            HumanBodyCapabilities humanBodyCapabilities = new HumanBodyCapabilities(false);
            ClothingCapabilities clothingCapabilities = new ClothingCapabilities(false);
            TopsCapabilities topsCapabilities = new TopsCapabilities(true);
            topsCapabilities.getColor().addAvailableStringValues(Arrays.asList(colorValues));
            topsCapabilities.setStyle(null);
            topsCapabilities.setGrain(null);
            topsCapabilities.setCategory(null);
            Parameter topsLength = new Parameter();
            topsLength.setDataType(DataType.STRING);
            topsLength.setName("Tops Length");
            topsLength.setPath("Object.Appearance.HumanBody.Clothing.Tops.Length");
            String[] topsLengthValues = new String[]{"Short", "Long"};
            topsLength.addAvailableStringValues(topsLengthValues);
            topsCapabilities.addExtension(topsLength);
            clothingCapabilities.setTopsCapabilities(topsCapabilities);
            BottomsCapabilities bottomsCapabilities = new BottomsCapabilities(true);
            bottomsCapabilities.getColor().addAvailableStringValues(Arrays.asList(colorValues));
            bottomsCapabilities.setStyle(null);
            bottomsCapabilities.setGrain(null);
            bottomsCapabilities.setCategory(null);
            Parameter bottomsLength = new Parameter();
            bottomsLength.setDataType(DataType.STRING);
            bottomsLength.setName("Bottoms Length");
            bottomsLength.setPath("Object.Appearance.HumanBody.Clothing.Bottoms.Length");
            String[] bottomsLengthValues = new String[]{"Short", "Long"};
            bottomsLength.addAvailableStringValues(bottomsLengthValues);
            bottomsCapabilities.addExtension(bottomsLength);
            clothingCapabilities.setBottomsCapabilities(bottomsCapabilities);
            humanBodyCapabilities.setClothingCapabilities(clothingCapabilities);
            HumanFaceCapabilities humanFaceCapabilities = new HumanFaceCapabilities(false);
            Parameter gender = new Parameter();
            gender.setName("Gender");
            gender.setDataType(DataType.STRING);
            String[] genderValues = new String[]{"Male", "Female"};
            gender.addAvailableStringValues(Arrays.asList(genderValues));
            gender.setPath("Object.Appearance.HumanFace.Gender");
            humanFaceCapabilities.setGender(gender);
            Parameter ageType = new Parameter();
            ageType.setDataType(DataType.STRING);
            String[] ageTypeValues = new String[]{"Young", "Adult", "Middle", "Senior"};
            ageType.addAvailableStringValues(Arrays.asList(ageTypeValues));
            ageType.setPath("Object.Appearance.HumanFace.AgeType");
            ageType.setName("Age");
            humanFaceCapabilities.setAge(ageType);
            AccessoryCapabilities glasses = new AccessoryCapabilities("Glasses");
            glasses.setColor(null);
            glasses.getWear().setName("Glasses");
            humanFaceCapabilities.addAccessoryCapabilitie(glasses);
            AccessoryCapabilities mask = new AccessoryCapabilities("Mask");
            mask.setColor(null);
            mask.getWear().setName("Mask");
            humanFaceCapabilities.addAccessoryCapabilitie(mask);
            AccessoryCapabilities hat = new AccessoryCapabilities("Hat");
            hat.setColor(null);
            hat.getWear().setName("Hat");
            humanFaceCapabilities.addAccessoryCapabilitie(hat);
            metadataCapabilities.setHumanFaceCapabilities(humanFaceCapabilities);
            BelongingCapabilities belongingCapabilities = new BelongingCapabilities(false);
            Parameter bag = new Parameter();
            bag.setDataType(DataType.BOOLEAN);
            bag.setName("Bag");
            bag.setPath("Object.Appearance.HumanBody.Belonging.Bag");
            belongingCapabilities.setBag(bag);
            humanBodyCapabilities.setBelongingCapabilities(belongingCapabilities);
            metadataCapabilities.setHumanBodyCapabilities(humanBodyCapabilities);
        }
        return metadataCapabilities;
    }

    protected MetadataCameraType getMetadataCameraType(int videoSource) throws SeeTecException, IOException {
        try {
            String url = "/opensdk/WiseAI/configuration/objectdetection";
            String capabilities = this.getSamsungDevice().getHttpHandler().readGetRequest(url);
            if (capabilities != null) {
                url = "/stw-cgi/opensdk.cgi?msubmenu=apps&action=view";
                String wiseAiData = this.getSamsungDevice().getHttpHandler().readGetRequest(url);
                String firmware = SamsungHelper.getValueFromList(wiseAiData, "WiseAI.Version");
                if (Basic.isVersionGreaterOrEqual((String)firmware, (int[])new int[]{1, 2, 1})) {
                    return MetadataCameraType.WISE_AI;
                }
                return MetadataCameraType.BASIC;
            }
        }
        catch (Exception ex) {
            this.getLogger().info("WiseAI not available for " + this + " looking for other Metadata capabilities");
        }
        org.w3c.dom.Document attributes = this.getSamsungDevice().getAttributesDoc();
        String xPath = "//attributes/group[@name='Media']/category[@name='Support']/channel[@number='" + (videoSource - 1) + "']/attribute[@name='Metadata.ClassTypes']/@value";
        List<String> attributesList = this.getSamsungDevice().getAttributes(xPath, attributes);
        if (attributesList != null && SamsungHelper.getFirstBoolean(attributesList)) {
            xPath = "//attributes/group[@name='Media']/category[@name='Support']/channel[@number='" + (videoSource - 1) + "']/attribute[@name='Metadata.ClassTypeDetails']/@value";
            attributesList = this.getSamsungDevice().getAttributes(xPath, attributes);
            if (attributesList != null && SamsungHelper.getFirstBoolean(attributesList)) {
                return MetadataCameraType.BUILT_IN;
            }
            return MetadataCameraType.BASIC;
        }
        xPath = "//attributes/group[@name='Eventsource']/category[@name='Support']/channel[@number='" + (videoSource - 1) + "']/attribute[@name='ObjectDetection']/@value";
        attributesList = this.getSamsungDevice().getAttributes(xPath, attributes);
        if (attributesList != null && SamsungHelper.getFirstBoolean(attributesList)) {
            return MetadataCameraType.BUILT_IN;
        }
        return MetadataCameraType.NONE;
    }
}

