/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.cm.device.video.samsung;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import de.seetec.v5.re.cm.device.shared.metadata.capabilities.AccessoryCapabilities;
import de.seetec.v5.re.cm.device.shared.metadata.capabilities.BelongingCapabilities;
import de.seetec.v5.re.cm.device.shared.metadata.capabilities.BottomsCapabilities;
import de.seetec.v5.re.cm.device.shared.metadata.capabilities.ClassCapabilities;
import de.seetec.v5.re.cm.device.shared.metadata.capabilities.ClothingCapabilities;
import de.seetec.v5.re.cm.device.shared.metadata.capabilities.ColorDescriptorType;
import de.seetec.v5.re.cm.device.shared.metadata.capabilities.DataType;
import de.seetec.v5.re.cm.device.shared.metadata.capabilities.HumanBodyCapabilities;
import de.seetec.v5.re.cm.device.shared.metadata.capabilities.HumanFaceCapabilities;
import de.seetec.v5.re.cm.device.shared.metadata.capabilities.Parameter;
import de.seetec.v5.re.cm.device.shared.metadata.capabilities.TopsCapabilities;
import de.seetec.v5.re.cm.device.shared.metadata.capabilities.VehicleInfoCapabilities;
import de.seetec.v5.re.cm.device.video.samsung.SamsungMetadataCapabilitiesXpath;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class SamsungMetadataHelper {
    private SamsungMetadataHelper() {
        throw new UnsupportedOperationException();
    }

    static VehicleInfoCapabilities getWiseAiVehicleInfoCapabilities(String capabilities, int videoSource) throws IOException, JsonParseException {
        Iterator<JsonNode> capabilityDetails = SamsungMetadataHelper.extractValidMetadata(capabilities, videoSource);
        VehicleInfoCapabilities vehicleInfoCapabilities = null;
        if (capabilityDetails != null) {
            vehicleInfoCapabilities = new VehicleInfoCapabilities(false);
            while (capabilityDetails.hasNext()) {
                JsonNode capabilityDetail = capabilityDetails.next();
                JsonNode capability = capabilityDetail.get("xpath");
                if (capability.asText().equalsIgnoreCase(SamsungMetadataCapabilitiesXpath.VEHICLE_INFO_COLOR.getValue())) {
                    Parameter color = new Parameter("Vehicle color", "Object.Appearance.VehicleInfo.Color.ColorCluster", ColorDescriptorType.ColorString.name(), DataType.COLOR);
                    color.addAvailableStringValues(SamsungMetadataHelper.getJsonEnumValues(capabilityDetail));
                    vehicleInfoCapabilities.addExtension(color);
                    continue;
                }
                if (!capability.asText().equalsIgnoreCase(SamsungMetadataCapabilitiesXpath.VEHICLE_INFO_TYPE.getValue())) continue;
                Parameter vehicleType = new Parameter("Vehicle type", "Object.Appearance.VehicleInfo.Type.Value", DataType.STRING_LIKELIHOOD, new String[0]);
                vehicleType.addAvailableStringValues(SamsungMetadataHelper.getJsonEnumValues(capabilityDetail));
                vehicleInfoCapabilities.setVehicleType(vehicleType);
            }
        }
        return vehicleInfoCapabilities;
    }

    static HumanFaceCapabilities getWiseAiHumanFaceCapabilities(String capabilities, int videoSource) throws IOException, JsonParseException {
        Iterator<JsonNode> capabilityDetails = SamsungMetadataHelper.extractValidMetadata(capabilities, videoSource);
        HumanFaceCapabilities humanFaceCapabilities = null;
        if (capabilityDetails != null) {
            humanFaceCapabilities = new HumanFaceCapabilities(false);
            boolean hatAlreadyIncluded = false;
            boolean genderAlreadyIncluded = false;
            while (capabilityDetails.hasNext()) {
                AccessoryCapabilities accessoryCapability;
                String accessoryName;
                JsonNode capabilityDetail = capabilityDetails.next();
                JsonNode capability = capabilityDetail.get("xpath");
                if ((capability.asText().equalsIgnoreCase(SamsungMetadataCapabilitiesXpath.HUMANFACE_GENDER.getValue()) || capability.asText().equalsIgnoreCase(SamsungMetadataCapabilitiesXpath.HUMANBODY_GENDER.getValue())) && !genderAlreadyIncluded) {
                    Parameter gender = new Parameter("Gender", "Object.Appearance.HumanFace.Gender", DataType.STRING, "Male", "Female");
                    humanFaceCapabilities.setGender(gender);
                    genderAlreadyIncluded = true;
                    continue;
                }
                if (capability.asText().equalsIgnoreCase(SamsungMetadataCapabilitiesXpath.HUMANFACE_AGE.getValue())) {
                    Parameter age = new Parameter("Age", "Object.Appearance.HumanFace.AgeType", DataType.STRING, new String[0]);
                    age.addAvailableStringValues(SamsungMetadataHelper.getJsonEnumValues(capabilityDetail));
                    humanFaceCapabilities.setAge(age);
                    continue;
                }
                if (capability.asText().equalsIgnoreCase(SamsungMetadataCapabilitiesXpath.HUMANFACE_OPTICALS.getValue())) {
                    accessoryName = "Glasses";
                    accessoryCapability = new AccessoryCapabilities(accessoryName);
                    accessoryCapability.setPath("Object.Appearance.HumanFace.Accesories." + accessoryName);
                    humanFaceCapabilities.addAccessoryCapabilitie(accessoryCapability);
                    continue;
                }
                if ((capability.asText().equalsIgnoreCase(SamsungMetadataCapabilitiesXpath.HUMANFACE_HAT.getValue()) || capability.asText().equalsIgnoreCase(SamsungMetadataCapabilitiesXpath.HUMANBODY_CLOTHING_HAT.getValue())) && !hatAlreadyIncluded) {
                    accessoryName = "Hat";
                    accessoryCapability = new AccessoryCapabilities(accessoryName);
                    accessoryCapability.setPath("Object.Appearance.HumanFace.Accesories." + accessoryName);
                    humanFaceCapabilities.addAccessoryCapabilitie(accessoryCapability);
                    hatAlreadyIncluded = true;
                    continue;
                }
                if (!capability.asText().equalsIgnoreCase(SamsungMetadataCapabilitiesXpath.HUMANFACE_MASK.getValue())) continue;
                accessoryName = "Mask";
                accessoryCapability = new AccessoryCapabilities(accessoryName);
                accessoryCapability.setPath("Object.Appearance.HumanFace.Accesories." + accessoryName);
                humanFaceCapabilities.addAccessoryCapabilitie(accessoryCapability);
            }
        }
        return humanFaceCapabilities;
    }

    static HumanBodyCapabilities getWiseAiHumanBodyCapabilities(String capabilities, int videoSource) throws IOException, JsonParseException {
        Iterator<JsonNode> capabilityDetails = SamsungMetadataHelper.extractValidMetadata(capabilities, videoSource);
        HumanBodyCapabilities humanBodyCapabilities = null;
        if (capabilityDetails != null) {
            humanBodyCapabilities = new HumanBodyCapabilities(false);
            ClothingCapabilities clothingCapabilities = new ClothingCapabilities(false);
            TopsCapabilities topsCapabilities = new TopsCapabilities(false);
            BottomsCapabilities bottomsCapabilities = new BottomsCapabilities(false);
            while (capabilityDetails.hasNext()) {
                Parameter category;
                JsonNode capabilityDetail = capabilityDetails.next();
                JsonNode capability = capabilityDetail.get("xpath");
                if (capability.asText().equalsIgnoreCase(SamsungMetadataCapabilitiesXpath.HUMANBODY_CLOTHING_TOPS_COLOR.getValue())) {
                    Parameter topsColor = new Parameter("Tops color", "Object.Appearance.HumanBody.Clothing.Tops.Color.ColorCluster", ColorDescriptorType.ColorString.name(), DataType.COLOR);
                    topsColor.addAvailableStringValues(SamsungMetadataHelper.getJsonEnumValues(capabilityDetail));
                    topsCapabilities.setColor(topsColor);
                    continue;
                }
                if (capability.asText().equalsIgnoreCase(SamsungMetadataCapabilitiesXpath.HUMANBODY_CLOTHING_TOPS_LENGTH.getValue())) {
                    category = new Parameter("Tops category", "Object.Appearance.HumanBody.Clothing.Tops.Category", DataType.STRING, new String[0]);
                    category.addAvailableStringValues(SamsungMetadataHelper.getJsonEnumValues(capabilityDetail));
                    topsCapabilities.setCategory(category);
                    continue;
                }
                if (capability.asText().equalsIgnoreCase(SamsungMetadataCapabilitiesXpath.HUMANBODY_CLOTHING_BOTTOMS_COLOR.getValue())) {
                    Parameter bottomsColor = new Parameter("Bottoms color", "Object.Appearance.HumanBody.Clothing.Bottoms.Color.ColorCluster", ColorDescriptorType.ColorString.name(), DataType.COLOR);
                    bottomsColor.addAvailableStringValues(SamsungMetadataHelper.getJsonEnumValues(capabilityDetail));
                    bottomsCapabilities.setColor(bottomsColor);
                    continue;
                }
                if (capability.asText().equalsIgnoreCase(SamsungMetadataCapabilitiesXpath.HUMANBODY_CLOTHING_BOTTOMS_LENGTH.getValue())) {
                    category = new Parameter("Bottoms category", "Object.Appearance.HumanBody.Clothing.Bottoms.Category", DataType.STRING, new String[0]);
                    category.addAvailableStringValues(SamsungMetadataHelper.getJsonEnumValues(capabilityDetail));
                    bottomsCapabilities.setCategory(category);
                    continue;
                }
                if (!capability.asText().equalsIgnoreCase(SamsungMetadataCapabilitiesXpath.HUMANBODY_CLOTHING_BELONGING_BAG.getValue())) continue;
                BelongingCapabilities belongingCapabilities = new BelongingCapabilities(false);
                Parameter bag = new Parameter("Bag", "Object.Appearance.HumanBody.Belonging.Bag", DataType.BOOLEAN, new String[0]);
                belongingCapabilities.setBag(bag);
                humanBodyCapabilities.setBelongingCapabilities(belongingCapabilities);
            }
            clothingCapabilities.setBottomsCapabilities(bottomsCapabilities);
            clothingCapabilities.setTopsCapabilities(topsCapabilities);
            humanBodyCapabilities.setClothingCapabilities(clothingCapabilities);
        }
        return humanBodyCapabilities;
    }

    static ClassCapabilities getWiseAiClassCapabilities(String capabilities, int videoSource) throws IOException, JsonParseException {
        Iterator<JsonNode> capabilityDetails = SamsungMetadataHelper.extractValidMetadata(capabilities, videoSource);
        ClassCapabilities classCapabilities = null;
        if (capabilityDetails != null) {
            classCapabilities = new ClassCapabilities(false);
            while (capabilityDetails.hasNext()) {
                JsonNode capabilityDetail = capabilityDetails.next();
                JsonNode capability = capabilityDetail.get("xpath");
                if (!capability.asText().equalsIgnoreCase(SamsungMetadataCapabilitiesXpath.CLASS_TYPE.getValue())) continue;
                Parameter classType = new Parameter("Type", "Object.Appearance.ClassDescriptor.Type", DataType.STRING_LIKELIHOOD, new String[0]);
                Iterator types = capabilityDetail.get("enum").elements();
                while (types.hasNext()) {
                    JsonNode type = (JsonNode)types.next();
                    String metadataType = type.asText();
                    if (metadataType.equals("LicensePlate")) continue;
                    classType.getAvailableStringValues().add(metadataType);
                }
                classCapabilities.setType(classType);
            }
        }
        return classCapabilities;
    }

    protected static Iterator<JsonNode> extractValidMetadata(String capabilities, int videoSource) throws IOException, JsonParseException {
        ObjectMapper objectMapper = new ObjectMapper();
        JsonFactory factory = objectMapper.getFactory();
        JsonParser jsonParser = factory.createParser(capabilities);
        JsonNode capabilitiesNode = (JsonNode)objectMapper.readTree(jsonParser);
        JsonNode channelList = capabilitiesNode.get("MetaFrameCapability");
        for (JsonNode jsonNode : channelList) {
            if (jsonNode.get("Channel").asInt() != videoSource - 1) continue;
            JsonNode appCapabilities = jsonNode.get("AppCapabilities");
            for (JsonNode node : appCapabilities) {
                JsonNode caps = node.get("Capabilities");
                if (caps == null) continue;
                Iterator capabilityDetails = caps.elements();
                return capabilityDetails;
            }
        }
        return null;
    }

    private static List<String> getJsonEnumValues(JsonNode capabilityDetail) {
        ArrayList<String> enumList = new ArrayList<String>();
        Iterator types = capabilityDetail.get("enum").elements();
        while (types.hasNext()) {
            JsonNode type = (JsonNode)types.next();
            enumList.add(type.asText());
        }
        return enumList;
    }
}

