/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.cm.device.video.samsung;

import de.seetec.v5.re.cm.Core;
import de.seetec.v5.re.cm.device.shared.Device;
import de.seetec.v5.re.cm.device.shared.io.DigitalInputSrv;
import de.seetec.v5.re.cm.device.shared.io.DigitalOutputSrv;
import de.seetec.v5.re.cm.device.shared.io.IOHandler;
import de.seetec.v5.re.cm.device.video.samsung.AlarmType;
import de.seetec.v5.re.cm.device.video.samsung.SamsungAlarmHandlerIntf;
import de.seetec.v5.re.cm.device.video.samsung.SamsungDevice;
import de.seetec.v5.re.cm.device.video.samsung.SamsungEventMessage;
import de.seetec.v5.re.cm.device.video.samsung.SamsungEventReader;
import de.seetec.v5.shared.net.HTTPResponse;
import de.seetec.v5.shared.net.HttpHandler;
import de.seetec.v5.shared.proxy.ent.Entity;
import de.seetec.v5.shared.util.SeeTecException;
import java.io.IOException;
import java.net.ConnectException;
import java.net.NoRouteToHostException;
import java.net.UnknownHostException;

public class SamsungIOHandler
extends IOHandler
implements SamsungAlarmHandlerIntf {
    private static final String CLASS_NAME = "de.seetec.v5.re.cm.device.video.samsung.SamsungIOHandler";
    private SamsungEventReader samsungEventReader;
    private SamsungDevice samsungDevice = null;
    private int inputNumber;
    private DigitalInputSrv[] iServices;
    private int firstInput;

    @Override
    public int init(Core core, Device device, Entity[] srvEntities, boolean ignoreSomeParameter, boolean unconditionalStartOfThread) {
        int error = super.init(core, device, srvEntities, ignoreSomeParameter, unconditionalStartOfThread);
        if (device.getDeviceEntity().getEntityType() == 201854L || device.getDeviceEntity().getEntityType() == 206400L || device.getDeviceEntity().getEntityType() == 206800L) {
            this.createSamsungAlarm();
        }
        return error;
    }

    private HttpHandler getHttpHandler() {
        return this.getSamsungDevice().getHttpHandler();
    }

    @Override
    public void run() {
        super.setRunFinished(CLASS_NAME, false);
        this.iServices = super.getDigitalInputSrv();
        this.firstInput = this.getSamsungDevice().getFirstInput();
        for (int i = 0; i < this.iServices.length / 2; ++i) {
            if (!this.iServices[i].getEntity().isEnabled().booleanValue()) continue;
            String url = "/cgi-bin/event.cgi?msubmenu=input" + (i + 1) + "&action=apply&active=always&device=1";
            try {
                if (this.getHttpHandler().readGetRequest(url) != null) continue;
                this.logger.error("Error while setting Alarm input " + (i + 1));
                continue;
            }
            catch (SeeTecException see) {
                if (see.getErrorCode() != -21657) continue;
                try {
                    if (this.getHttpHandler().readGetRequest(url) != null) continue;
                    this.logger.error("Error while setting Alarm input " + (i + 1));
                    continue;
                }
                catch (SeeTecException ex) {
                    this.logger.error("Exception while setting up authentication for " + this);
                }
            }
        }
        try {
            boolean previousLoopWithError = false;
            while (!(this.isShutdown(CLASS_NAME) || super.isShutdown() || this.device.isShutdown())) {
                try {
                    long duration;
                    long ts = System.currentTimeMillis();
                    this.readDigitalInputs();
                    if (previousLoopWithError) {
                        previousLoopWithError = false;
                        this.logger.info("Publishing input stati after error for " + this);
                        DigitalInputSrv[] ex = this.iServices;
                        int n = ex.length;
                        for (int i = 0; i < n; ++i) {
                            DigitalInputSrv iService = ex[i];
                            if (!iService.getEntity().isEnabled().booleanValue()) continue;
                            iService.publishServiceStatus(iService.getInputStatus());
                        }
                    }
                    if ((duration = System.currentTimeMillis() - ts) < 0L || duration >= 190L) continue;
                    try {
                        Thread.sleep(200L - duration);
                    }
                    catch (InterruptedException interruptedException) {}
                }
                catch (Throwable ex) {
                    previousLoopWithError = true;
                    if (ex instanceof IOException || ex instanceof UnknownHostException || ex instanceof NoRouteToHostException || ex instanceof ConnectException) {
                        this.logger.warn("Network trouble for " + this);
                    } else {
                        this.logger.warn((Object)ex, ex);
                        if (ex.getMessage().contains("Address already in use")) {
                            this.logger.warn("TCP stack seems to be overloaded, so there are problems for " + this);
                        } else {
                            this.logger.warn("Unknown trouble for " + this);
                        }
                    }
                    try {
                        for (DigitalInputSrv iService : this.iServices) {
                            if (!iService.getEntity().isEnabled().booleanValue()) continue;
                            iService.publishServiceStatus(-21603);
                        }
                    }
                    catch (Throwable t) {
                        this.logger.warn((Object)t, t);
                    }
                    long tsTimeout = System.currentTimeMillis() + 10000L;
                    while (tsTimeout > System.currentTimeMillis() && !this.isShutdown(CLASS_NAME) && !this.device.isShutdown()) {
                        try {
                            Thread.sleep(100L);
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                }
            }
        }
        catch (Throwable ex) {
            this.logger.error((Object)ex, ex);
        }
        this.logger.info("Thread of this " + this + " finished :-)");
        super.setRunFinished(CLASS_NAME, true);
        this.shutdown();
    }

    @Override
    public int writeDigitalOutput(int outputNumber, int value, long holdTime) {
        IOHandler.HoldTimer holdTimer;
        int errorCode = 0;
        DigitalOutputSrv service = super.getDigitalOutputSrv(outputNumber);
        if (service == null) {
            this.logger.error(this + " has no digital output service configured for [ " + outputNumber + " ] :-( ");
            return -21601;
        }
        if (value < 0) {
            this.logger.error("Value [ " + value + " ] is not valid for " + this + " :-( ");
            return -21601;
        }
        StringBuilder url = new StringBuilder();
        int outputType = this.getSamsungDevice().getOutputType();
        if (outputType == 1) {
            url.append("/cgi-bin/io?submenu=output&action=");
            url.append(outputNumber);
            url.append(":");
            if (value > 0) {
                url.append("/");
            } else {
                url.append("\\");
            }
        } else if (outputType == 2) {
            url.append("/cgi-bin/control.cgi?msubmenu=output&action=");
            url.append(outputNumber);
            url.append(":");
            if (value > 0) {
                url.append("H");
            } else {
                url.append("L");
            }
        } else if (outputType == 3) {
            url.append("/cgi-bin/control.cgi?msubmenu=output&action=");
            url.append(outputNumber);
            url.append(":");
            if (value > 0) {
                url.append("/");
            } else {
                url.append("\\");
            }
        } else {
            try {
                if (this.getSamsungDevice().isSunApi_2()) {
                    url.append("/stw-cgi/io.cgi?msubmenu=alarmoutput&action=control&AlarmOutput.").append(outputNumber).append(".State=");
                    if (value > 0) {
                        url.append("On");
                    } else {
                        url.append("Off");
                    }
                    String urlWithHoldingTime = url.toString() + "&AlarmOutput." + outputNumber + ".ManualDuration=Always";
                    try {
                        this.getHttpHandler().readGetRequest(urlWithHoldingTime);
                    }
                    catch (Exception e) {
                        this.logger.warn("Setting output using " + urlWithHoldingTime + " doesnt work. Trying command " + url.toString() + " for " + this);
                    }
                }
            }
            catch (SeeTecException ex) {
                this.logger.error((Object)ex, (Throwable)ex);
                return ex.getErrorCode();
            }
        }
        try {
            this.getHttpHandler().readGetRequest(url.toString());
        }
        catch (SeeTecException see) {
            if (see.getErrorCode() == -21657) {
                try {
                    this.getHttpHandler().readGetRequest(url.toString());
                }
                catch (Exception e) {
                    this.logger.error((Object)e, (Throwable)e);
                    return errorCode;
                }
            }
            this.logger.error((Object)see, (Throwable)see);
            errorCode = see.getErrorCode();
            return errorCode;
        }
        catch (Exception e) {
            this.logger.error((Object)e, (Throwable)e);
            return errorCode;
        }
        if (holdTime > 0L && (errorCode = (holdTimer = new IOHandler.HoldTimer()).init(outputNumber, value > 0 ? 0 : 1, holdTime)) != 0) {
            holdTimer.shutdown();
            this.logger.warn("Creating " + holdTimer + " failed with error [ " + errorCode + " ]");
        }
        return 0;
    }

    private int readDigitalInputs() throws Exception {
        block7: {
            block6: {
                if (this.iServices == null) {
                    this.iServices = super.getDigitalInputSrv();
                }
                if (!this.getSamsungDevice().isSunApi_2()) break block6;
                if (this.device.getDeviceEntity().getEntityType() == 201854L || this.device.getDeviceEntity().getEntityType() == 206400L || this.device.getDeviceEntity().getEntityType() == 206800L) break block7;
                String url = "/stw-cgi/eventstatus.cgi?msubmenu=eventstatus&action=check&AlarmInput=";
                for (DigitalInputSrv iService : this.iServices) {
                    HTTPResponse httpResponse;
                    String inputResult;
                    String[] resultLines;
                    int in = iService.getInputNumber();
                    byte[] result = this.getHttpHandler().readGetRequestAsByteArray(url + in);
                    if (result == null || (resultLines = (inputResult = (httpResponse = new HTTPResponse(result)).getHttpBody().getData().replace("\r", "").replace("\n", "").trim()).split("=")).length != 2) continue;
                    if (resultLines[1].trim().equalsIgnoreCase("true")) {
                        iService.checkInput(1);
                        continue;
                    }
                    iService.checkInput(0);
                }
                break block7;
            }
            String url = "/cgi-bin/control.cgi?msubmenu=input&action=check";
            String digitalInputResult = this.getHttpHandler().readGetRequest(url);
            if (digitalInputResult != null) {
                String[] digitalInputResults = digitalInputResult.split("IO");
                for (DigitalInputSrv iService : this.iServices) {
                    int nInputNumber = iService.getInputNumber();
                    String[] resultForOneDigitalInput = digitalInputResults[nInputNumber].split(":");
                    this.inputNumber = Integer.parseInt(resultForOneDigitalInput[0].trim());
                    int n = this.inputNumber = this.firstInput == 0 ? this.inputNumber + 1 : this.inputNumber;
                    if (this.inputNumber != nInputNumber) continue;
                    if (resultForOneDigitalInput[1].contains("H")) {
                        iService.checkInput(1);
                        continue;
                    }
                    iService.checkInput(0);
                }
            }
        }
        return 0;
    }

    @Override
    public AlarmType getAlarmType() {
        return AlarmType.INPUT;
    }

    @Override
    public void receiveAlarm(SamsungEventMessage samsungEventMessage) {
        DigitalInputSrv[] inputServices;
        int value = samsungEventMessage.isTriggered() ? 1 : 0;
        for (DigitalInputSrv iService : inputServices = super.getDigitalInputSrv()) {
            if (iService.getInputNumber() != samsungEventMessage.getAlarmNumber()) continue;
            iService.checkInput(value);
        }
    }

    @Override
    public void deregister() {
        if (this.samsungEventReader != null) {
            this.samsungEventReader.deregister(this);
        }
    }

    private void createSamsungAlarm() {
        this.samsungEventReader = this.getSamsungDevice().getEventReader();
        this.samsungEventReader.register(this);
        if (this.samsungEventReader == null) {
            this.logger.error("Could not initialize Alarm Handling for " + this);
        }
    }

    @Override
    public void notifyForNetworkProblems() {
        this.logger.warn("Network Problems for " + this);
    }

    @Override
    public int getChannel() {
        return 0;
    }

    private SamsungDevice getSamsungDevice() {
        if (this.samsungDevice == null) {
            this.samsungDevice = (SamsungDevice)this.device;
            this.samsungDevice.setModelInformation();
        }
        return this.samsungDevice;
    }

    @Override
    public int shutdown() {
        this.deregister();
        return super.shutdown();
    }
}

