/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.cm.device.video.samsung;

import de.seetec.v5.re.cm.shared.AbsolutePTZCapabilities;
import de.seetec.v5.shared.util.SeeTecException;
import java.util.ArrayList;
import java.util.List;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.Document;
import org.w3c.dom.NodeList;

public final class SamsungHelper {
    private SamsungHelper() {
    }

    public static Integer getSourceNumber(String eventName) {
        String[] eventNameParts;
        if (eventName != null && eventName.toLowerCase().startsWith("channel") && (eventNameParts = eventName.split("\\.")).length > 1) {
            try {
                int sourceNumber = Integer.parseInt(eventNameParts[1]) + 1;
                return sourceNumber;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return null;
    }

    public static AbsolutePTZCapabilities getAbsolutePTZCapabilities(Document attributes, int videoSource) throws SeeTecException {
        AbsolutePTZCapabilities absolutePTZCapabilities = new AbsolutePTZCapabilities();
        absolutePTZCapabilities.setSupportsAbsolutePan(SamsungHelper.isSupportsAbsolutePan(attributes, videoSource));
        absolutePTZCapabilities.setSupportsAbsoluteTilt(SamsungHelper.isSupportsAbsoluteTilt(attributes, videoSource));
        absolutePTZCapabilities.setSupportsAbsoluteZoom(SamsungHelper.isSupportsAbsoluteZoom(attributes, videoSource));
        absolutePTZCapabilities.setAbsolutePanMin(SamsungHelper.getAbsolutePanMin(attributes));
        absolutePTZCapabilities.setAbsolutePanMax(SamsungHelper.getAbsolutePanMax(attributes));
        absolutePTZCapabilities.setAbsoluteTiltMin(SamsungHelper.getAbsoluteTiltMin(attributes));
        absolutePTZCapabilities.setAbsoluteTiltMax(SamsungHelper.getAbsoluteTiltMax(attributes));
        absolutePTZCapabilities.setAbsoluteZoomMin(SamsungHelper.getAbsoluteZoomMin(attributes));
        absolutePTZCapabilities.setAbsoluteZoomMax(SamsungHelper.getAbsoluteZoomMax(attributes));
        return absolutePTZCapabilities;
    }

    public static Integer getFirstFromListAsInt(List<String> input) {
        return SamsungHelper.getElementFromListAsInt(input, 0);
    }

    public static String[] getListAsStringArray(List<String> input) {
        if (input == null || input.isEmpty()) {
            return new String[0];
        }
        String inputString = input.get(0);
        String[] lines = inputString.split(",");
        for (int i = 0; i < lines.length; ++i) {
            lines[i] = lines[i].trim();
        }
        return lines;
    }

    private static Integer getElementFromListAsInt(List<String> input, int position) {
        if (input != null && !input.isEmpty() && input.size() >= position) {
            try {
                return Integer.valueOf(input.get(position));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return null;
    }

    protected static boolean getFirstBoolean(List<String> input) {
        return !input.isEmpty() && input.get(0).equals("True");
    }

    private static List<String> getAttributes(String path, Document attributesDoc) throws SeeTecException {
        ArrayList<String> resultList = new ArrayList<String>();
        if (path == null || path.isEmpty()) {
            return resultList;
        }
        XPath xPath = XPathFactory.newInstance().newXPath();
        try {
            NodeList nodeList = (NodeList)xPath.compile(path).evaluate(attributesDoc, XPathConstants.NODESET);
            for (int i = 0; i < nodeList.getLength(); ++i) {
                String value = nodeList.item(i).getTextContent();
                resultList.add(value);
            }
        }
        catch (Exception ex) {
            throw new SeeTecException(-20001, "Could not read attributes");
        }
        return resultList;
    }

    private static boolean isSupportsAbsolutePan(Document attributes, int videoSource) throws SeeTecException {
        String xPath = "//attributes/group[@name='PTZSupport']/category[@name='Support']/channel[@number='" + videoSource + "']/attribute[@name='Absolute.Pan']/@value";
        return SamsungHelper.getFirstBoolean(SamsungHelper.getAttributes(xPath, attributes));
    }

    private static boolean isSupportsAbsoluteTilt(Document attributes, int videoSource) throws SeeTecException {
        String xPath = "//attributes/group[@name='PTZSupport']/category[@name='Support']/channel[@number='" + videoSource + "']/attribute[@name='Absolute.Tilt']/@value";
        return SamsungHelper.getFirstBoolean(SamsungHelper.getAttributes(xPath, attributes));
    }

    private static boolean isSupportsAbsoluteZoom(Document attributes, int videoSource) throws SeeTecException {
        String xPath = "//attributes/group[@name='PTZSupport']/category[@name='Support']/channel[@number='" + videoSource + "']/attribute[@name='Absolute.Zoom']/@value";
        return SamsungHelper.getFirstBoolean(SamsungHelper.getAttributes(xPath, attributes));
    }

    private static Integer getAbsolutePanMin(Document attributes) throws SeeTecException {
        String xPath = "//cgis/cgi[@name='ptzcontrol']/submenu[@name='absolute']/action[@name='control']/parameter[@name='Pan']/dataType/float/@min";
        return SamsungHelper.getFirstFromListAsInt(SamsungHelper.getAttributes(xPath, attributes));
    }

    private static Integer getAbsolutePanMax(Document attributes) throws SeeTecException {
        String xPath = "//cgis/cgi[@name='ptzcontrol']/submenu[@name='absolute']/action[@name='control']/parameter[@name='Pan']/dataType/float/@max";
        return SamsungHelper.getFirstFromListAsInt(SamsungHelper.getAttributes(xPath, attributes));
    }

    private static Integer getAbsoluteTiltMin(Document attributes) throws SeeTecException {
        String xPath = "//cgis/cgi[@name='ptzcontrol']/submenu[@name='absolute']/action[@name='control']/parameter[@name='Tilt']/dataType/float/@min";
        return SamsungHelper.getFirstFromListAsInt(SamsungHelper.getAttributes(xPath, attributes));
    }

    private static Integer getAbsoluteTiltMax(Document attributes) throws SeeTecException {
        String xPath = "//cgis/cgi[@name='ptzcontrol']/submenu[@name='absolute']/action[@name='control']/parameter[@name='Tilt']/dataType/float/@max";
        return SamsungHelper.getFirstFromListAsInt(SamsungHelper.getAttributes(xPath, attributes));
    }

    private static Integer getAbsoluteZoomMin(Document attributes) throws SeeTecException {
        String xPath = "//cgis/cgi[@name='ptzcontrol']/submenu[@name='absolute']/action[@name='control']/parameter[@name='Zoom']/dataType/float/@min";
        return SamsungHelper.getFirstFromListAsInt(SamsungHelper.getAttributes(xPath, attributes));
    }

    private static Integer getAbsoluteZoomMax(Document attributes) throws SeeTecException {
        String xPath = "//cgis/cgi[@name='ptzcontrol']/submenu[@name='absolute']/action[@name='control']/parameter[@name='Zoom']/dataType/float/@max";
        return SamsungHelper.getFirstFromListAsInt(SamsungHelper.getAttributes(xPath, attributes));
    }

    protected static String getValueFromList(String list, String key) {
        String[] listItems;
        String result = "";
        for (String item : listItems = list.split("\r\n")) {
            if (!item.startsWith(key + "=")) continue;
            result = item.replace(key + "=", "").trim();
        }
        return result;
    }
}

