/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.cm.device.video.samsung;

import de.seetec.v5.re.cm.device.video.samsung.AlarmType;
import de.seetec.v5.re.cm.device.video.samsung.SamsungAlarmHandlerIntf;
import de.seetec.v5.re.cm.device.video.samsung.SamsungDevice;
import de.seetec.v5.re.cm.device.video.samsung.SamsungEventMessage;
import de.seetec.v5.shared.Basic;
import de.seetec.v5.shared.net.HttpHandlerImpl;
import de.seetec.v5.shared.net.HttpHandlerIntf;
import de.seetec.v5.shared.net.NetworkParameter;
import de.seetec.v5.shared.util.ConfigurationException;
import java.util.ArrayList;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SamsungEventReader
extends Basic
implements Runnable,
HttpHandlerIntf {
    private static final String CLASS_NAME = "de.seetec.v5.re.cm.device.video.samsung.SamsungEventReader";
    private Logger logger = null;
    private NetworkParameter networkParameter;
    private Thread myThread;
    private SamsungDevice samsungDevice;
    private final ArrayList<SamsungAlarmHandlerIntf> callback = new ArrayList();
    private HttpHandlerImpl httpHandlerImpl;

    public SamsungEventReader() {
        this.logger = LogManager.getLogger((String)this.getClass().getName());
    }

    public void sendStatusService(int statusCode) {
        if (statusCode != 0) {
            this.notifyForNetworkProblems();
        }
    }

    private void notifyForNetworkProblems() {
        this.logger.warn("Network problems for Samsung Event Reader from " + this);
        if (!this.callback.isEmpty()) {
            this.reinizialize();
        }
    }

    protected void deregister(SamsungAlarmHandlerIntf callback) {
        this.callback.remove(callback);
    }

    protected void register(SamsungAlarmHandlerIntf samsungAlarmHandlerIntf) {
        this.callback.add(samsungAlarmHandlerIntf);
    }

    @Override
    public void run() {
        String url = "/stw-cgi/eventstatus.cgi?msubmenu=eventstatus&action=monitor";
        this.networkParameter.setSoTimeout(15000);
        try {
            String checkString = "/stw-cgi/eventstatus.cgi?msubmenu=eventstatus&action=check";
            this.samsungDevice.getHttpHandler().readGetRequest(checkString);
            this.httpHandlerImpl = new HttpHandlerImpl(this.networkParameter, true);
            this.httpHandlerImpl.readServerPushRequest(url, (HttpHandlerIntf)this);
        }
        catch (Throwable ex) {
            this.logger.warn("Exception while checking Samsung events for " + this + " : " + ex.getMessage());
            try {
                Thread.sleep(1000L);
                this.reinizialize();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    protected void init(SamsungDevice samsungDevice) throws ConfigurationException {
        this.samsungDevice = samsungDevice;
        this.networkParameter = samsungDevice.getDeviceCnf().getNetworkParameter();
        this.myThread = new Thread((Runnable)this, "EventReader for " + samsungDevice.toString());
        this.myThread.start();
    }

    public int shutdown() {
        if (this.startShutdown(CLASS_NAME)) {
            return 0;
        }
        if (this.httpHandlerImpl != null) {
            this.httpHandlerImpl.shutdown();
            this.httpHandlerImpl = null;
        }
        return 0;
    }

    protected SamsungDevice getSamsungDevice() {
        return this.samsungDevice;
    }

    private void reinizialize() {
        if (this.isShutdown(CLASS_NAME)) {
            this.logger.info("Do not reinit for " + this + " because of shutdown");
            return;
        }
        try {
            Thread.sleep(500L);
            this.init(this.getSamsungDevice());
        }
        catch (Exception ex) {
            this.logger.warn("Exception while re-initializing: " + ex.getMessage() + " for " + this);
        }
    }

    public void deliverContent(byte[] httpServerPushContent) {
        String content = new String(httpServerPushContent);
        String[] contentLines = content.split("\r\n");
        try {
            for (String contentLine : contentLines) {
                if (!SamsungEventMessage.isValidEventString(contentLine)) continue;
                SamsungEventMessage samsungEventMessage = new SamsungEventMessage(contentLine);
                for (int j = 0; j < this.callback.size(); ++j) {
                    SamsungAlarmHandlerIntf actualCallback = this.callback.get(j);
                    int channelNumber = actualCallback.getChannel();
                    if (actualCallback.getAlarmType() == AlarmType.INPUT && samsungEventMessage.getChannelNumber() == 0 && samsungEventMessage.getEventName().startsWith("AlarmInput")) {
                        actualCallback.receiveAlarm(samsungEventMessage);
                        continue;
                    }
                    if (actualCallback.getAlarmType() != AlarmType.GENERIC || channelNumber != 0 && channelNumber != samsungEventMessage.getChannelNumber()) continue;
                    actualCallback.receiveAlarm(samsungEventMessage);
                }
            }
        }
        catch (Exception ex) {
            this.logger.warn("Exception while evaluating event from " + this + " : " + ex.getMessage());
        }
    }
}

